// Code generated by "./generator ./system/org.freedesktop.DisplayManager"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package DisplayManager

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type DisplayManager interface {
	displayManager // interface org.freedesktop.DisplayManager
	proxy.Object
}

type objectDisplayManager struct {
	interfaceDisplayManager // interface org.freedesktop.DisplayManager
	proxy.ImplObject
}

func NewDisplayManager(conn *dbus.Conn) DisplayManager {
	obj := new(objectDisplayManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.DisplayManager", "/org/freedesktop/DisplayManager")
	return obj
}

type displayManager interface {
	ConnectSeatAdded(cb func(seat dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSeatRemoved(cb func(seat dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSessionAdded(cb func(session dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSessionRemoved(cb func(session dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Seats() proxy.PropObjectPathArray
	Sessions() proxy.PropObjectPathArray
}

type interfaceDisplayManager struct{}

func (v *interfaceDisplayManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDisplayManager) GetInterfaceName_() string {
	return "org.freedesktop.DisplayManager"
}

// signal SeatAdded

func (v *interfaceDisplayManager) ConnectSeatAdded(cb func(seat dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SeatAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SeatAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var seat dbus.ObjectPath
		err := dbus.Store(sig.Body, &seat)
		if err == nil {
			cb(seat)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SeatRemoved

func (v *interfaceDisplayManager) ConnectSeatRemoved(cb func(seat dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SeatRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SeatRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var seat dbus.ObjectPath
		err := dbus.Store(sig.Body, &seat)
		if err == nil {
			cb(seat)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SessionAdded

func (v *interfaceDisplayManager) ConnectSessionAdded(cb func(session dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SessionAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SessionAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var session dbus.ObjectPath
		err := dbus.Store(sig.Body, &session)
		if err == nil {
			cb(session)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SessionRemoved

func (v *interfaceDisplayManager) ConnectSessionRemoved(cb func(session dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SessionRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SessionRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var session dbus.ObjectPath
		err := dbus.Store(sig.Body, &session)
		if err == nil {
			cb(session)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Seats ao

func (v *interfaceDisplayManager) Seats() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Seats",
	}
}

// property Sessions ao

func (v *interfaceDisplayManager) Sessions() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Sessions",
	}
}
