% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBrukerFlexDir-functions.R
\name{readBrukerFlexDir}
\alias{readBrukerFlexDir}
\title{Reads recursively mass spectrometry data in Bruker Daltonics XMASS format.}
\usage{
readBrukerFlexDir(
  brukerFlexDir,
  removeCalibrationScans = TRUE,
  removeMetaData = FALSE,
  useHpc = TRUE,
  useSpectraNames = TRUE,
  filterZeroIntensities = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{brukerFlexDir}{\code{character}, path to \emph{directory} which
should be read recursively.}

\item{removeCalibrationScans}{\code{logical}, if \code{TRUE} all scans in
directories called \code{[Cc]alibration} will be ignored.}

\item{removeMetaData}{\code{logical}, to calculate mass data a lot of
meta data are needed. To save memory they could be deleted after
calculation.}

\item{useHpc}{\code{logical}, should Bruker Daltonics' High Precision
Calibration be used if available? (see also:
\code{\link[readBrukerFlexData]{.hpc}})}

\item{useSpectraNames}{\code{logical}, if \code{TRUE} all list elements
get an unique name from metaData otherwise file path is used.
(If \sQuote{removeMetaData} is \code{TRUE} \sQuote{useSpectraNames}
has no effect.)}

\item{filterZeroIntensities}{\code{logical}, don't change it. If \code{TRUE}
all intensities equal \code{0.0} are removed.
(see also: \code{\link[readBrukerFlexData]{readBrukerFlexFile}})}

\item{verbose}{\code{logical}, print verbose messages?}
}
\value{
A \code{list} of spectra.
\itemize{
    \item{\code{[[1]]$spectrum$mass}: A vector of calculated mass.}
    \item{\code{[[1]]$spectrum$intensity}: A vector of intensity values.}
    \item{\code{[[1]]$metaData}: A list of metaData depending on read spectrum.}
}
}
\description{
This function leads recursively all mass spectrometry data in
Bruker Daltonics XMASS format in a specified directory.
}
\details{
See \code{\link[readBrukerFlexData]{readBrukerFlexFile}}.
}
\examples{
## load library
library("readBrukerFlexData")

## get examples directory
exampleDirectory <- system.file("Examples", package="readBrukerFlexData")

## read example spectra
spec <- readBrukerFlexDir(file.path(exampleDirectory,
  "2010_05_19_Gibb_C8_A1"))

## plot spectra
plot(spec[[1]]$spectrum$mass, spec[[1]]$spectrum$intensity, type="n")

l <- length(spec)
legendStr <- character(l)
for (i in seq(along=spec)) {
  lines(spec[[i]]$spectrum$mass, spec[[i]]$spectrum$intensity, type="l",
        col=rainbow(l)[i])
  legendStr[i] <- spec[[i]]$metaData$fullName
}

## draw legend
legend(x="topright", legend=legendStr, col=rainbow(l), lwd=1)

}
\seealso{
\code{\link[MALDIquantForeign]{importBrukerFlex}},
 \code{\link[readBrukerFlexData]{readBrukerFlexFile}},
 \code{\link[readBrukerFlexData]{.hpc}}
}
\keyword{IO}
