% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_info.R
\name{standardize_info}
\alias{standardize_info}
\alias{standardise_info}
\alias{standardize_info.default}
\title{Get Standardization Information}
\usage{
standardize_info(model, ...)

\method{standardize_info}{default}(
  model,
  robust = FALSE,
  two_sd = FALSE,
  include_pseudo = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Arguments passed to or from other methods.}

\item{robust}{Logical, if \code{TRUE}, centering is done by subtracting the
median from the variables and dividing it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by subtracting the
mean and dividing it by the standard deviation (SD).}

\item{two_sd}{If \code{TRUE}, the variables are scaled by two times the deviation
(SD or MAD depending on \code{robust}). This method can be useful to obtain
model coefficients of continuous parameters comparable to coefficients
related to binary predictors, when applied to \strong{the predictors} (not the
outcome) (Gelman, 2008).}

\item{include_pseudo}{(For (G)LMMs) Should Pseudo-standardized information be
included?}

\item{verbose}{Toggle warnings and messages on or off.}
}
\value{
A data frame with information on each parameter (see
\code{\link[=parameters_type]{parameters_type()}}), and various standardization coefficients
for the post-hoc methods (see \code{\link[=standardize_parameters]{standardize_parameters()}}) for the predictor
and the response.
}
\description{
This function extracts information, such as the deviations (SD or MAD) from
parent variables, that are necessary for post-hoc standardization of
parameters. This function gives a window on how standardized are obtained,
i.e., by what they are divided. The "basic" method of standardization uses.
}
\examples{
\dontshow{if (insight::check_if_installed("datawizard", minimum_version = "0.12.0", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(mpg ~ ., data = mtcars)
standardize_info(model)
standardize_info(model, robust = TRUE)
standardize_info(model, two_sd = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other standardize: 
\code{\link{standardize_parameters}()}
}
\concept{standardize}
