# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.network import NetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-network
# USAGE
    python network_watcher_packet_capture_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.packet_captures.begin_create(
        resource_group_name="rg1",
        network_watcher_name="nw1",
        packet_capture_name="pc1",
        parameters={
            "properties": {
                "bytesToCapturePerPacket": 10000,
                "filters": [{"localIPAddress": "10.0.0.4", "localPort": "80", "protocol": "TCP"}],
                "storageLocation": {
                    "filePath": "D:\\capture\\pc1.cap",
                    "storageId": "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore",
                    "storagePath": "https://mytestaccountname.blob.core.windows.net/capture/pc1.cap",
                },
                "target": "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1",
                "timeLimitInSeconds": 100,
                "totalBytesPerSession": 100000,
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/network/resource-manager/Microsoft.Network/stable/2024-05-01/examples/NetworkWatcherPacketCaptureCreate.json
if __name__ == "__main__":
    main()
