/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "widget.h"
#include "ui_widget.h"
#include <QDebug>
#include <dtk_wmjack.h>

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    InitDtkWmDisplay();
    ui->setupUi(this);
    ui->lineEdit->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_2->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_3->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_4->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_5->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_6->setPlaceholderText("请输入十进制的窗口id");
    ui->lineEdit_16->setPlaceholderText("请输入十进制的窗口id");

    connect(&m_timer, &QTimer::timeout, this, &Widget::timerSlot);
    connect(&m_timer1, &QTimer::timeout, this, &Widget::timerSlot1);
    connect(&m_timer2, &QTimer::timeout, this, &Widget::timerSlot2);
    connect(ui->pushButton, &QPushButton::clicked, this, &Widget::onGetCompositorSwitchStatus);
    connect(ui->pushButton_2, &QPushButton::clicked, this, &Widget::onToggleMultitaskView);
    connect(ui->pushButton_3, &QPushButton::clicked, this, &Widget::onMinimizeWindow);
    connect(ui->pushButton_4, &QPushButton::clicked, this, &Widget::onMaximizeWindow);
    connect(ui->pushButton_5, &QPushButton::clicked, this, &Widget::onGetWindowText);
    connect(ui->pushButton_6, &QPushButton::clicked, this, &Widget::onGetWindowSize);
    connect(ui->pushButton_7, &QPushButton::clicked, this, &Widget::onGetWindowPosition);
    connect(ui->pushButton_8, &QPushButton::clicked, this, &Widget::onGetActiveWindowID);
    connect(ui->pushButton_9, &QPushButton::clicked, this, &Widget::onGetDesktopWindowID);
    connect(ui->pushButton_10, &QPushButton::clicked, this, &Widget::onGetChildWindowIDs);
    connect(ui->pushButton_11, &QPushButton::clicked, this, &Widget::onGetPointerPosition);
    connect(ui->pushButton_12, &QPushButton::clicked, this, &Widget::onShowSplitMenu);
    connect(ui->pushButton_13, &QPushButton::clicked, this, &Widget::onHideSplitMenu);
    connect(ui->pushButton_14, &QPushButton::clicked, this, &Widget::onGetWindowFromPoint);
    connect(ui->pushButton_15, &QPushButton::clicked, this, &Widget::onGetDevicePerformanceLevel);
    connect(ui->pushButton_18, &QPushButton::clicked, this, &Widget::onGetWindowPid);

}

Widget::~Widget()
{
    DestoryDtkWmDisplay();
    delete ui;
}

void Widget::timerSlot()
{
    onGetActiveWindowID();
}

void Widget::timerSlot1()
{
    onGetPointerPosition();
}

void Widget::timerSlot2()
{
    onGetWindowFromPoint();
}

void Widget::onGetCompositorSwitchStatus()
{
    bool b = GetCompositorSwitchStatus();
    qInfo() << b;
    if (b) {
        ui->label_2->setText("true");
    } else {
        ui->label_2->setText("false");
    }

}

void Widget::onToggleMultitaskView()
{
    qInfo() << ToggleMultitaskView();
}

void Widget::onMinimizeWindow()
{
    ulong id = ui->lineEdit->text().toULong();
    qInfo() << this->winId();
    qInfo() << id;
    qInfo() << MinimizeWindow(id);
}

void Widget::onMaximizeWindow()
{
    ulong id = ui->lineEdit_2->text().toULong();
    qInfo() << this->winId();
    qInfo() << id;
    qInfo() << MaximizeWindow(id);
}

void Widget::onGetWindowText()
{
    ulong id = ui->lineEdit_3->text().toULong();
    char *ret = GetWindowText(id);
    qInfo() << this->winId();
    qInfo() << id;
    qInfo() << ret;
    ui->label_6->setText(QString(ret));
}

void Widget::onGetWindowSize()
{
    ulong id = ui->lineEdit_4->text().toULong();
    Size ret = GetWindowSize(id);
    qInfo() << this->winId();
    qInfo() << id;
    qInfo() << ret.w << ret.h;
    ui->label_10->setText(QString("wdith: %1, height: %2").arg(ret.w).arg(ret.h));
}

void Widget::onGetWindowPosition()
{
    ulong id = ui->lineEdit_5->text().toULong();
    Position ret = GetWindowPosition(id);
    qInfo() << this->winId();
    qInfo() << id;
    qInfo() << this->geometry();
    qInfo() << ret.x << ret.y;
    ui->label_13->setText(QString("x: %1, y: %2").arg(ret.x).arg(ret.y));
}

void Widget::onGetActiveWindowID()
{
    ulong id = GetActiveWindowID();
    qInfo() << id;
    qInfo() << this->winId();
    qInfo() << "-------------------\n";
    ui->label_16->setText(QString("活动窗口id：: %1").arg(id));
    m_timer.start(1000);
}

void Widget::onGetDesktopWindowID()
{
    ulong id = GetDesktopWindowID();
    qInfo() << id;
    ui->label_18->setText(QString("桌面窗口id：: %1").arg(id));
}

void Widget::onGetChildWindowIDs()
{
    ulong id = ui->lineEdit_6->text().toULong();
    WindowId *pChildIDs;
    int ret = GetWindowChildren(id, &pChildIDs);
    qInfo() << ret;
    QStringList list;
    for (int i = 0; i < ret; i++) {
        list << QString("%1").arg(pChildIDs[i]);
    }
    ui->label_20->setText(QString("子窗口数：%1").arg(ret));
    ui->textBrowser->setText(QString("%1").arg(list.isEmpty()? "无" : list.join(",")));
    FreeWindowList(pChildIDs);
}

void Widget::onGetPointerPosition()
{
    Position ret = GetPointerPosition();
    qInfo() << ret.x << ret.y;
    ui->label_23->setText(QString("x: %1, y: %2").arg(ret.x).arg(ret.y));
    m_timer1.start(1000);
}

void Widget::onGetWindowPid()
{
    ulong id = ui->lineEdit_16->text().toULong();
    int pid = GetWindowPID(id);
    qInfo() << pid;
    QStringList list;
    ui->label_116->setText(QString("pid：%1").arg(pid));
}

void Widget::onShowSplitMenu()
{
    QTimer::singleShot(1000, this,
        [this] {
            QRect rect = QRect(114, 514, 19, 19);
            ShowSplitMenu(rect.x(), rect.y(), rect.width(), rect.height());
        }
    );
}

void Widget::onHideSplitMenu()
{
    HideSplitMenu(true, winId());
}

void Widget::onGetWindowFromPoint()
{
    ulong id = GetWindowFromPoint();
    ui->label_25->setText(QString("指向窗口id：%1").arg(id));
    m_timer2.start(1000);
}

void Widget::onGetDevicePerformanceLevel()
{
    int level = GetDevicePerformanceLevel();
    ui->label_26->setText(QString("性能：%1").arg(level));
}