/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     gl di <diguoliang@uniontech.com>
 *
 * Maintainer: gl di <diguoliang@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PROHIBITEDWINDOWCONTROLLER_H
#define PROHIBITEDWINDOWCONTROLLER_H

#include <QtCore/QObject>

#include <unordered_set>
#include <unordered_map>

#include "window-system/x11.h"

class Config;
class X11WindowSystem;

class ProhibitedWindowDecision
{
public:
    /**
     * @brief prohibit screenshot judgment for hook screenshot function
     * @param window The window id of screenshot function
     * @return true or false if dont need to prohibit screenshot
    */
    bool needProhibitScreenshot(Window window);

    /**
     * @brief specify window judgment by property
     * @param window The window id of screenshot function
     * @return true or false if is not prohibited window
     */
    bool isSpecifyWindow(Window window, const std::unordered_map<std::string, std::vector<std::string>>& mapPropertyName2Values);

    /**
     * @brief the judgment of window visualization
     * @param window The window id of screenshot function
     * @return true or false if not visualization window
     */
    bool isNormalState(Window window);

private:
    X11WindowSystem  m_windowSystem;
};

#endif // PROHIBITEDWINDOWCONTROLLER_H
