# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.preview.bulk_exports.export.day import DayList


class ExportList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the ExportList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.preview.bulk_exports.export.ExportList
        :rtype: twilio.rest.preview.bulk_exports.export.ExportList
        """
        super(ExportList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, resource_type):
        """
        Constructs a ExportContext

        :param resource_type: The resource_type

        :returns: twilio.rest.preview.bulk_exports.export.ExportContext
        :rtype: twilio.rest.preview.bulk_exports.export.ExportContext
        """
        return ExportContext(self._version, resource_type=resource_type,)

    def __call__(self, resource_type):
        """
        Constructs a ExportContext

        :param resource_type: The resource_type

        :returns: twilio.rest.preview.bulk_exports.export.ExportContext
        :rtype: twilio.rest.preview.bulk_exports.export.ExportContext
        """
        return ExportContext(self._version, resource_type=resource_type,)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.ExportList>'


class ExportPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ExportPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.preview.bulk_exports.export.ExportPage
        :rtype: twilio.rest.preview.bulk_exports.export.ExportPage
        """
        super(ExportPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ExportInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.bulk_exports.export.ExportInstance
        :rtype: twilio.rest.preview.bulk_exports.export.ExportInstance
        """
        return ExportInstance(self._version, payload,)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.ExportPage>'


class ExportContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, resource_type):
        """
        Initialize the ExportContext

        :param Version version: Version that contains the resource
        :param resource_type: The resource_type

        :returns: twilio.rest.preview.bulk_exports.export.ExportContext
        :rtype: twilio.rest.preview.bulk_exports.export.ExportContext
        """
        super(ExportContext, self).__init__(version)

        # Path Solution
        self._solution = {'resource_type': resource_type,}
        self._uri = '/Exports/{resource_type}'.format(**self._solution)

        # Dependents
        self._days = None

    def fetch(self):
        """
        Fetch a ExportInstance

        :returns: Fetched ExportInstance
        :rtype: twilio.rest.preview.bulk_exports.export.ExportInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return ExportInstance(self._version, payload, resource_type=self._solution['resource_type'],)

    @property
    def days(self):
        """
        Access the days

        :returns: twilio.rest.preview.bulk_exports.export.day.DayList
        :rtype: twilio.rest.preview.bulk_exports.export.day.DayList
        """
        if self._days is None:
            self._days = DayList(self._version, resource_type=self._solution['resource_type'],)
        return self._days

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.BulkExports.ExportContext {}>'.format(context)


class ExportInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, resource_type=None):
        """
        Initialize the ExportInstance

        :returns: twilio.rest.preview.bulk_exports.export.ExportInstance
        :rtype: twilio.rest.preview.bulk_exports.export.ExportInstance
        """
        super(ExportInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'resource_type': payload['resource_type'],
            'url': payload['url'],
            'links': payload['links'],
        }

        # Context
        self._context = None
        self._solution = {'resource_type': resource_type or self._properties['resource_type'],}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ExportContext for this ExportInstance
        :rtype: twilio.rest.preview.bulk_exports.export.ExportContext
        """
        if self._context is None:
            self._context = ExportContext(self._version, resource_type=self._solution['resource_type'],)
        return self._context

    @property
    def resource_type(self):
        """
        :returns: The resource_type
        :rtype: unicode
        """
        return self._properties['resource_type']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The links
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch a ExportInstance

        :returns: Fetched ExportInstance
        :rtype: twilio.rest.preview.bulk_exports.export.ExportInstance
        """
        return self._proxy.fetch()

    @property
    def days(self):
        """
        Access the days

        :returns: twilio.rest.preview.bulk_exports.export.day.DayList
        :rtype: twilio.rest.preview.bulk_exports.export.day.DayList
        """
        return self._proxy.days

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.BulkExports.ExportInstance {}>'.format(context)
