/****************************/
/* THIS IS OPEN SOURCE CODE */
/****************************/

/* 
* File:    map-i7.h
* CVS:     $Id: map-i7.h,v 1.1.2.2 2010/03/06 16:12:08 servat Exp $
* Author:  George Neville-Neil
*          gnn@freebsd.org
*/

#ifndef FreeBSD_MAP_I7
#define FreeBSD_MAP_I7

enum NativeEvent_Value_i7Processor {
	PNE_I7_SB_FORWARD_ANY= PAPI_NATIVE_MASK ,
	PNE_I7_LOAD_BLOCK_STD,
	PNE_I7_LOAD_BLOCK_ADDRESS_OFFSET,
	PNE_I7_SB_DRAIN_CYCLES,
	PNE_I7_MISALIGN_MEM_REF_LOAD,
	PNE_I7_MISALIGN_MEM_REF_STORE,
	PNE_I7_MISALIGN_MEM_REF_ANY,
	PNE_I7_STORE_BLOCKS_NOT_STA,
	PNE_I7_STORE_BLOCKS_STA,
	PNE_I7_STORE_BLOCKS_AT_RET,
	PNE_I7_STORE_BLOCKS_L1D_BLOCK,
	PNE_I7_STORE_BLOCKS_ANY,
	PNE_I7_PARTIAL_ADDRESS_ALIAS,
	PNE_I7_DTLB_LOAD_MISSES_ANY,
	PNE_I7_DTLB_LOAD_MISSES_WALK_COMPLETED,
	PNE_I7_DTLB_LOAD_MISSES_STLB_HIT,
	PNE_I7_DTLB_LOAD_MISSES_PDE_MISS,
	PNE_I7_DTLB_LOAD_MISSES_PDP_MISS,
	PNE_I7_DTLB_LOAD_MISSES_LARGE_WALK_COMPLETED,
	PNE_I7_MEMORY_DISAMBIGURATION_RESET,
	PNE_I7_MEMORY_DISAMBIGURATION_SUCCESS,
	PNE_I7_MEMORY_DISAMBIGURATION_WATCHDOG,
	PNE_I7_MEMORY_DISAMBIGURATION_WATCH_CYCLES,
	PNE_I7_MEM_INST_RETIRED_LOADS,
	PNE_I7_MEM_INST_RETIRED_STORES,
	PNE_I7_MEM_STORE_RETIRED_DTLB_MISS,
	PNE_I7_UOPS_ISSUED_ANY,
	PNE_I7_UOPS_ISSUED_FUSED,
	PNE_I7_MEM_UNCORE_RETIRED_OTHER_CORE_L2_HITM,
	PNE_I7_MEM_UNCORE_RETIRED_REMOTE_CACHE_LOCAL_HOME_HIT,
	PNE_I7_MEM_UNCORE_RETIRED_REMOTE_DRAM,
	PNE_I7_MEM_UNCORE_RETIRED_LOCAL_DRAM,
	PNE_I7_FP_COMP_OPS_EXE_X87,
	PNE_I7_FP_COMP_OPS_EXE_MMX,
	PNE_I7_FP_COMP_OPS_EXE_SSE_FP,
	PNE_I7_FP_COMP_OPS_EXE_SSE2_INTEGER,
	PNE_I7_FP_COMP_OPS_EXE_SSE_FP_PACKED,
	PNE_I7_FP_COMP_OPS_EXE_SSE_FP_SCALAR,
	PNE_I7_FP_COMP_OPS_EXE_SSE_SINGLE_PRECISION,
	PNE_I7_FP_COMP_OPS_EXE_SSE_DOUBLE_PRECISION,
	PNE_I7_SIMD_INT_128_PACKED_MPY,
	PNE_I7_SIMD_INT_128_PACKED_SHIFT,
	PNE_I7_SIMD_INT_128_PACK,
	PNE_I7_SIMD_INT_128_UNPACK,
	PNE_I7_SIMD_INT_128_PACKED_LOGICAL,
	PNE_I7_SIMD_INT_128_PACKED_ARITH,
	PNE_I7_SIMD_INT_128_SHUFFLE_MOVE,
	PNE_I7_LOAD_DISPATCH_RS,
	PNE_I7_LOAD_DISPATCH_RS_DELAYED,
	PNE_I7_LOAD_DISPATCH_MOB,
	PNE_I7_LOAD_DISPATCH_ANY,
	PNE_I7_ARITH_CYCLES_DIV_BUSY,
	PNE_I7_ARITH_MUL,
	PNE_I7_INST_QUEUE_WRITES,
	PNE_I7_INST_DECODED_DEC0,
	PNE_I7_TWO_UOP_INSTS_DECODED,
	PNE_I7_HW_INT_RCV,
	PNE_I7_HW_INT_CYCLES_MASKED,
	PNE_I7_HW_INT_CYCLES_PENDING_AND_MASKED,
	PNE_I7_INST_QUEUE_WRITE_CYCLES,
	PNE_I7_L2_RQSTS_LD_HIT,
	PNE_I7_L2_RQSTS_LD_MISS,
	PNE_I7_L2_RQSTS_LOADS,
	PNE_I7_L2_RQSTS_RFO_HIT,
	PNE_I7_L2_RQSTS_RFO_MISS,
	PNE_I7_L2_RQSTS_RFOS,
	PNE_I7_L2_RQSTS_IFETCH_HIT,
	PNE_I7_L2_RQSTS_IFETCH_MISS,
	PNE_I7_L2_RQSTS_IFETCHES,
	PNE_I7_L2_RQSTS_PREFETCH_HIT,
	PNE_I7_L2_RQSTS_PREFETCH_MISS,
	PNE_I7_L2_RQSTS_PREFETCHES,
	PNE_I7_L2_RQSTS_MISS,
	PNE_I7_L2_RQSTS_REFERENCES,
	PNE_I7_L2_DATA_RQSTS_DEMAND_I_STATE,
	PNE_I7_L2_DATA_RQSTS_DEMAND_S_STATE,
	PNE_I7_L2_DATA_RQSTS_DEMAND_E_STATE,
	PNE_I7_L2_DATA_RQSTS_DEMAND_M_STATE,
	PNE_I7_L2_DATA_RQSTS_DEMAND_MESI,
	PNE_I7_L2_DATA_RQSTS_PREFETCH_I_STATE,
	PNE_I7_L2_DATA_RQSTS_PREFETCH_S_STATE,
	PNE_I7_L2_DATA_RQSTS_PREFETCH_E_STATE,
	PNE_I7_L2_DATA_RQSTS_PREFETCH_M_STATE,
	PNE_I7_L2_DATA_RQSTS_PREFETCH_MESI,
	PNE_I7_L2_DATA_RQSTS_ANY,
	PNE_I7_L2_WRITE_RFO_I_STATE,
	PNE_I7_L2_WRITE_RFO_S_STATE,
	PNE_I7_L2_WRITE_RFO_E_STATE,
	PNE_I7_L2_WRITE_RFO_M_STATE,
	PNE_I7_L2_WRITE_RFO_HIT,
	PNE_I7_L2_WRITE_RFO_MESI,
	PNE_I7_L2_WRITE_LOCK_I_STATE,
	PNE_I7_L2_WRITE_LOCK_S_STATE,
	PNE_I7_L2_WRITE_LOCK_E_STATE,
	PNE_I7_L2_WRITE_LOCK_M_STATE,
	PNE_I7_L2_WRITE_LOCK_HIT,
	PNE_I7_L2_WRITE_LOCK_MESI,
	PNE_I7_L1D_WB_L2_I_STATE,
	PNE_I7_L1D_WB_L2_S_STATE,
	PNE_I7_L1D_WB_L2_E_STATE,
	PNE_I7_L1D_WB_L2_M_STATE,
	PNE_I7_L1D_WB_L2_MESI,
	PNE_I7_L3_LAT_CACHE_REFERENCE,
	PNE_I7_L3_LAT_CACHE_MISS,
	PNE_I7_CPU_CLK_UNHALTED_THREAD_P,
	PNE_I7_CPU_CLK_UNHALTED_REF_P,
	PNE_I7_UOPS_DECODED_DEC0,
	PNE_I7_L1D_CACHE_LD_I_STATE,
	PNE_I7_L1D_CACHE_LD_S_STATE,
	PNE_I7_L1D_CACHE_LD_E_STATE,
	PNE_I7_L1D_CACHE_LD_M_STATE,
	PNE_I7_L1D_CACHE_LD_MESI,
	PNE_I7_L1D_CACHE_ST_I_STATE,
	PNE_I7_L1D_CACHE_ST_S_STATE,
	PNE_I7_L1D_CACHE_ST_E_STATE,
	PNE_I7_L1D_CACHE_ST_M_STATE,
	PNE_I7_L1D_CACHE_ST_MESI,
	PNE_I7_L1D_CACHE_LOCK_HIT,
	PNE_I7_L1D_CACHE_LOCK_S_STATE,
	PNE_I7_L1D_CACHE_LOCK_E_STATE,
	PNE_I7_L1D_CACHE_LOCK_M_STATE,
	PNE_I7_L1D_ALL_REF_ANY,
	PNE_I7_L1D_ALL_REF_CACHEABLE,
	PNE_I7_L1D_PEND_MISS_LOAD_BUFFERS_FULL,
	PNE_I7_DTLB_MISSES_ANY,
	PNE_I7_DTLB_MISSES_WALK_COMPLETED,
	PNE_I7_DTLB_MISSES_STLB_HIT,
	PNE_I7_DTLB_MISSES_PDE_MISS,
	PNE_I7_DTLB_MISSES_PDP_MISS,
	PNE_I7_DTLB_MISSES_LARGE_WALK_COMPLETED,
	PNE_I7_SSE_MEM_EXEC_NTA,
	PNE_I7_SSE_MEM_EXEC_STREAMING_STORES,
	PNE_I7_LOAD_HIT_PRE,
	PNE_I7_SFENCE_CYCLES,
	PNE_I7_L1D_PREFETCH_REQUESTS,
	PNE_I7_L1D_PREFETCH_MISS,
	PNE_I7_L1D_PREFETCH_TRIGGERS,
	PNE_I7_EPT_EPDE_MISS,
	PNE_I7_EPT_EPDPE_HIT,
	PNE_I7_EPT_EPDPE_MISS,
	PNE_I7_L1D_REPL,
	PNE_I7_L1D_M_REPL,
	PNE_I7_L1D_M_EVICT,
	PNE_I7_L1D_M_SNOOP_EVICT,
	PNE_I7_L1D_CACHE_PREFETCH_LOCK_FB_HIT,
	PNE_I7_L1D_CACHE_LOCK_FB_HIT,
	PNE_I7_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_READ_DATA,
	PNE_I7_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_READ_CODE,
	PNE_I7_OFFCORE_REQUESTS_OUTSTANDING_DEMAND_RFO,
	PNE_I7_OFFCORE_REQUESTS_OUTSTANDING_ANY_READ,
	PNE_I7_CACHE_LOCK_CYCLES_L1D_L2,
	PNE_I7_CACHE_LOCK_CYCLES_L1D,
	PNE_I7_IO_TRANSACTIONS,
	PNE_I7_L1I_HITS,
	PNE_I7_L1I_MISSES,
	PNE_I7_L1I_READS,
	PNE_I7_L1I_CYCLES_STALLED,
	PNE_I7_IFU_IVC_FULL,
	PNE_I7_IFU_IVC_L1I_EVICTION,
	PNE_I7_LARGE_ITLB_HIT,
	PNE_I7_L1I_OPPORTUNISTIC_HITS,
	PNE_I7_ITLB_MISSES_ANY,
	PNE_I7_ITLB_MISSES_WALK_COMPLETED,
	PNE_I7_ITLB_MISSES_WALK_CYCLES,
	PNE_I7_ITLB_MISSES_STLB_HIT,
	PNE_I7_ITLB_MISSES_PDE_MISS,
	PNE_I7_ITLB_MISSES_PDP_MISS,
	PNE_I7_ITLB_MISSES_LARGE_WALK_COMPLETED,
	PNE_I7_ILD_STALL_ANY,
	PNE_I7_ILD_STALL_IQ_FULL,
	PNE_I7_ILD_STALL_LCP,
	PNE_I7_ILD_STALL_MRU,
	PNE_I7_ILD_STALL_REGEN,
	PNE_I7_BR_INST_EXEC_ANY,
	PNE_I7_BR_INST_EXEC_COND,
	PNE_I7_BR_INST_EXEC_DIRECT,
	PNE_I7_BR_INST_EXEC_DIRECT_NEAR_CALL,
	PNE_I7_BR_INST_EXEC_INDIRECT_NEAR_CALL,
	PNE_I7_BR_INST_EXEC_INDIRECT_NON_CALL,
	PNE_I7_BR_INST_EXEC_NEAR_CALLS,
	PNE_I7_BR_INST_EXEC_NON_CALLS,
	PNE_I7_BR_INST_EXEC_RETURN_NEAR,
	PNE_I7_BR_INST_EXEC_TAKEN,
	PNE_I7_BR_MISP_EXEC_COND,
	PNE_I7_BR_MISP_EXEC_DIRECT,
	PNE_I7_BR_MISP_EXEC_INDIRECT_NON_CALL,
	PNE_I7_BR_MISP_EXEC_NON_CALLS,
	PNE_I7_BR_MISP_EXEC_RETURN_NEAR,
	PNE_I7_BR_MISP_EXEC_DIRECT_NEAR_CALL,
	PNE_I7_BR_MISP_EXEC_INDIRECT_NEAR_CALL,
	PNE_I7_BR_MISP_EXEC_NEAR_CALLS,
	PNE_I7_BR_MISP_EXEC_TAKEN,
	PNE_I7_BR_MISP_EXEC_ANY,
	PNE_I7_RESOURCE_STALLS_ANY,
	PNE_I7_RESOURCE_STALLS_LOAD,
	PNE_I7_RESOURCE_STALLS_RS_FULL,
	PNE_I7_RESOURCE_STALLS_STORE,
	PNE_I7_RESOURCE_STALLS_ROB_FULL,
	PNE_I7_RESOURCE_STALLS_FPCW,
	PNE_I7_RESOURCE_STALLS_MXCSR,
	PNE_I7_RESOURCE_STALLS_OTHER,
	PNE_I7_MACRO_INSTS_FUSIONS_DECODED,
	PNE_I7_BACLEAR_FORCE_IQ,
	PNE_I7_LSD_UOPS,
	PNE_I7_ITLB_FLUSH,
	PNE_I7_OFFCORE_REQUESTS_DEMAND_READ_DATA,
	PNE_I7_OFFCORE_REQUESTS_DEMAND_READ_CODE,
	PNE_I7_OFFCORE_REQUESTS_DEMAND_RFO,
	PNE_I7_OFFCORE_REQUESTS_ANY_READ,
	PNE_I7_OFFCORE_REQUESTS_ANY_RFO,
	PNE_I7_OFFCORE_REQUESTS_UNCACHED_MEM,
	PNE_I7_OFFCORE_REQUESTS_L1D_WRITEBACK,
	PNE_I7_OFFCORE_REQUESTS_ANY,
	PNE_I7_UOPS_EXECUTED_PORT0,
	PNE_I7_UOPS_EXECUTED_PORT1,
	PNE_I7_UOPS_EXECUTED_PORT2_CORE,
	PNE_I7_UOPS_EXECUTED_PORT3_CORE,
	PNE_I7_UOPS_EXECUTED_PORT4_CORE,
	PNE_I7_UOPS_EXECUTED_PORT5,
	PNE_I7_UOPS_EXECUTED_CORE_ACTIVE_CYCLES,
	PNE_I7_UOPS_EXECUTED_PORT015,
	PNE_I7_UOPS_EXECUTED_PORT234,
	PNE_I7_OFFCORE_REQUESTS_SQ_FULL,
	PNE_I7_SNOOPQ_REQUESTS_OUTSTANDING_DATA,
	PNE_I7_SNOOPQ_REQUESTS_OUTSTANDING_INVALIDATE,
	PNE_I7_SNOOPQ_REQUESTS_OUTSTANDING_CODE,
	PNE_I7_OFF_CORE_RESPONSE_0,
	PNE_I7_SNOOP_RESPONSE_HIT,
	PNE_I7_SNOOP_RESPONSE_HITE,
	PNE_I7_SNOOP_RESPONSE_HITM,
	PNE_I7_PIC_ACCESSES_TPR_READS,
	PNE_I7_PIC_ACCESSES_TPR_WRITES,
	PNE_I7_INST_RETIRED_ANY_P,
	PNE_I7_INST_RETIRED_X87,
	PNE_I7_UOPS_RETIRED_ANY,
	PNE_I7_UOPS_RETIRED_RETIRE_SLOTS,
	PNE_I7_UOPS_RETIRED_MACRO_FUSED,
	PNE_I7_MACHINE_CLEARS_CYCLES,
	PNE_I7_MACHINE_CLEARS_MEM_ORDER,
	PNE_I7_MACHINE_CLEARS_SMC,
	PNE_I7_MACHINE_CLEARS_FUSION_ASSIST,
	PNE_I7_BR_INST_RETIRED_ALL_BRANCHES,
	PNE_I7_BR_INST_RETIRED_CONDITIONAL,
	PNE_I7_BR_INST_RETIRED_NEAR_CALL,
	PNE_I7_BR_MISP_RETIRED_ALL_BRANCHES,
	PNE_I7_BR_MISP_RETIRED_NEAR_CALL,
	PNE_I7_SSEX_UOPS_RETIRED_PACKED_SINGLE,
	PNE_I7_SSEX_UOPS_RETIRED_SCALAR_SINGLE,
	PNE_I7_SSEX_UOPS_RETIRED_PACKED_DOUBLE,
	PNE_I7_SSEX_UOPS_RETIRED_SCALAR_DOUBLE,
	PNE_I7_SSEX_UOPS_RETIRED_VECTOR_INTEGER,
	PNE_I7_ITLB_MISS_RETIRED,
	PNE_I7_MEM_LOAD_RETIRED_L1D_HIT,
	PNE_I7_MEM_LOAD_RETIRED_L2_HIT,
	PNE_I7_MEM_LOAD_RETIRED_OTHER_CORE_L2_HIT_HITM,
	PNE_I7_MEM_LOAD_RETIRED_HIT_LFB,
	PNE_I7_MEM_LOAD_RETIRED_DTLB_MISS,
	PNE_I7_MEM_LOAD_RETIRED_L3_MISS,
	PNE_I7_MEM_LOAD_RETIRED_L3_UNSHARED_HIT,
	PNE_I7_FP_MMX_TRANS_TO_FP,
	PNE_I7_FP_MMX_TRANS_TO_MMX,
	PNE_I7_FP_MMX_TRANS_ANY,
	PNE_I7_MACRO_INSTS_DECODED,
	PNE_I7_UOPS_DECODED_MS,
	PNE_I7_UOPS_DECODED_ESP_FOLDING,
	PNE_I7_UOPS_DECODED_ESP_SYNC,
	PNE_I7_RAT_STALLS_FLAGS,
	PNE_I7_RAT_STALLS_REGISTERS,
	PNE_I7_RAT_STALLS_ROB_READ_PORT,
	PNE_I7_RAT_STALLS_SCOREBOARD,
	PNE_I7_RAT_STALLS_ANY,
	PNE_I7_SEG_RENAME_STALLS,
	PNE_I7_ES_REG_RENAMES,
	PNE_I7_UOP_UNFUSION,
	PNE_I7_BR_INST_DECODED,
	PNE_I7_BOGUS_BR,
	PNE_I7_BPU_MISSED_CALL_RET,
	PNE_I7_L2_HW_PREFETCH_DATA_TRIGGER,
	PNE_I7_L2_HW_PREFETCH_CODE_TRIGGER,
	PNE_I7_L2_HW_PREFETCH_DCA_TRIGGER,
	PNE_I7_L2_HW_PREFETCH_KICK_START,
	PNE_I7_SQ_MISC_PROMOTION,
	PNE_I7_SQ_MISC_PROMOTION_POST_GO,
	PNE_I7_SQ_MISC_LRU_HINTS,
	PNE_I7_SQ_MISC_FILL_DROPPED,
	PNE_I7_SQ_MISC_SPLIT_LOCK,
	PNE_I7_SQ_FULL_STALL_CYCLES,
	PNE_I7_FP_ASSIST_ALL,
	PNE_I7_FP_ASSIST_OUTPUT,
	PNE_I7_FP_ASSIST_INPUT,
	PNE_I7_SEGMENT_REG_LOADS,
	PNE_I7_SIMD_INT_64_PACKED_MPY,
	PNE_I7_SIMD_INT_64_PACKED_SHIFT,
	PNE_I7_SIMD_INT_64_PACK,
	PNE_I7_SIMD_INT_64_UNPACK,
	PNE_I7_SIMD_INT_64_PACKED_LOGICAL,
	PNE_I7_SIMD_INT_64_PACKED_ARITH,
	PNE_I7_SIMD_INT_64_SHUFFLE_MOVE,
	PNE_I7_INSTR_RETIRED_ANY,
	PNE_I7_CPU_CLK_UNHALTED_CORE,
	PNE_I7_CPU_CLK_UNHALTED_REF,
	PNE_I7_GQ_CYCLES_FULL_READ_TRACKER,
	PNE_I7_GQ_CYCLES_FULL_WRITE_TRACKER,
	PNE_I7_GQ_CYCLES_FULL_PEER_PROBE_TRACKER,
	PNE_I7_GQ_CYCLES_NOT_EMPTY_READ_TRACKER,
	PNE_I7_GQ_CYCLES_NOT_EMPTY_WRITE_TRACKER,
	PNE_I7_GQ_CYCLES_NOT_EMPTY_PEER_PROBE_TRACKER,
	PNE_I7_GQ_ALLOC_READ_TRACKER,
	PNE_I7_GQ_ALLOC_RT_L3_MISS,
	PNE_I7_GQ_ALLOC_RT_TO_L3_RESP,
	PNE_I7_GQ_ALLOC_RT_TO_RTID_ACQUIRED,
	PNE_I7_GQ_ALLOC_WT_TO_RTID_ACQUIRED,
	PNE_I7_GQ_ALLOC_WRITE_TRACKER,
	PNE_I7_GQ_ALLOC_PEER_PROBE_TRACKER,
	PNE_I7_GQ_DATA_FROM_QPI,
	PNE_I7_GQ_DATA_FROM_QMC,
	PNE_I7_GQ_DATA_FROM_L3,
	PNE_I7_GQ_DATA_FROM_CORES_02,
	PNE_I7_GQ_DATA_FROM_CORES_13,
	PNE_I7_GQ_DATA_TO_QPI_QMC,
	PNE_I7_GQ_DATA_TO_L3,
	PNE_I7_GQ_DATA_TO_CORES,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_I_STATE,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_S_STATE,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_FWD_S_STATE,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_FWD_I_STATE,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_CONFLICT,
	PNE_I7_SNP_RESP_TO_LOCAL_HOME_WB,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_I_STATE,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_S_STATE,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_FWD_S_STATE,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_FWD_I_STATE,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_CONFLICT,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_WB,
	PNE_I7_SNP_RESP_TO_REMOTE_HOME_HITM,
	PNE_I7_L3_HITS_READ,
	PNE_I7_L3_HITS_WRITE,
	PNE_I7_L3_HITS_PROBE,
	PNE_I7_L3_HITS_ANY,
	PNE_I7_L3_MISS_READ,
	PNE_I7_L3_MISS_WRITE,
	PNE_I7_L3_MISS_PROBE,
	PNE_I7_L3_MISS_ANY,
	PNE_I7_L3_LINES_IN_M_STATE,
	PNE_I7_L3_LINES_IN_E_STATE,
	PNE_I7_L3_LINES_IN_S_STATE,
	PNE_I7_L3_LINES_IN_F_STATE,
	PNE_I7_L3_LINES_IN_ANY,
	PNE_I7_L3_LINES_OUT_M_STATE,
	PNE_I7_L3_LINES_OUT_E_STATE,
	PNE_I7_L3_LINES_OUT_S_STATE,
	PNE_I7_L3_LINES_OUT_I_STATE,
	PNE_I7_L3_LINES_OUT_F_STATE,
	PNE_I7_L3_LINES_OUT_ANY,
	PNE_I7_QHL_REQUESTS_IOH_READS,
	PNE_I7_QHL_REQUESTS_IOH_WRITES,
	PNE_I7_QHL_REQUESTS_REMOTE_READS,
	PNE_I7_QHL_REQUESTS_REMOTE_WRITES,
	PNE_I7_QHL_REQUESTS_LOCAL_READS,
	PNE_I7_QHL_REQUESTS_LOCAL_WRITES,
	PNE_I7_QHL_CYCLES_FULL_IOH,
	PNE_I7_QHL_CYCLES_FULL_REMOTE,
	PNE_I7_QHL_CYCLES_FULL_LOCAL,
	PNE_I7_QHL_CYCLES_NOT_EMPTY_IOH,
	PNE_I7_QHL_CYCLES_NOT_EMPTY_REMOTE,
	PNE_I7_QHL_CYCLES_NOT_EMPTY_LOCAL,
	PNE_I7_QHL_OCCUPANCY_IOH,
	PNE_I7_QHL_OCCUPANCY_REMOTE,
	PNE_I7_QHL_OCCUPANCY_LOCAL,
	PNE_I7_QHL_ADDRESS_CONFLICTS_2WAY,
	PNE_I7_QHL_ADDRESS_CONFLICTS_3WAY,
	PNE_I7_QHL_CONFLICT_CYCLES_IOH,
	PNE_I7_QHL_CONFLICT_CYCLES_REMOTE,
	PNE_I7_QHL_CONFLICT_CYCLES_LOCAL,
	PNE_I7_QHL_TO_QMC_BYPASS,
	PNE_I7_QMC_NORMAL_FULL_READ_CH0,
	PNE_I7_QMC_NORMAL_FULL_READ_CH1,
	PNE_I7_QMC_NORMAL_FULL_READ_CH2,
	PNE_I7_QMC_NORMAL_FULL_WRITE_CH0,
	PNE_I7_QMC_NORMAL_FULL_WRITE_CH1,
	PNE_I7_QMC_NORMAL_FULL_WRITE_CH2,
	PNE_I7_QMC_ISOC_FULL_READ_CH0,
	PNE_I7_QMC_ISOC_FULL_READ_CH1,
	PNE_I7_QMC_ISOC_FULL_READ_CH2,
	PNE_I7_QMC_ISOC_FULL_WRITE_CH0,
	PNE_I7_QMC_ISOC_FULL_WRITE_CH1,
	PNE_I7_QMC_ISOC_FULL_WRITE_CH2,
	PNE_I7_QMC_BUSY_READ_CH0,
	PNE_I7_QMC_BUSY_READ_CH1,
	PNE_I7_QMC_BUSY_READ_CH2,
	PNE_I7_QMC_BUSY_WRITE_CH0,
	PNE_I7_QMC_BUSY_WRITE_CH1,
	PNE_I7_QMC_BUSY_WRITE_CH2,
	PNE_I7_QMC_OCCUPANCY_CH0,
	PNE_I7_QMC_OCCUPANCY_CH1,
	PNE_I7_QMC_OCCUPANCY_CH2,
	PNE_I7_QMC_ISSOC_OCCUPANCY_CH0,
	PNE_I7_QMC_ISSOC_OCCUPANCY_CH1,
	PNE_I7_QMC_ISSOC_OCCUPANCY_CH2,
	PNE_I7_QMC_ISSOC_READS_ANY,
	PNE_I7_QMC_NORMAL_READS_CH0,
	PNE_I7_QMC_NORMAL_READS_CH1,
	PNE_I7_QMC_NORMAL_READS_CH2,
	PNE_I7_QMC_NORMAL_READS_ANY,
	PNE_I7_QMC_HIGH_PRIORITY_READS_CH0,
	PNE_I7_QMC_HIGH_PRIORITY_READS_CH1,
	PNE_I7_QMC_HIGH_PRIORITY_READS_CH2,
	PNE_I7_QMC_HIGH_PRIORITY_READS_ANY,
	PNE_I7_QMC_CRITICAL_PRIORITY_READS_CH0,
	PNE_I7_QMC_CRITICAL_PRIORITY_READS_CH1,
	PNE_I7_QMC_CRITICAL_PRIORITY_READS_CH2,
	PNE_I7_QMC_CRITICAL_PRIORITY_READS_ANY,
	PNE_I7_QMC_WRITES_FULL_CH0,
	PNE_I7_QMC_WRITES_FULL_CH1,
	PNE_I7_QMC_WRITES_FULL_CH2,
	PNE_I7_QMC_WRITES_FULL_ANY,
	PNE_I7_QMC_WRITES_PARTIAL_CH0,
	PNE_I7_QMC_WRITES_PARTIAL_CH1,
	PNE_I7_QMC_WRITES_PARTIAL_CH2,
	PNE_I7_QMC_WRITES_PARTIAL_ANY,
	PNE_I7_QMC_CANCEL_CH0,
	PNE_I7_QMC_CANCEL_CH1,
	PNE_I7_QMC_CANCEL_CH2,
	PNE_I7_QMC_CANCEL_ANY,
	PNE_I7_QMC_PRIORITY_UPDATES_CH0,
	PNE_I7_QMC_PRIORITY_UPDATES_CH1,
	PNE_I7_QMC_PRIORITY_UPDATES_CH2,
	PNE_I7_QMC_PRIORITY_UPDATES_ANY,
	PNE_I7_QHL_FRC_ACK_CNFLTS_LOCAL,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_HOME_LINK_0,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_SNOOP_LINK_0,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_NDR_LINK_0,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_HOME_LINK_1,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_SNOOP_LINK_1,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_NDR_LINK_1,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_LINK_0,
	PNE_I7_QPI_TX_STALLED_SINGLE_FLIT_LINK_1,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_DRS_LINK_0,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_NCB_LINK_0,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_NCS_LINK_0,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_DRS_LINK_1,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_NCB_LINK_1,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_NCS_LINK_1,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_LINK_0,
	PNE_I7_QPI_TX_STALLED_MULTI_FLIT_LINK_1,
	PNE_I7_QPI_TX_HEADER_BUSY_LINK_0,
	PNE_I7_QPI_TX_HEADER_BUSY_LINK_1,
	PNE_I7_QPI_RX_NO_PPT_CREDIT_STALLS_LINK_0,
	PNE_I7_QPI_RX_NO_PPT_CREDIT_STALLS_LINK_1,
	PNE_I7_DRAM_OPEN_CH0,
	PNE_I7_DRAM_OPEN_CH1,
	PNE_I7_DRAM_OPEN_CH2,
	PNE_I7_DRAM_PAGE_CLOSE_CH0,
	PNE_I7_DRAM_PAGE_CLOSE_CH1,
	PNE_I7_DRAM_PAGE_CLOSE_CH2,
	PNE_I7_DRAM_PAGE_MISS_CH0,
	PNE_I7_DRAM_PAGE_MISS_CH1,
	PNE_I7_DRAM_PAGE_MISS_CH2,
	PNE_I7_DRAM_READ_CAS_CH0,
	PNE_I7_DRAM_READ_CAS_AUTOPRE_CH0,
	PNE_I7_DRAM_READ_CAS_CH1,
	PNE_I7_DRAM_READ_CAS_AUTOPRE_CH1,
	PNE_I7_DRAM_READ_CAS_CH2,
	PNE_I7_DRAM_READ_CAS_AUTOPRE_CH2,
	PNE_I7_DRAM_WRITE_CAS_CH0,
	PNE_I7_DRAM_WRITE_CAS_AUTOPRE_CH0,
	PNE_I7_DRAM_WRITE_CAS_CH1,
	PNE_I7_DRAM_WRITE_CAS_AUTOPRE_CH1,
	PNE_I7_DRAM_WRITE_CAS_CH2,
	PNE_I7_DRAM_WRITE_CAS_AUTOPRE_CH2,
	PNE_I7_DRAM_REFRESH_CH0,
	PNE_I7_DRAM_REFRESH_CH1,
	PNE_I7_DRAM_REFRESH_CH2,
	PNE_I7_DRAM_PRE_ALL_CH0,
	PNE_I7_DRAM_PRE_ALL_CH1,
	PNE_I7_DRAM_PRE_ALL_CH2,
	PNE_I7_NATNAME_GUARD
};

extern Native_Event_LabelDescription_t i7Processor_info[];
extern hwi_search_t i7Processor_map[];

#endif
