/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class XSLPerformSort
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return AnyItemType.getInstance();
        }
        return this.select.getItemType();
    }

    public boolean mayContainTemplateBody() {
        return false;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        boolean bl = false;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLSort) {
                bl = true;
                continue;
            }
            if (nodeInfo instanceof XSLFallback) continue;
            if (nodeInfo.getNodeKind() == 3) {
                if (Navigator.isWhite(nodeInfo.getStringValue())) continue;
                this.compileError("Character data is not allowed within xsl:perform-sort");
                continue;
            }
            this.compileError("Invalid element within xsl:perform-sort");
        }
        if (!bl) {
            this.compileError("xsl:perform-sort must have at least one xsl:sort child");
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Instruction compile() throws TransformerConfigurationException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        Sequence sequence = new Sequence(new SortExpression(this.select, sortKeyDefinitionArray), SequenceType.ANY_SEQUENCE);
        this.compileChildren(sequence);
        return sequence;
    }
}

