--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity pc_standard is
	generic(
		disksize : integer := 2048
	);
	port(
		ext_eth0 : inout eth_conn;
		ext_usb0 : inout usb_conn;
		ext_usb1 : inout usb_conn;
		ext_par : inout parallel;
		ext_ser0 : inout serial;
		ext_ser1 : inout serial;

		power_switch : in boolean;
		power_button : in boolean;
		reset_button : in boolean;

		media_floppy : inout floppy;
		floppy : in cstring;
		media_cd : inout magneto_optical;
		cdrom : in cstring;
		media_image : inout opt_rgb;
		image : in cstring;

		key : in boolean_array(0 to 127);

		mouse_dx : in integer;
		mouse_dy : in integer;
		mouse_dz : in integer;
		mouse_button1 : in boolean;
		mouse_button2 : in boolean;
		mouse_button3 : in boolean;
		mouse_button4 : in boolean;
		mouse_button5 : in boolean;

		screen_shot : in boolean;
		rec : in boolean;

		opt_screen : out opt_rgb
	);
end pc_standard;

architecture structural of pc_standard is
	signal power_board : atx_conn;
	signal power_dev0 : molex_ide_power_conn;
	signal power_dev1 : molex_ide_power_conn;
	signal power_dev2 : molex_ide_power_conn;
	signal power_dev3 : molex_ide_power_conn;
	signal power_dev4 : molex_ide_power_conn;
	signal power_dev5 : molex_ide_power_conn;
	signal power_dev6 : molex_ide_power_conn;
	signal power_dev7 : molex_ide_power_conn;

	signal int_cpu : host775_conn;
	signal int_mem0 : dimm240_conn;
	signal int_mem1 : dimm240_conn;
	signal int_mem2 : dimm240_conn;
	signal int_mem3 : dimm240_conn;
	signal int_agp : agp_conn;
	signal int_pci0 : pci_conn;
	signal int_pci1 : pci_conn;
	signal int_pci2 : pci_conn;
	signal int_sata0 : sata_bus;
	signal int_sata1 : sata_bus;
	signal int_sata2 : sata_bus;
	signal int_sata3 : sata_bus;
	signal int_sata4 : sata_bus;
	signal int_sata5 : sata_bus;
	signal int_kbd : ps2_conn;
	signal int_mouse : ps2_conn;
	signal int_shugart : shugart_conn;
	signal int_n_power_button : std_logic;
	signal int_n_reset_button : std_logic;
	signal int_vga : vga_conn;
	signal int_power_led : std_logic_conn;
	signal int_ide_led : std_logic;
	signal int_speaker : sound;
	signal int_power_230v : boolean;

begin
	chassis : chassis
		port map(
			mech_power_button => power_button,
			n_power_button => int_n_power_button,
			mech_reset_button => reset_button,
			n_reset_button => int_n_reset_button,
			power_led => int_power_led,
			ide_led => int_ide_led,
			-- audio_speaker connected with frontend
			speaker => int_speaker
		);
	power_supply : power_supply
		port map(
			mech_power_switch => power_switch,
			power_board => power_board,
			power_dev0 => power_dev0,
			power_dev1 => power_dev1,
			power_dev2 => power_dev2,
			power_dev3 => power_dev3,
			power_dev4 => power_dev4,
			power_dev5 => power_dev5,
			power_dev6 => power_dev6,
			power_dev7 => power_dev7,
			power_230v => int_power_230v
		);
	motherboard : mb_fujitsu_D2817
		port map(
			power => power_board,
			cpu => int_cpu,
			mem0 => int_mem0,
			mem1 => int_mem1,
			mem2 => int_mem2,
			mem3 => int_mem3,
			agp => int_agp,
			pci0 => int_pci0,
			pci1 => int_pci1,
			pci2 => int_pci2,
			sata0 => int_sata0,
			sata1 => int_sata1,
			sata2 => int_sata2,
			sata3 => int_sata3,
			sata4 => int_sata4,
			sata5 => int_sata5,
			usb0 => ext_usb0,
			usb1 => ext_usb1,
			ser0 => ext_ser0,
			ser1 => ext_ser1,
			par => ext_par,
			keyboard => int_kbd,
			mouse => int_mouse,
			speaker => int_speaker,
			shugart => int_shugart,
			n_power_button => int_n_power_button,
			n_reset_button => int_n_reset_button,
			power_led => int_power_led,
			ide_led => int_ide_led
		);
	cpu : cpu_intel_x86_64_int
		port map(
			conn => int_cpu
		);
	mem0 : dimm240_gen_1G
		port map(
			conn => int_mem0
		);
	video : pci_cirrus_gd5446
		port map(
			pci => int_pci0,
			vga => int_vga
		);
	eth0 : pci_intel_eepro100
		port map(
			pci => int_pci1,
			network => ext_eth0
		);
	keyboard : keyboard
		port map(
			ps2 => int_kbd,
			key0 => key(0), key1 => key(1),
			key2 => key(2), key3 => key(3),
			key4 => key(4), key5 => key(5),
			key6 => key(6), key7 => key(7),
			key8 => key(8), key9 => key(9),
			key10 => key(10), key11 => key(11),
			key12 => key(12), key13 => key(13),
			key14 => key(14), key15 => key(15),
			key16 => key(16), key17 => key(17),
			key18 => key(18), key19 => key(19),
			key20 => key(20), key21 => key(21),
			key22 => key(22), key23 => key(23),
			key24 => key(24), key25 => key(25),
			key26 => key(26), key27 => key(27),
			key28 => key(28), key29 => key(29),
			key30 => key(30), key31 => key(31),
			key32 => key(32), key33 => key(33),
			key34 => key(34), key35 => key(35),
			key36 => key(36), key37 => key(37),
			key38 => key(38), key39 => key(39),
			key40 => key(40), key41 => key(41),
			key42 => key(42), key43 => key(43),
			key44 => key(44), key45 => key(45),
			key46 => key(46), key47 => key(47),
			key48 => key(48), key49 => key(49),
			key50 => key(50), key51 => key(51),
			key52 => key(52), key53 => key(53),
			key54 => key(54), key55 => key(55),
			key56 => key(56), key57 => key(57),
			key58 => key(58), key59 => key(59),
			key60 => key(60), key61 => key(61),
			key62 => key(62), key63 => key(63),
			key64 => key(64), key65 => key(65),
			key66 => key(66), key67 => key(67),
			key68 => key(68), key69 => key(69),
			key70 => key(70), key71 => key(71),
			key72 => key(72), key73 => key(73),
			key74 => key(74), key75 => key(75),
			key76 => key(76), key77 => key(77),
			key78 => key(78), key79 => key(79),
			key80 => key(80), key81 => key(81),
			key82 => key(82), key83 => key(83),
			key84 => key(84), key85 => key(85),
			key86 => key(86), key87 => key(87),
			key88 => key(88), key89 => key(89),
			key90 => key(90), key91 => key(91),
			key92 => key(92), key93 => key(93),
			key94 => key(94), key95 => key(95),
			key96 => key(96), key97 => key(97),
			key98 => key(98), key99 => key(99),
			key100 => key(100), key101 => key(101),
			key102 => key(102), key103 => key(103),
			key104 => key(104), key105 => key(105),
			key106 => key(106), key107 => key(107),
			key108 => key(108), key109 => key(109),
			key110 => key(110), key111 => key(111),
			key112 => key(112), key113 => key(113),
			key114 => key(114), key115 => key(115),
			key116 => key(116), key117 => key(117),
			key118 => key(118), key119 => key(119),
			key120 => key(120), key121 => key(121),
			key122 => key(122), key123 => key(123),
			key124 => key(124), key125 => key(125),
			key126 => key(126), key127 => key(127)
		);
	mouse : ps2_gen_mouse_4
		port map(
			ps2 => int_mouse,
			deltax => mouse_dx,
			deltay => mouse_dy,
			deltaz => mouse_dz,
			button1 => mouse_button1,
			button2 => mouse_button2,
			button3 => mouse_button3,
			button4 => mouse_button4,
			button5 => mouse_button5
		);
	monitor : monitor_eizo_flexscan_f67
		port map(
			vga => int_vga,
			opt_video => opt_screen,
			screen_shot => screen_shot,
			rec => rec,
			power_230v => int_power_230v
		);
	floppy_drive : floppy_gen_floppydrive
		generic map(
			unit => 0
		)
		port map(
			power => power_dev2,
			shugart => int_shugart,
			media => media_floppy,
			change => floppy
		);
	hda : sata_disk_gen
		generic map(
			size => disksize
		)
		port map(
			power => power_dev0,
			sata => int_sata0
		);
	hdc : sata_cdrom_gen
		port map(
			power => power_dev1,
			sata => int_sata2,
			media => media_cd,
			change => cdrom
		);
end structural;
