/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * ASL file for FAUMachine DSDT
 * compile this file with "iasl -tc faum-dsdt.asl" to get faum-dsdt.hex
 */

DefinitionBlock ("faum-dsdt.aml", "DSDT", 2, "FAUM  ", "faum0001", 1)
{
	Scope(\_PR) /* processor scope, compatible with ACPI 1.0 */
	{
		Processor(CPU0, /* ProcessorName */
			  0x00, /* ProcessorID */
			  0x4010, /* PBlockAddress (PCNTRL, PLVL2, PLVL3) */
			  0x06) /* PBlockLength (4+1+1) */
		{ /* no sub-objects: we're not in \_SB */ }
		Processor(CPU1, /* ProcessorName */
			  0x01, /* ProcessorID */
			  0x4010, /* PBlockAddress (PCNTRL, PLVL2, PLVL3) */
			  0x06) /* PBlockLength (4+1+1) */
		{ /* no sub-objects: we're not in \_SB */ }
	}

	/* what to write in SUS_TYP on suspend to sleep state Sx: */
	Name (\_S0, Package (0x04) /* working */
	{
		0x05, Zero, Zero, Zero
	})
//	Name (\_S3, Package (0x04) /* suspend to ram */
//	{
//		0x01, Zero, Zero, Zero
//	})
	Name (\_S4, Package (0x04) /* suspend to disk */
	{
		0x00, Zero, Zero, Zero
	})
	Name (\_S5, Package (0x04) /* soft off */
	{
		0x00, Zero, Zero, Zero
	})

	Scope (\_SB) /* system bus tree */
	{
		/* PCI bus */
		Device (PCI0)
		{
			/* Device ID */
			Name (_HID, EisaId ("PNP0A03")) /* PCI Host Bridge */
			Name (_ADR, 0)
			/* Current resources (unsure...) */
			Name (_CRS, ResourceTemplate() {
				/* bus range */
				WordBusNumber (ResourceConsumer, MinFixed, MaxFixed, PosDecode,
						0x0000, 0x0000, 0x00ff, 0x0000, 0x0100,,)
				/* pci configspace access registers */
				IO (Decode16, 0x0cf8, 0x0cf8, 0x01, 0x08)
				/* IO space of Power Management */
				IO (Decode16, 0x4000, 0x4000, 1, 0x38)
				/* IO space of SMBus controller */
				IO (Decode16, 0x5000, 0x5000, 1, 0x0e)
				/* provided I/O space from pci/isa devices: */
				/* from 0 to 0xcf7 */
				WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
					0x0000, 0x0000, 0x0cf7, 0x0000, 0x0cf8,,,, TypeStatic)
				/* from 0xd00 to 0x3fff */
				WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
					0x0000, 0x0d00, 0x3fff, 0x0000, 0x3300,,,, TypeStatic)
				/* from 0x4038 to 0x4fff */
				WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
					0x0000, 0x4038, 0x4fff, 0x0000, 0x0fc8,,,, TypeStatic)
				/* from 0x500e to 0xffff */
				WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
					0x0000, 0x500e, 0xffff, 0x0000, 0xaff2,,,, TypeStatic)
				/* (possibly) decoded memory range, FIXME */
				DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed,
					Cacheable, ReadWrite, 0x00000000,
					0x50000000, /* this is where our BIOS starts assigning */
					0xffefffff, /* end of address space minus mapped BIOS ROM */ 
					0x00000000, 0xaff00000,,,, AddressRangeMemory, TypeStatic)
			})
			/* PCI IRQ Routing */
			Name(_PRT, Package() {
				/* The _PRT object is required under all PCI
				   root bridges. _PRT evaluates to a package
				   that contains a list of packages, each of
				   which describes the mapping of a PCI
				   interrupt pin.  */
				/* copied from pci.c irq routing table */
				/* Device 1: Host to PCI Bridge */
				Package(){0x0000FFFF, 0, \_SB.PCI0.ISA.LNKA, 0}, // INTA
				Package(){0x0000FFFF, 1, \_SB.PCI0.ISA.LNKB, 0}, // INTB
				Package(){0x0000FFFF, 2, \_SB.PCI0.ISA.LNKC, 0}, // INTC
				Package(){0x0000FFFF, 3, \_SB.PCI0.ISA.LNKD, 0}, // INTD
				/* Device 1: PCI to AGP Bridge */
				Package(){0x0001FFFF, 0, \_SB.PCI0.ISA.LNKB, 0}, // INTA
				Package(){0x0001FFFF, 1, \_SB.PCI0.ISA.LNKC, 0}, // INTB
				Package(){0x0001FFFF, 2, \_SB.PCI0.ISA.LNKD, 0}, // INTC
				Package(){0x0001FFFF, 3, \_SB.PCI0.ISA.LNKA, 0}, // INTD
				/* Device 7: Southbridge */
				Package(){0x0007FFFF, 0, \_SB.PCI0.ISA.LNKA, 0}, // INTA
				Package(){0x0007FFFF, 1, \_SB.PCI0.ISA.LNKB, 0}, // INTB
				Package(){0x0007FFFF, 2, \_SB.PCI0.ISA.LNKC, 0}, // INTC
				Package(){0x0007FFFF, 3, \_SB.PCI0.ISA.LNKD, 0}, // INTD
				/* Device 8: Slot 1 */
				Package(){0x0008FFFF, 0, \_SB.PCI0.ISA.LNKA, 0}, // INTA
				Package(){0x0008FFFF, 1, \_SB.PCI0.ISA.LNKB, 0}, // INTB
				Package(){0x0008FFFF, 2, \_SB.PCI0.ISA.LNKC, 0}, // INTC
				Package(){0x0008FFFF, 3, \_SB.PCI0.ISA.LNKD, 0}, // INTD
				/* Device 9: Slot 2 */
				Package(){0x0009FFFF, 0, \_SB.PCI0.ISA.LNKB, 0}, // INTA
				Package(){0x0009FFFF, 1, \_SB.PCI0.ISA.LNKC, 0}, // INTB
				Package(){0x0009FFFF, 2, \_SB.PCI0.ISA.LNKD, 0}, // INTC
				Package(){0x0009FFFF, 3, \_SB.PCI0.ISA.LNKA, 0}, // INTD
				/* Device 10: Slot 3 */
				Package(){0x000AFFFF, 0, \_SB.PCI0.ISA.LNKC, 0}, // INTA
				Package(){0x000AFFFF, 1, \_SB.PCI0.ISA.LNKD, 0}, // INTB
				Package(){0x000AFFFF, 2, \_SB.PCI0.ISA.LNKA, 0}, // INTC
				Package(){0x000AFFFF, 3, \_SB.PCI0.ISA.LNKB, 0}, // INTD
				/* Device 11: Slot 4 */
				Package(){0x000BFFFF, 0, \_SB.PCI0.ISA.LNKD, 0}, // INTA
				Package(){0x000BFFFF, 1, \_SB.PCI0.ISA.LNKA, 0}, // INTB
				Package(){0x000BFFFF, 2, \_SB.PCI0.ISA.LNKB, 0}, // INTC
				Package(){0x000BFFFF, 3, \_SB.PCI0.ISA.LNKC, 0}, // INTD
				/* In case of GA-686DLX: Device 12: Adaptec IAC-7880U */
				/* Device 12: Slot 5 */
				Package(){0x000CFFFF, 0, \_SB.PCI0.ISA.LNKA, 0}, // INTA
				Package(){0x000CFFFF, 1, \_SB.PCI0.ISA.LNKB, 0}, // INTB
				Package(){0x000CFFFF, 2, \_SB.PCI0.ISA.LNKC, 0}, // INTC
				Package(){0x000CFFFF, 3, \_SB.PCI0.ISA.LNKD, 0}  // INTD
			})
			
			/*
			   PIIX PCI IRQ Routing:

			   PCI to ISA/EIO Bridge PCI Configuration Space Registers

			   4.1.10.   PIRQRC[A:D] - PIRQX Route Control Registers (Function 0)

			   Address Offset :    60h (PIRQRCA#)-63h (PIRQRCD#)
			   Bit  Description
			    7   Interrupt Routing Enable. 0=Enable; 1=Disable.
			    6:4 Reserved. Read as 0s.
			    3:0 Interrupt Routing. When bit 7=0, this field selects the
			        routing of the PIRQx to one of the interrupt controller
				interrupt inputs.
			*/
			Device (ISA) /* chipset function 0: PCI to ISA/EIO Bridge */
			{
				Name (_ADR, 0x00070000)
				OperationRegion (PIRQ, PCI_Config, 0x60, 0x04)
				Field (PIRQ, ByteAcc, NoLock, Preserve)
				{
					PIRA, 8, PIRB, 8, PIRC, 8, PIRD, 8
				}
				Device (LNKA)
				{
					Name(_HID, EISAID("PNP0C0F")) /* PCI Interrupt Link */
					Name(_UID, 1)
					Name(_PRS, ResourceTemplate(){
						IRQ (Level, ActiveLow, Shared)
						    {3,4,5,6,7,9,10,11,12,14,15}
					})
					Method(_DIS) {
						/* set bit 7 of PIRQRCA */
						Or (0x80, PIRA, PIRA)
					}
					Method (_STA) {
						/* check bit 7 of PIRQRCA */
						And (PIRA, 0x80, Local0)
						If (LEqual (Local0, 0x80)) {
							/* present (1), functioning (8) */
							Return (0x09)
						} Else {
							/* present (1), enabled (2), functioning (8) */
							Return (0x0B)
						}
					}
					Method(_CRS) {
						/* get irq no. from PIRQRCA */
						And (PIRA, 0x0f, Local0)
						/* put it in a resource deskriptor.
						   see 6.4.2.1 (p 200). this is ugly. */
						Name (FOO, ResourceTemplate () {
							IRQ(Level, ActiveLow, Shared) { }
						})
						CreateWordField (FOO, 1, INTR)
						ShiftLeft (0x01, Local0, INTR)
						Return ( FOO )
					}
					Method(_SRS, 1) {
						/* argument: ressource deskriptor like the one
						   returned by _CRS */
						/* "decode" argument */
						CreateWordField (Arg0, 1, INTR)
						FindSetRightBit (INTR, Local0)
						/* stupid FindSetRightBit counts from 1 */
						Decrement (Local0)
						/* store it in PIRQRCA */
						Store (Local0, PIRA)
					}
				} /* end Device (LNKA) */
				Device (LNKB)
				{
					Name(_HID, EISAID("PNP0C0F")) /* PCI Interrupt Link */
					Name(_UID, 2)
					Name(_PRS, ResourceTemplate(){
						IRQ (Level, ActiveLow, Shared)
						    {3,4,5,6,7,9,10,11,12,14,15}
					})
					Method(_DIS) {
						/* set bit 7 of PIRQRCB */
						Or (0x80, PIRB, PIRB)
					}
					Method (_STA) {
						/* check bit 7 of PIRQRCB */
						And (PIRB, 0x80, Local0)
						If (LEqual (Local0, 0x80)) {
							Return (0x09)
						} Else {
							Return (0x0B)
						}
					}
					Method(_CRS) {
						And (PIRB, 0x0f, Local0)
						Name (FOO, ResourceTemplate () {
							IRQ(Level, ActiveLow, Shared) { }
						})
						CreateWordField (FOO, 1, INTR)
						ShiftLeft (0x01, Local0, INTR)
						Return ( FOO )
					}
					Method(_SRS, 1) {
						CreateWordField (Arg0, 1, INTR)
						FindSetRightBit (INTR, Local0)
						Decrement (Local0)
						Store (Local0, PIRB)
					}
				} /* end Device (LNKB) */
				Device (LNKC)
				{
					Name(_HID, EISAID("PNP0C0F")) /* PCI Interrupt Link */
					Name(_UID, 3)
					Name(_PRS, ResourceTemplate(){
						IRQ (Level, ActiveLow, Shared)
						    {3,4,5,6,7,9,10,11,12,14,15}
					})
					Method(_DIS) {
						/* set bit 7 of PIRQRCC */
						Or (0x80, PIRC, PIRC)
					}
					Method (_STA) {
						/* check bit 7 of PIRQRCC */
						And (PIRC, 0x80, Local0)
						If (LEqual (Local0, 0x80)) {
							Return (0x09)
						} Else {
							Return (0x0B)
						}
					}
					Method(_CRS) {
						And (PIRC, 0x0f, Local0)
						Name (FOO, ResourceTemplate () {
							IRQ(Level, ActiveLow, Shared) { }
						})
						CreateWordField (FOO, 1, INTR)
						ShiftLeft (0x01, Local0, INTR)
						Return ( FOO )
					}
					Method(_SRS, 1) {
						CreateWordField (Arg0, 1, INTR)
						FindSetRightBit (INTR, Local0)
						Decrement (Local0)
						Store (Local0, PIRC)
					}
				} /* end Device (LNKC) `*/
				Device (LNKD)
				{
					Name(_HID, EISAID("PNP0C0F")) /* PCI Interrupt Link */
					Name(_UID, 4)
					Name(_PRS, ResourceTemplate(){
						IRQ (Level, ActiveLow, Shared)
						    {3,4,5,6,7,9,10,11,12,14,15}
					})
					Method(_DIS) {
						/* set bit 7 of PIRQRCD */
						Or (0x80, PIRD, PIRD)
					}
					Method (_STA) {
						/* check bit 7 of PIRQRCD */
						And (PIRD, 0x80, Local0)
						If (LEqual (Local0, 0x80)) {
							Return (0x09)
						} Else {
							Return (0x0B)
						}
					}
					Method(_CRS) {
						And (PIRD, 0x0f, Local0)
						Name (FOO, ResourceTemplate () {
							IRQ(Level, ActiveLow, Shared) { }
						})
						CreateWordField (FOO, 1, INTR)
						ShiftLeft (0x01, Local0, INTR)
						Return ( FOO )
					}
					Method(_SRS, 1) {
						CreateWordField (Arg0, 1, INTR)
						FindSetRightBit (INTR, Local0)
						Decrement (Local0)
						Store (Local0, PIRD)
					}
				} /* end Device (LNKD) */

				Device (PIC) /* Programmable Interrupt Controller */
				{
					Name (_HID, EisaId ("PNP0000")) /* AT interrupt controller */
					Name (_CRS, ResourceTemplate () {
						/* Interrupt Controller 1 */
						IO (Decode16, 0x0020, 0x0020, 0x01, 0x02)
						/* Interrupt Controller 2 */
						IO (Decode16, 0x00A0, 0x00A0, 0x01, 0x02)
						/* Edge/Level Control Registers for 1 and 2 */
						IO (Decode16, 0x04d0, 0x04d0, 0x01, 0x02)
						/* IRQ 2 used to cascade controllers */
						IRQNoFlags () {2}
					})
				}

				Device (PIT) /* Programmable Interval Timer */
				{
					Name (_HID, EisaId ("PNP0100")) /* AT timer */
					Name (_CRS, ResourceTemplate () {
						/* Registers from 0x40 to 0x43 */
						IO (Decode16, 0x0040, 0x0040, 0x01, 0x04)
						/* hardwired to IRQ0 */
						IRQNoFlags () {0}
					})
				}

				Device (MOUS) /* PS/2 Mouse */
				{
					Name (_HID, EisaId ("PNP0F13")) /* PS/2 port for PS/2-style mouse */
					Name (_CRS, ResourceTemplate () {
						IRQNoFlags () {12}
					})
					Method (_STA, 0, NotSerialized) {
						Return (0x0f)
					}
				}

				Device (KEYB) /* PS/2 Keyboard */
				{
					Name (_HID, EisaId ("PNP0303")) /* IBM Enhanced (101/102-key, PS/2 mouse support) */
					Name (_CRS, ResourceTemplate () {
						IO (Decode16, 0x0060, 0x0060, 0x01, 0x01)
						IO (Decode16, 0x0064, 0x0064, 0x01, 0x01)
						IRQNoFlags () {1}
					})
					Method (_STA, 0, NotSerialized) {
						Return (0x0f)
					}
				}

				Device (DMAC) /* DMA controller */
				{
					Name (_HID, EisaId ("PNP0200")) /* AT direct memory access (DMA) controller */
					Name (_CRS, ResourceTemplate () {
						DMA (Compatibility, BusMaster, Transfer8) {4}
						IO (Decode16, 0x0000, 0x0000, 0x01, 0x10)
						IO (Decode16, 0x0080, 0x0080, 0x01, 0x11)
						IO (Decode16, 0x0094, 0x0094, 0x01, 0x0C)
						IO (Decode16, 0x00C0, 0x00C0, 0x01, 0x20)
					})
				}

				Device (RTC) /* Real-Time Clock */
				{
					Name (_HID, EisaId ("PNP0B00")) /* AT real-time clock */
					Name (_CRS, ResourceTemplate () {
						IO (Decode16, 0x0070, 0x0070, 0x04, 0x04)
						IRQNoFlags () {8}
					})
				}

				Device (SPKR) /* Speaker */
				{
					Name (_HID, EisaId ("PNP0800")) /* AT-style speaker sound */
					Name (_CRS, ResourceTemplate () {
						IO (Decode16, 0x0061, 0x0061, 0x01, 0x01)
					})
				}

				Device (COPR) /* Co-Processor */
				{
					Name (_HID, EisaId ("PNP0C04")) /* Math co-processor */
					Name (_CRS, ResourceTemplate () {
						IO (Decode16, 0x00F0, 0x00F0, 0x01, 0x10)
						IRQNoFlags () {13}
					})
				}


			// FIXME: WinXP dies with 0x0000007B when this is defined
			//	Device (IDE) /* IDE Controller */
			//	{
			//		Name (_HID, EisaId ("PNP0600")) /* Generic ESDI/IDE/ATA-compatible hard disk controller */
			//		Name (_CRS, ResourceTemplate () {
			//			/* Primary Command Block */
			//			IO (Decode16, 0x01f0, 0x01f0, 0x01, 0x08)
			//			/* Primary Control Block -- WRONG! FIXME */
			//			IO (Decode16, 0x03f4, 0x03f4, 0x01, 0x04)
			//			/* Secondary Command Block */
			//			IO (Decode16, 0x0170, 0x0170, 0x01, 0x08)
			//			/* Secondary Control Block -- WRONG! FIXME */
			//			IO (Decode16, 0x0374, 0x0374, 0x01, 0x04)
			//			IRQNoFlags () {14}
			//			IRQNoFlags () {15}
			//		})
			//	}

				Device (FLOP) /* Floppy Controller */
				{
					Name (_HID, EisaId ("PNP0700")) /* PC standard floppy disk controller (FDC) */
					Name (_CRS, ResourceTemplate () {
						/* 0x03f0 - 0x03f5 */
						IO (Decode16, 0x03f0, 0x03f0, 0x01, 0x06)
						/* 0x03f7 */
						IO (Decode16, 0x03f7, 0x03f7, 0x01, 0x01) 
						IRQNoFlags () {6}
						DMA (Compatibility, NotBusMaster, Transfer8) {2}
					})
				}

			} /* end Device (ISA) */

			Device (USB) /* chipset function 2: USB host controller */
			{
				Name (_ADR, 0x00070002)
			}

			Device (CHPM) /* chipset function 3: Power Management/SMBus */
			{
				Name (_ADR, 0x00070003)
				Name (_FIX, Package(4) {
					EISAID("PNP0C21"),  // PM1a event
					EISAID("PNP0C23"),  // PM1a control
					EISAID("PNP0C26"),  // PM Timer
					EISAID("PNP0C27")   // GPE0
				})
			}

		} /* end Device (PCI0) */
	} /* end Scope (\_SB) */
}

