/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __JIT_CACHE_H_INCLUDED
#define __JIT_CACHE_H_INCLUDED

struct jit_entry {
	struct jit_entry *prev;
	struct jit_entry *next;

	unsigned long state;
	unsigned long pc;

	void *func;
};

struct jit_cache {
	struct jit_entry *first[1024];
	struct jit_entry *last[1024];
};


extern void
jit_cache_add(struct jit_cache *cache, unsigned long state, unsigned long pc, void *func);
extern void *
jit_cache_lookup(struct jit_cache *cache, unsigned long state, unsigned long pc);

extern void
jit_cache_reset(struct jit_cache *cache);
extern void
jit_cache_create(struct jit_cache *cache);
extern void
jit_cache_destroy(struct jit_cache *cache);

#endif /* __JIT_CACHE_H_INCLUDED */
