/*
 * Copyright (C) 2014-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LRU_H_INCLUDED
#define __LRU_H_INCLUDED

#include <inttypes.h>

#define LRU_DECL(count, name)	uint8_t name[(count + 7) / 8]

extern const uint8_t lru4_use_table[8][4];
extern const uint8_t lru4_old_table[8];

extern const uint8_t lru8_use_table[128][8];
extern const uint8_t lru8_old_table[128];

extern void
lrux_use(int count, uint8_t *info, int used);
extern int
lrux_oldest(int count, uint8_t *info);
extern void
lrux_reset(int count, uint8_t *info);


static inline void
lru_use(int count, uint8_t *info, int used)
{
	switch (count) {
	case 1:
		break;
	case 2:
		*info = used;
		break;
	case 4:
		*info = lru4_use_table[*info][used];
		break;
	case 8:
		*info = lru8_use_table[*info][used];
		break;
	default:
		lrux_use(count, info, used);
		break;
	}
}

static inline int
lru_oldest(int count, uint8_t *info)
{
	switch (count) {
	case 1:
		return 0;
	case 2:
		return ! *info;
	case 4:
		return lru4_old_table[*info];
	case 8:
		return lru8_old_table[*info];
	default:
		return lrux_oldest(count, info);
	}
}

static inline void
lru_reset(int count, uint8_t *info)
{
	switch (count) {
	case 1:
	case 2:
	case 4:
	case 8:
		*info = 0;
		break;
	default:
		lrux_reset(count, info);
		break;
	}
}

#endif /* __LRU_H_INCLUDED */
