/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Replace variables in the form "$some_var" with the value from the
 * corresponding ennvironment variable.
 */

#include "config.h"

#include <stdlib.h>
#include <string.h>

#include "env.h"
#include "glue-log.h"

static char buffer[1024];

char *
env_replace(const char *src)
{
	char *dst;

	for (dst = buffer; *src; src++) {
		if (*src == '$') {
			src++;
			if (('a' <= *src && *src <= 'z')
					|| ('A' <= *src && *src <= 'Z')
					|| *src == '_') {
				char env_var[64];
				char *env_ptr;

				env_ptr = env_var;
				while (*src && (
					('a' <= *src && *src <= 'z')
					|| ('A' <= *src && *src <= 'Z')
					|| ('0' <= *src && *src <= '9')
					|| *src == '_'
					)
				) {
					*env_ptr++ = *src++;
				}
				*env_ptr = 0;
				env_ptr = getenv(env_var);
				if (env_ptr) {
					strcpy(dst, env_ptr);
					dst += strlen(env_ptr);
				} else {
					faum_log(FAUM_LOG_WARNING, "env", 
						__func__,
						"reference to unset "
						"environment variable %s\n",
						env_var);
				}
				if (! *src) {
					break;
				}
			} else if('1' <= *src && *src <= '9') {
				*dst++ = '$';
			}
		}
		*dst++ = *src;
	}
	*dst = 0;
	return buffer;
}
