--
-- Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity pci_soundcard is 
	port (
		ext_pci : inout pci_conn;
		ext_speaker : inout sound
	);
end entity pci_soundcard;

architecture pci_soundcard_impl of pci_soundcard is
	signal int_cbe_n_0 : std_logic;
	signal int_cbe_n_1 : std_logic;
	signal int_cbe_n_2 : std_logic;
	signal int_cbe_n_3 : std_logic;
	signal int_ad_0 : std_logic;
	signal int_ad_1 : std_logic;
	signal int_ad_2 : std_logic;
	signal int_ad_3 : std_logic;
	signal int_ad_4 : std_logic;
	signal int_ad_5 : std_logic;
	signal int_ad_6 : std_logic;
	signal int_ad_7 : std_logic;
	signal int_ad_8 : std_logic;
	signal int_ad_9 : std_logic;
	signal int_ad_10 : std_logic;
	signal int_ad_11 : std_logic;
	signal int_ad_12 : std_logic;
	signal int_ad_13 : std_logic;
	signal int_ad_14 : std_logic;
	signal int_ad_15 : std_logic;
	signal int_ad_16 : std_logic;
	signal int_ad_17 : std_logic;
	signal int_ad_18 : std_logic;
	signal int_ad_19 : std_logic;
	signal int_ad_20 : std_logic;
	signal int_ad_21 : std_logic;
	signal int_ad_22 : std_logic;
	signal int_ad_23 : std_logic;
	signal int_ad_24 : std_logic;
	signal int_ad_25 : std_logic;
	signal int_ad_26 : std_logic;
	signal int_ad_27 : std_logic;
	signal int_ad_28 : std_logic;
	signal int_ad_29 : std_logic;
	signal int_ad_30 : std_logic;
	signal int_ad_31 : std_logic;
	signal int_par : std_logic;
	signal int_frame_n : std_logic;
	signal int_trdy_n : std_logic;
	signal int_irdy_n : std_logic;
	signal int_stop_n : std_logic;
	signal int_devsel_n : std_logic;
	signal int_idsel : std_logic;
	signal int_perr_n : std_logic;
	signal int_serr_n : std_logic;
	signal int_clk : std_logic;
	signal int_rst_n : std_logic;
	signal int_ton_0 : std_logic;
	signal int_ton_1 : std_logic;
	signal int_ton_2 : std_logic;
	signal int_ton_3 : std_logic;
	signal int_ton_4 : std_logic;
	signal int_ton_5 : std_logic;
	signal int_ton_6 : std_logic;
	signal int_ton_7 : std_logic;
	signal int_ton_8 : std_logic;
	signal int_ton_9 : std_logic;
	signal int_ton_10 : std_logic;
	signal int_ton_11 : std_logic;
	signal int_ton_12 : std_logic;
	signal int_ton_13 : std_logic;
	signal int_ton_14 : std_logic;
	signal int_ton_15 : std_logic;
	signal int_rc_time_0 : std_logic;
	signal int_rc_time_1 : std_logic;
	signal int_rc_time_2 : std_logic;
	signal int_rc_time_3 : std_logic;
	signal int_volume_0 : std_logic;
	signal int_volume_1 : std_logic;
	signal int_volume_2 : std_logic;
	signal int_volume_3 : std_logic;
	signal int_ton_out : std_logic;
	signal int_sound_left : sound;
	signal int_sound_right : sound;
	signal int_sound_audio_left : sound;
	signal int_sound_audio_right : sound;
begin
	pci_converter : misc_pci_vhdl_con 
		port map (
			pci => ext_pci,
			cbe_n_0 => int_cbe_n_0,
			cbe_n_1 => int_cbe_n_1,
			cbe_n_2 => int_cbe_n_2,
			cbe_n_3 => int_cbe_n_3,
			ad_0 => int_ad_0,
			ad_1 => int_ad_1,
			ad_2 => int_ad_2,
			ad_3 => int_ad_3,
			ad_4 => int_ad_4,
			ad_5 => int_ad_5,
			ad_6 => int_ad_6,
			ad_7 => int_ad_7,
			ad_8 => int_ad_8,
			ad_9 => int_ad_9,
			ad_10 => int_ad_10,
			ad_11 => int_ad_11,
			ad_12 => int_ad_12,
			ad_13 => int_ad_13,
			ad_14 => int_ad_14,
			ad_15 => int_ad_15,
			ad_16 => int_ad_16,
			ad_17 => int_ad_17,
			ad_18 => int_ad_18,
			ad_19 => int_ad_19,
			ad_20 => int_ad_20,
			ad_21 => int_ad_21,
			ad_22 => int_ad_22,
			ad_23 => int_ad_23,
			ad_24 => int_ad_24,
			ad_25 => int_ad_25,
			ad_26 => int_ad_26,
			ad_27 => int_ad_27,
			ad_28 => int_ad_28,
			ad_29 => int_ad_29,
			ad_30 => int_ad_30,
			ad_31 => int_ad_31,
			par => int_par,
			frame_n => int_frame_n,
			trdy_n => int_trdy_n,
			irdy_n => int_irdy_n,
			stop_n => int_stop_n,
			devsel_n => int_devsel_n,
			idsel => int_idsel,
			perr_n => int_perr_n,
			serr_n => int_serr_n,
			clk => int_clk,
			rst_n => int_rst_n
		);

	pci_interface : pcicard 
		port map (
			irdy_n	=> int_irdy_n,
			cbe_n_0 => int_cbe_n_0,
			cbe_n_1 => int_cbe_n_1,
			cbe_n_2 => int_cbe_n_2,
			cbe_n_3 => int_cbe_n_3,
			ad_0 => int_ad_0,
			ad_1 => int_ad_1,
			ad_2 => int_ad_2,
			ad_3 => int_ad_3,
			ad_4 => int_ad_4,
			ad_5 => int_ad_5,
			ad_6 => int_ad_6,
			ad_7 => int_ad_7,
			ad_8 => int_ad_8,
			ad_9 => int_ad_9,
			ad_10 => int_ad_10,
			ad_11 => int_ad_11,
			ad_12 => int_ad_12,
			ad_13 => int_ad_13,
			ad_14 => int_ad_14,
			ad_15 => int_ad_15,
			ad_16 => int_ad_16,
			ad_17 => int_ad_17,
			ad_18 => int_ad_18,
			ad_19 => int_ad_19,
			ad_20 => int_ad_20,
			ad_21 => int_ad_21,
			ad_22 => int_ad_22,
			ad_23 => int_ad_23,
			ad_24 => int_ad_24,
			ad_25 => int_ad_25,
			ad_26 => int_ad_26,
			ad_27 => int_ad_27,
			ad_28 => int_ad_28,
			ad_29 => int_ad_29,
			ad_30 => int_ad_30,
			ad_31 => int_ad_31,
			par => int_par,
			frame_n => int_frame_n,
			trdy_n => int_trdy_n,
			devsel_n => int_devsel_n,
			idsel => int_idsel,
			clk => int_clk,
			rst_n => int_rst_n,
			reg_out_xx0_0 => int_ton_0,
			reg_out_xx0_1 => int_ton_1,
			reg_out_xx0_2 => int_ton_2,
			reg_out_xx0_3 => int_ton_3,
			reg_out_xx0_4 => int_ton_4,
			reg_out_xx0_5 => int_ton_5,
			reg_out_xx0_6 => int_ton_6,
			reg_out_xx0_7 => int_ton_7,
			reg_out_xx1_0 => int_ton_8,
			reg_out_xx1_1 => int_ton_9,
			reg_out_xx1_2 => int_ton_10,
			reg_out_xx1_3 => int_ton_11,
			reg_out_xx1_4 => int_ton_12,
			reg_out_xx1_5 => int_ton_13,
			reg_out_xx1_6 => int_ton_14,
			reg_out_xx1_7 => int_ton_15
		);

	sound_gen : chip_gen_sound
		port map (
			ton_in_0 => int_ton_0,
			ton_in_1 => int_ton_1,
			ton_in_2 => int_ton_2,
			ton_in_3 => int_ton_3,
			ton_in_4 => int_ton_4,
			ton_in_5 => int_ton_5,
			ton_in_6 => int_ton_6,
			ton_in_7 => int_ton_7,
			ton_in_8 => int_ton_8,
			ton_in_9 => int_ton_9,
			ton_in_10 => int_ton_10,
			ton_in_11 => int_ton_11,
			ton_in_12 => int_ton_12,
			ton_in_13 => int_ton_13,
			ton_in_14 => int_ton_14,
			ton_in_15 => int_ton_15,
			pci_clock => int_clk,
			rstn => int_rst_n,
			rc_time_0 => int_rc_time_0,
			rc_time_1 => int_rc_time_1,
			rc_time_2 => int_rc_time_2,
			rc_time_3 => int_rc_time_3,
			volume_0 => int_volume_0,
			volume_1 => int_volume_1,
			volume_2 => int_volume_2,
			volume_3 => int_volume_3,
			ton_out => int_ton_out
		);

	amplifier : misc_analog_rcsound
		port map (
			ton_in => int_ton_out,
			rc_in_0 => int_rc_time_0,
			rc_in_1 => int_rc_time_1,
			rc_in_2 => int_rc_time_2,
			rc_in_3 => int_rc_time_3,
			vol_in_0 => int_volume_0,
			vol_in_1 => int_volume_1,
			vol_in_2 => int_volume_2,
			vol_in_3 => int_volume_3,
			snd_out_left => int_sound_left,
			snd_out_right => int_sound_right
		);

	speaker : loudspeaker
		port map (
			sound_in_left => int_sound_left,
			sound_in_right => int_sound_right,
			audio_sound_left => int_sound_audio_left,
			audio_sound_right => int_sound_audio_right
		);
end;

	
