/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
    unsigned int states[3];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

#ifdef DEBUG
#define STR(x)   #x
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* DEBUG */

static void
NAME_(create)(struct cpssp *cpssp)
{
    cpssp->NAME.states[0] = 0;
    cpssp->NAME.states[1] = 0;
    cpssp->NAME.states[2] = 0;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = 0;

#ifdef DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to JUST A DUMMY\n", res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_1_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
}

#ifdef NAME_IN_PORT_0_
static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[0] = 2000 < SIG_mV(val);
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_0_ */

#ifdef NAME_IN_PORT_1_
static void
NAME_IN_PORT_1_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[1] = 2000 < SIG_mV(val);
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_1_ */

#ifdef NAME_IN_PORT_2_
static void
NAME_IN_PORT_2_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[2] = 2000 < SIG_mV(val);
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_2_ */

#endif /*BEHAVIOUR*/
