/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
    unsigned int states[6];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

#ifdef DEBUG
#define STR(x)   #x
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* DEBUG */

static void
NAME_(create)(struct cpssp *cpssp)
{
    cpssp->NAME.states[0] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[1] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[2] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[3] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[4] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[5] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[6] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[7] = SIG_STD_LOGIC_Z;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    /*
       res_0 ^= 0 & 1 & 2 & 4
       res_1 ^= 3 & 1 & 2 & 4

       res_2 ^= 5 & 1 & 4 & 6
       res_3 ^= 7 & 1 & 4 & 6

       -->  if (1 2 4) 0=0 1=3
       if (1 4 6) 2=5 3=7
       */

    unsigned int res_0;
    unsigned int res_1;
    unsigned int res_2;
    unsigned int res_3;

    if(2000 < SIG_mV(cpssp->NAME.states[1]) &&
       2000 < SIG_mV(cpssp->NAME.states[2]) &&
       2000 < SIG_mV(cpssp->NAME.states[4])) {

	res_0 = 2000 < SIG_mV(cpssp->NAME.states[0]);
	res_1 = 2000 < SIG_mV(cpssp->NAME.states[3]);

    } else {
	res_0 = 0;
	res_1 = 0;
    }
    if(2000 < SIG_mV(cpssp->NAME.states[1]) &&
       2000 < SIG_mV(cpssp->NAME.states[4]) &&
       2000 < SIG_mV(cpssp->NAME.states[6])) {

	res_2 = 2000 < SIG_mV(cpssp->NAME.states[5]);
	res_3 = 2000 < SIG_mV(cpssp->NAME.states[7]);

    } else {
	res_2 = 0;
	res_3 = 0;
    }

#ifdef DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets OUTP_0 to %i\n", res_0);
    fprintf(stderr, "\tsets OUTP_1 to %i\n", res_1);
    fprintf(stderr, "\tsets OUTP_2 to %i\n", res_2);
    fprintf(stderr, "\tsets OUTP_3 to %i\n", res_3);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res_0 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_1_(out_set)(cpssp, res_1 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_2_(out_set)(cpssp, res_2 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_3_(out_set)(cpssp, res_3 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
}

#ifdef NAME_IN_PORT_0_
static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[0] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_0_ */

#ifdef NAME_IN_PORT_1_
static void
NAME_IN_PORT_1_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[1] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_1_ */

#ifdef NAME_IN_PORT_2_
static void
NAME_IN_PORT_2_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[2] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_2_ */

#ifdef NAME_IN_PORT_3_
static void
NAME_IN_PORT_3_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[3] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_3_ */

#ifdef NAME_IN_PORT_4_
static void
NAME_IN_PORT_4_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[4] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_4_ */

#ifdef NAME_IN_PORT_5_
static void
NAME_IN_PORT_5_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[5] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_5_ */

#ifdef NAME_IN_PORT_6_
static void
NAME_IN_PORT_6_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[6] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_6_ */

#ifdef NAME_IN_PORT_7_
static void
NAME_IN_PORT_7_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[7] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_7_ */


#endif /*BEHAVIOUR*/
