/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
    unsigned int states[1];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

#ifdef DEBUG
#define STR(x)   #x
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* DEBUG */

static void
NAME_(create)(struct cpssp *cpssp)
{
    cpssp->NAME.states[0] = SIG_STD_LOGIC_Z;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {

    /* negates */

#ifdef DEBUG
    SHOW_DEFINE(NAME);
    unsigned int res = 2000 < SIG_mV(cpssp->NAME.states[0]) ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1;
    fprintf(stderr, " sets to %i\n", res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, 2000 < SIG_mV(cpssp->NAME.states[0]) ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1);
}

#ifdef NAME_IN_PORT_0_
static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[0] = val;
    NAME_(solve)(cpssp);
}
#endif /*BEHAVIOUR*/
