/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "voltmeter_gui.h"
#ifdef HAVE_GTK
#include "voltmeter_gui_gtk.h"
#endif

#define COMP_(x)	voltmeter_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_input,
	struct sig_std_logic *port_output,
	struct sig_integer *port_voltage
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name, port_manage,
				port_input, port_output, port_voltage);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}
