/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "glue.h"
#include "glue-gui-gtk.h"

#include "potentiometer_gui_gtk.h"

#define COMP		"potentiometer"
#define COMP_(x)	potentiometer_ ## x

struct cpssp {
	GtkAdjustment *gui_adj;
	struct sig_integer *port_adj;
};

/*
 * Simulator Callbacks
 */
static void
COMP_(gui_gtk_adj_sim)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	assert(0 <= val
	    && val <= 100);

	gtk_adjustment_set_value(cpssp->gui_adj, (gdouble) val);
	g_signal_emit_by_name(cpssp->gui_adj, "changed");
}

/*
 * GUI Callbacks
 */
static void
COMP_(gui_gtk_adj_gui)(GtkAdjustment *adj, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	sig_integer_set(cpssp->port_adj, cpssp, (int) adj->value);
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_left,
	struct sig_std_logic *port_mid,
	struct sig_std_logic *port_right,
	struct sig_integer *port_adj
)
{
	static const struct sig_integer_funcs adj_funcs = {
		.set = COMP_(gui_gtk_adj_sim),
	};
	struct cpssp *cpssp;
	GtkWidget *box;
	GtkWidget *label;
	GtkWidget *scale;
	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	box = gtk_vbox_new(FALSE, 1);

	label = gtk_label_new("Value");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, FALSE, 0);

	/* New scale widget to set intensity of potentiometer. */
	cpssp->gui_adj = (GtkAdjustment *) gtk_adjustment_new(0.0, /* value */
			0.0, /* lower */
			110.0, /* upper + pagesize */
			5.0, /* step increment */
			10.0, /* page increment */
			10.0 /* page size */);
	g_signal_connect(cpssp->gui_adj, "value_changed",
			G_CALLBACK(COMP_(gui_gtk_adj_gui)), cpssp);
	scale = gtk_hscale_new(cpssp->gui_adj);
	gtk_widget_show(scale);
	gtk_box_pack_start(GTK_BOX(box), scale, TRUE, FALSE, 0);

	gtk_widget_show(box);

	gui_gtk_comp_add(page, COMP, name, box, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_adj = port_adj;

	/* In */
	sig_integer_connect_in(port_adj, cpssp, &adj_funcs);

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}
