/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"

#include "lcd_s401m16kr.h"

#define COMP_(x) lcd_s401m16kr_ ## x

struct cpssp {
	unsigned int state_seg[8];

	int seg[32];

	struct sig_opt_rgb *port_opt[32];
};

static void
COMP_(com_set)(void *_cpssp, int n, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if (val == SIG_STD_LOGIC_0) {
		int i;

		for (i = 0; i < 8; i++) {
			uint8_t col;
			cpssp->seg[i * 4 + n] = cpssp->state_seg[i];
			col = cpssp->state_seg[i] ? 0x00 : 0xff;
			sig_opt_rgb_pixel_set(cpssp->port_opt[i * 4 + n], cpssp,
					0, 0, col, col, col);
		}
#if 0
		fprintf(stderr, "LCD State: ");
		for (i = 0; i < 32; i++) {
			fprintf(stderr, "%d", cpssp->seg[i]);
		}
		fprintf(stderr, "\n");
#endif
	}
}

static void
COMP_(seg_set)(void *_cpssp, int n, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->state_seg[n] = val == SIG_STD_LOGIC_0 ? 0 : 1;
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *manage,
	struct sig_std_logic *port_com0,
	struct sig_std_logic *port_com1,
	struct sig_std_logic *port_com2,
	struct sig_std_logic *port_com3,
	struct sig_std_logic *port_D1_E1_G1_F1,
	struct sig_std_logic *port_DP1_C1_B1_A1,
	struct sig_std_logic *port_D2_E2_G2_F2,
	struct sig_std_logic *port_DP2_C2_B2_A2,
	struct sig_std_logic *port_D3_E3_G3_F3,
	struct sig_std_logic *port_DP3_C3_B3_A3,
	struct sig_std_logic *port_D4_E4_G4_F4,
	struct sig_std_logic *port_COL_C4_B4_A4,
	struct sig_opt_rgb *port_D1,
	struct sig_opt_rgb *port_E1,
	struct sig_opt_rgb *port_G1,
	struct sig_opt_rgb *port_F1,
	struct sig_opt_rgb *port_DP1,
	struct sig_opt_rgb *port_C1,
	struct sig_opt_rgb *port_B1,
	struct sig_opt_rgb *port_A1,
	struct sig_opt_rgb *port_D2,
	struct sig_opt_rgb *port_E2,
	struct sig_opt_rgb *port_G2,
	struct sig_opt_rgb *port_F2,
	struct sig_opt_rgb *port_DP2,
	struct sig_opt_rgb *port_C2,
	struct sig_opt_rgb *port_B2,
	struct sig_opt_rgb *port_A2,
	struct sig_opt_rgb *port_D3,
	struct sig_opt_rgb *port_E3,
	struct sig_opt_rgb *port_G3,
	struct sig_opt_rgb *port_F3,
	struct sig_opt_rgb *port_DP3,
	struct sig_opt_rgb *port_C3,
	struct sig_opt_rgb *port_B3,
	struct sig_opt_rgb *port_A3,
	struct sig_opt_rgb *port_D4,
	struct sig_opt_rgb *port_E4,
	struct sig_opt_rgb *port_G4,
	struct sig_opt_rgb *port_F4,
	struct sig_opt_rgb *port_COL,
	struct sig_opt_rgb *port_C4,
	struct sig_opt_rgb *port_B4,
	struct sig_opt_rgb *port_A4
)
{
	static const struct sig_std_logic_funcs com_funcs = {
		.std_logic_setN = COMP_(com_set),
	};
	static const struct sig_std_logic_funcs seg_funcs = {
		.std_logic_setN = COMP_(seg_set),
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	/* Out */
	cpssp->port_opt[0] = port_D1;
	cpssp->port_opt[1] = port_E1,
	cpssp->port_opt[2] = port_G1,
	cpssp->port_opt[3] = port_F1,
	cpssp->port_opt[4] = port_DP1,
	cpssp->port_opt[5] = port_C1,
	cpssp->port_opt[6] = port_B1,
	cpssp->port_opt[7] = port_A1,
	cpssp->port_opt[8] = port_D2;
	cpssp->port_opt[9] = port_E2,
	cpssp->port_opt[10] = port_G2,
	cpssp->port_opt[11] = port_F2,
	cpssp->port_opt[12] = port_DP2,
	cpssp->port_opt[13] = port_C2,
	cpssp->port_opt[14] = port_B2,
	cpssp->port_opt[15] = port_A2,
	cpssp->port_opt[16] = port_D3;
	cpssp->port_opt[17] = port_E3,
	cpssp->port_opt[18] = port_G3,
	cpssp->port_opt[19] = port_F3,
	cpssp->port_opt[20] = port_DP3,
	cpssp->port_opt[21] = port_C3,
	cpssp->port_opt[22] = port_B3,
	cpssp->port_opt[23] = port_A3,
	cpssp->port_opt[24] = port_D4;
	cpssp->port_opt[25] = port_E4,
	cpssp->port_opt[26] = port_G4,
	cpssp->port_opt[27] = port_F4,
	cpssp->port_opt[28] = port_COL,
	cpssp->port_opt[29] = port_C4,
	cpssp->port_opt[30] = port_B4,
	cpssp->port_opt[31] = port_A4,

	/* In */
	sig_std_logic_connect_inN(port_com0, cpssp, 0, &com_funcs);
	sig_std_logic_connect_inN(port_com1, cpssp, 1, &com_funcs);
	sig_std_logic_connect_inN(port_com2, cpssp, 2, &com_funcs);
	sig_std_logic_connect_inN(port_com3, cpssp, 3, &com_funcs);

	cpssp->state_seg[0] = 0;
	sig_std_logic_connect_inN(port_D1_E1_G1_F1, cpssp, 0, &seg_funcs);
	cpssp->state_seg[1] = 0;
	sig_std_logic_connect_inN(port_DP1_C1_B1_A1, cpssp, 1, &seg_funcs);
	cpssp->state_seg[2] = 0;
	sig_std_logic_connect_inN(port_D2_E2_G2_F2, cpssp, 2, &seg_funcs);
	cpssp->state_seg[3] = 0;
	sig_std_logic_connect_inN(port_DP2_C2_B2_A2, cpssp, 3, &seg_funcs);
	cpssp->state_seg[4] = 0;
	sig_std_logic_connect_inN(port_D3_E3_G3_F3, cpssp, 4, &seg_funcs);
	cpssp->state_seg[5] = 0;
	sig_std_logic_connect_inN(port_DP3_C3_B3_A3, cpssp, 5, &seg_funcs);
	cpssp->state_seg[6] = 0;
	sig_std_logic_connect_inN(port_D4_E4_G4_F4, cpssp, 6, &seg_funcs);
	cpssp->state_seg[7] = 0;
	sig_std_logic_connect_inN(port_COL_C4_B4_A4, cpssp, 7, &seg_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
