/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"

#include "button_down.h"

#define COMP_(x)	button_down_ ## x

struct cpssp {
	int state_mech_push_button;

	struct sig_std_logic *port_push_button;
};

static void
COMP_(mech_button_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	sig_std_logic_set(cpssp->port_push_button, cpssp,
			val ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_Z);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *manage,
	struct sig_boolean *port_mech_push_button,
	struct sig_std_logic *port_push_button
)
{
	static const struct sig_boolean_funcs mech_push_button_funcs = {
		.set = COMP_(mech_button_set),
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	/* Call */
	/* Out */
	cpssp->port_push_button = port_push_button;
	sig_std_logic_connect_out(port_push_button, cpssp, SIG_STD_LOGIC_Z);

	/* In */
	cpssp->state_mech_push_button = 0;
	sig_boolean_connect_in(port_mech_push_button, cpssp,
			&mech_push_button_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}

