/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(register_event)(struct cpssp *cpssp, int channel, bool rising_edge);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(register_event)(struct cpssp *cpssp, int channel, bool rising_edge)
{
	struct event_measure_point event_measure_point;

	if (! cpssp->running) {
		return;
	}
	if (cpssp->registered_events[channel] == cpssp->first_event_buffer_pos[channel]
	 && cpssp->registered_events[channel] != 0
	 && cpssp->first_event_buffer_pos[channel] != 0) {
		fprintf(stderr, "event overflow channel %d at pos %d\n",
				channel, cpssp->registered_events[channel]);
		return;
	}

	event_measure_point = cpssp->event_buffer[channel][cpssp->registered_events[channel]];
	event_measure_point.time_stamp = time_virt();
	event_measure_point.hi = rising_edge;
	cpssp->event_buffer[channel][cpssp->registered_events[channel]] = event_measure_point;
	cpssp->registered_events[channel]++;
	cpssp->registered_events[channel] %= EVENT_BUFFER_SIZE;

	if (cpssp->trigger_armed
	 && cpssp->trigger_edge == rising_edge) {
		register_trigger(cpssp, channel + NUMBER_ANALOG_CHANNELS);
	}
}

#endif /* BEHAVIOUR */
