/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(start_acquisition)(void *_cpssp, unsigned int val);
/*forward*/ static void
NAME_(stop_acquisition)(void *_cpssp, unsigned int val);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(print_summary)(struct cpssp *cpssp)
{
	int channel;

	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
		fprintf(stderr, "******SUMMARY******CH%d******\n", channel);
		long long sample_count = 0;
		int buffer_count = 0;
		int buffer_pos = cpssp->first_buffer_pos[channel];
		fprintf(stderr, "start buffer pos %d\n", buffer_pos);
		if (buffer_pos == -1) {
			buffer_pos = 0;
		}
		if (cpssp->last_buffer_pos[channel] == -1) {
			continue;
		}
		sample_count -= cpssp->first_sample_pos[channel];
		struct RLE_buffer_item buf = cpssp->RLE_buffer[channel][buffer_pos];
		while (buf.sample_count != -1) {
			buffer_count++;
			sample_count += buf.sample_count;
			if (buffer_pos == cpssp->last_buffer_pos[channel]) {
				break;
			}
			buffer_pos++;
			buffer_pos %= RLE_BUFFER_SIZE;
			buf = cpssp->RLE_buffer[channel][buffer_pos];

		}
		fprintf(stderr, "total samples %lld\n", sample_count);
		fprintf(stderr, "total number buffer items %d\n",
				buffer_count);
		cpssp->total_number_buffer_items[channel] = buffer_count;
	}
	for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
		fprintf(stderr, "******SUMMARY*******D%d*******\n", channel);
		int event_count = 0;
		int buffer_pos = cpssp->first_event_buffer_pos[channel];
		if (buffer_pos == -1) {
			buffer_pos = 0;
		}
		if (cpssp->last_event_buffer_pos[channel] == -1) {
			continue;
		}
		struct event_measure_point buf = cpssp->event_buffer[channel][buffer_pos];
		while (buf.time_stamp != 0) {
			event_count++;
			if (buffer_pos
				== cpssp->last_event_buffer_pos[channel]) {
				break;
			}
			buffer_pos++;
			buffer_pos %= EVENT_BUFFER_SIZE;
			buf = cpssp->event_buffer[channel][buffer_pos];
		}
		fprintf(stderr, "total events %d\n", event_count);
		cpssp->total_number_events[channel] = event_count;
	}
}

static void
NAME_(stop)(struct cpssp *cpssp)
{
	int channel;

	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
		cpssp->last_buffer_pos[channel] =
			cpssp->RLE_buffer_pos[channel];
		struct RLE_buffer_item last_buffer_item =
			cpssp->RLE_buffer[channel][cpssp->last_buffer_pos[channel]];
		if (last_buffer_item.sample_count != -1) {
			cpssp->last_sample_pos[channel] = last_buffer_item.sample_count;
		}

	}
	for (channel = 0; channel < NUMBER_DIGITAL_CHANNELS; channel++) {
		cpssp->last_event_buffer_pos[channel] =
			cpssp->registered_events[channel];
	}
	NAME_(print_summary)(cpssp);
	cpssp->end_time = time_virt();
	cpssp->last_pos_ticks = cpssp->timer_tick_count;
	cpssp->running = false;

	wipe_screen(cpssp);
	update_pixel_buffer(cpssp);
}

static void
NAME_(on_timer_tick)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	struct RLE_buffer_item current_buffer_item;
	int current_RLE_buffer_pos;
	int channel;

	if (! cpssp->running) {
		return;
	}
	for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
		current_RLE_buffer_pos = cpssp->RLE_buffer_pos[channel];
		current_buffer_item = cpssp->RLE_buffer[channel][current_RLE_buffer_pos];
		if (current_buffer_item.sample_count == -1) {
			/* first item for channel */
			current_buffer_item.value = cpssp->channel_values[channel];
			current_buffer_item.sample_count = 1;
			current_buffer_item.time_stamp = time_virt();
			cpssp->RLE_buffer[channel][current_RLE_buffer_pos] = current_buffer_item;
			continue;
		}
		if (current_buffer_item.value == cpssp->channel_values[channel]
		 && current_buffer_item.sample_count < INT8_MAX - 1) {
			current_buffer_item.sample_count++;
			cpssp->RLE_buffer[channel][current_RLE_buffer_pos] = current_buffer_item;
		} else {
			current_RLE_buffer_pos++;
			current_RLE_buffer_pos %= RLE_BUFFER_SIZE;

			if (current_RLE_buffer_pos == cpssp->first_buffer_pos[channel]) {
				/* Real overflow */
				NAME_(print_summary)(cpssp);
				cpssp->running = false;
				wipe_screen(cpssp);
				update_pixel_buffer(cpssp);
				return;
			} else {
				/* add new buffer item */
				struct RLE_buffer_item next_item;
				next_item.value = cpssp->channel_values[channel];
				next_item.sample_count = 1;
				next_item.time_stamp = time_virt();
				cpssp->RLE_buffer[channel][current_RLE_buffer_pos] =
							next_item;
				cpssp->RLE_buffer_pos[channel] = current_RLE_buffer_pos;
			}
		}
	}
	cpssp->timer_tick_count += cpssp->ticks_per_sample;

	if (cpssp->trigger_armed == false) {
		cpssp->number_samples_total++;
	}
	if (cpssp->sweep_time * (double)cpssp->sample_rate <= cpssp->number_samples_total) {
		NAME_(stop)(cpssp);
	}
	if (cpssp->running == true) {
		if (time_virt() == ULONG_MAX - 1) {
			NAME_(stop)(cpssp);
		}
		time_call_at( time_virt() + cpssp->call_after_ticks, &NAME_(on_timer_tick), cpssp);
	}
}

static void
NAME_(start_acquisition)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	int mV;

	mV = SIG_mV(val);
	if (0 < mV
	 && ! cpssp->running) {
		int i;

		cpssp->running = true;
		cpssp->number_samples_total = 0;
		cpssp->screen_start_time = 0.0;
		cpssp->start_time = 0;
		cpssp->end_time = 0;
		cpssp->trigger_armed = true;

		for (i = 0; i < NUMBER_ANALOG_CHANNELS; i++) {
			int j;

			cpssp->RLE_buffer_pos[i] = 0;
			cpssp->RLE_buffer_read_pos[i] = 0;
			cpssp->buffer_item_skipped_samples[i] = 0;
			cpssp->total_number_buffer_items[i] = 0;
			cpssp->last_on_screen_y[i] = -1 ;
			cpssp->pixel_step_overflow[i] = 0.0;
			cpssp->first_buffer_pos[i] = -1;
			cpssp->first_sample_pos[i] = 0;

			for (j = 0; j < RLE_BUFFER_SIZE; j++) {
				struct RLE_buffer_item item;

				item = cpssp->RLE_buffer[i][j];
				item.sample_count = -1;
				item.time_stamp = 0;
				cpssp->RLE_buffer[i][j] = item;
			}
		}
		for (i = 0; i < NUMBER_DIGITAL_CHANNELS; i++) {
			int j;

			cpssp->digital_channel_hi[i] = false;
			cpssp->registered_events[i] = 0;
			cpssp->event_pointer[i] = 0;
			cpssp->total_number_events[i] = 0;
			cpssp->first_event_buffer_pos[i] = 0;
			cpssp->last_event_buffer_pos[i] = 0;

			for (j = 0; j < EVENT_BUFFER_SIZE; j++) {
				struct event_measure_point event_item;

				event_item = cpssp->event_buffer[i][j];
				event_item.time_stamp = 0;
				cpssp->event_buffer[i][j] = event_item;
			}
		}
		wipe_screen(cpssp);
		cpssp->start_time = time_virt();
		NAME_(on_timer_tick)(cpssp);
		if (cpssp->initial_start) {
			cpssp->initial_start = false;
			draw_pixels(cpssp);
		}
	}
}

static void
NAME_(stop_acquisition)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	int mV;

	mV = SIG_mV(val);
	if (0 < mV) {
		NAME_(stop)(cpssp);
	}

}

#endif /* BEHAVIOUR */
