function s = char(dd)

% Given a one element dates object, returns a string with the formatted date.
%
% INPUTS
%   o dd   dates object with one element
%
% OUTPUTS
%   o s    a string
%
% SPECIAL REQUIREMENTS
%   none

% Copyright (C) 2014-2017 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

if length(dd)>1
    error('The input argument must be a singleton dates object!')
end

s = date2string(dd.time, dd.freq);