/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.MinimizerInterface;
import org.jmol.i18n.GT;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class Minimizer
implements MinimizerInterface {
    public Viewer viewer;
    public Atom[] atoms;
    public MinAtom[] minAtoms;
    public MinBond[] minBonds;
    public BitSet bsMinFixed;
    private int atomCount;
    private int bondCount;
    private int atomCountFull;
    private int[] atomMap;
    public int[][] angles;
    public int[][] torsions;
    public double[] partialCharges;
    private int steps = 50;
    private double crit = 0.001;
    private static Vector atomTypes;
    private ForceField pFF;
    private String ff = "UFF";
    private BitSet bsTaint;
    private BitSet bsSelected;
    private BitSet bsAtoms;
    private BitSet bsFixed;
    public Vector constraints;
    private Hashtable constraintMap;
    static final int TOKEN_ELEMENT_ONLY = 0;
    static final int TOKEN_ELEMENT_CHARGED = 1;
    static final int TOKEN_ELEMENT_CONNECTED = 2;
    static final int TOKEN_ELEMENT_AROMATIC = 3;
    static final int TOKEN_ELEMENT_SP = 4;
    static final int TOKEN_ELEMENT_SP2 = 5;
    static final int PT_ELEMENT = 2;
    static final int PT_CHARGE = 5;
    static final int PT_CONNECT = 6;
    static final Token[][] tokenTypes;
    boolean minimizationOn;
    private MinimizationThread minimizationThread;
    double[][] coordSaved;

    public void setProperty(String string, Object object) {
        if (string.equals("cancel")) {
            this.stopMinimization(false);
            return;
        }
        if (string.equals("clear")) {
            if (this.minAtoms != null) {
                this.stopMinimization(false);
                this.clear();
            }
            return;
        }
        if (string.equals("constraint")) {
            this.addConstraint((Object[])object);
            return;
        }
        if (string.equals("fixed")) {
            this.bsFixed = (BitSet)object;
            return;
        }
        if (string.equals("stop")) {
            this.stopMinimization(true);
            return;
        }
        if (string.equals("viewer")) {
            this.viewer = (Viewer)object;
            return;
        }
    }

    public Object getProperty(String string, int n) {
        if (string.equals("log")) {
            return this.pFF == null ? "" : this.pFF.getLogData();
        }
        return null;
    }

    private void addConstraint(Object[] objectArray) {
        String string;
        Object[] objectArray2;
        if (objectArray == null) {
            return;
        }
        int[] nArray = (int[])objectArray[0];
        int n = nArray[0];
        if (n == 0) {
            this.constraints = null;
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Vector();
            this.constraintMap = new Hashtable();
        }
        if (nArray[1] > nArray[n]) {
            ArrayUtil.swap(nArray, 1, n);
            if (n == 4) {
                ArrayUtil.swap(nArray, 2, 3);
            }
        }
        if ((objectArray2 = (Object[])this.constraintMap.get(string = Escape.escape(nArray))) != null) {
            objectArray2[2] = objectArray[2];
            return;
        }
        this.constraintMap.put(string, objectArray);
        this.constraints.addElement(objectArray);
    }

    private void clear() {
        this.setMinimizationOn(false);
        this.atomCount = 0;
        this.bondCount = 0;
        this.atoms = null;
        this.minAtoms = null;
        this.minBonds = null;
        this.angles = null;
        this.torsions = null;
        this.partialCharges = null;
        this.coordSaved = null;
        this.atomMap = null;
        this.bsTaint = null;
        this.bsAtoms = null;
        this.bsFixed = null;
        this.bsMinFixed = null;
        this.bsSelected = null;
        this.constraints = null;
        this.constraintMap = null;
        this.pFF = null;
    }

    public boolean minimize(int n, double d, BitSet bitSet) {
        Object object;
        if (n == Integer.MAX_VALUE && (object = this.viewer.getParameter("minimizationSteps")) != null && object instanceof Integer) {
            n = (Integer)object;
        }
        this.steps = n;
        if (d <= 0.0 && (object = this.viewer.getParameter("minimizationCriterion")) != null && object instanceof Float) {
            d = ((Float)object).floatValue();
        }
        this.crit = Math.max(d, 1.0E-4);
        if (this.minimizationOn) {
            return false;
        }
        Logger.info("minimize: initializing (steps = " + n + " criterion = " + d + ") ...");
        this.getForceField();
        if (this.pFF == null) {
            Logger.error(GT._("Could not get class for force field {0}", this.ff));
            return false;
        }
        if (this.atoms == null) {
            this.atomCountFull = this.viewer.getAtomCount();
            this.atoms = this.viewer.getModelSet().getAtoms();
        }
        this.bsAtoms = BitSetUtil.copy(bitSet);
        System.out.println("minimizer bsAtoms: " + this.bsAtoms);
        this.atomCount = BitSetUtil.cardinalityOf(this.bsAtoms);
        if (this.atomCount == 0) {
            Logger.error(GT._("No atoms selected -- nothing to do!"));
            return false;
        }
        if (!BitSetUtil.areEqual(bitSet, this.bsSelected) && !this.setupMinimization()) {
            this.clear();
            return false;
        }
        this.setAtomPositions();
        this.bsSelected = bitSet;
        if (this.constraints != null) {
            int n2 = this.constraints.size();
            block0: while (--n2 >= 0) {
                Object[] objectArray = (Object[])this.constraints.elementAt(n2);
                int[] nArray = (int[])objectArray[0];
                int[] nArray2 = (int[])objectArray[1];
                int n3 = nArray[0] = Math.abs(nArray[0]);
                for (int i = 1; i <= n3; ++i) {
                    if (n <= 0 || !this.bsAtoms.get(nArray[i])) {
                        nArray[0] = -n3;
                        continue block0;
                    }
                    nArray2[i - 1] = this.atomMap[nArray[i]];
                }
            }
        }
        this.pFF.setConstraints(this);
        if (n > 0 && !this.viewer.useMinimizationThread()) {
            this.minimizeWithoutThread();
        } else if (n > 0) {
            this.setMinimizationOn(true);
        } else {
            this.getEnergyOnly();
        }
        return true;
    }

    private boolean setupMinimization() {
        int n;
        int n2;
        int n3;
        int n4;
        Bond[] bondArray;
        this.atomMap = new int[this.atomCountFull];
        this.minAtoms = new MinAtom[this.atomCount];
        int n5 = 0;
        BitSet bitSet = new BitSet();
        int n6 = this.bsAtoms.nextSetBit(0);
        int n7 = 0;
        while (n6 >= 0) {
            bondArray = this.atoms[n6];
            this.atomMap[n6] = n7;
            n4 = this.atoms[n6].getElementNumber();
            n5 = Math.max(n5, n4);
            bitSet.set(n4);
            this.minAtoms[n7] = new MinAtom(n7, (Atom)bondArray, new double[]{bondArray.x, bondArray.y, bondArray.z}, null);
            n6 = this.bsAtoms.nextSetBit(n6 + 1);
            ++n7;
        }
        Logger.info(GT._("{0} atoms will be minimized.", "" + this.atomCount));
        Logger.info("minimize: creating bonds...");
        Vector<int[]> vector = new Vector<int[]>();
        this.bondCount = 0;
        n7 = this.bsAtoms.nextSetBit(0);
        while (n7 >= 0) {
            bondArray = this.atoms[n7].getBonds();
            if (bondArray != null) {
                for (n4 = 0; n4 < bondArray.length; ++n4) {
                    n3 = bondArray[n4].getOtherAtom(this.atoms[n7]).getIndex();
                    if (n3 <= n7 || !this.bsAtoms.get(n3)) continue;
                    n2 = bondArray[n4].getOrder();
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 515: {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = 1;
                        }
                    }
                    ++this.bondCount;
                    vector.addElement(new int[]{this.atomMap[n7], this.atomMap[n3], n2});
                }
            }
            n7 = this.bsAtoms.nextSetBit(n7 + 1);
        }
        this.minBonds = new MinBond[this.bondCount];
        for (n = 0; n < this.bondCount; ++n) {
            int[] nArray = (int[])vector.elementAt(n);
            MinBond minBond = this.minBonds[n] = new MinBond(nArray, false, false);
            n3 = nArray[0];
            n2 = nArray[1];
            this.minAtoms[n3].bonds.addElement(minBond);
            this.minAtoms[n2].bonds.addElement(minBond);
            ++this.minAtoms[n3].nBonds;
            ++this.minAtoms[n2].nBonds;
        }
        for (n = 0; n < this.atomCount; ++n) {
            int[] nArray = this.minAtoms[n].getBondedAtomIndexes();
        }
        Logger.info("minimize: setting atom types...");
        if (atomTypes == null) {
            atomTypes = this.getAtomTypes();
        }
        if (atomTypes == null) {
            return false;
        }
        n = atomTypes.size();
        bitSet.clear(0);
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])atomTypes.get(i);
            String string = stringArray[0];
            if (string == null) continue;
            BitSet bitSet2 = this.getSearch(string, n5, bitSet);
            if (bitSet.get(0)) {
                bitSet.clear(0);
                continue;
            }
            if (bitSet2 == null) break;
            int n8 = 0;
            for (int j = 0; j < this.atomCountFull; ++j) {
                if (!this.bsAtoms.get(j)) continue;
                if (bitSet2.get(j)) {
                    this.minAtoms[n8].type = stringArray[1];
                }
                ++n8;
            }
        }
        Logger.info("minimize: getting angles...");
        this.getAngles();
        Logger.info("minimize: getting torsions...");
        this.getTorsions();
        this.pFF.setModel(this);
        if (!this.pFF.setup()) {
            Logger.error(GT._("could not setup force field {0}", this.ff));
            return false;
        }
        if (this.steps > 0) {
            this.bsTaint = BitSetUtil.copy(this.bsAtoms);
            BitSetUtil.andNot(this.bsTaint, this.bsFixed);
            this.viewer.setTaintedAtoms(this.bsTaint, (byte)2);
        }
        return true;
    }

    private void setAtomPositions() {
        int n;
        for (n = 0; n < this.atomCount; ++n) {
            this.minAtoms[n].set();
        }
        this.bsMinFixed = null;
        if (this.bsFixed != null) {
            this.bsMinFixed = new BitSet();
            n = this.bsAtoms.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (this.bsFixed.get(n)) {
                    this.bsMinFixed.set(n2);
                }
                n = this.bsAtoms.nextSetBit(n + 1);
                ++n2;
            }
        }
    }

    private BitSet getSearch(String string, int n, BitSet bitSet) {
        Object object;
        Token[] tokenArray = null;
        int n2 = string.length();
        tokenArray = tokenTypes[0];
        int n3 = string.charAt(n2 - 2) - 48;
        int n4 = 0;
        if (n3 >= 10) {
            n3 = 0;
        }
        if (string.charAt(1) == '#') {
            n4 = Parser.parseInt(string.substring(2, n2 - 1));
        } else {
            object = string.substring(1, n3 > 0 ? n2 - 3 : n2 - 1);
            if (((String)object).equals(((String)object).toLowerCase())) {
                object = ((String)object).toUpperCase();
                tokenArray = tokenTypes[3];
            }
            n4 = JmolConstants.elementNumberFromSymbol((String)object);
        }
        if (n4 > n) {
            return null;
        }
        if (!bitSet.get(n4)) {
            bitSet.set(0);
            return null;
        }
        switch (string.charAt(n2 - 3)) {
            case 'D': {
                tokenArray = tokenTypes[2];
                tokenArray[6].intValue = n3;
                break;
            }
            case '^': {
                tokenArray = tokenTypes[4 + (n3 - 1)];
                break;
            }
            case '+': {
                tokenArray = tokenTypes[1];
                tokenArray[5].intValue = n3;
            }
        }
        tokenArray[2].intValue = n4;
        object = this.viewer.evaluateExpression(tokenArray);
        return object instanceof BitSet ? (BitSet)object : null;
    }

    public void getAngles() {
        int n;
        Vector<int[]> vector = new Vector<int[]>();
        for (n = 0; n < this.atomCount; ++n) {
            MinAtom minAtom = this.minAtoms[n];
            int n2 = minAtom.nBonds;
            if (n2 < 2) continue;
            int[] nArray = minAtom.getBondedAtomIndexes();
            for (int i = 0; i < n2 - 1; ++i) {
                for (int j = i + 1; j < n2; ++j) {
                    vector.addElement(new int[]{nArray[i], n, nArray[j]});
                }
            }
        }
        this.angles = new int[vector.size()][];
        n = vector.size();
        while (--n >= 0) {
            this.angles[n] = (int[])vector.elementAt(n);
        }
        Logger.info(this.angles.length + " angles");
    }

    public void getTorsions() {
        Vector<int[]> vector = new Vector<int[]>();
        int n = this.angles.length;
        while (--n >= 0) {
            int n2;
            int n3;
            int[] nArray;
            int[] nArray2 = this.angles[n];
            int n4 = nArray2[0];
            int n5 = nArray2[2];
            int n6 = nArray2[1];
            if (n5 > n6 && this.minAtoms[n5].nBonds != 1) {
                nArray = this.minAtoms[n5].getBondedAtomIndexes();
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    if (n2 == n4 || n2 == n6) continue;
                    vector.addElement(new int[]{n4, n6, n5, n2});
                }
            }
            if (n4 <= n6 || this.minAtoms[n4].nBonds == 1) continue;
            nArray = this.minAtoms[n4].getBondedAtomIndexes();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (n2 == n5 || n2 == n6) continue;
                vector.addElement(new int[]{n5, n6, n4, n2});
            }
        }
        this.torsions = new int[vector.size()][];
        n = vector.size();
        while (--n >= 0) {
            this.torsions[n] = (int[])vector.elementAt(n);
        }
        Logger.info(this.torsions.length + " torsions");
    }

    public ForceField getForceField() {
        if (this.pFF == null) {
            try {
                String string = this.getClass().getName();
                string = string.substring(0, string.lastIndexOf(".")) + ".forcefield.ForceField" + this.ff;
                Logger.info("minimize: using " + string);
                this.pFF = (ForceField)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                Logger.error(exception.getMessage());
            }
        }
        return this.pFF;
    }

    public Vector getAtomTypes() {
        this.getForceField();
        return this.pFF == null ? null : this.pFF.getAtomTypes();
    }

    private void setMinimizationOn(boolean bl) {
        this.minimizationOn = bl;
        if (!bl) {
            if (this.minimizationThread != null) {
                this.minimizationThread = null;
            }
            return;
        }
        if (this.minimizationThread == null) {
            this.minimizationThread = new MinimizationThread();
            this.minimizationThread.start();
        }
    }

    private void getEnergyOnly() {
        if (this.pFF == null || this.viewer == null) {
            return;
        }
        this.pFF.steepestDescentInitialize(this.steps, this.crit);
        this.viewer.setFloatProperty("_minimizationEnergyDiff", 0.0f);
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setStringProperty("_minimizationStatus", "calculate");
        this.viewer.notifyMinimizationStatus();
    }

    public boolean startMinimization() {
        try {
            Logger.info("minimizer: startMinimization");
            this.viewer.setIntProperty("_minimizationStep", 0);
            this.viewer.setStringProperty("_minimizationStatus", "starting");
            this.viewer.setFloatProperty("_minimizationEnergy", 0.0f);
            this.viewer.setFloatProperty("_minimizationEnergyDiff", 0.0f);
            this.viewer.notifyMinimizationStatus();
            this.viewer.saveCoordinates("minimize", this.bsTaint);
            this.pFF.steepestDescentInitialize(this.steps, this.crit);
            this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
            this.saveCoordinates();
        }
        catch (Exception exception) {
            Logger.error("minimization error viewer=" + this.viewer + " pFF = " + this.pFF);
            return false;
        }
        this.minimizationOn = true;
        return true;
    }

    boolean stepMinimization() {
        if (!this.minimizationOn) {
            return false;
        }
        boolean bl = this.viewer.getBooleanProperty("minimizationRefresh");
        this.viewer.setStringProperty("_minimizationStatus", "running");
        boolean bl2 = this.pFF.steepestDescentTakeNSteps(1);
        int n = this.pFF.getCurrentStep();
        this.viewer.setIntProperty("_minimizationStep", n);
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setFloatProperty("_minimizationEnergyDiff", (float)this.pFF.getEnergyDiff());
        this.viewer.notifyMinimizationStatus();
        if (bl) {
            this.updateAtomXYZ();
            this.viewer.refresh(3, "minimization step " + n);
        }
        return bl2;
    }

    void endMinimization() {
        this.updateAtomXYZ();
        this.setMinimizationOn(false);
        boolean bl = this.pFF.detectExplosion();
        if (bl) {
            this.restoreCoordinates();
        }
        this.viewer.setIntProperty("_minimizationStep", this.pFF.getCurrentStep());
        this.viewer.setFloatProperty("_minimizationEnergy", (float)this.pFF.getEnergy());
        this.viewer.setStringProperty("_minimizationStatus", bl ? "failed" : "done");
        this.viewer.notifyMinimizationStatus();
        this.viewer.refresh(3, "Minimizer:done" + (bl ? " EXPLODED" : "OK"));
        Logger.info("minimizer: endMinimization");
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.atomCount][3];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        if (this.coordSaved == null) {
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
        this.updateAtomXYZ();
    }

    private void stopMinimization(boolean bl) {
        if (!this.minimizationOn) {
            return;
        }
        this.setMinimizationOn(false);
        if (bl) {
            this.endMinimization();
        } else {
            this.restoreCoordinates();
        }
    }

    void updateAtomXYZ() {
        if (this.steps <= 0) {
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            MinAtom minAtom = this.minAtoms[i];
            Atom atom = minAtom.atom;
            atom.x = (float)minAtom.coord[0];
            atom.y = (float)minAtom.coord[1];
            atom.z = (float)minAtom.coord[2];
        }
        this.viewer.refreshMeasures(false);
    }

    private void minimizeWithoutThread() {
        if (!this.startMinimization()) {
            return;
        }
        while (this.stepMinimization()) {
        }
        this.endMinimization();
    }

    static {
        tokenTypes = new Token[][]{{Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenAnd, new Token(269484420, 1632634889), Token.intToken(0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenAnd, new Token(135266318, "connected"), Token.tokenLeftParen, Token.intToken(0), Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenAnd, new Token(0x100009, "isaromatic"), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenAnd, Token.tokenLeftParen, new Token(135266318, "connected"), Token.tokenLeftParen, Token.intToken(1), Token.tokenComma, new Token(4, "triple"), Token.tokenRightParen, Token.tokenOr, new Token(135266318, "connected"), Token.tokenLeftParen, Token.intToken(2), Token.tokenComma, new Token(4, "double"), Token.tokenRightParen, Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484420, 1095763976), Token.intToken(0), Token.tokenAnd, new Token(135266318, "connected"), Token.tokenLeftParen, Token.intToken(1), Token.tokenComma, new Token(4, "double"), Token.tokenRightParen, Token.tokenExpressionEnd}};
    }

    class MinimizationThread
    extends Thread
    implements Runnable {
        MinimizationThread() {
            this.setName("MinimizationThread");
        }

        public void run() {
            block6: {
                long l;
                long l2 = l = System.currentTimeMillis();
                if (!Minimizer.this.startMinimization()) {
                    return;
                }
                try {
                    do {
                        long l3;
                        int n;
                        int n2;
                        if ((n2 = 33 - (n = (int)((l3 = System.currentTimeMillis()) - l2))) > 0) {
                            Thread.sleep(n2);
                        }
                        l2 = l3 = System.currentTimeMillis();
                        if (!Minimizer.this.stepMinimization()) {
                            Minimizer.this.endMinimization();
                        }
                        n = (int)(l3 - l);
                    } while (Minimizer.this.minimizationOn && !this.isInterrupted());
                }
                catch (Exception exception) {
                    if (!Minimizer.this.minimizationOn) break block6;
                    Logger.debug(" minimization thread interrupted");
                }
            }
        }
    }
}

