/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.io.PrintWriter;
import rene.gui.Global;

public class LatexOutput {
    PrintWriter Out;
    double W;
    double H;
    boolean DoubleDollar;
    boolean Dollar;
    boolean NoDollar;

    public LatexOutput(PrintWriter printWriter) {
        this.Out = printWriter;
        this.DoubleDollar = Global.getParameter("options.doubledollar", true);
        this.Dollar = Global.getParameter("options.dollar", true);
        this.NoDollar = Global.getParameter("options.nodollar", false);
    }

    public void open(double d2, double d3, double d4, String string) {
        this.W = d2;
        this.H = d3;
        this.Out.println("\\setlength{\\unitlength}{" + 2.54 / d4 + "cm}");
        this.Out.println("\\begin{picture}(" + this.round(d2) + "," + this.round(d3) + ")");
        String string2 = string.replace('\\', '/');
        this.Out.println("\\put(0,0){\\includegraphics[width=" + this.round(d2 / d4 * 2.54) + "cm]{" + string2 + "}}");
        this.Out.println("%\\put(0,0){\\includegraphics[width=" + this.round(d2 / d4 * 2.54) + "cm,bb=0 0 " + (int)d2 + " " + (int)d3 + "]{" + string2 + "}}");
    }

    public void close() {
        this.Out.println("\\end{picture}");
        this.Out.close();
    }

    public boolean println(String string, double d2, double d3, boolean bl) {
        if (string.startsWith("$$")) {
            if (!this.DoubleDollar) {
                return false;
            }
            if ((string = string.substring(1)).endsWith("$$")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!string.endsWith("$")) {
                string = string + "$";
            }
        } else if (!bl && string.startsWith("$")) {
            if (!this.Dollar) {
                return false;
            }
            if (!string.endsWith("$")) {
                string = string + "$";
            }
        } else if (!bl && !this.NoDollar) {
            return false;
        }
        this.Out.println("\\put(" + this.round(d2) + "," + this.round(this.H - d3) + "){" + string + "}");
        return true;
    }

    public boolean println(String string, double d2, double d3) {
        return this.println(string, d2, d3, false);
    }

    public double round(double d2) {
        return Math.floor(d2 * 1000.0 + 0.5) / 1000.0;
    }

    public boolean printDollar() {
        return this.Dollar;
    }
}

