use cargo_metadata::Dependency;

// custom "PartialEq" implementation for Dependency:
// ignores fields that are mangled by publishing (.source, .path)
pub fn dependency_partial_eq(kdep: &Dependency, udep: &Dependency) -> bool {
    if kdep.name != udep.name {
        return false;
    }
    if kdep.req != udep.req {
        return false;
    }
    if kdep.kind != udep.kind {
        return false;
    }
    if kdep.optional != udep.optional {
        return false;
    }
    if kdep.uses_default_features != udep.uses_default_features {
        return false;
    }
    if kdep.features != udep.features {
        return false;
    }
    if kdep.target != udep.target {
        return false;
    }
    if kdep.rename != udep.rename {
        return false;
    }

    true
}
