module Toys
  module StandardMixins
    ##
    # **_Defined in the toys-core gem_**
    #
    # A mixin that provides access to the capabilities of the highline gem.
    #
    # This mixin requires the highline gem, version 2.0 or later. It will
    # attempt to install the gem if it is not available.
    #
    # You may make these methods available to your tool by including the
    # following directive in your tool configuration:
    #
    #     include :highline
    #
    # A HighLine object will then be available by calling the {#highline}
    # method. For information on using this object, see the
    # [Highline documentation](https://www.rubydoc.info/gems/highline). Some of
    # the most common HighLine methods, such as `say`, are also mixed into the
    # tool and can be called directly.
    #
    # You can configure the HighLine object by passing options to the `include`
    # directive. For example:
    #
    #     include :highline, my_stdin, my_stdout
    #
    # The arguments will be passed on to the
    # [HighLine constructor](https://www.rubydoc.info/gems/highline/HighLine:initialize).
    #
    module Highline
      include Mixin

      ##
      # Context key for the highline object.
      # @return [Object]
      #
      KEY = ::Object.new.freeze

      ##
      # A tool-wide [HighLine](https://www.rubydoc.info/gems/highline/HighLine)
      # instance
      # @return [::HighLine]
      #
      def highline
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#agree](https://www.rubydoc.info/gems/highline/HighLine:agree)
      #
      def agree(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#ask](https://www.rubydoc.info/gems/highline/HighLine:ask)
      #
      def ask(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#choose](https://www.rubydoc.info/gems/highline/HighLine:choose)
      #
      def choose(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#list](https://www.rubydoc.info/gems/highline/HighLine:list)
      #
      def list(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#say](https://www.rubydoc.info/gems/highline/HighLine:say)
      #
      def say(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#indent](https://www.rubydoc.info/gems/highline/HighLine:indent)
      #
      def indent(...)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#newline](https://www.rubydoc.info/gems/highline/HighLine:newline)
      #
      def newline
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#puts](https://www.rubydoc.info/gems/highline/HighLine:puts)
      #
      def puts(*args)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#color](https://www.rubydoc.info/gems/highline/HighLine:color)
      #
      def color(*args)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#color_code](https://www.rubydoc.info/gems/highline/HighLine:color_code)
      #
      def color_code(*args)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#uncolor](https://www.rubydoc.info/gems/highline/HighLine:uncolor)
      #
      def uncolor(*args)
        # Source available in the toys-core gem
      end

      ##
      # Calls [HighLine#new_scope](https://www.rubydoc.info/gems/highline/HighLine:new_scope)
      #
      def new_scope
        # Source available in the toys-core gem
      end
    end
  end
end
