# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, AsyncIterator, Callable, Dict, Literal, Optional, TypeVar, Union, cast

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._policy_states_operations import (
    build_list_query_results_for_management_group_request,
    build_list_query_results_for_policy_definition_request,
    build_list_query_results_for_policy_set_definition_request,
    build_list_query_results_for_resource_group_level_policy_assignment_request,
    build_list_query_results_for_resource_group_request,
    build_list_query_results_for_resource_request,
    build_list_query_results_for_subscription_level_policy_assignment_request,
    build_list_query_results_for_subscription_request,
    build_next_link_request,
    build_summarize_for_management_group_request,
    build_summarize_for_policy_definition_request,
    build_summarize_for_policy_set_definition_request,
    build_summarize_for_resource_group_level_policy_assignment_request,
    build_summarize_for_resource_group_request,
    build_summarize_for_resource_request,
    build_summarize_for_subscription_level_policy_assignment_request,
    build_summarize_for_subscription_request,
    build_trigger_resource_group_evaluation_request,
    build_trigger_subscription_evaluation_request,
)
from .._configuration import PolicyInsightsClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class PolicyStatesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.aio.PolicyInsightsClient`'s
        :attr:`policy_states` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PolicyInsightsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_query_results_for_management_group(
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        management_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the resources under the management group.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param management_group_name: Management group name. Required.
        :type management_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_management_group_request(
                    policy_states_resource=policy_states_resource,
                    management_group_name=management_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    management_groups_namespace=management_groups_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_management_group(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        management_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the resources under the management group.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param management_group_name: Management group name. Required.
        :type management_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_management_group_request(
            policy_states_summary_resource=policy_states_summary_resource,
            management_group_name=management_group_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            management_groups_namespace=management_groups_namespace,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_subscription(
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the resources under the subscription.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_subscription(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the resources under the subscription.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_subscription_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_resource_group(
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        resource_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the resources under the resource group.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_resource_group(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        resource_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the resources under the resource group.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_resource_group_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_resource(
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        resource_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the resource.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param resource_id: Resource ID. Required.
        :type resource_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_request(
                    policy_states_resource=policy_states_resource,
                    resource_id=resource_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    expand=_expand,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_resource(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        resource_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the resource.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param resource_id: Resource ID. Required.
        :type resource_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_resource_request(
            policy_states_summary_resource=policy_states_summary_resource,
            resource_id=resource_id,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _trigger_subscription_evaluation_initial(
        self, subscription_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_trigger_subscription_evaluation_request(
            subscription_id=subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_trigger_subscription_evaluation(self, subscription_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Triggers a policy evaluation scan for all the resources under the subscription.

        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._trigger_subscription_evaluation_initial(
                subscription_id=subscription_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _trigger_resource_group_evaluation_initial(  # pylint: disable=name-too-long
        self, subscription_id: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_trigger_resource_group_evaluation_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_trigger_resource_group_evaluation(
        self, subscription_id: str, resource_group_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Triggers a policy evaluation scan for all the resources under the resource group.

        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._trigger_resource_group_evaluation_initial(
                subscription_id=subscription_id,
                resource_group_name=resource_group_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_query_results_for_policy_set_definition(  # pylint: disable=name-too-long
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        policy_set_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the subscription level policy set definition.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name. Required.
        :type policy_set_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_set_definition_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    policy_set_definition_name=policy_set_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_policy_set_definition(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        policy_set_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the subscription level policy set definition.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name. Required.
        :type policy_set_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_policy_set_definition_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            policy_set_definition_name=policy_set_definition_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            authorization_namespace=authorization_namespace,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_policy_definition(
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        policy_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the subscription level policy definition.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name. Required.
        :type policy_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_definition_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    policy_definition_name=policy_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_policy_definition(
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        policy_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the subscription level policy definition.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name. Required.
        :type policy_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_policy_definition_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            policy_definition_name=policy_definition_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            authorization_namespace=authorization_namespace,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_subscription_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the subscription level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_level_policy_assignment_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_subscription_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the subscription level policy assignment.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_subscription_level_policy_assignment_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            policy_assignment_name=policy_assignment_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            authorization_namespace=authorization_namespace,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_query_results_for_resource_group_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_states_resource: Union[str, _models.PolicyStatesResource],
        subscription_id: str,
        resource_group_name: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyState"]:
        """Queries policy states for the resource group level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates resource type. In a
         given time range, 'latest' represents the latest policy state(s), whereas 'default' represents
         all policy state(s). Known values are: "default" and "latest". Required.
        :type policy_states_resource: str or ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyState or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyStatesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_level_policy_assignment_request(
                    policy_states_resource=policy_states_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyStatesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def summarize_for_resource_group_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_states_summary_resource: Union[str, _models.PolicyStatesSummaryResourceType],
        subscription_id: str,
        resource_group_name: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> _models.SummarizeResults:
        """Summarizes policy states for the resource group level policy assignment.

        :param policy_states_summary_resource: The virtual resource under PolicyStates resource type
         for summarize action. In a given time range, 'latest' represents the latest policy state(s) and
         is the only allowed value. "latest" Required.
        :type policy_states_summary_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesSummaryResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: SummarizeResults or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.SummarizeResults] = kwargs.pop("cls", None)

        _top = None
        _from_property = None
        _to = None
        _filter = None
        if query_options is not None:
            _filter = query_options.filter
            _from_property = query_options.from_property
            _to = query_options.to
            _top = query_options.top

        _request = build_summarize_for_resource_group_level_policy_assignment_request(
            policy_states_summary_resource=policy_states_summary_resource,
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            policy_assignment_name=policy_assignment_name,
            top=_top,
            from_property=_from_property,
            to=_to,
            filter=_filter,
            authorization_namespace=authorization_namespace,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SummarizeResults", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
