---
page_type: sample
languages:
  - python
products:
  - azure
urlFragment: azure-purview-datamap-samples
---

# Azure Purview DataMap service client library for Python Samples

These are code samples that show common scenario operations with the Azure DataMap client library.
The async versions of the samples (the python sample files appended with `_async`) show asynchronous operations.

## Prerequisites

* Python 3.8 or later is required to use this package
* You must have an [Azure subscription][azure_subscription] and a [Purview][purview_resource] to use this package.

## Setup

1. Install the Azure Web PubSub service client library for Python with [pip](https://pypi.org/project/pip/):

```bash
pip install azure-purview-datamap
```

2. Clone or download this sample repository
3. Open the sample folder in Visual Studio Code or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file, e.g. `python get_types.py`


<!-- LINKS -->

[product_documentation]: https://azure.microsoft.com/services/purview/
[azure_subscription]: https://azure.microsoft.com/free/
[purview_resource]: https://learn.microsoft.com/azure/purview/create-catalog-portal