/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericRealmService;

public class RealmService {
    protected static GenericRealmService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericRealmService)((Object)TurbineServices.getInstance().getService(GenericRealmService.SERVICE_NAME))) == null) {
            Log.warn("chef", "RealmService.find: missing service: " + GenericRealmService.SERVICE_NAME);
        }
    }

    public static GenericRealmService getInstance() {
        RealmService.find();
        return M_service;
    }

    public static List getRealms() {
        RealmService.find();
        return M_service.getRealms();
    }

    public static Realm getRealm(String id) throws IdUnusedException {
        RealmService.find();
        return M_service.getRealm(id);
    }

    public static boolean allowUpdateRealm(String id) {
        RealmService.find();
        return M_service.allowUpdateRealm(id);
    }

    public static RealmEdit editRealm(String id) throws IdUnusedException, PermissionException, InUseException {
        RealmService.find();
        return M_service.editRealm(id);
    }

    public static void commitEdit(RealmEdit realm) {
        RealmService.find();
        M_service.commitEdit(realm);
    }

    public static void cancelEdit(RealmEdit realm) {
        RealmService.find();
        M_service.cancelEdit(realm);
    }

    public static boolean allowAddRealm(String id) {
        RealmService.find();
        return M_service.allowAddRealm(id);
    }

    public static RealmEdit addRealm(String id) throws IdInvalidException, IdUsedException, PermissionException {
        RealmService.find();
        return M_service.addRealm(id);
    }

    public static RealmEdit addRealm(String id, Realm other) throws IdInvalidException, IdUsedException, PermissionException {
        RealmService.find();
        return M_service.addRealm(id, other);
    }

    public static boolean allowRemoveRealm(String id) {
        RealmService.find();
        return M_service.allowRemoveRealm(id);
    }

    public static void removeRealm(RealmEdit realm) throws IdUnusedException, PermissionException {
        RealmService.find();
        M_service.removeRealm(realm);
    }

    public static String realmReference(String id) {
        RealmService.find();
        return M_service.realmReference(id);
    }
}

