/***********************************************************************

 HiSIM (Hiroshima University STARC IGFET Model)
 Copyright (C) 2014 Hiroshima University & STARC

 MODEL NAME : HiSIM_HV 
 ( VERSION : 2  SUBVERSION : 2  REVISION : 0 ) 
 Model Parameter 'VERSION' : 2.20
 FILE : hsmhv.c

 DATE : 2014.6.11


 released by
                Hiroshima University &
                Semiconductor Technology Academic Research Center (STARC)
***********************************************************************/

/**********************************************************************

The following source code, and all copyrights, trade secrets or other
intellectual property rights in and to the source code in its entirety,
is owned by the Hiroshima University and the STARC organization.

All users need to follow the "HISIM_HV Distribution Statement and
Copyright Notice" attached to HiSIM_HV model.

-----HISIM_HV Distribution Statement and Copyright Notice--------------

Software is distributed as is, completely without warranty or service
support. Hiroshima University or STARC and its employees are not liable
for the condition or performance of the software.

Hiroshima University and STARC own the copyright and grant users a perpetual,
irrevocable, worldwide, non-exclusive, royalty-free license with respect 
to the software as set forth below.   

Hiroshima University and STARC hereby disclaims all implied warranties.

Hiroshima University and STARC grant the users the right to modify, copy,
and redistribute the software and documentation, both within the user's
organization and externally, subject to the following restrictions

1. The users agree not to charge for Hiroshima University and STARC code
itself but may charge for additions, extensions, or support.

2. In any product based on the software, the users agree to acknowledge
Hiroshima University and STARC that developed the software. This
acknowledgment shall appear in the product documentation.

3. The users agree to reproduce any copyright notice which appears on
the software on any copy or modification of such made available
to others."

Toshimasa Asahara, President, Hiroshima University
Mitiko Miura-Mattausch, Professor, Hiroshima University
Katsuhiro Shimohigashi, President&CEO, STARC
June 2008 (revised October 2011) 
*************************************************************************/

#include "ngspice/ngspice.h"
#include "ngspice/devdefs.h"
#include "hsmhv2def.h"
#include "ngspice/suffix.h"

IFparm HSMHV2pTable[] = { /* parameters */
 IOP( "coselfheat", HSMHV2_COSELFHEAT, IF_INTEGER, "Calculation of self heating model"),
 IOP( "cosubnode", HSMHV2_COSUBNODE, IF_INTEGER, "Switch tempNode to subNode"),
 IOP( "l",   HSMHV2_L,      IF_REAL   , "Length"),
 IOP( "w",   HSMHV2_W,      IF_REAL   , "Width"),
 IOP( "ad",  HSMHV2_AD,     IF_REAL   , "Drain area"),
 IOP( "as",  HSMHV2_AS,     IF_REAL   , "Source area"),
 IOP( "pd",  HSMHV2_PD,     IF_REAL   , "Drain perimeter"),
 IOP( "ps",  HSMHV2_PS,     IF_REAL   , "Source perimeter"),
 IOP( "nrd", HSMHV2_NRD,    IF_REAL   , "Number of squares in drain"),
 IOP( "nrs", HSMHV2_NRS,    IF_REAL   , "Number of squares in source"),
 IOP( "dtemp", HSMHV2_DTEMP,IF_REAL   , ""),
 IOP( "off", HSMHV2_OFF,    IF_FLAG   , "Device is initially off"),
 IP ( "ic",  HSMHV2_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
 IOP("corbnet", HSMHV2_CORBNET, IF_INTEGER, "Activate body resistance (1) or not (0)"),
 IOP("rbpb", HSMHV2_RBPB, IF_REAL, ""),
 IOP("rbpd", HSMHV2_RBPD, IF_REAL, ""),
 IOP("rbps", HSMHV2_RBPS, IF_REAL, ""),
 IOP("rbdb", HSMHV2_RBDB, IF_REAL, ""),
 IOP("rbsb", HSMHV2_RBSB, IF_REAL, ""),
 IOP("corg", HSMHV2_CORG, IF_INTEGER, "Activate gate resistance (1) or not (0)"),
 IOP("ngcon", HSMHV2_NGCON, IF_REAL, "Number of gate contacts"),
 IOP("xgw", HSMHV2_XGW, IF_REAL, "Distance from gate contact to channel edge"),
 IOP("xgl", HSMHV2_XGL, IF_REAL, "Offset of gate length due to variation in patterning"),
 IOP("nf", HSMHV2_NF, IF_REAL, "Number of fingers"),
 IOP("sa", HSMHV2_SA, IF_REAL, "Distance from STI edge to Gate edge [m]"),
 IOP("sb", HSMHV2_SB, IF_REAL, "Distance from STI edge to Gate edge [m]"),
 IOP("sd", HSMHV2_SD, IF_REAL, "Distance from Gate edge to Gate edge [m]"),
 IOP("nsubcdfm", HSMHV2_NSUBCDFM, IF_REAL, "Constant part of Nsub for DFM [1/cm^3]"),
 IOP("m", HSMHV2_M, IF_REAL, "Multiplication factor [-]"),
 IOP("subld1", HSMHV2_SUBLD1, IF_REAL, "Parameter for impact-ionization current in the drift region [-]"),
 IOP("subld2", HSMHV2_SUBLD2, IF_REAL, "Parameter for impact-ionization current in the drift region [m^{-1}*V^{3/2}]"),
 IOP("lover", HSMHV2_LOVER, IF_REAL, "Overlap length on source side [m]"),
 IOP("lovers", HSMHV2_LOVERS, IF_REAL, "Overlap length on source side [m]"),
 IOP("loverld", HSMHV2_LOVERLD, IF_REAL, "Overlap length on drain side [m]"),
 IOP("ldrift1", HSMHV2_LDRIFT1, IF_REAL, "Parameter for drift region length-1 [m]"),  
 IOP("ldrift2", HSMHV2_LDRIFT2, IF_REAL, "Parameter for drift region length-2 [m]"),  
 IOP("ldrift1s", HSMHV2_LDRIFT1S, IF_REAL, "Parameter for drift region length-1 on source side[m]"),  
 IOP("ldrift2s", HSMHV2_LDRIFT2S, IF_REAL, "Parameter for drift region length-2 on source side[m]"),  

 /* Output Physical Values: */
 OP ( "ids",   HSMHV2_CD,    IF_REAL   , "Ids"),  /* Drain-Source current */
 OP ( "isub",  HSMHV2_ISUB,  IF_REAL   , "Isub"),  /* Substrate current */
 OP ( "isubld",  HSMHV2_ISUBLD,  IF_REAL   , "IsubLD"),  /* Substrate current */
 OP ( "idsibpc",  HSMHV2_IDSIBPC,  IF_REAL   , "IdsIBPC"),  /*  Impact-Ionization Induced Bulk Potential Change (IBPC)*/
 OP ( "igidl", HSMHV2_IGIDL, IF_REAL   , "Igidl"), /* Gate-Induced Drain Leakage current */
 OP ( "igisl", HSMHV2_IGISL, IF_REAL   , "Igisl"), /* Gate-Induced Source Leakage current */
 OP ( "igd",   HSMHV2_IGD,   IF_REAL   , "Igd"),  /* Gate-Drain current */
 OP ( "igs",   HSMHV2_IGS,   IF_REAL   , "Igs"),  /* Gate-Source current */
 OP ( "igb",   HSMHV2_IGB,   IF_REAL   , "Igb"),  /* Gate-Substrate current */
 OP ( "gm",    HSMHV2_GM,    IF_REAL   , "Gm"),   /* Transconductance */
 OP ( "gds",   HSMHV2_GDS,   IF_REAL   , "Gds"),  /* Channel conductance */
 OP ( "gmbs",  HSMHV2_GMBS,  IF_REAL   , "Gmbs"), /* Body effect (Back gate) transconductance */
 OP ( "gmt",   HSMHV2_GMT,   IF_REAL   , "GmT"),   /* Temp - transconductance ----SHE----*/
 OP ( "von",   HSMHV2_VON,   IF_REAL   , "Von"),  /* Threshold voltage */
 OP ( "vdsat", HSMHV2_VDSAT, IF_REAL   , "Vdsat"), /* Saturation voltage */
 OP ( "qb",    HSMHV2_QB,    IF_REAL   , "Qb"),   /* Bulk charge */
 OP ( "qg",    HSMHV2_QG,    IF_REAL   , "Qg"),   /* Gate charge */
 OP ( "qd",    HSMHV2_QD,    IF_REAL   , "Qd"),   /* Drain charge */
 OP ( "cgg",   HSMHV2_CGG,   IF_REAL   , "Cgg"),  /* MOSFET capacitance */
 OP ( "cgd",   HSMHV2_CGD,   IF_REAL   , "Cgd"),  /* MOSFET capacitance */
 OP ( "cgs",   HSMHV2_CGS,   IF_REAL   , "Cgs"),  /* MOSFET capacitance */
 OP ( "cbg",   HSMHV2_CBG,   IF_REAL   , "Cbg"),  /* MOSFET capacitance */
 OP ( "cbs",   HSMHV2_CBSB,  IF_REAL   , "Cbs"),  /* MOSFET capacitance */
 OP ( "cbd",   HSMHV2_CBDB,  IF_REAL   , "Cbd"),  /* MOSFET capacitance */
 OP ( "cdg",   HSMHV2_CDG,   IF_REAL   , "Cdg"),  /* MOSFET capacitance */
 OP ( "cdd",   HSMHV2_CDD,   IF_REAL   , "Cdd"),  /* MOSFET capacitance */
 OP ( "cds",   HSMHV2_CDS,   IF_REAL   , "Cds"),  /* MOSFET capacitance */
 OP ( "cgdo",  HSMHV2_CGDO,  IF_REAL   , "Cgdo"), /* MOSFET overlap capacitance */
 OP ( "cgso",  HSMHV2_CGSO,  IF_REAL   , "Cgso"), /* MOSFET overlap capacitance */
 OP ( "cgbo",  HSMHV2_CGBO,  IF_REAL   , "Cgbo"), /* MOSFET overlap capacitance */
 OP ( "ibd",   HSMHV2_CBD,   IF_REAL   , "Ibd"),  /* Diode current */
 OP ( "ibs",   HSMHV2_CBS,   IF_REAL   , "Ibs"),  /* Diode current */
 OP ( "gbd",   HSMHV2_GBD,   IF_REAL   , "Gbd"),  /* Diode conductance */
 OP ( "gbs",   HSMHV2_GBS,   IF_REAL   , "Gbs"),  /* Diode conductance */
 OP ( "capbd", HSMHV2_CAPBD, IF_REAL   , "Capbd"), /* Diode capacitance */
 OP ( "capbs", HSMHV2_CAPBS, IF_REAL   , "Capbs") /* Diode capacitance */
};

IFparm HSMHV2mPTable[] = { /* model parameters */
  IP("nmos", HSMHV2_MOD_NMOS, IF_FLAG, ""),
  IP("pmos", HSMHV2_MOD_PMOS, IF_FLAG, ""),
  IOP("level", HSMHV2_MOD_LEVEL, IF_INTEGER, ""),
  IOP("info", HSMHV2_MOD_INFO, IF_INTEGER, "Information level (for debug, etc.)"),
  IOP("noise", HSMHV2_MOD_NOISE, IF_INTEGER, "Noise model selector"),
  IOP("version", HSMHV2_MOD_VERSION, IF_STRING, "Model version"),
  IOP("show", HSMHV2_MOD_SHOW, IF_INTEGER, "Show physical value"),
  IOP("corsrd", HSMHV2_MOD_CORSRD, IF_INTEGER, "Handling of Rs and Rd"),
  IOP("corg", HSMHV2_MOD_CORG, IF_INTEGER, "Activate gate resistance (1) or not (0)"),
  IOP("coiprv", HSMHV2_MOD_COIPRV, IF_INTEGER, "Use ids_prv as initial guess of Ids (internal flag)"),
  IOP("copprv", HSMHV2_MOD_COPPRV, IF_INTEGER, "Use ps{0/l}_prv as initial guess of Ps{0/l} (internal flag)"),
  IOP("coadov", HSMHV2_MOD_COADOV, IF_INTEGER, "Add overlap to intrisic"),
  IOP("coisub", HSMHV2_MOD_COISUB, IF_INTEGER, "Calculate isub"),
  IOP("coiigs", HSMHV2_MOD_COIIGS, IF_INTEGER, "Calculate igate"),
  IOP("cogidl", HSMHV2_MOD_COGIDL, IF_INTEGER, "Calculate igidl"),
  IOP("coovlp", HSMHV2_MOD_COOVLP, IF_INTEGER, "Calculate overlap charge on the drain side"),
  IOP("coovlps", HSMHV2_MOD_COOVLPS, IF_INTEGER, "Calculate overlap charge on the source side"),
  IOP("coflick", HSMHV2_MOD_COFLICK, IF_INTEGER, "Calculate 1/f noise"),
  IOP("coisti", HSMHV2_MOD_COISTI, IF_INTEGER, "Calculate STI"),
  IOP("conqs", HSMHV2_MOD_CONQS, IF_INTEGER, "Calculate in nqs mode or qs mode"),
  IOP("corbnet", HSMHV2_MOD_CORBNET, IF_INTEGER, ""),
  IOP("cothrml", HSMHV2_MOD_COTHRML, IF_INTEGER, "Calculate thermal noise"),
  IOP("coign", HSMHV2_MOD_COIGN, IF_INTEGER, "Calculate induced gate noise"),
  IOP("codfm", HSMHV2_MOD_CODFM, IF_INTEGER, "Calculation of model for DFM"),
  IOP("coqovsm", HSMHV2_MOD_COQOVSM, IF_INTEGER, "select smoothing method of Qover"),
  IOP("coselfheat", HSMHV2_MOD_COSELFHEAT, IF_INTEGER, "Calculation of self heating model"), 
  IOP("cosubnode", HSMHV2_MOD_COSUBNODE, IF_INTEGER, "Switch tempNode to subNode"),
  IOP("cosym", HSMHV2_MOD_COSYM, IF_INTEGER, "Model selector for symmetry device"), 
  IOP("cotemp", HSMHV2_MOD_COTEMP, IF_INTEGER, "Model flag for temperature dependence"), 
  IOP("coldrift", HSMHV2_MOD_COLDRIFT, IF_INTEGER, "selector for Ldrift parameter"),
  IOP("cordrift", HSMHV2_MOD_CORDRIFT, IF_INTEGER, ""),
  IOP("coerrrep", HSMHV2_MOD_COERRREP, IF_INTEGER, "selector for error report"),
  IOP("codep", HSMHV2_MOD_CODEP, IF_INTEGER, "selector for depletion device"),
  IOP("coddlt", HSMHV2_MOD_CODDLT, IF_INTEGER, "selector for DDLT model"),

  IOP("vbsmin", HSMHV2_MOD_VBSMIN, IF_REAL, "Minimum back bias voltage to be treated in hsmhveval [V]"),

  IOP("vmax", HSMHV2_MOD_VMAX, IF_REAL, "Saturation velocity [cm/s]"),
  IOP("vmaxt1", HSMHV2_MOD_VMAXT1, IF_REAL, "Saturation velocity coeff. [-]"),
  IOP("vmaxt2", HSMHV2_MOD_VMAXT2, IF_REAL, "Saturation velocity coeff. [-]"),
  IOP("bgtmp1", HSMHV2_MOD_BGTMP1, IF_REAL, "First order temp. coeff. for band gap [V/K]"),
  IOP("bgtmp2", HSMHV2_MOD_BGTMP2, IF_REAL, "Second order temp. coeff. for band gap [V/K^2]"),
  IOP("eg0", HSMHV2_MOD_EG0, IF_REAL, ""),
  IOP("tox", HSMHV2_MOD_TOX, IF_REAL, "Oxide thickness [m]"),
  IOP("xld", HSMHV2_MOD_XLD, IF_REAL, "Lateral diffusion of S/D under the gate [m]"),
  IOP("xldld", HSMHV2_MOD_XLDLD, IF_REAL, "Lateral diffusion of Drain under the gate [m]"),
  IOP("xwdld", HSMHV2_MOD_XWDLD, IF_REAL, ""),
  IOP("lover", HSMHV2_MOD_LOVER, IF_REAL, "Overlap length on source side [m], alias for lovers"),
  IOP("lovers", HSMHV2_MOD_LOVERS, IF_REAL, "Overlap length on source side [m]"),
  IOP("rdov11", HSMHV2_MOD_RDOV11, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdov12", HSMHV2_MOD_RDOV12, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdov13", HSMHV2_MOD_RDOV13, IF_REAL, "Dependence coeff. for overlap length"),
  IOP("rdslp1", HSMHV2_MOD_RDSLP1, IF_REAL, "LDRIFT1 dependence of resistance for CORSRD=1,3"),
  IOP("rdict1", HSMHV2_MOD_RDICT1, IF_REAL, "LDRIFT1 dependence of resistance for CORSRD=1,3"),
  IOP("rdslp2", HSMHV2_MOD_RDSLP2, IF_REAL, "LDRIFT2 dependence of resistance for CORSRD=1,3"),
  IOP("rdict2", HSMHV2_MOD_RDICT2, IF_REAL, "LDRIFT2 dependence of resistance for CORSRD=1,3"),
  IOP("loverld", HSMHV2_MOD_LOVERLD, IF_REAL, "Overlap length on the drain side"), 
  IOP("ldrift1", HSMHV2_MOD_LDRIFT1, IF_REAL, "Drift region length-1 on the drain side[m]"), 
  IOP("ldrift2", HSMHV2_MOD_LDRIFT2, IF_REAL, "Drift region length-2 on the drain side[m]"), 
  IOP("ldrift1s", HSMHV2_MOD_LDRIFT1S, IF_REAL, "Drift region length-1 on the source side[m]"), 
  IOP("ldrift2s", HSMHV2_MOD_LDRIFT2S, IF_REAL, "Drift region length-2 on the source side[m]"), 
  IOP("subld1", HSMHV2_MOD_SUBLD1, IF_REAL, "Impact-ionization current in the drift region [-]"),
  IOP("subld1l", HSMHV2_MOD_SUBLD1L, IF_REAL, "Impact-ionization current in the drift region [um^{subld1lp}]"),
  IOP("subld1lp", HSMHV2_MOD_SUBLD1LP, IF_REAL, "Impact-ionization current in the drift region [-]"),
  IOP("subld2", HSMHV2_MOD_SUBLD2, IF_REAL, "Impact-ionization current in the drift region [m^{-1}*V^{3/2}]"),
  IOP("xpdv", HSMHV2_MOD_XPDV, IF_REAL, "Impact-ionization current in the drift region [m^{-1}]"),
  IOP("xpvdth", HSMHV2_MOD_XPVDTH, IF_REAL, "Impact-ionization current in the drift region [V]"),
  IOP("xpvdthg", HSMHV2_MOD_XPVDTHG, IF_REAL, "Impact-ionization current in the drift region [V^{-1}]"),
  IOP("ddltmax", HSMHV2_MOD_DDLTMAX, IF_REAL, ""), /* Vdseff */
  IOP("ddltslp", HSMHV2_MOD_DDLTSLP, IF_REAL, ""), /* Vdseff */
  IOP("ddltict", HSMHV2_MOD_DDLTICT, IF_REAL, ""), /* Vdseff */
  IOP("vfbover", HSMHV2_MOD_VFBOVER, IF_REAL, ""),
  IOP("nover", HSMHV2_MOD_NOVER, IF_REAL, ""),
  IOP("novers", HSMHV2_MOD_NOVERS, IF_REAL, ""),
  IOP("xwd", HSMHV2_MOD_XWD, IF_REAL, "Lateral diffusion along the width dir. [m]"),
  IOP("xwdc", HSMHV2_MOD_XWDC, IF_REAL, "Lateral diffusion along the width dir. for capacitance [m]"),
  IOP("xl", HSMHV2_MOD_XL, IF_REAL, "Gate length offset due to mask/etch effect [m]"),
  IOP("xw", HSMHV2_MOD_XW, IF_REAL, "Gate width offset due to mask/etch effect [m]"),
  IOP("saref", HSMHV2_MOD_SAREF, IF_REAL, "Reference distance from STI edge to Gate edge [m]"),
  IOP("sbref", HSMHV2_MOD_SBREF, IF_REAL, "Reference distance from STI edge to Gate edge [m]"),
  IOP("ll", HSMHV2_MOD_LL, IF_REAL, "Gate length parameter"),
  IOP("lld", HSMHV2_MOD_LLD, IF_REAL, "Gate length parameter"),
  IOP("lln", HSMHV2_MOD_LLN, IF_REAL, "Gate length parameter"),
  IOP("wl", HSMHV2_MOD_WL, IF_REAL, "Gate width parameter"),
  IOP("wl1", HSMHV2_MOD_WL1, IF_REAL, "Gate width parameter"),
  IOP("wl1p", HSMHV2_MOD_WL1P, IF_REAL, "Gate width parameter"),
  IOP("wl2", HSMHV2_MOD_WL2, IF_REAL, "Gate width parameter"),
  IOP("wl2p", HSMHV2_MOD_WL2P, IF_REAL, "Gate width parameter"),
  IOP("wld", HSMHV2_MOD_WLD, IF_REAL, "Gate width parameter"),
  IOP("wln", HSMHV2_MOD_WLN, IF_REAL, "Gate width parameter"),
  IOP("xqy", HSMHV2_MOD_XQY, IF_REAL, "[m]"),
  IOP("xqy1", HSMHV2_MOD_XQY1, IF_REAL, "[F m^{XQY2}]"),
  IOP("xqy2", HSMHV2_MOD_XQY2, IF_REAL, "[-]"),
  IOP("rs", HSMHV2_MOD_RS, IF_REAL, "Source contact resistance [ohm m]"),
  IOP("rd", HSMHV2_MOD_RD, IF_REAL, "Drain contact resistance  [ohm m]"),
  IOP("rsh", HSMHV2_MOD_RSH, IF_REAL, "Source/drain diffusion sheet  resistance  [ohm]"),
  IOP("rshg", HSMHV2_MOD_RSHG, IF_REAL, "Gate-elecrode sheet resistance"),
  IOP("vfbc", HSMHV2_MOD_VFBC, IF_REAL, "Constant part of Vfb [V]"),
  IOP("vbi", HSMHV2_MOD_VBI, IF_REAL, "Built-in potential [V]"),
  IOP("nsubc", HSMHV2_MOD_NSUBC, IF_REAL, "Constant part of Nsub [1/cm^3]"),
  IOP("parl2", HSMHV2_MOD_PARL2, IF_REAL, "Under diffusion [m]"),
  IOP("lp", HSMHV2_MOD_LP, IF_REAL, "Length of pocket potential [m]"),
  IOP("nsubp", HSMHV2_MOD_NSUBP, IF_REAL, "[1/cm^3]"),
  IOP("nsubp0", HSMHV2_MOD_NSUBP0, IF_REAL, "Pocket implant parameter"),
  IOP("nsubwp", HSMHV2_MOD_NSUBWP, IF_REAL, "Pocket implant parameter"),
  IOP("scp1", HSMHV2_MOD_SCP1, IF_REAL, "Parameter for pocket [-]"),
  IOP("scp2", HSMHV2_MOD_SCP2, IF_REAL, "Parameter for pocket [1/V]"),
  IOP("scp3", HSMHV2_MOD_SCP3, IF_REAL, "Parameter for pocket [m/V]"),
  IOP("sc1", HSMHV2_MOD_SC1, IF_REAL, "Parameter for SCE [-]"),
  IOP("sc2", HSMHV2_MOD_SC2, IF_REAL, "Parameter for SCE [1/V]"),
  IOP("sc3", HSMHV2_MOD_SC3, IF_REAL, "Parameter for SCE [m/V]"),
  IOP("sc4", HSMHV2_MOD_SC4, IF_REAL, "Parameter for SCE [1/V]"), 
  IOP("pgd1", HSMHV2_MOD_PGD1, IF_REAL, "Parameter for gate-poly depletion [V]"),
  IOP("pgd2", HSMHV2_MOD_PGD2, IF_REAL, "Parameter for gate-poly depletion [V]"),
//IOP("pgd3", HSMHV2_MOD_PGD3, IF_REAL, "Parameter for gate-poly depletion [-]"),
  IOP("pgd4", HSMHV2_MOD_PGD4, IF_REAL, "Parameter for gate-poly depletion [-]"),
  IOP("ndep", HSMHV2_MOD_NDEP, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ndepl", HSMHV2_MOD_NDEPL, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ndeplp", HSMHV2_MOD_NDEPLP, IF_REAL, "Coeff. of Qbm for Eeff [-]"),
  IOP("ninv", HSMHV2_MOD_NINV, IF_REAL, "Coeff. of Qnm for Eeff [-]"),
  IOP("ninvd", HSMHV2_MOD_NINVD, IF_REAL, "Modification of Vdse dependence on Eeff [1/V]"),
  IOP("ninvdw", HSMHV2_MOD_NINVDW, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdwp", HSMHV2_MOD_NINVDWP, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdt1", HSMHV2_MOD_NINVDT1, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("ninvdt2", HSMHV2_MOD_NINVDT2, IF_REAL, "Coeff of modification of Vdse dependence on Eeff [-]"),
  IOP("muecb0", HSMHV2_MOD_MUECB0, IF_REAL, "Const. part of coulomb scattering [cm^2/Vs]"),
  IOP("muecb1", HSMHV2_MOD_MUECB1, IF_REAL, "Coeff. for coulomb scattering [cm^2/Vs]"),
  IOP("mueph0", HSMHV2_MOD_MUEPH0, IF_REAL, "Power of Eeff for phonon scattering [-]"),
  IOP("mueph1", HSMHV2_MOD_MUEPH1, IF_REAL, ""),
  IOP("muephw", HSMHV2_MOD_MUEPHW, IF_REAL, ""),
  IOP("muepwp", HSMHV2_MOD_MUEPWP, IF_REAL, "Phonon scattering parameter"),
  IOP("muephl", HSMHV2_MOD_MUEPHL, IF_REAL, "Phonon scattering parameter"),
  IOP("mueplp", HSMHV2_MOD_MUEPLP, IF_REAL, "Phonon scattering parameter"),
  IOP("muephs", HSMHV2_MOD_MUEPHS, IF_REAL, ""),
  IOP("muepsp", HSMHV2_MOD_MUEPSP, IF_REAL, ""),
  IOP("vtmp", HSMHV2_MOD_VTMP, IF_REAL, ""),
  IOP("wvth0", HSMHV2_MOD_WVTH0, IF_REAL, ""),
  IOP("muesr0", HSMHV2_MOD_MUESR0, IF_REAL, "Power of Eeff for S.R. scattering [-]"),
  IOP("muesr1", HSMHV2_MOD_MUESR1, IF_REAL, "Coeff. for S.R. scattering [-]"),
  IOP("muesrl", HSMHV2_MOD_MUESRL, IF_REAL, "Surface roughness parameter"),
  IOP("muesrw", HSMHV2_MOD_MUESRW, IF_REAL, "Change of surface roughness related mobility"),
  IOP("mueswp", HSMHV2_MOD_MUESWP, IF_REAL, "Change of surface roughness related mobility"),
  IOP("mueslp", HSMHV2_MOD_MUESLP, IF_REAL, "Surface roughness parameter"),
  IOP("muetmp", HSMHV2_MOD_MUETMP, IF_REAL, "Parameter for mobility [-]"),
  IOP("bb", HSMHV2_MOD_BB, IF_REAL, "Empirical mobility model coefficient [-]"),
  IOP("sub1", HSMHV2_MOD_SUB1, IF_REAL, "Parameter for Isub [1/V]"),
  IOP("sub2", HSMHV2_MOD_SUB2, IF_REAL, "Parameter for Isub [V]"),
  IOP("svgs", HSMHV2_MOD_SVGS, IF_REAL, "Coefficient for Vg of Psislsat"),
  IOP("svbs", HSMHV2_MOD_SVBS, IF_REAL, "Coefficient for Vbs of Psislsat"),
  IOP("svbsl", HSMHV2_MOD_SVBSL, IF_REAL, " "),
  IOP("svds", HSMHV2_MOD_SVDS, IF_REAL, " "),
  IOP("slg", HSMHV2_MOD_SLG, IF_REAL, " "),
  IOP("sub1l", HSMHV2_MOD_SUB1L, IF_REAL, " "),
  IOP("sub2l", HSMHV2_MOD_SUB2L, IF_REAL, " "),
  IOP("fn1", HSMHV2_MOD_FN1, IF_REAL, " "),
  IOP("fn2", HSMHV2_MOD_FN2, IF_REAL, " "),
  IOP("fn3", HSMHV2_MOD_FN3, IF_REAL, " "),
  IOP("fvbs", HSMHV2_MOD_FVBS, IF_REAL, " "),
  IOP("svgsl", HSMHV2_MOD_SVGSL, IF_REAL, " "),
  IOP("svgslp", HSMHV2_MOD_SVGSLP, IF_REAL, " "),
  IOP("svgswp", HSMHV2_MOD_SVGSWP, IF_REAL, " "),
  IOP("svgsw", HSMHV2_MOD_SVGSW, IF_REAL, " "),
  IOP("svbslp", HSMHV2_MOD_SVBSLP, IF_REAL, " "),
  IOP("slgl", HSMHV2_MOD_SLGL, IF_REAL, " "),
  IOP("slglp", HSMHV2_MOD_SLGLP, IF_REAL, " "),
  IOP("sub1lp", HSMHV2_MOD_SUB1LP, IF_REAL, " "),
  IOP("nsti", HSMHV2_MOD_NSTI, IF_REAL, "Parameter for STI [1/cm^3]"),
  IOP("wsti", HSMHV2_MOD_WSTI, IF_REAL, "Parameter for STI [m]"),
  IOP("wstil", HSMHV2_MOD_WSTIL, IF_REAL, "Parameter for STI [?]"),
  IOP("wstilp", HSMHV2_MOD_WSTILP, IF_REAL, "Parameter for STI [?]"),
  IOP("wstiw", HSMHV2_MOD_WSTIW, IF_REAL, "Parameter for STI [?]"),
  IOP("wstiwp", HSMHV2_MOD_WSTIWP, IF_REAL, "Parameter for STI [?]"),
  IOP("scsti1", HSMHV2_MOD_SCSTI1, IF_REAL, "Parameter for STI [-]"),
  IOP("scsti2", HSMHV2_MOD_SCSTI2, IF_REAL, "Parameter for STI [1/V]"),
  IOP("vthsti", HSMHV2_MOD_VTHSTI, IF_REAL, "Parameter for STI"),
  IOP("vdsti", HSMHV2_MOD_VDSTI, IF_REAL, "Parameter for STI [-]"),
  IOP("muesti1", HSMHV2_MOD_MUESTI1, IF_REAL, "STI Stress mobility parameter"),
  IOP("muesti2", HSMHV2_MOD_MUESTI2, IF_REAL, "STI Stress mobility parameter"),
  IOP("muesti3", HSMHV2_MOD_MUESTI3, IF_REAL, "STI Stress mobility parameter"),
  IOP("nsubpsti1", HSMHV2_MOD_NSUBPSTI1, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("nsubpsti2", HSMHV2_MOD_NSUBPSTI2, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("nsubpsti3", HSMHV2_MOD_NSUBPSTI3, IF_REAL, "STI Stress pocket implant parameter"),
  IOP("lpext", HSMHV2_MOD_LPEXT, IF_REAL, "Pocket extension"),
  IOP("npext", HSMHV2_MOD_NPEXT, IF_REAL, "Pocket extension"),
  IOP("scp22", HSMHV2_MOD_SCP22, IF_REAL, ""),
  IOP("scp21", HSMHV2_MOD_SCP21, IF_REAL, ""),
  IOP("bs1", HSMHV2_MOD_BS1, IF_REAL, ""),
  IOP("bs2", HSMHV2_MOD_BS2, IF_REAL, ""),
  IOP("cgso", HSMHV2_MOD_CGSO, IF_REAL, "G-S overlap capacitance per unit W [F/m]"),
  IOP("cgdo", HSMHV2_MOD_CGDO, IF_REAL, "G-D overlap capacitance per unit W [F/m]"),
  IOP("cgbo", HSMHV2_MOD_CGBO, IF_REAL, "G-B overlap capacitance per unit L [F/m]"),
  IOP("tpoly", HSMHV2_MOD_TPOLY, IF_REAL, "Height of poly gate on the source side[m]"),
  IOP("js0", HSMHV2_MOD_JS0, IF_REAL, "Saturation current density [A/m^2]"),
  IOP("js0sw", HSMHV2_MOD_JS0SW, IF_REAL, "Side wall saturation current density [A/m]"),
  IOP("nj", HSMHV2_MOD_NJ, IF_REAL, "Emission coefficient [-]"),
  IOP("njsw", HSMHV2_MOD_NJSW, IF_REAL, "Sidewall emission coefficient"),
  IOP("xti", HSMHV2_MOD_XTI, IF_REAL, "Junction current temparature exponent coefficient [-]"),
  IOP("cj", HSMHV2_MOD_CJ, IF_REAL, "Bottom junction capacitance per unit area at zero bias [F/m^2]"),
  IOP("cjsw", HSMHV2_MOD_CJSW, IF_REAL, "Source/drain sidewall junction capacitance grading coefficient per unit length at zero bias [F/m]"),
  IOP("cjswg", HSMHV2_MOD_CJSWG, IF_REAL, "Source/drain gate sidewall junction capacitance per unit length at zero bias [F/m]"),
  IOP("mj", HSMHV2_MOD_MJ, IF_REAL, "Bottom junction capacitance grading coefficient"),
  IOP("mjsw", HSMHV2_MOD_MJSW, IF_REAL, "Source/drain sidewall junction capacitance grading coefficient"),
  IOP("mjswg", HSMHV2_MOD_MJSWG, IF_REAL, "Source/drain gate sidewall junction capacitance grading coefficient"),
  IOP("pb", HSMHV2_MOD_PB, IF_REAL, "Bottom junction build-in potential  [V]"),
  IOP("pbsw", HSMHV2_MOD_PBSW, IF_REAL, "Source/drain sidewall junction build-in potential [V]"),
  IOP("pbswg", HSMHV2_MOD_PBSWG, IF_REAL, "Source/drain gate sidewall junction build-in potential [V]"),

  IOP("xti2", HSMHV2_MOD_XTI2, IF_REAL, "Temperature coefficient [-]"),
  IOP("cisb", HSMHV2_MOD_CISB, IF_REAL, "Reverse bias saturation current [-]"),
  IOP("cvb", HSMHV2_MOD_CVB, IF_REAL, "Bias dependence coefficient of cisb [-]"),
  IOP("ctemp", HSMHV2_MOD_CTEMP, IF_REAL, "Temperature coefficient [-]"),
  IOP("cisbk", HSMHV2_MOD_CISBK, IF_REAL, "Reverse bias saturation current [A]"),
  IOP("cvbk", HSMHV2_MOD_CVBK, IF_REAL, "Inactived by CVB "),
  IOP("divx", HSMHV2_MOD_DIVX, IF_REAL, "  [1/V]"),

  IOP("clm1", HSMHV2_MOD_CLM1, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm2", HSMHV2_MOD_CLM2, IF_REAL, "Parameter for CLM [1/m]"),
  IOP("clm3", HSMHV2_MOD_CLM3, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm5", HSMHV2_MOD_CLM5, IF_REAL, "Parameter for CLM [-]"),
  IOP("clm6", HSMHV2_MOD_CLM6, IF_REAL, "Parameter for CLM [um^{-clm5}]"),
  IOP("vover", HSMHV2_MOD_VOVER, IF_REAL, "Parameter for overshoot [m^{voverp}]"),
  IOP("voverp", HSMHV2_MOD_VOVERP, IF_REAL, "Parameter for overshoot [-]"),
  IOP("vovers", HSMHV2_MOD_VOVERS, IF_REAL, "Parameter for overshoot [-]"),
  IOP("voversp", HSMHV2_MOD_VOVERSP, IF_REAL, "Parameter for overshoot [-]"),

  IOP("wfc", HSMHV2_MOD_WFC, IF_REAL, "Parameter for narrow channel effect [m*F/(cm^2)]"),
  IOP("nsubcw", HSMHV2_MOD_NSUBCW, IF_REAL, "Parameter for narrow channel effect "),
  IOP("nsubcwp", HSMHV2_MOD_NSUBCWP, IF_REAL, "Parameter for narrow channel effect "),
  IOP("qme1", HSMHV2_MOD_QME1, IF_REAL, "Parameter for quantum effect [mV]"),
  IOP("qme2", HSMHV2_MOD_QME2, IF_REAL, "Parameter for quantum effect [V]"),
  IOP("qme3", HSMHV2_MOD_QME3, IF_REAL, "Parameter for quantum effect [m]"),
  IOP("gidl1", HSMHV2_MOD_GIDL1, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl2", HSMHV2_MOD_GIDL2, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl3", HSMHV2_MOD_GIDL3, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl4", HSMHV2_MOD_GIDL4, IF_REAL, "Parameter for GIDL [?]"),
  IOP("gidl5", HSMHV2_MOD_GIDL5, IF_REAL, "Parameter for GIDL [?]"),
  IOP("glpart1", HSMHV2_MOD_GLPART1, IF_REAL, "Parameter for gate current [-]"),
  IOP("gleak1", HSMHV2_MOD_GLEAK1, IF_REAL, "Parameter for gate current [A*V^(-3/2)/C]"),
  IOP("gleak2", HSMHV2_MOD_GLEAK2, IF_REAL, "Parameter for gate current [V^(-1/2)/m ]"),
  IOP("gleak3", HSMHV2_MOD_GLEAK3, IF_REAL, "Parameter for gate current [-]"),
  IOP("gleak4", HSMHV2_MOD_GLEAK4, IF_REAL, "Parameter for gate current [1/m]"),
  IOP("gleak5", HSMHV2_MOD_GLEAK5, IF_REAL, "Parameter for gate current [V/m]"),
  IOP("gleak6", HSMHV2_MOD_GLEAK6, IF_REAL, "Parameter for gate current [V]"),
  IOP("gleak7", HSMHV2_MOD_GLEAK7, IF_REAL, "Parameter for gate current [m^2]"),
  IOP("glksd1", HSMHV2_MOD_GLKSD1, IF_REAL, "Parameter for gate current [A*m/V^2]"),
  IOP("glksd2", HSMHV2_MOD_GLKSD2, IF_REAL, "Parameter for gate current [1/(V*m)]"),
  IOP("glksd3", HSMHV2_MOD_GLKSD3, IF_REAL, "Parameter for gate current [1/m]"),
  IOP("glkb1", HSMHV2_MOD_GLKB1, IF_REAL, "Parameter for gate current [A/V^2]"),
  IOP("glkb2", HSMHV2_MOD_GLKB2, IF_REAL, "Parameter for gate current [m/V]"),
  IOP("glkb3", HSMHV2_MOD_GLKB3, IF_REAL, "Parameter for gate current [V]"),
  IOP("egig", HSMHV2_MOD_EGIG, IF_REAL, "Parameter for gate current [V]"),
  IOP("igtemp2", HSMHV2_MOD_IGTEMP2, IF_REAL, "Parameter for gate current [V*k]"),
  IOP("igtemp3", HSMHV2_MOD_IGTEMP3, IF_REAL, "Parameter for gate current [V*k^2]"),
  IOP("vzadd0", HSMHV2_MOD_VZADD0, IF_REAL, "Vzadd at Vds=0  [V]"),
  IOP("pzadd0", HSMHV2_MOD_PZADD0, IF_REAL, "Pzadd at Vds=0  [V]"),
  IOP("nftrp", HSMHV2_MOD_NFTRP, IF_REAL, ""),
  IOP("nfalp", HSMHV2_MOD_NFALP, IF_REAL, ""),
  IOP("cit", HSMHV2_MOD_CIT, IF_REAL, ""),
  IOP("falph", HSMHV2_MOD_FALPH, IF_REAL, "Parameter for 1/f noise"),
  IOP("kappa", HSMHV2_MOD_KAPPA, IF_REAL, "Dielectric constant for high-k stacked gate"),
//IOP("pthrou", HSMHV2_MOD_PTHROU, IF_REAL, "Modify subthreshold slope [-]"),
  IOP("vdiffj", HSMHV2_MOD_VDIFFJ, IF_REAL, "Threshold voltage for S/D junction diode [V]"),
  IOP("dly1", HSMHV2_MOD_DLY1, IF_REAL, "Parameter for transit time [-]"),
  IOP("dly2", HSMHV2_MOD_DLY2, IF_REAL, "Parameter for transit time [-]"),
  IOP("dly3", HSMHV2_MOD_DLY3, IF_REAL, "Parameter for transforming bulk charge [s/F]"),
  IOP("dlyov", HSMHV2_MOD_DLYOV, IF_REAL, "Parameter for transforming overlap charge [s/F]"),  /* not used */
  IOP("tnom", HSMHV2_MOD_TNOM, IF_REAL, "Nominal temperature [K]"),
  IOP("ovslp", HSMHV2_MOD_OVSLP, IF_REAL, ""),
  IOP("ovmag", HSMHV2_MOD_OVMAG, IF_REAL, ""),

  IOP("gbmin", HSMHV2_MOD_GBMIN, IF_REAL, ""),
  IOP("rbpb", HSMHV2_MOD_RBPB, IF_REAL, ""),
  IOP("rbpd", HSMHV2_MOD_RBPD, IF_REAL, ""),  /* not used */
  IOP("rbps", HSMHV2_MOD_RBPS, IF_REAL, ""),  /* not used */
  IOP("rbdb", HSMHV2_MOD_RBDB, IF_REAL, ""),
  IOP("rbsb", HSMHV2_MOD_RBSB, IF_REAL, ""),

  IOP("ibpc1", HSMHV2_MOD_IBPC1, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),
  IOP("ibpc1l", HSMHV2_MOD_IBPC1L, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),
  IOP("ibpc1lp", HSMHV2_MOD_IBPC1LP, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),
  IOP("ibpc2", HSMHV2_MOD_IBPC2, IF_REAL, "Parameter for impact-ionization induced bulk potential change"),

  IOP("mphdfm", HSMHV2_MOD_MPHDFM, IF_REAL, "NSUBCDFM dependence of phonon scattering for DFM"),


  IOP("ptl", HSMHV2_MOD_PTL, IF_REAL, ""),
  IOP("ptp", HSMHV2_MOD_PTP, IF_REAL, ""),
  IOP("pt2", HSMHV2_MOD_PT2, IF_REAL, ""),
  IOP("ptlp", HSMHV2_MOD_PTLP, IF_REAL, ""),
  IOP("gdl", HSMHV2_MOD_GDL, IF_REAL, ""),
  IOP("gdlp", HSMHV2_MOD_GDLP, IF_REAL, ""),

  IOP("gdld", HSMHV2_MOD_GDLD, IF_REAL, ""),
  IOP("pt4", HSMHV2_MOD_PT4, IF_REAL, ""),
  IOP("pt4p", HSMHV2_MOD_PT4P, IF_REAL, ""),
  IOP("rdvg11", HSMHV2_MOD_RDVG11, IF_REAL, ""), 
  IOP("rdvg12", HSMHV2_MOD_RDVG12, IF_REAL, ""), 
  IOP("rth0", HSMHV2_MOD_RTH0, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("cth0", HSMHV2_MOD_CTH0, IF_REAL, "Thermal capacitance"), /* Self-heating model --SHE--- */
  IOP("powrat", HSMHV2_MOD_POWRAT, IF_REAL, ""), /* Self-heating model --SHE--- */

  IOP("rthtemp1", HSMHV2_MOD_RTHTEMP1, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("rthtemp2", HSMHV2_MOD_RTHTEMP2, IF_REAL, "Thermal resistance"), /* Self-heating model --SHE---*/
  IOP("prattemp1", HSMHV2_MOD_PRATTEMP1, IF_REAL, ""), /* Self-heating model --SHE--- */
  IOP("prattemp2", HSMHV2_MOD_PRATTEMP2, IF_REAL, ""), /* Self-heating model --SHE--- */

  IOP("tcjbd", HSMHV2_MOD_TCJBD, IF_REAL, "Temperature dependence of cjbd"), /* Self-heating model --SHE--- */
  IOP("tcjbs", HSMHV2_MOD_TCJBS, IF_REAL, "Temperature dependence of cjbs"), /* Self-heating model --SHE--- */
  IOP("tcjbdsw", HSMHV2_MOD_TCJBDSW, IF_REAL, "Temperature dependence of cjbdsw"), /* Self-heating model --SHE--- */
  IOP("tcjbssw", HSMHV2_MOD_TCJBSSW, IF_REAL, "Temperature dependence of cjbssw"), /* Self-heating model --SHE--- */
  IOP("tcjbdswg", HSMHV2_MOD_TCJBDSWG, IF_REAL, "Temperature dependence of cjbdswg"), /* Self-heating model --SHE--- */
  IOP("tcjbsswg", HSMHV2_MOD_TCJBSSWG, IF_REAL, "Temperature dependence of cjbsswg"), /* Self-heating model --SHE--- */

  IOP("qdftvd", HSMHV2_MOD_QDFTVD, IF_REAL, "Qdrift Vd dependence "),
  IOP("rdvd", HSMHV2_MOD_RDVD, IF_REAL, ""), 
  IOP("rdvb", HSMHV2_MOD_RDVB, IF_REAL, ""), 
  IOP("rd20", HSMHV2_MOD_RD20, IF_REAL, ""), 
  IOP("rd21", HSMHV2_MOD_RD21, IF_REAL, ""), 
  IOP("rd22", HSMHV2_MOD_RD22, IF_REAL, ""), 
  IOP("rd22d", HSMHV2_MOD_RD22D, IF_REAL, ""), 
  IOP("rd23", HSMHV2_MOD_RD23, IF_REAL, ""), 
  IOP("rd24", HSMHV2_MOD_RD24, IF_REAL, ""), 
  IOP("rd25", HSMHV2_MOD_RD25, IF_REAL, ""), 
  IOP("rdvdl", HSMHV2_MOD_RDVDL, IF_REAL, ""), 
  IOP("rdvdlp", HSMHV2_MOD_RDVDLP, IF_REAL, ""), 
  IOP("rdvds", HSMHV2_MOD_RDVDS, IF_REAL, ""), 
  IOP("rdvdsp", HSMHV2_MOD_RDVDSP, IF_REAL, ""), 
  IOP("rd23l", HSMHV2_MOD_RD23L, IF_REAL, ""), 
  IOP("rd23lp", HSMHV2_MOD_RD23LP, IF_REAL, ""), 
  IOP("rd23s", HSMHV2_MOD_RD23S, IF_REAL, ""), 
  IOP("rd23sp", HSMHV2_MOD_RD23SP, IF_REAL, ""), 
  IOP("rds", HSMHV2_MOD_RDS, IF_REAL, ""), 
  IOP("rdsp", HSMHV2_MOD_RDSP, IF_REAL, ""), 
//IOP("qovsm", HSMHV2_MOD_QOVSM, IF_REAL, "Smoothing Qover at depletion/inversion transition"), 
//  IOP("ldrift", HSMHV2_MOD_LDRIFT, IF_REAL, "alias for ldrift2"),
  IOP("rdtemp1", HSMHV2_MOD_RDTEMP1, IF_REAL, "Temperature-dependence of Rd"), 
  IOP("rdtemp2", HSMHV2_MOD_RDTEMP2, IF_REAL, "Temperature-dependence of Rd"), 
  IOP("rth0r", HSMHV2_MOD_RTH0R, IF_REAL, "Heat radiation for SHE"),   /* not used */
  IOP("rdvdtemp1", HSMHV2_MOD_RDVDTEMP1, IF_REAL, "Temperature-dependence of RDVD"), 
  IOP("rdvdtemp2", HSMHV2_MOD_RDVDTEMP2, IF_REAL, "Temperature-dependence of RDVD"), 
  IOP("rth0w", HSMHV2_MOD_RTH0W, IF_REAL, "Width-dependence of RTH0"), 
  IOP("rth0wp", HSMHV2_MOD_RTH0WP, IF_REAL, "Width-dependence of RTH0"), 
  IOP("rth0nf", HSMHV2_MOD_RTH0NF, IF_REAL, "nf-dependence of RTH0"), 
  IOP("cvdsover", HSMHV2_MOD_CVDSOVER, IF_REAL, "vds drop along the overlap"), 

  IOP("rdvsub", HSMHV2_MOD_RDVSUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("rdvdsub", HSMHV2_MOD_RDVDSUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("ddrift", HSMHV2_MOD_DDRIFT, IF_REAL, "model parameter for the substrate effect"),
  IOP("vbisub", HSMHV2_MOD_VBISUB, IF_REAL, "model parameter for the substrate effect"),
  IOP("nsubsub", HSMHV2_MOD_NSUBSUB, IF_REAL, "model parameter for the substrate effect"),

  IOP("rdrmue", HSMHV2_MOD_RDRMUE, IF_REAL, ""),
  IOP("rdrvmax", HSMHV2_MOD_RDRVMAX, IF_REAL, ""),
  IOP("rdrmuetmp", HSMHV2_MOD_RDRMUETMP, IF_REAL, ""),
  IOP("ndepm", HSMHV2_MOD_NDEPM, IF_REAL, "N- layer concentlation of the depletion MOS model"),
  IOP("tndep", HSMHV2_MOD_TNDEP, IF_REAL, "N- layer depth of the depletion MOS model"),
  IOP("depmue0", HSMHV2_MOD_DEPMUE0, IF_REAL, "coulomb scattering of resistor region "),
  IOP("depmue1", HSMHV2_MOD_DEPMUE1, IF_REAL, "coulomb scattering of resistor region"),
  IOP("depmueback0", HSMHV2_MOD_DEPMUEBACK0, IF_REAL, "coulomb scattering of back region"),
  IOP("depmueback1", HSMHV2_MOD_DEPMUEBACK1, IF_REAL, "coulomb scattering of back region"),
  IOP("depleak", HSMHV2_MOD_DEPLEAK, IF_REAL, "leakage current coefficient"),
  IOP("depeta", HSMHV2_MOD_DEPETA, IF_REAL, "Vds dependence"),
  IOP("depvmax", HSMHV2_MOD_DEPVMAX, IF_REAL, "velocity saturation"),
  IOP("depvdsef1", HSMHV2_MOD_DEPVDSEF1, IF_REAL, "Vds dependece of leakage current"),
  IOP("depvdsef2", HSMHV2_MOD_DEPVDSEF2, IF_REAL, "Vds dependece of leakage current"),
  IOP("depmueph0", HSMHV2_MOD_DEPMUEPH0, IF_REAL, "phonon scattering"),
  IOP("depmueph1", HSMHV2_MOD_DEPMUEPH1, IF_REAL, "phonon scattering"),
  IOP("depbb", HSMHV2_MOD_DEPBB, IF_REAL, "high field effect coeeficient"),
  IOP("depvtmp", HSMHV2_MOD_DEPVTMP, IF_REAL, "temperature dependence of velocity saturation"),
  IOP("depmuetmp", HSMHV2_MOD_DEPMUETMP, IF_REAL, "temperature dependence of mobility"),


  IOP("isbreak", HSMHV2_MOD_ISBREAK, IF_REAL, "reverse saturation current for breakdown"),
  IOP("rwell", HSMHV2_MOD_RWELL, IF_REAL, "well resistance for breakdown"),

  IOP("rdrvtmp", HSMHV2_MOD_RDRVTMP, IF_REAL, ""),
/*   IOP("rdrvmaxt1", HSMHV2_MOD_RDRVMAXT1, IF_REAL, ""), */
/*   IOP("rdrvmaxt2", HSMHV2_MOD_RDRVMAXT2, IF_REAL, ""), */
  IOP("rdrdjunc", HSMHV2_MOD_RDRDJUNC, IF_REAL, ""),
  IOP("rdrcx", HSMHV2_MOD_RDRCX, IF_REAL, ""),
  IOP("rdrcar", HSMHV2_MOD_RDRCAR, IF_REAL, ""),
  IOP("rdrdl1", HSMHV2_MOD_RDRDL1, IF_REAL, ""),
  IOP("rdrdl2", HSMHV2_MOD_RDRDL2, IF_REAL, ""),
  IOP("rdrvmaxw", HSMHV2_MOD_RDRVMAXW, IF_REAL, ""),
  IOP("rdrvmaxwp", HSMHV2_MOD_RDRVMAXWP, IF_REAL, ""),
  IOP("rdrvmaxl", HSMHV2_MOD_RDRVMAXL, IF_REAL, ""),
  IOP("rdrvmaxlp", HSMHV2_MOD_RDRVMAXLP, IF_REAL, ""),
  IOP("rdrmuel", HSMHV2_MOD_RDRMUEL, IF_REAL, ""),
  IOP("rdrmuelp", HSMHV2_MOD_RDRMUELP, IF_REAL, ""),
  IOP("rdrqover", HSMHV2_MOD_RDRQOVER, IF_REAL, ""),
  IOP("qovadd",  HSMHV2_MOD_QOVADD, IF_REAL,  "parameter for additional Qover Charge [-]"),
  IOP("js0d",    HSMHV2_MOD_JS0D, IF_REAL,    "Saturation current density for drain junction [A/m^2]"),
  IOP("js0swd",  HSMHV2_MOD_JS0SWD, IF_REAL,  "Side wall saturation current density for drain junction [A/m  ]"),
  IOP("njd",     HSMHV2_MOD_NJD, IF_REAL,     "Emission coefficient for drain junction [-    ]"),
  IOP("njswd",   HSMHV2_MOD_NJSWD, IF_REAL,   "Sidewall emission coefficient for drain junction [     ]"),
  IOP("xtid",    HSMHV2_MOD_XTID, IF_REAL,    "Junction current temparature exponent coefficient for drain junction [-    ]"),
  IOP("cjd",     HSMHV2_MOD_CJD, IF_REAL,     "Bottom junction capacitance per unit area at zero bias for drain junction [F/m^2]"),
  IOP("cjswd",   HSMHV2_MOD_CJSWD, IF_REAL,   "Sidewall junction capacitance grading coefficient per unit length at zero bias for drain junction [F/m  ]"),
  IOP("cjswgd",  HSMHV2_MOD_CJSWGD, IF_REAL,  "Gate sidewall junction capacitance per unit length at zero bias for drain junction [F/m  ]"),
  IOP("mjd",     HSMHV2_MOD_MJD, IF_REAL,     "Bottom junction capacitance grading coefficient for drain junction [     ]"),
  IOP("mjswd",   HSMHV2_MOD_MJSWD, IF_REAL,   "Sidewall junction capacitance grading coefficient for drain junction [     ]"),
  IOP("mjswgd",  HSMHV2_MOD_MJSWGD, IF_REAL,  "Gate sidewall junction capacitance grading coefficient for drain junction [     ]"),
  IOP("pbd",     HSMHV2_MOD_PBD, IF_REAL,     "Bottom junction build-in potential  for drain junction  [V    ]"),
  IOP("pbswd",   HSMHV2_MOD_PBSWD, IF_REAL,   "Sidewall junction build-in potential for drain junction [V    ]"),
  IOP("pbswgd",  HSMHV2_MOD_PBSWDG, IF_REAL,  "Gate sidewall junction build-in potential for drain junction [V    ]"),
  IOP("xti2d",   HSMHV2_MOD_XTI2D, IF_REAL,   "Temperature coefficient for drain junction [-    ]"),
  IOP("cisbd",   HSMHV2_MOD_CISBD, IF_REAL,   "Reverse bias saturation current for drain junction [-    ]"),
  IOP("cvbd",    HSMHV2_MOD_CVBD, IF_REAL,    "Bias dependence coefficient of cisb for drain junction  [-    ]"),
  IOP("ctempd",  HSMHV2_MOD_CTEMPD, IF_REAL,  "Temperature coefficient for drain junction [-    ]"),
  IOP("cisbkd",  HSMHV2_MOD_CISBKD, IF_REAL,  "Reverse bias saturation current for drain junction [A    ]"),
  IOP("divxd",   HSMHV2_MOD_DIVXD, IF_REAL,   "Reverse coefficient coefficient for drain junction [1/V  ]"),
  IOP("vdiffjd", HSMHV2_MOD_VDIFFJD, IF_REAL, "Threshold voltage for junction diode for drain junction [V    ]"),
  IOP("js0s",    HSMHV2_MOD_JS0S, IF_REAL,    "Saturation current density for source junction [A/m^2]"),
  IOP("js0sws",  HSMHV2_MOD_JS0SWS, IF_REAL,  "Side wall saturation current density for source junction [A/m  ]"),
  IOP("njs",     HSMHV2_MOD_NJS, IF_REAL,     "Emission coefficient for source junction [-    ]"),
  IOP("njsws",   HSMHV2_MOD_NJSWS, IF_REAL,   "Sidewall emission coefficient for source junction [     ]"),
  IOP("xtis",    HSMHV2_MOD_XTIS, IF_REAL,    "Junction current temparature exponent coefficient for source junction [-    ]"),
  IOP("cjs",     HSMHV2_MOD_CJS, IF_REAL,     "Bottom junction capacitance per unit area at zero bias for source junction [F/m^2]"),
  IOP("cjsws",   HSMHV2_MOD_CJSSW, IF_REAL,   "Sidewall junction capacitance grading coefficient per unit length at zero bias for source junction [F/m  ]"),
  IOP("cjswgs",  HSMHV2_MOD_CJSWGS, IF_REAL,  "Gate sidewall junction capacitance per unit length at zero bias for source junction [F/m  ]"),
  IOP("mjs",     HSMHV2_MOD_MJS, IF_REAL,     "Bottom junction capacitance grading coefficient for source junction [     ]"),
  IOP("mjsws",   HSMHV2_MOD_MJSWS, IF_REAL,   "Sidewall junction capacitance grading coefficient for source junction [     ]"),
  IOP("mjswgs",  HSMHV2_MOD_MJSWGS, IF_REAL,  "Gate sidewall junction capacitance grading coefficient for source junction [     ]"),
  IOP("pbs",     HSMHV2_MOD_PBS, IF_REAL,     "Bottom junction build-in potential  for source junction  [V    ]"),
  IOP("pbsws",   HSMHV2_MOD_PBSWS, IF_REAL,   "Sidewall junction build-in potential for source junction [V    ]"),
  IOP("pbswgs",  HSMHV2_MOD_PBSWSG, IF_REAL,  "Gate sidewall junction build-in potential for source junction [V    ]"),
  IOP("xti2s",   HSMHV2_MOD_XTI2S, IF_REAL,   "Temperature coefficient for source junction [-    ]"),
  IOP("cisbs",   HSMHV2_MOD_CISBS, IF_REAL,   "Reverse bias saturation current for source junction [-    ]"),
  IOP("cvbs",    HSMHV2_MOD_CVBS, IF_REAL,    "Bias dependence coefficient of cisb for source junction  [-    ]"),
  IOP("ctemps",  HSMHV2_MOD_CTEMPS, IF_REAL,  "Temperature coefficient for source junction [-    ]"),
  IOP("cisbks",  HSMHV2_MOD_CISBKS, IF_REAL,  "Reverse bias saturation current for source junction [A    ]"),
  IOP("divxs",   HSMHV2_MOD_DIVXS, IF_REAL,   "Reverse coefficient coefficient for source junction [1/V  ]"),
  IOP("vdiffjs", HSMHV2_MOD_VDIFFJS, IF_REAL, "Threshold voltage for junction diode for source junction [V    ]"),
  IOP("shemax",  HSMHV2_MOD_SHEMAX, IF_REAL,  "Maximum rise temperatue for SHE [C]"),
  IOP("vgsmin",  HSMHV2_MOD_VGSMIN, IF_REAL,  "minimal/maximal expected Vgs (NMOS/PMOS) [V]"),
  IOP("gdsleak", HSMHV2_MOD_GDSLEAK, IF_REAL, "Channel leakage conductance [A/V]"),
  IOP("rdrbb", HSMHV2_MOD_RDRBB, IF_REAL, "degradation of the mobility in drift region"),
  IOP("rdrbbtmp", HSMHV2_MOD_RDRBBTMP, IF_REAL, "temperature coeeficient of RDRBB"),


  /* binning parameters */
  IOP("lmin", HSMHV2_MOD_LMIN, IF_REAL, "Minimum length for the model"),
  IOP("lmax", HSMHV2_MOD_LMAX, IF_REAL, "Maximum length for the model"),
  IOP("wmin", HSMHV2_MOD_WMIN, IF_REAL, "Minimum width for the model"),
  IOP("wmax", HSMHV2_MOD_WMAX, IF_REAL, "Maximum width for the model"),
  IOP("lbinn", HSMHV2_MOD_LBINN, IF_REAL, "L modulation coefficient for binning"),
  IOP("wbinn", HSMHV2_MOD_WBINN, IF_REAL, "W modulation coefficient for binning"),

  /* Length dependence */
  IOP("lvmax", HSMHV2_MOD_LVMAX, IF_REAL, "Length dependence of vmax"),
  IOP("lbgtmp1", HSMHV2_MOD_LBGTMP1, IF_REAL, "Length dependence of bgtmp1"),
  IOP("lbgtmp2", HSMHV2_MOD_LBGTMP2, IF_REAL, "Length dependence of bgtmp2"),
  IOP("leg0", HSMHV2_MOD_LEG0, IF_REAL, "Length dependence of eg0"),
  IOP("lvfbover", HSMHV2_MOD_LVFBOVER, IF_REAL, "Length dependence of vfbover"),
  IOP("lnover", HSMHV2_MOD_LNOVER, IF_REAL, "Length dependence of nover"),
  IOP("lnovers", HSMHV2_MOD_LNOVERS, IF_REAL, "Length dependence of nover on source side"),
  IOP("lwl2", HSMHV2_MOD_LWL2, IF_REAL, "Length dependence of wl2"),
  IOP("lvfbc", HSMHV2_MOD_LVFBC, IF_REAL, "Length dependence of vfbc"),
  IOP("lnsubc", HSMHV2_MOD_LNSUBC, IF_REAL, "Length dependence of nsubc"),
  IOP("lnsubp", HSMHV2_MOD_LNSUBP, IF_REAL, "Length dependence of nsubp"),
  IOP("lscp1", HSMHV2_MOD_LSCP1, IF_REAL, "Length dependence of scp1"),
  IOP("lscp2", HSMHV2_MOD_LSCP2, IF_REAL, "Length dependence of scp2"),
  IOP("lscp3", HSMHV2_MOD_LSCP3, IF_REAL, "Length dependence of scp3"),
  IOP("lsc1", HSMHV2_MOD_LSC1, IF_REAL, "Length dependence of sc1"),
  IOP("lsc2", HSMHV2_MOD_LSC2, IF_REAL, "Length dependence of sc2"),
  IOP("lsc3", HSMHV2_MOD_LSC3, IF_REAL, "Length dependence of sc3"),
  IOP("lpgd1", HSMHV2_MOD_LPGD1, IF_REAL, "Length dependence of pgd1"),
//IOP("lpgd3", HSMHV2_MOD_LPGD3, IF_REAL, "Length dependence of pgd3"),
  IOP("lndep", HSMHV2_MOD_LNDEP, IF_REAL, "Length dependence of ndep"),
  IOP("lninv", HSMHV2_MOD_LNINV, IF_REAL, "Length dependence of ninv"),
  IOP("lmuecb0", HSMHV2_MOD_LMUECB0, IF_REAL, "Length dependence of muecb0"),
  IOP("lmuecb1", HSMHV2_MOD_LMUECB1, IF_REAL, "Length dependence of muecb1"),
  IOP("lmueph1", HSMHV2_MOD_LMUEPH1, IF_REAL, "Length dependence of mueph1"),
  IOP("lvtmp", HSMHV2_MOD_LVTMP, IF_REAL, "Length dependence of vtmp"),
  IOP("lwvth0", HSMHV2_MOD_LWVTH0, IF_REAL, "Length dependence of wvth0"),
  IOP("lmuesr1", HSMHV2_MOD_LMUESR1, IF_REAL, "Length dependence of muesr1"),
  IOP("lmuetmp", HSMHV2_MOD_LMUETMP, IF_REAL, "Length dependence of muetmp"),
  IOP("lsub1", HSMHV2_MOD_LSUB1, IF_REAL, "Length dependence of sub1"),
  IOP("lsub2", HSMHV2_MOD_LSUB2, IF_REAL, "Length dependence of sub2"),
  IOP("lsvds", HSMHV2_MOD_LSVDS, IF_REAL, "Length dependence of svds"),
  IOP("lsvbs", HSMHV2_MOD_LSVBS, IF_REAL, "Length dependence of svbs"),
  IOP("lsvgs", HSMHV2_MOD_LSVGS, IF_REAL, "Length dependence of svgs"),
  IOP("lfn1", HSMHV2_MOD_LFN1, IF_REAL, "Length dependence of fn1"),
  IOP("lfn2", HSMHV2_MOD_LFN2, IF_REAL, "Length dependence of fn2"),
  IOP("lfn3", HSMHV2_MOD_LFN3, IF_REAL, "Length dependence of fn3"),
  IOP("lfvbs", HSMHV2_MOD_LFVBS, IF_REAL, "Length dependence of fvbs"),
  IOP("lnsti", HSMHV2_MOD_LNSTI, IF_REAL, "Length dependence of nsti"),
  IOP("lwsti", HSMHV2_MOD_LWSTI, IF_REAL, "Length dependence of wsti"),
  IOP("lscsti1", HSMHV2_MOD_LSCSTI1, IF_REAL, "Length dependence of scsti1"),
  IOP("lscsti2", HSMHV2_MOD_LSCSTI2, IF_REAL, "Length dependence of scsti2"),
  IOP("lvthsti", HSMHV2_MOD_LVTHSTI, IF_REAL, "Length dependence of vthsti"),
  IOP("lmuesti1", HSMHV2_MOD_LMUESTI1, IF_REAL, "Length dependence of muesti1"),
  IOP("lmuesti2", HSMHV2_MOD_LMUESTI2, IF_REAL, "Length dependence of muesti2"),
  IOP("lmuesti3", HSMHV2_MOD_LMUESTI3, IF_REAL, "Length dependence of muesti3"),
  IOP("lnsubpsti1", HSMHV2_MOD_LNSUBPSTI1, IF_REAL, "Length dependence of nsubpsti1"),
  IOP("lnsubpsti2", HSMHV2_MOD_LNSUBPSTI2, IF_REAL, "Length dependence of nsubpsti2"),
  IOP("lnsubpsti3", HSMHV2_MOD_LNSUBPSTI3, IF_REAL, "Length dependence of nsubpsti3"),
  IOP("lcgso", HSMHV2_MOD_LCGSO, IF_REAL, "Length dependence of cgso"),
  IOP("lcgdo", HSMHV2_MOD_LCGDO, IF_REAL, "Length dependence of cgdo"),
  IOP("ljs0", HSMHV2_MOD_LJS0, IF_REAL, "Length dependence of js0"),
  IOP("ljs0sw", HSMHV2_MOD_LJS0SW, IF_REAL, "Length dependence of js0sw"),
  IOP("lnj", HSMHV2_MOD_LNJ, IF_REAL, "Length dependence of nj"),
  IOP("lcisbk", HSMHV2_MOD_LCISBK, IF_REAL, "Length dependence of cisbk"),
  IOP("lclm1", HSMHV2_MOD_LCLM1, IF_REAL, "Length dependence of clm1"),
  IOP("lclm2", HSMHV2_MOD_LCLM2, IF_REAL, "Length dependence of clm2"),
  IOP("lclm3", HSMHV2_MOD_LCLM3, IF_REAL, "Length dependence of clm3"),
  IOP("lwfc", HSMHV2_MOD_LWFC, IF_REAL, "Length dependence of wfc"),
  IOP("lgidl1", HSMHV2_MOD_LGIDL1, IF_REAL, "Length dependence of gidl1"),
  IOP("lgidl2", HSMHV2_MOD_LGIDL2, IF_REAL, "Length dependence of gidl2"),
  IOP("lgleak1", HSMHV2_MOD_LGLEAK1, IF_REAL, "Length dependence of gleak1"),
  IOP("lgleak2", HSMHV2_MOD_LGLEAK2, IF_REAL, "Length dependence of gleak2"),
  IOP("lgleak3", HSMHV2_MOD_LGLEAK3, IF_REAL, "Length dependence of gleak3"),
  IOP("lgleak6", HSMHV2_MOD_LGLEAK6, IF_REAL, "Length dependence of gleak6"),
  IOP("lglksd1", HSMHV2_MOD_LGLKSD1, IF_REAL, "Length dependence of glksd1"),
  IOP("lglksd2", HSMHV2_MOD_LGLKSD2, IF_REAL, "Length dependence of glksd2"),
  IOP("lglkb1", HSMHV2_MOD_LGLKB1, IF_REAL, "Length dependence of glkb1"),
  IOP("lglkb2", HSMHV2_MOD_LGLKB2, IF_REAL, "Length dependence of glkb2"),
  IOP("lnftrp", HSMHV2_MOD_LNFTRP, IF_REAL, "Length dependence of nftrp"),
  IOP("lnfalp", HSMHV2_MOD_LNFALP, IF_REAL, "Length dependence of nfalp"),
//IOP("lpthrou", HSMHV2_MOD_LPTHROU, IF_REAL, "Length dependence of pthrou"),
  IOP("lvdiffj", HSMHV2_MOD_LVDIFFJ, IF_REAL, "Length dependence of vdiffj"),
  IOP("libpc1", HSMHV2_MOD_LIBPC1, IF_REAL, "Length dependence of ibpc1"),
  IOP("libpc2", HSMHV2_MOD_LIBPC2, IF_REAL, "Length dependence of ibpc2"),
  IOP("lcgbo", HSMHV2_MOD_LCGBO, IF_REAL, "Length dependence of cgbo"),
  IOP("lcvdsover", HSMHV2_MOD_LCVDSOVER, IF_REAL, "Length dependence of cvdsover"),
  IOP("lfalph", HSMHV2_MOD_LFALPH, IF_REAL, "Length dependence of falph"),
  IOP("lnpext", HSMHV2_MOD_LNPEXT, IF_REAL, "Length dependence of npext"),
  IOP("lpowrat", HSMHV2_MOD_LPOWRAT, IF_REAL, "Length dependence of powrat"),
  IOP("lrd", HSMHV2_MOD_LRD, IF_REAL, "Length dependence of rd"),
  IOP("lrd22", HSMHV2_MOD_LRD22, IF_REAL, "Length dependence of rd22"),
  IOP("lrd23", HSMHV2_MOD_LRD23, IF_REAL, "Length dependence of rd23"),
  IOP("lrd24", HSMHV2_MOD_LRD24, IF_REAL, "Length dependence of rd24"),
  IOP("lrdict1", HSMHV2_MOD_LRDICT1, IF_REAL, "Length dependence of rdict1"),
  IOP("lrdov13", HSMHV2_MOD_LRDOV13, IF_REAL, "Length dependence of rdov13"),
  IOP("lrdslp1", HSMHV2_MOD_LRDSLP1, IF_REAL, "Length dependence of rdslp1"),
  IOP("lrdvb", HSMHV2_MOD_LRDVB, IF_REAL, "Length dependence of rdvb"),
  IOP("lrdvd", HSMHV2_MOD_LRDVD, IF_REAL, "Length dependence of rdvd"),
  IOP("lrdvg11", HSMHV2_MOD_LRDVG11, IF_REAL, "Length dependence of rdvg11"),
  IOP("lrs", HSMHV2_MOD_LRS, IF_REAL, "Length dependence of rs"),
  IOP("lrth0", HSMHV2_MOD_LRTH0, IF_REAL, "Length dependence of rth0"),
  IOP("lvover", HSMHV2_MOD_LVOVER, IF_REAL, "Length dependence of vover"),
  IOP("ljs0d",   HSMHV2_MOD_LJS0D, IF_REAL,   "Length dependence of js0d"),
  IOP("ljs0swd", HSMHV2_MOD_LJS0SWD, IF_REAL, "Length dependence of js0swd"),
  IOP("lnjd",    HSMHV2_MOD_LNJD, IF_REAL,    "Length dependence of njd"),
  IOP("lcisbkd", HSMHV2_MOD_LCISBKD, IF_REAL, "Length dependence of cisbkd"),
  IOP("lvdiffjd", HSMHV2_MOD_LVDIFFJD, IF_REAL, "Length dependence of vdiffjd"),
  IOP("ljs0s",   HSMHV2_MOD_LJS0S, IF_REAL,   "Length dependence of js0s"),
  IOP("ljs0sws", HSMHV2_MOD_LJS0SWS, IF_REAL, "Length dependence of js0sws"),
  IOP("lnjs",    HSMHV2_MOD_LNJS, IF_REAL,    "Length dependence of njs"),
  IOP("lcisbks", HSMHV2_MOD_LCISBKS, IF_REAL, "Length dependence of cisbks"),
  IOP("lvdiffjs", HSMHV2_MOD_LVDIFFJS, IF_REAL, "Length dependence of vdiffjs"),

  /* Width dependence */
  IOP("wvmax", HSMHV2_MOD_WVMAX, IF_REAL, "Width dependence of vmax"),
  IOP("wbgtmp1", HSMHV2_MOD_WBGTMP1, IF_REAL, "Width dependence of bgtmp1"),
  IOP("wbgtmp2", HSMHV2_MOD_WBGTMP2, IF_REAL, "Width dependence of bgtmp2"),
  IOP("weg0", HSMHV2_MOD_WEG0, IF_REAL, "Width dependence of eg0"),
  IOP("wvfbover", HSMHV2_MOD_WVFBOVER, IF_REAL, "Width dependence of vfbover"),
  IOP("wnover", HSMHV2_MOD_WNOVER, IF_REAL, "Width dependence of nover"),
  IOP("wnovers", HSMHV2_MOD_WNOVERS, IF_REAL, "Width dependence of novers on source side"),
  IOP("wwl2", HSMHV2_MOD_WWL2, IF_REAL, "Width dependence of wl2"),
  IOP("wvfbc", HSMHV2_MOD_WVFBC, IF_REAL, "Width dependence of vfbc"),
  IOP("wnsubc", HSMHV2_MOD_WNSUBC, IF_REAL, "Width dependence of nsubc"),
  IOP("wnsubp", HSMHV2_MOD_WNSUBP, IF_REAL, "Width dependence of nsubp"),
  IOP("wscp1", HSMHV2_MOD_WSCP1, IF_REAL, "Width dependence of scp1"),
  IOP("wscp2", HSMHV2_MOD_WSCP2, IF_REAL, "Width dependence of scp2"),
  IOP("wscp3", HSMHV2_MOD_WSCP3, IF_REAL, "Width dependence of scp3"),
  IOP("wsc1", HSMHV2_MOD_WSC1, IF_REAL, "Width dependence of sc1"),
  IOP("wsc2", HSMHV2_MOD_WSC2, IF_REAL, "Width dependence of sc2"),
  IOP("wsc3", HSMHV2_MOD_WSC3, IF_REAL, "Width dependence of sc3"),
  IOP("wpgd1", HSMHV2_MOD_WPGD1, IF_REAL, "Width dependence of pgd1"),
//IOP("wpgd3", HSMHV2_MOD_WPGD3, IF_REAL, "Width dependence of pgd3"),
  IOP("wndep", HSMHV2_MOD_WNDEP, IF_REAL, "Width dependence of ndep"),
  IOP("wninv", HSMHV2_MOD_WNINV, IF_REAL, "Width dependence of ninv"),
  IOP("wmuecb0", HSMHV2_MOD_WMUECB0, IF_REAL, "Width dependence of muecb0"),
  IOP("wmuecb1", HSMHV2_MOD_WMUECB1, IF_REAL, "Width dependence of muecb1"),
  IOP("wmueph1", HSMHV2_MOD_WMUEPH1, IF_REAL, "Width dependence of mueph1"),
  IOP("wvtmp", HSMHV2_MOD_WVTMP, IF_REAL, "Width dependence of vtmp"),
  IOP("wwvth0", HSMHV2_MOD_WWVTH0, IF_REAL, "Width dependence of wvth0"),
  IOP("wmuesr1", HSMHV2_MOD_WMUESR1, IF_REAL, "Width dependence of muesr1"),
  IOP("wmuetmp", HSMHV2_MOD_WMUETMP, IF_REAL, "Width dependence of muetmp"),
  IOP("wsub1", HSMHV2_MOD_WSUB1, IF_REAL, "Width dependence of sub1"),
  IOP("wsub2", HSMHV2_MOD_WSUB2, IF_REAL, "Width dependence of sub2"),
  IOP("wsvds", HSMHV2_MOD_WSVDS, IF_REAL, "Width dependence of svds"),
  IOP("wsvbs", HSMHV2_MOD_WSVBS, IF_REAL, "Width dependence of svbs"),
  IOP("wsvgs", HSMHV2_MOD_WSVGS, IF_REAL, "Width dependence of svgs"),
  IOP("wfn1", HSMHV2_MOD_WFN1, IF_REAL, "Width dependence of fn1"),
  IOP("wfn2", HSMHV2_MOD_WFN2, IF_REAL, "Width dependence of fn2"),
  IOP("wfn3", HSMHV2_MOD_WFN3, IF_REAL, "Width dependence of fn3"),
  IOP("wfvbs", HSMHV2_MOD_WFVBS, IF_REAL, "Width dependence of fvbs"),
  IOP("wnsti", HSMHV2_MOD_WNSTI, IF_REAL, "Width dependence of nsti"),
  IOP("wwsti", HSMHV2_MOD_WWSTI, IF_REAL, "Width dependence of wsti"),
  IOP("wscsti1", HSMHV2_MOD_WSCSTI1, IF_REAL, "Width dependence of scsti1"),
  IOP("wscsti2", HSMHV2_MOD_WSCSTI2, IF_REAL, "Width dependence of scsti2"),
  IOP("wvthsti", HSMHV2_MOD_WVTHSTI, IF_REAL, "Width dependence of vthsti"),
  IOP("wmuesti1", HSMHV2_MOD_WMUESTI1, IF_REAL, "Width dependence of muesti1"),
  IOP("wmuesti2", HSMHV2_MOD_WMUESTI2, IF_REAL, "Width dependence of muesti2"),
  IOP("wmuesti3", HSMHV2_MOD_WMUESTI3, IF_REAL, "Width dependence of muesti3"),
  IOP("wnsubpsti1", HSMHV2_MOD_WNSUBPSTI1, IF_REAL, "Width dependence of nsubpsti1"),
  IOP("wnsubpsti2", HSMHV2_MOD_WNSUBPSTI2, IF_REAL, "Width dependence of nsubpsti2"),
  IOP("wnsubpsti3", HSMHV2_MOD_WNSUBPSTI3, IF_REAL, "Width dependence of nsubpsti3"),
  IOP("wcgso", HSMHV2_MOD_WCGSO, IF_REAL, "Width dependence of cgso"),
  IOP("wcgdo", HSMHV2_MOD_WCGDO, IF_REAL, "Width dependence of cgdo"),
  IOP("wjs0", HSMHV2_MOD_WJS0, IF_REAL, "Width dependence of js0"),
  IOP("wjs0sw", HSMHV2_MOD_WJS0SW, IF_REAL, "Width dependence of js0sw"),
  IOP("wnj", HSMHV2_MOD_WNJ, IF_REAL, "Width dependence of nj"),
  IOP("wcisbk", HSMHV2_MOD_WCISBK, IF_REAL, "Width dependence of cisbk"),
  IOP("wclm1", HSMHV2_MOD_WCLM1, IF_REAL, "Width dependence of clm1"),
  IOP("wclm2", HSMHV2_MOD_WCLM2, IF_REAL, "Width dependence of clm2"),
  IOP("wclm3", HSMHV2_MOD_WCLM3, IF_REAL, "Width dependence of clm3"),
  IOP("wwfc", HSMHV2_MOD_WWFC, IF_REAL, "Width dependence of wfc"),
  IOP("wgidl1", HSMHV2_MOD_WGIDL1, IF_REAL, "Width dependence of gidl1"),
  IOP("wgidl2", HSMHV2_MOD_WGIDL2, IF_REAL, "Width dependence of gidl2"),
  IOP("wgleak1", HSMHV2_MOD_WGLEAK1, IF_REAL, "Width dependence of gleak1"),
  IOP("wgleak2", HSMHV2_MOD_WGLEAK2, IF_REAL, "Width dependence of gleak2"),
  IOP("wgleak3", HSMHV2_MOD_WGLEAK3, IF_REAL, "Width dependence of gleak3"),
  IOP("wgleak6", HSMHV2_MOD_WGLEAK6, IF_REAL, "Width dependence of gleak6"),
  IOP("wglksd1", HSMHV2_MOD_WGLKSD1, IF_REAL, "Width dependence of glksd1"),
  IOP("wglksd2", HSMHV2_MOD_WGLKSD2, IF_REAL, "Width dependence of glksd2"),
  IOP("wglkb1", HSMHV2_MOD_WGLKB1, IF_REAL, "Width dependence of glkb1"),
  IOP("wglkb2", HSMHV2_MOD_WGLKB2, IF_REAL, "Width dependence of glkb2"),
  IOP("wnftrp", HSMHV2_MOD_WNFTRP, IF_REAL, "Width dependence of nftrp"),
  IOP("wnfalp", HSMHV2_MOD_WNFALP, IF_REAL, "Width dependence of nfalp"),
//IOP("wpthrou", HSMHV2_MOD_WPTHROU, IF_REAL, "Width dependence of pthrou"),
  IOP("wvdiffj", HSMHV2_MOD_WVDIFFJ, IF_REAL, "Width dependence of vdiffj"),
  IOP("wibpc1", HSMHV2_MOD_WIBPC1, IF_REAL, "Width dependence of ibpc1"),
  IOP("wibpc2", HSMHV2_MOD_WIBPC2, IF_REAL, "Width dependence of ibpc2"),
  IOP("wcgbo", HSMHV2_MOD_WCGBO, IF_REAL, "Width dependence of cgbo"),
  IOP("wcvdsover", HSMHV2_MOD_WCVDSOVER, IF_REAL, "Width dependence of cvdsover"),
  IOP("wfalph", HSMHV2_MOD_WFALPH, IF_REAL, "Width dependence of falph"),
  IOP("wnpext", HSMHV2_MOD_WNPEXT, IF_REAL, "Width dependence of npext"),
  IOP("wpowrat", HSMHV2_MOD_WPOWRAT, IF_REAL, "Width dependence of powrat"),
  IOP("wrd", HSMHV2_MOD_WRD, IF_REAL, "Width dependence of rd"),
  IOP("wrd22", HSMHV2_MOD_WRD22, IF_REAL, "Width dependence of rd22"),
  IOP("wrd23", HSMHV2_MOD_WRD23, IF_REAL, "Width dependence of rd23"),
  IOP("wrd24", HSMHV2_MOD_WRD24, IF_REAL, "Width dependence of rd24"),
  IOP("wrdict1", HSMHV2_MOD_WRDICT1, IF_REAL, "Width dependence of rdict1"),
  IOP("wrdov13", HSMHV2_MOD_WRDOV13, IF_REAL, "Width dependence of rdov13"),
  IOP("wrdslp1", HSMHV2_MOD_WRDSLP1, IF_REAL, "Width dependence of rdslp1"),
  IOP("wrdvb", HSMHV2_MOD_WRDVB, IF_REAL, "Width dependence of rdvb"),
  IOP("wrdvd", HSMHV2_MOD_WRDVD, IF_REAL, "Width dependence of rdvd"),
  IOP("wrdvg11", HSMHV2_MOD_WRDVG11, IF_REAL, "Width dependence of rdvg11"),
  IOP("wrs", HSMHV2_MOD_WRS, IF_REAL, "Width dependence of rs"),
  IOP("wrth0", HSMHV2_MOD_WRTH0, IF_REAL, "Width dependence of rth0"),
  IOP("wvover", HSMHV2_MOD_WVOVER, IF_REAL, "Width dependence of vover"),
  IOP("wjs0d",   HSMHV2_MOD_WJS0D, IF_REAL,   "Wength dependence of js0d"),
  IOP("wjs0swd", HSMHV2_MOD_WJS0SWD, IF_REAL, "Wength dependence of js0swd"),
  IOP("wnjd",    HSMHV2_MOD_WNJD, IF_REAL,    "Wength dependence of njd"),
  IOP("wcisbkd", HSMHV2_MOD_WCISBKD, IF_REAL, "Wength dependence of cisbkd"),
  IOP("wvdiffjd", HSMHV2_MOD_WVDIFFJD, IF_REAL, "Wength dependence of vdiffjd"),
  IOP("wjs0s",   HSMHV2_MOD_WJS0S, IF_REAL,   "Wength dependence of js0s"),
  IOP("wjs0sws", HSMHV2_MOD_WJS0SWS, IF_REAL, "Wength dependence of js0sws"),
  IOP("wnjs",    HSMHV2_MOD_WNJS, IF_REAL,    "Wength dependence of njs"),
  IOP("wcisbks", HSMHV2_MOD_WCISBKS, IF_REAL, "Wength dependence of cisbks"),
  IOP("wvdiffjs", HSMHV2_MOD_WVDIFFJS, IF_REAL, "Wength dependence of vdiffjs"),

  /* Cross-term dependence */
  IOP("pvmax", HSMHV2_MOD_PVMAX, IF_REAL, "Cross-term dependence of vmax"),
  IOP("pbgtmp1", HSMHV2_MOD_PBGTMP1, IF_REAL, "Cross-term dependence of bgtmp1"),
  IOP("pbgtmp2", HSMHV2_MOD_PBGTMP2, IF_REAL, "Cross-term dependence of bgtmp2"),
  IOP("peg0", HSMHV2_MOD_PEG0, IF_REAL, "Cross-term dependence of eg0"),
  IOP("pvfbover", HSMHV2_MOD_PVFBOVER, IF_REAL, "Cross-term dependence of vfbover"),
  IOP("pnover", HSMHV2_MOD_PNOVER, IF_REAL, "Cross-term dependence of nover"),
  IOP("pnovers", HSMHV2_MOD_PNOVERS, IF_REAL, "Cross-term dependence of nover on source side"),
  IOP("pwl2", HSMHV2_MOD_PWL2, IF_REAL, "Cross-term dependence of wl2"),
  IOP("pvfbc", HSMHV2_MOD_PVFBC, IF_REAL, "Cross-term dependence of vfbc"),
  IOP("pnsubc", HSMHV2_MOD_PNSUBC, IF_REAL, "Cross-term dependence of nsubc"),
  IOP("pnsubp", HSMHV2_MOD_PNSUBP, IF_REAL, "Cross-term dependence of nsubp"),
  IOP("pscp1", HSMHV2_MOD_PSCP1, IF_REAL, "Cross-term dependence of scp1"),
  IOP("pscp2", HSMHV2_MOD_PSCP2, IF_REAL, "Cross-term dependence of scp2"),
  IOP("pscp3", HSMHV2_MOD_PSCP3, IF_REAL, "Cross-term dependence of scp3"),
  IOP("psc1", HSMHV2_MOD_PSC1, IF_REAL, "Cross-term dependence of sc1"),
  IOP("psc2", HSMHV2_MOD_PSC2, IF_REAL, "Cross-term dependence of sc2"),
  IOP("psc3", HSMHV2_MOD_PSC3, IF_REAL, "Cross-term dependence of sc3"),
  IOP("ppgd1", HSMHV2_MOD_PPGD1, IF_REAL, "Cross-term dependence of pgd1"),
//IOP("ppgd3", HSMHV2_MOD_PPGD3, IF_REAL, "Cross-term dependence of pgd3"),
  IOP("pndep", HSMHV2_MOD_PNDEP, IF_REAL, "Cross-term dependence of ndep"),
  IOP("pninv", HSMHV2_MOD_PNINV, IF_REAL, "Cross-term dependence of ninv"),
  IOP("pmuecb0", HSMHV2_MOD_PMUECB0, IF_REAL, "Cross-term dependence of muecb0"),
  IOP("pmuecb1", HSMHV2_MOD_PMUECB1, IF_REAL, "Cross-term dependence of muecb1"),
  IOP("pmueph1", HSMHV2_MOD_PMUEPH1, IF_REAL, "Cross-term dependence of mueph1"),
  IOP("pvtmp", HSMHV2_MOD_PVTMP, IF_REAL, "Cross-term dependence of vtmp"),
  IOP("pwvth0", HSMHV2_MOD_PWVTH0, IF_REAL, "Cross-term dependence of wvth0"),
  IOP("pmuesr1", HSMHV2_MOD_PMUESR1, IF_REAL, "Cross-term dependence of muesr1"),
  IOP("pmuetmp", HSMHV2_MOD_PMUETMP, IF_REAL, "Cross-term dependence of muetmp"),
  IOP("psub1", HSMHV2_MOD_PSUB1, IF_REAL, "Cross-term dependence of sub1"),
  IOP("psub2", HSMHV2_MOD_PSUB2, IF_REAL, "Cross-term dependence of sub2"),
  IOP("psvds", HSMHV2_MOD_PSVDS, IF_REAL, "Cross-term dependence of svds"),
  IOP("psvbs", HSMHV2_MOD_PSVBS, IF_REAL, "Cross-term dependence of svbs"),
  IOP("psvgs", HSMHV2_MOD_PSVGS, IF_REAL, "Cross-term dependence of svgs"),
  IOP("pfn1", HSMHV2_MOD_PFN1, IF_REAL, "Cross-term dependence of fn1"),
  IOP("pfn2", HSMHV2_MOD_PFN2, IF_REAL, "Cross-term dependence of fn2"),
  IOP("pfn3", HSMHV2_MOD_PFN3, IF_REAL, "Cross-term dependence of fn3"),
  IOP("pfvbs", HSMHV2_MOD_PFVBS, IF_REAL, "Cross-term dependence of fvbs"),
  IOP("pnsti", HSMHV2_MOD_PNSTI, IF_REAL, "Cross-term dependence of nsti"),
  IOP("pwsti", HSMHV2_MOD_PWSTI, IF_REAL, "Cross-term dependence of wsti"),
  IOP("pscsti1", HSMHV2_MOD_PSCSTI1, IF_REAL, "Cross-term dependence of scsti1"),
  IOP("pscsti2", HSMHV2_MOD_PSCSTI2, IF_REAL, "Cross-term dependence of scsti2"),
  IOP("pvthsti", HSMHV2_MOD_PVTHSTI, IF_REAL, "Cross-term dependence of vthsti"),
  IOP("pmuesti1", HSMHV2_MOD_PMUESTI1, IF_REAL, "Cross-term dependence of muesti1"),
  IOP("pmuesti2", HSMHV2_MOD_PMUESTI2, IF_REAL, "Cross-term dependence of muesti2"),
  IOP("pmuesti3", HSMHV2_MOD_PMUESTI3, IF_REAL, "Cross-term dependence of muesti3"),
  IOP("pnsubpsti1", HSMHV2_MOD_PNSUBPSTI1, IF_REAL, "Cross-term dependence of nsubpsti1"),
  IOP("pnsubpsti2", HSMHV2_MOD_PNSUBPSTI2, IF_REAL, "Cross-term dependence of nsubpsti2"),
  IOP("pnsubpsti3", HSMHV2_MOD_PNSUBPSTI3, IF_REAL, "Cross-term dependence of nsubpsti3"),
  IOP("pcgso", HSMHV2_MOD_PCGSO, IF_REAL, "Cross-term dependence of cgso"),
  IOP("pcgdo", HSMHV2_MOD_PCGDO, IF_REAL, "Cross-term dependence of cgdo"),
  IOP("pjs0", HSMHV2_MOD_PJS0, IF_REAL, "Cross-term dependence of js0"),
  IOP("pjs0sw", HSMHV2_MOD_PJS0SW, IF_REAL, "Cross-term dependence of js0sw"),
  IOP("pnj", HSMHV2_MOD_PNJ, IF_REAL, "Cross-term dependence of nj"),
  IOP("pcisbk", HSMHV2_MOD_PCISBK, IF_REAL, "Cross-term dependence of cisbk"),
  IOP("pclm1", HSMHV2_MOD_PCLM1, IF_REAL, "Cross-term dependence of clm1"),
  IOP("pclm2", HSMHV2_MOD_PCLM2, IF_REAL, "Cross-term dependence of clm2"),
  IOP("pclm3", HSMHV2_MOD_PCLM3, IF_REAL, "Cross-term dependence of clm3"),
  IOP("pwfc", HSMHV2_MOD_PWFC, IF_REAL, "Cross-term dependence of wfc"),
  IOP("pgidl1", HSMHV2_MOD_PGIDL1, IF_REAL, "Cross-term dependence of gidl1"),
  IOP("pgidl2", HSMHV2_MOD_PGIDL2, IF_REAL, "Cross-term dependence of gidl2"),
  IOP("pgleak1", HSMHV2_MOD_PGLEAK1, IF_REAL, "Cross-term dependence of gleak1"),
  IOP("pgleak2", HSMHV2_MOD_PGLEAK2, IF_REAL, "Cross-term dependence of gleak2"),
  IOP("pgleak3", HSMHV2_MOD_PGLEAK3, IF_REAL, "Cross-term dependence of gleak3"),
  IOP("pgleak6", HSMHV2_MOD_PGLEAK6, IF_REAL, "Cross-term dependence of gleak6"),
  IOP("pglksd1", HSMHV2_MOD_PGLKSD1, IF_REAL, "Cross-term dependence of glksd1"),
  IOP("pglksd2", HSMHV2_MOD_PGLKSD2, IF_REAL, "Cross-term dependence of glksd2"),
  IOP("pglkb1", HSMHV2_MOD_PGLKB1, IF_REAL, "Cross-term dependence of glkb1"),
  IOP("pglkb2", HSMHV2_MOD_PGLKB2, IF_REAL, "Cross-term dependence of glkb2"),
  IOP("pnftrp", HSMHV2_MOD_PNFTRP, IF_REAL, "Cross-term dependence of nftrp"),
  IOP("pnfalp", HSMHV2_MOD_PNFALP, IF_REAL, "Cross-term dependence of nfalp"),
//IOP("ppthrou", HSMHV2_MOD_PPTHROU, IF_REAL, "Cross-term dependence of pthrou"),
  IOP("pvdiffj", HSMHV2_MOD_PVDIFFJ, IF_REAL, "Cross-term dependence of vdiffj"),
  IOP("pibpc1", HSMHV2_MOD_PIBPC1, IF_REAL, "Cross-term dependence of ibpc1"),
  IOP("pibpc2", HSMHV2_MOD_PIBPC2, IF_REAL, "Cross-term dependence of ibpc2"),
  IOP("pcgbo", HSMHV2_MOD_PCGBO, IF_REAL, "Cross-term dependence of cgbo"),
  IOP("pcvdsover", HSMHV2_MOD_PCVDSOVER, IF_REAL, "Cross-term dependence of cvdsover"),
  IOP("pfalph", HSMHV2_MOD_PFALPH, IF_REAL, "Cross-term dependence of falph"),
  IOP("pnpext", HSMHV2_MOD_PNPEXT, IF_REAL, "Cross-term dependence of npext"),
  IOP("ppowrat", HSMHV2_MOD_PPOWRAT, IF_REAL, "Cross-term dependence of powrat"),
  IOP("prd", HSMHV2_MOD_PRD, IF_REAL, "Cross-term dependence of rd"),
  IOP("prd22", HSMHV2_MOD_PRD22, IF_REAL, "Cross-term dependence of rd22"),
  IOP("prd23", HSMHV2_MOD_PRD23, IF_REAL, "Cross-term dependence of rd23"),
  IOP("prd24", HSMHV2_MOD_PRD24, IF_REAL, "Cross-term dependence of rd24"),
  IOP("prdict1", HSMHV2_MOD_PRDICT1, IF_REAL, "Cross-term dependence of rdict1"),
  IOP("prdov13", HSMHV2_MOD_PRDOV13, IF_REAL, "Cross-term dependence of rdov13"),
  IOP("prdslp1", HSMHV2_MOD_PRDSLP1, IF_REAL, "Cross-term dependence of rdslp1"),
  IOP("prdvb", HSMHV2_MOD_PRDVB, IF_REAL, "Cross-term dependence of rdvb"),
  IOP("prdvd", HSMHV2_MOD_PRDVD, IF_REAL, "Cross-term dependence of rdvd"),
  IOP("prdvg11", HSMHV2_MOD_PRDVG11, IF_REAL, "Cross-term dependence of rdvg11"),
  IOP("prs", HSMHV2_MOD_PRS, IF_REAL, "Cross-term dependence of rs"),
  IOP("prth0", HSMHV2_MOD_PRTH0, IF_REAL, "Cross-term dependence of rth0"),
  IOP("pvover", HSMHV2_MOD_PVOVER, IF_REAL, "Cross-term dependence of vover"),
  IOP("pjs0d",   HSMHV2_MOD_PJS0D, IF_REAL,   "Cross-term dependence of js0d"),
  IOP("pjs0swd", HSMHV2_MOD_PJS0SWD, IF_REAL, "Cross-term dependence of js0swd"),
  IOP("pnjd",    HSMHV2_MOD_PNJD, IF_REAL,    "Cross-term dependence of njd"),
  IOP("pcisbkd", HSMHV2_MOD_PCISBKD, IF_REAL, "Cross-term dependence of cisbkd"),
  IOP("pvdiffjd", HSMHV2_MOD_PVDIFFJD, IF_REAL, "Cross-term dependence of vdiffjd"),
  IOP("pjs0s",   HSMHV2_MOD_PJS0S, IF_REAL,   "Cross-term dependence of js0s"),
  IOP("pjs0sws", HSMHV2_MOD_PJS0SWS, IF_REAL, "Cross-term dependence of js0sws"),
  IOP("pnjs",    HSMHV2_MOD_PNJS, IF_REAL,    "Cross-term dependence of njs"),
  IOP("pcisbks", HSMHV2_MOD_PCISBKS, IF_REAL, "Cross-term dependence of cisbks"),
  IOP("pvdiffjs", HSMHV2_MOD_PVDIFFJS, IF_REAL, "Cross-term dependence of vdiffjs"),

  IOP("vgs_max", HSMHV2_MOD_VGS_MAX, IF_REAL, "maximum voltage G-S branch"),
  IOP("vgd_max", HSMHV2_MOD_VGD_MAX, IF_REAL, "maximum voltage G-D branch"),
  IOP("vgb_max", HSMHV2_MOD_VGB_MAX, IF_REAL, "maximum voltage G-B branch"),
  IOP("vds_max", HSMHV2_MOD_VDS_MAX, IF_REAL, "maximum voltage D-S branch"),
  IOP("vbs_max", HSMHV2_MOD_VBS_MAX, IF_REAL, "maximum voltage B-S branch"),
  IOP("vbd_max", HSMHV2_MOD_VBD_MAX, IF_REAL, "maximum voltage B-D branch"),
  IOP("vgsr_max", HSMHV2_MOD_VGSR_MAX, IF_REAL, "maximum voltage G-S branch"),
  IOP("vgdr_max", HSMHV2_MOD_VGDR_MAX, IF_REAL, "maximum voltage G-D branch"),
  IOP("vgbr_max", HSMHV2_MOD_VGBR_MAX, IF_REAL, "maximum voltage G-B branch"),
  IOP("vbsr_max", HSMHV2_MOD_VBSR_MAX, IF_REAL, "maximum voltage B-S branch"),
  IOP("vbdr_max", HSMHV2_MOD_VBDR_MAX, IF_REAL, "maximum voltage B-D branch")

};

char *HSMHV2names[] = {
    "Drain",
    "Gate",
    "Source",
    "Bulk",
    "Substrate",
    "Temp"
};

int	HSMHV2nSize = NUMELEMS(HSMHV2names);
int	HSMHV2pTSize = NUMELEMS(HSMHV2pTable);
int	HSMHV2mPTSize = NUMELEMS(HSMHV2mPTable);
int	HSMHV2iSize = sizeof(HSMHV2instance);
int	HSMHV2mSize = sizeof(HSMHV2model);

