; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='sroa<preserve-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-PRESERVE-CFG
; RUN: opt < %s -passes='sroa<modify-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-MODIFY-CFG

declare i8 @gen.i8()
declare ptr @gen.ptr()

define i8 @store(i8 %init, i1 %cond, ptr dereferenceable(4) %escape) {
; CHECK-PRESERVE-CFG-LABEL: @store(
; CHECK-PRESERVE-CFG-NEXT:  entry:
; CHECK-PRESERVE-CFG-NEXT:    [[TMP:%.*]] = alloca i8, align 4
; CHECK-PRESERVE-CFG-NEXT:    store i8 [[INIT:%.*]], ptr [[TMP]], align 4
; CHECK-PRESERVE-CFG-NEXT:    [[REINIT:%.*]] = call i8 @gen.i8()
; CHECK-PRESERVE-CFG-NEXT:    [[ADDR:%.*]] = select i1 [[COND:%.*]], ptr [[TMP]], ptr [[ESCAPE:%.*]]
; CHECK-PRESERVE-CFG-NEXT:    store i8 [[REINIT]], ptr [[ADDR]], align 4
; CHECK-PRESERVE-CFG-NEXT:    [[TMP_0_RES:%.*]] = load i8, ptr [[TMP]], align 4
; CHECK-PRESERVE-CFG-NEXT:    ret i8 [[TMP_0_RES]]
;
; CHECK-MODIFY-CFG-LABEL: @store(
; CHECK-MODIFY-CFG-NEXT:  entry:
; CHECK-MODIFY-CFG-NEXT:    [[REINIT:%.*]] = call i8 @gen.i8()
; CHECK-MODIFY-CFG-NEXT:    br i1 [[COND:%.*]], label [[ENTRY_THEN:%.*]], label [[ENTRY_ELSE:%.*]]
; CHECK-MODIFY-CFG:       entry.then:
; CHECK-MODIFY-CFG-NEXT:    br label [[ENTRY_CONT:%.*]]
; CHECK-MODIFY-CFG:       entry.else:
; CHECK-MODIFY-CFG-NEXT:    store i8 [[REINIT]], ptr [[ESCAPE:%.*]], align 4
; CHECK-MODIFY-CFG-NEXT:    br label [[ENTRY_CONT]]
; CHECK-MODIFY-CFG:       entry.cont:
; CHECK-MODIFY-CFG-NEXT:    [[TMP_0:%.*]] = phi i8 [ [[REINIT]], [[ENTRY_THEN]] ], [ [[INIT:%.*]], [[ENTRY_ELSE]] ]
; CHECK-MODIFY-CFG-NEXT:    ret i8 [[TMP_0]]
;
entry:
  %tmp = alloca i8, align 4
  store i8 %init, ptr %tmp, align 4
  %reinit = call i8 @gen.i8()
  %addr = select i1 %cond, ptr %tmp, ptr %escape
  store i8 %reinit, ptr %addr, align 4
  %res = load i8, ptr %tmp, align 4
  ret i8 %res
}

define ptr @store_of_addr(ptr %init, i1 %cond, ptr %other.ptr, ptr dereferenceable(4) %escape.dest) {
; CHECK-LABEL: @store_of_addr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
; CHECK-NEXT:    store ptr [[INIT:%.*]], ptr [[TMP]], align 4
; CHECK-NEXT:    [[REINIT:%.*]] = call ptr @gen.ptr()
; CHECK-NEXT:    [[ADDR:%.*]] = select i1 [[COND:%.*]], ptr [[TMP]], ptr [[OTHER_PTR:%.*]]
; CHECK-NEXT:    store ptr [[ADDR]], ptr [[ESCAPE_DEST:%.*]], align 4
; CHECK-NEXT:    [[RES:%.*]] = load ptr, ptr [[TMP]], align 4
; CHECK-NEXT:    ret ptr [[RES]]
;
entry:
  %tmp = alloca ptr, align 4
  store ptr %init, ptr %tmp, align 4
  %reinit = call ptr @gen.ptr()
  %addr = select i1 %cond, ptr %tmp, ptr %other.ptr
  store ptr %addr, ptr %escape.dest, align 4
  %res = load ptr, ptr %tmp, align 4
  ret ptr %res
}

define i8 @store_atomic_unord(i8 %init, i1 %cond, ptr dereferenceable(4) %escape) {
; CHECK-PRESERVE-CFG-LABEL: @store_atomic_unord(
; CHECK-PRESERVE-CFG-NEXT:  entry:
; CHECK-PRESERVE-CFG-NEXT:    [[TMP:%.*]] = alloca i8, align 4
; CHECK-PRESERVE-CFG-NEXT:    store i8 [[INIT:%.*]], ptr [[TMP]], align 4
; CHECK-PRESERVE-CFG-NEXT:    [[REINIT:%.*]] = call i8 @gen.i8()
; CHECK-PRESERVE-CFG-NEXT:    [[ADDR:%.*]] = select i1 [[COND:%.*]], ptr [[TMP]], ptr [[ESCAPE:%.*]]
; CHECK-PRESERVE-CFG-NEXT:    store atomic i8 [[REINIT]], ptr [[ADDR]] unordered, align 4
; CHECK-PRESERVE-CFG-NEXT:    [[TMP_0_RES:%.*]] = load i8, ptr [[TMP]], align 4
; CHECK-PRESERVE-CFG-NEXT:    ret i8 [[TMP_0_RES]]
;
; CHECK-MODIFY-CFG-LABEL: @store_atomic_unord(
; CHECK-MODIFY-CFG-NEXT:  entry:
; CHECK-MODIFY-CFG-NEXT:    [[REINIT:%.*]] = call i8 @gen.i8()
; CHECK-MODIFY-CFG-NEXT:    br i1 [[COND:%.*]], label [[ENTRY_THEN:%.*]], label [[ENTRY_ELSE:%.*]]
; CHECK-MODIFY-CFG:       entry.then:
; CHECK-MODIFY-CFG-NEXT:    br label [[ENTRY_CONT:%.*]]
; CHECK-MODIFY-CFG:       entry.else:
; CHECK-MODIFY-CFG-NEXT:    store atomic i8 [[REINIT]], ptr [[ESCAPE:%.*]] unordered, align 4
; CHECK-MODIFY-CFG-NEXT:    br label [[ENTRY_CONT]]
; CHECK-MODIFY-CFG:       entry.cont:
; CHECK-MODIFY-CFG-NEXT:    [[TMP_0:%.*]] = phi i8 [ [[REINIT]], [[ENTRY_THEN]] ], [ [[INIT:%.*]], [[ENTRY_ELSE]] ]
; CHECK-MODIFY-CFG-NEXT:    ret i8 [[TMP_0]]
;
entry:
  %tmp = alloca i8, align 4
  store i8 %init, ptr %tmp, align 4
  %reinit = call i8 @gen.i8()
  %addr = select i1 %cond, ptr %tmp, ptr %escape
  store atomic i8 %reinit, ptr %addr unordered, align 4
  %res = load i8, ptr %tmp, align 4
  ret i8 %res
}

define i8 @store_volatile(i8 %init, i1 %cond, ptr dereferenceable(4) %escape) {
; CHECK-LABEL: @store_volatile(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = alloca i8, align 4
; CHECK-NEXT:    store i8 [[INIT:%.*]], ptr [[TMP]], align 4
; CHECK-NEXT:    [[REINIT:%.*]] = call i8 @gen.i8()
; CHECK-NEXT:    [[ADDR:%.*]] = select i1 [[COND:%.*]], ptr [[TMP]], ptr [[ESCAPE:%.*]]
; CHECK-NEXT:    store volatile i8 [[REINIT]], ptr [[ADDR]], align 4
; CHECK-NEXT:    [[TMP_0_RES:%.*]] = load i8, ptr [[TMP]], align 4
; CHECK-NEXT:    ret i8 [[TMP_0_RES]]
;
entry:
  %tmp = alloca i8, align 4
  store i8 %init, ptr %tmp, align 4
  %reinit = call i8 @gen.i8()
  %addr = select i1 %cond, ptr %tmp, ptr %escape
  store volatile i8 %reinit, ptr %addr, align 4
  %res = load i8, ptr %tmp, align 4
  ret i8 %res
}
