
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_STRUCT_LS_MUP_HEADER
#define hypre_STRUCT_LS_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


hypre_StructMatrix *
hypre_CycRedCreateCoarseOp_flt( hypre_StructMatrix *A, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_CycRedCreateCoarseOp_dbl( hypre_StructMatrix *A, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_CycRedCreateCoarseOp_long_dbl( hypre_StructMatrix *A, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );

HYPRE_Int
hypre_CycRedSetupCoarseOp_flt( hypre_StructMatrix *A, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride, HYPRE_Int cdir );
HYPRE_Int
hypre_CycRedSetupCoarseOp_dbl( hypre_StructMatrix *A, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride, HYPRE_Int cdir );
HYPRE_Int
hypre_CycRedSetupCoarseOp_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride, HYPRE_Int cdir );

HYPRE_Int
hypre_CyclicReduction_flt( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_CyclicReduction_dbl( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_CyclicReduction_long_dbl( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

void *
hypre_CyclicReductionCreate_flt( MPI_Comm comm );
void *
hypre_CyclicReductionCreate_dbl( MPI_Comm comm );
void *
hypre_CyclicReductionCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_CyclicReductionDestroy_flt( void *cyc_red_vdata );
HYPRE_Int
hypre_CyclicReductionDestroy_dbl( void *cyc_red_vdata );
HYPRE_Int
hypre_CyclicReductionDestroy_long_dbl( void *cyc_red_vdata );

HYPRE_Int
hypre_CyclicReductionSetBase_flt( void *cyc_red_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_CyclicReductionSetBase_dbl( void *cyc_red_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_CyclicReductionSetBase_long_dbl( void *cyc_red_vdata, hypre_Index base_index, hypre_Index base_stride );

HYPRE_Int
hypre_CyclicReductionSetCDir_flt( void *cyc_red_vdata, HYPRE_Int cdir );
HYPRE_Int
hypre_CyclicReductionSetCDir_dbl( void *cyc_red_vdata, HYPRE_Int cdir );
HYPRE_Int
hypre_CyclicReductionSetCDir_long_dbl( void *cyc_red_vdata, HYPRE_Int cdir );

HYPRE_Int
hypre_CyclicReductionSetup_flt( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_CyclicReductionSetup_dbl( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_CyclicReductionSetup_long_dbl( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

void *
hypre_HybridCreate_flt( MPI_Comm comm );
void *
hypre_HybridCreate_dbl( MPI_Comm comm );
void *
hypre_HybridCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_HybridDestroy_flt( void *hybrid_vdata );
HYPRE_Int
hypre_HybridDestroy_dbl( void *hybrid_vdata );
HYPRE_Int
hypre_HybridDestroy_long_dbl( void *hybrid_vdata );

HYPRE_Int
hypre_HybridGetDSCGNumIterations_flt( void *hybrid_vdata, HYPRE_Int *dscg_num_its );
HYPRE_Int
hypre_HybridGetDSCGNumIterations_dbl( void *hybrid_vdata, HYPRE_Int *dscg_num_its );
HYPRE_Int
hypre_HybridGetDSCGNumIterations_long_dbl( void *hybrid_vdata, HYPRE_Int *dscg_num_its );

HYPRE_Int
hypre_HybridGetFinalRelativeResidualNorm_flt( void *hybrid_vdata, hypre_float *final_rel_res_norm );
HYPRE_Int
hypre_HybridGetFinalRelativeResidualNorm_dbl( void *hybrid_vdata, hypre_double *final_rel_res_norm );
HYPRE_Int
hypre_HybridGetFinalRelativeResidualNorm_long_dbl( void *hybrid_vdata, hypre_long_double *final_rel_res_norm );

HYPRE_Int
hypre_HybridGetNumIterations_flt( void *hybrid_vdata, HYPRE_Int *num_its );
HYPRE_Int
hypre_HybridGetNumIterations_dbl( void *hybrid_vdata, HYPRE_Int *num_its );
HYPRE_Int
hypre_HybridGetNumIterations_long_dbl( void *hybrid_vdata, HYPRE_Int *num_its );

HYPRE_Int
hypre_HybridGetPCGNumIterations_flt( void *hybrid_vdata, HYPRE_Int *pcg_num_its );
HYPRE_Int
hypre_HybridGetPCGNumIterations_dbl( void *hybrid_vdata, HYPRE_Int *pcg_num_its );
HYPRE_Int
hypre_HybridGetPCGNumIterations_long_dbl( void *hybrid_vdata, HYPRE_Int *pcg_num_its );

HYPRE_Int
hypre_HybridGetRecomputeResidual_flt( void *hybrid_vdata, HYPRE_Int *recompute_residual );
HYPRE_Int
hypre_HybridGetRecomputeResidual_dbl( void *hybrid_vdata, HYPRE_Int *recompute_residual );
HYPRE_Int
hypre_HybridGetRecomputeResidual_long_dbl( void *hybrid_vdata, HYPRE_Int *recompute_residual );

HYPRE_Int
hypre_HybridGetRecomputeResidualP_flt( void *hybrid_vdata, HYPRE_Int *recompute_residual_p );
HYPRE_Int
hypre_HybridGetRecomputeResidualP_dbl( void *hybrid_vdata, HYPRE_Int *recompute_residual_p );
HYPRE_Int
hypre_HybridGetRecomputeResidualP_long_dbl( void *hybrid_vdata, HYPRE_Int *recompute_residual_p );

HYPRE_Int
hypre_HybridSetConvergenceTol_flt( void *hybrid_vdata, hypre_float cf_tol );
HYPRE_Int
hypre_HybridSetConvergenceTol_dbl( void *hybrid_vdata, hypre_double cf_tol );
HYPRE_Int
hypre_HybridSetConvergenceTol_long_dbl( void *hybrid_vdata, hypre_long_double cf_tol );

HYPRE_Int
hypre_HybridSetDSCGMaxIter_flt( void *hybrid_vdata, HYPRE_Int dscg_max_its );
HYPRE_Int
hypre_HybridSetDSCGMaxIter_dbl( void *hybrid_vdata, HYPRE_Int dscg_max_its );
HYPRE_Int
hypre_HybridSetDSCGMaxIter_long_dbl( void *hybrid_vdata, HYPRE_Int dscg_max_its );

HYPRE_Int
hypre_HybridSetKDim_flt( void *hybrid_vdata, HYPRE_Int k_dim );
HYPRE_Int
hypre_HybridSetKDim_dbl( void *hybrid_vdata, HYPRE_Int k_dim );
HYPRE_Int
hypre_HybridSetKDim_long_dbl( void *hybrid_vdata, HYPRE_Int k_dim );

HYPRE_Int
hypre_HybridSetLogging_flt( void *hybrid_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_HybridSetLogging_dbl( void *hybrid_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_HybridSetLogging_long_dbl( void *hybrid_vdata, HYPRE_Int logging );

HYPRE_Int
hypre_HybridSetPCGAbsoluteTolFactor_flt( void *hybrid_vdata, hypre_float pcg_atolf );
HYPRE_Int
hypre_HybridSetPCGAbsoluteTolFactor_dbl( void *hybrid_vdata, hypre_double pcg_atolf );
HYPRE_Int
hypre_HybridSetPCGAbsoluteTolFactor_long_dbl( void *hybrid_vdata, hypre_long_double pcg_atolf );

HYPRE_Int
hypre_HybridSetPCGMaxIter_flt( void *hybrid_vdata, HYPRE_Int pcg_max_its );
HYPRE_Int
hypre_HybridSetPCGMaxIter_dbl( void *hybrid_vdata, HYPRE_Int pcg_max_its );
HYPRE_Int
hypre_HybridSetPCGMaxIter_long_dbl( void *hybrid_vdata, HYPRE_Int pcg_max_its );

HYPRE_Int
hypre_HybridSetPrintLevel_flt( void *hybrid_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_HybridSetPrintLevel_dbl( void *hybrid_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_HybridSetPrintLevel_long_dbl( void *hybrid_vdata, HYPRE_Int print_level );

HYPRE_Int
hypre_HybridSetRecomputeResidual_flt( void *hybrid_vdata, HYPRE_Int recompute_residual );
HYPRE_Int
hypre_HybridSetRecomputeResidual_dbl( void *hybrid_vdata, HYPRE_Int recompute_residual );
HYPRE_Int
hypre_HybridSetRecomputeResidual_long_dbl( void *hybrid_vdata, HYPRE_Int recompute_residual );

HYPRE_Int
hypre_HybridSetRecomputeResidualP_flt( void *hybrid_vdata, HYPRE_Int recompute_residual_p );
HYPRE_Int
hypre_HybridSetRecomputeResidualP_dbl( void *hybrid_vdata, HYPRE_Int recompute_residual_p );
HYPRE_Int
hypre_HybridSetRecomputeResidualP_long_dbl( void *hybrid_vdata, HYPRE_Int recompute_residual_p );

HYPRE_Int
hypre_HybridSetRelChange_flt( void *hybrid_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_HybridSetRelChange_dbl( void *hybrid_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_HybridSetRelChange_long_dbl( void *hybrid_vdata, HYPRE_Int rel_change );

HYPRE_Int
hypre_HybridSetSolverType_flt( void *hybrid_vdata, HYPRE_Int solver_type );
HYPRE_Int
hypre_HybridSetSolverType_dbl( void *hybrid_vdata, HYPRE_Int solver_type );
HYPRE_Int
hypre_HybridSetSolverType_long_dbl( void *hybrid_vdata, HYPRE_Int solver_type );

HYPRE_Int
hypre_HybridSetStopCrit_flt( void *hybrid_vdata, HYPRE_Int stop_crit );
HYPRE_Int
hypre_HybridSetStopCrit_dbl( void *hybrid_vdata, HYPRE_Int stop_crit );
HYPRE_Int
hypre_HybridSetStopCrit_long_dbl( void *hybrid_vdata, HYPRE_Int stop_crit );

HYPRE_Int
hypre_HybridSetTol_flt( void *hybrid_vdata, hypre_float tol );
HYPRE_Int
hypre_HybridSetTol_dbl( void *hybrid_vdata, hypre_double tol );
HYPRE_Int
hypre_HybridSetTol_long_dbl( void *hybrid_vdata, hypre_long_double tol );

HYPRE_Int
hypre_HybridSetTwoNorm_flt( void *hybrid_vdata, HYPRE_Int two_norm );
HYPRE_Int
hypre_HybridSetTwoNorm_dbl( void *hybrid_vdata, HYPRE_Int two_norm );
HYPRE_Int
hypre_HybridSetTwoNorm_long_dbl( void *hybrid_vdata, HYPRE_Int two_norm );

HYPRE_Int
hypre_HybridSetup_flt( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_HybridSetup_dbl( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_HybridSetup_long_dbl( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_HybridSolve_flt( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_HybridSolve_dbl( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_HybridSolve_long_dbl( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

hypre_StructMatrix *
hypre_PFMG2CreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMG2CreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMG2CreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1_flt( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1_long_dbl( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

hypre_StructMatrix *
hypre_PFMG3CreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMG3CreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMG3CreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );

HYPRE_Int
hypre_PFMGBuildCoarseOp5_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMGBuildCoarseOp5_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMGBuildCoarseOp5_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMGBuildCoarseOp7_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMGBuildCoarseOp7_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_PFMGBuildCoarseOp7_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP );

HYPRE_Int
hypre_PFMGCoarsen_flt( hypre_Box *cbox, hypre_Index periodic, HYPRE_Int max_levels, HYPRE_Int dxyz_flag, hypre_float *dxyz, HYPRE_Int **cdir_l_ptr, HYPRE_Int **active_l_ptr, hypre_float **relax_weights_ptr, HYPRE_Int *num_levels );
HYPRE_Int
hypre_PFMGCoarsen_dbl( hypre_Box *cbox, hypre_Index periodic, HYPRE_Int max_levels, HYPRE_Int dxyz_flag, hypre_double *dxyz, HYPRE_Int **cdir_l_ptr, HYPRE_Int **active_l_ptr, hypre_double **relax_weights_ptr, HYPRE_Int *num_levels );
HYPRE_Int
hypre_PFMGCoarsen_long_dbl( hypre_Box *cbox, hypre_Index periodic, HYPRE_Int max_levels, HYPRE_Int dxyz_flag, hypre_long_double *dxyz, HYPRE_Int **cdir_l_ptr, HYPRE_Int **active_l_ptr, hypre_long_double **relax_weights_ptr, HYPRE_Int *num_levels );

HYPRE_Int
hypre_PFMGComputeCxyz_flt( hypre_StructMatrix *A, hypre_float *cxyz, hypre_float *sqcxyz );
HYPRE_Int
hypre_PFMGComputeCxyz_dbl( hypre_StructMatrix *A, hypre_double *cxyz, hypre_double *sqcxyz );
HYPRE_Int
hypre_PFMGComputeCxyz_long_dbl( hypre_StructMatrix *A, hypre_long_double *cxyz, hypre_long_double *sqcxyz );

HYPRE_Int
hypre_PFMGComputeDxyz_flt( hypre_StructMatrix *A, hypre_float *dxyz, HYPRE_Int *dxyz_flag );
HYPRE_Int
hypre_PFMGComputeDxyz_dbl( hypre_StructMatrix *A, hypre_double *dxyz, HYPRE_Int *dxyz_flag );
HYPRE_Int
hypre_PFMGComputeDxyz_long_dbl( hypre_StructMatrix *A, hypre_long_double *dxyz, HYPRE_Int *dxyz_flag );

HYPRE_Int
hypre_PFMGComputeMaxLevels_flt( hypre_StructGrid *grid, HYPRE_Int *max_levels_ptr );
HYPRE_Int
hypre_PFMGComputeMaxLevels_dbl( hypre_StructGrid *grid, HYPRE_Int *max_levels_ptr );
HYPRE_Int
hypre_PFMGComputeMaxLevels_long_dbl( hypre_StructGrid *grid, HYPRE_Int *max_levels_ptr );

void *
hypre_PFMGCreate_flt( MPI_Comm comm );
void *
hypre_PFMGCreate_dbl( MPI_Comm comm );
void *
hypre_PFMGCreate_long_dbl( MPI_Comm comm );

hypre_StructMatrix *
hypre_PFMGCreateCoarseOp5_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMGCreateCoarseOp5_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMGCreateCoarseOp5_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );

hypre_StructMatrix *
hypre_PFMGCreateCoarseOp7_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMGCreateCoarseOp7_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_PFMGCreateCoarseOp7_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir );

hypre_StructMatrix *
hypre_PFMGCreateInterpOp_flt( hypre_StructMatrix *A, HYPRE_Int cdir, hypre_Index stride, HYPRE_Int rap_type );
hypre_StructMatrix *
hypre_PFMGCreateInterpOp_dbl( hypre_StructMatrix *A, HYPRE_Int cdir, hypre_Index stride, HYPRE_Int rap_type );
hypre_StructMatrix *
hypre_PFMGCreateInterpOp_long_dbl( hypre_StructMatrix *A, HYPRE_Int cdir, hypre_Index stride, HYPRE_Int rap_type );

hypre_StructMatrix *
hypre_PFMGCreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int rap_type );
hypre_StructMatrix *
hypre_PFMGCreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int rap_type );
hypre_StructMatrix *
hypre_PFMGCreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int rap_type );

HYPRE_Int
hypre_PFMGDestroy_flt( void *pfmg_vdata );
HYPRE_Int
hypre_PFMGDestroy_dbl( void *pfmg_vdata );
HYPRE_Int
hypre_PFMGDestroy_long_dbl( void *pfmg_vdata );

HYPRE_Int
hypre_PFMGGetFinalRelativeResidualNorm_flt( void *pfmg_vdata, hypre_float *relative_residual_norm );
HYPRE_Int
hypre_PFMGGetFinalRelativeResidualNorm_dbl( void *pfmg_vdata, hypre_double *relative_residual_norm );
HYPRE_Int
hypre_PFMGGetFinalRelativeResidualNorm_long_dbl( void *pfmg_vdata, hypre_long_double *relative_residual_norm );

HYPRE_Int
hypre_PFMGGetJacobiWeight_flt( void *pfmg_vdata, hypre_float *weight );
HYPRE_Int
hypre_PFMGGetJacobiWeight_dbl( void *pfmg_vdata, hypre_double *weight );
HYPRE_Int
hypre_PFMGGetJacobiWeight_long_dbl( void *pfmg_vdata, hypre_long_double *weight );

HYPRE_Int
hypre_PFMGGetLogging_flt( void *pfmg_vdata, HYPRE_Int *logging );
HYPRE_Int
hypre_PFMGGetLogging_dbl( void *pfmg_vdata, HYPRE_Int *logging );
HYPRE_Int
hypre_PFMGGetLogging_long_dbl( void *pfmg_vdata, HYPRE_Int *logging );

HYPRE_Int
hypre_PFMGGetMatmultType_flt( void *pfmg_vdata, HYPRE_Int *matmult_type );
HYPRE_Int
hypre_PFMGGetMatmultType_dbl( void *pfmg_vdata, HYPRE_Int *matmult_type );
HYPRE_Int
hypre_PFMGGetMatmultType_long_dbl( void *pfmg_vdata, HYPRE_Int *matmult_type );

HYPRE_Int
hypre_PFMGGetMaxIter_flt( void *pfmg_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_PFMGGetMaxIter_dbl( void *pfmg_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_PFMGGetMaxIter_long_dbl( void *pfmg_vdata, HYPRE_Int *max_iter );

HYPRE_Int
hypre_PFMGGetMaxLevels_flt( void *pfmg_vdata, HYPRE_Int *max_levels );
HYPRE_Int
hypre_PFMGGetMaxLevels_dbl( void *pfmg_vdata, HYPRE_Int *max_levels );
HYPRE_Int
hypre_PFMGGetMaxLevels_long_dbl( void *pfmg_vdata, HYPRE_Int *max_levels );

HYPRE_Int
hypre_PFMGGetNumIterations_flt( void *pfmg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_PFMGGetNumIterations_dbl( void *pfmg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_PFMGGetNumIterations_long_dbl( void *pfmg_vdata, HYPRE_Int *num_iterations );

HYPRE_Int
hypre_PFMGGetNumPostRelax_flt( void *pfmg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int
hypre_PFMGGetNumPostRelax_dbl( void *pfmg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int
hypre_PFMGGetNumPostRelax_long_dbl( void *pfmg_vdata, HYPRE_Int *num_post_relax );

HYPRE_Int
hypre_PFMGGetNumPreRelax_flt( void *pfmg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int
hypre_PFMGGetNumPreRelax_dbl( void *pfmg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int
hypre_PFMGGetNumPreRelax_long_dbl( void *pfmg_vdata, HYPRE_Int *num_pre_relax );

HYPRE_Int
hypre_PFMGGetPrintFreq_flt( void *pfmg_vdata, HYPRE_Int *print_freq );
HYPRE_Int
hypre_PFMGGetPrintFreq_dbl( void *pfmg_vdata, HYPRE_Int *print_freq );
HYPRE_Int
hypre_PFMGGetPrintFreq_long_dbl( void *pfmg_vdata, HYPRE_Int *print_freq );

HYPRE_Int
hypre_PFMGGetPrintLevel_flt( void *pfmg_vdata, HYPRE_Int *print_level );
HYPRE_Int
hypre_PFMGGetPrintLevel_dbl( void *pfmg_vdata, HYPRE_Int *print_level );
HYPRE_Int
hypre_PFMGGetPrintLevel_long_dbl( void *pfmg_vdata, HYPRE_Int *print_level );

HYPRE_Int
hypre_PFMGGetRAPType_flt( void *pfmg_vdata, HYPRE_Int *rap_type );
HYPRE_Int
hypre_PFMGGetRAPType_dbl( void *pfmg_vdata, HYPRE_Int *rap_type );
HYPRE_Int
hypre_PFMGGetRAPType_long_dbl( void *pfmg_vdata, HYPRE_Int *rap_type );

HYPRE_Int
hypre_PFMGGetRelChange_flt( void *pfmg_vdata, HYPRE_Int *rel_change );
HYPRE_Int
hypre_PFMGGetRelChange_dbl( void *pfmg_vdata, HYPRE_Int *rel_change );
HYPRE_Int
hypre_PFMGGetRelChange_long_dbl( void *pfmg_vdata, HYPRE_Int *rel_change );

HYPRE_Int
hypre_PFMGGetRelaxType_flt( void *pfmg_vdata, HYPRE_Int *relax_type );
HYPRE_Int
hypre_PFMGGetRelaxType_dbl( void *pfmg_vdata, HYPRE_Int *relax_type );
HYPRE_Int
hypre_PFMGGetRelaxType_long_dbl( void *pfmg_vdata, HYPRE_Int *relax_type );

HYPRE_Int
hypre_PFMGGetSkipRelax_flt( void *pfmg_vdata, HYPRE_Int *skip_relax );
HYPRE_Int
hypre_PFMGGetSkipRelax_dbl( void *pfmg_vdata, HYPRE_Int *skip_relax );
HYPRE_Int
hypre_PFMGGetSkipRelax_long_dbl( void *pfmg_vdata, HYPRE_Int *skip_relax );

HYPRE_Int
hypre_PFMGGetTol_flt( void *pfmg_vdata, hypre_float *tol );
HYPRE_Int
hypre_PFMGGetTol_dbl( void *pfmg_vdata, hypre_double *tol );
HYPRE_Int
hypre_PFMGGetTol_long_dbl( void *pfmg_vdata, hypre_long_double *tol );

HYPRE_Int
hypre_PFMGGetZeroGuess_flt( void *pfmg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_PFMGGetZeroGuess_dbl( void *pfmg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_PFMGGetZeroGuess_long_dbl( void *pfmg_vdata, HYPRE_Int *zero_guess );

HYPRE_Int
hypre_PFMGPrintLogging_flt( void *pfmg_vdata );
HYPRE_Int
hypre_PFMGPrintLogging_dbl( void *pfmg_vdata );
HYPRE_Int
hypre_PFMGPrintLogging_long_dbl( void *pfmg_vdata );

HYPRE_Int
hypre_PFMGRelax_flt( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGRelax_dbl( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGRelax_long_dbl( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

void *
hypre_PFMGRelaxCreate_flt( MPI_Comm comm );
void *
hypre_PFMGRelaxCreate_dbl( MPI_Comm comm );
void *
hypre_PFMGRelaxCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_PFMGRelaxDestroy_flt( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxDestroy_dbl( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxDestroy_long_dbl( void *pfmg_relax_vdata );

HYPRE_Int
hypre_PFMGRelaxSetJacobiWeight_flt( void *pfmg_relax_vdata, hypre_float weight );
HYPRE_Int
hypre_PFMGRelaxSetJacobiWeight_dbl( void *pfmg_relax_vdata, hypre_double weight );
HYPRE_Int
hypre_PFMGRelaxSetJacobiWeight_long_dbl( void *pfmg_relax_vdata, hypre_long_double weight );

HYPRE_Int
hypre_PFMGRelaxSetMaxIter_flt( void *pfmg_relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_PFMGRelaxSetMaxIter_dbl( void *pfmg_relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_PFMGRelaxSetMaxIter_long_dbl( void *pfmg_relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_PFMGRelaxSetPostRelax_flt( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxSetPostRelax_dbl( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxSetPostRelax_long_dbl( void *pfmg_relax_vdata );

HYPRE_Int
hypre_PFMGRelaxSetPreRelax_flt( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxSetPreRelax_dbl( void *pfmg_relax_vdata );
HYPRE_Int
hypre_PFMGRelaxSetPreRelax_long_dbl( void *pfmg_relax_vdata );

HYPRE_Int
hypre_PFMGRelaxSetTempVec_flt( void *pfmg_relax_vdata, hypre_StructVector *t );
HYPRE_Int
hypre_PFMGRelaxSetTempVec_dbl( void *pfmg_relax_vdata, hypre_StructVector *t );
HYPRE_Int
hypre_PFMGRelaxSetTempVec_long_dbl( void *pfmg_relax_vdata, hypre_StructVector *t );

HYPRE_Int
hypre_PFMGRelaxSetTol_flt( void *pfmg_relax_vdata, hypre_float tol );
HYPRE_Int
hypre_PFMGRelaxSetTol_dbl( void *pfmg_relax_vdata, hypre_double tol );
HYPRE_Int
hypre_PFMGRelaxSetTol_long_dbl( void *pfmg_relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_PFMGRelaxSetType_flt( void *pfmg_relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_PFMGRelaxSetType_dbl( void *pfmg_relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_PFMGRelaxSetType_long_dbl( void *pfmg_relax_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_PFMGRelaxSetZeroGuess_flt( void *pfmg_relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_PFMGRelaxSetZeroGuess_dbl( void *pfmg_relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_PFMGRelaxSetZeroGuess_long_dbl( void *pfmg_relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_PFMGRelaxSetup_flt( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGRelaxSetup_dbl( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGRelaxSetup_long_dbl( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_PFMGSetDxyz_flt( void *pfmg_vdata, hypre_float *dxyz );
HYPRE_Int
hypre_PFMGSetDxyz_dbl( void *pfmg_vdata, hypre_double *dxyz );
HYPRE_Int
hypre_PFMGSetDxyz_long_dbl( void *pfmg_vdata, hypre_long_double *dxyz );

HYPRE_Int
hypre_PFMGSetJacobiWeight_flt( void *pfmg_vdata, hypre_float weight );
HYPRE_Int
hypre_PFMGSetJacobiWeight_dbl( void *pfmg_vdata, hypre_double weight );
HYPRE_Int
hypre_PFMGSetJacobiWeight_long_dbl( void *pfmg_vdata, hypre_long_double weight );

HYPRE_Int
hypre_PFMGSetLogging_flt( void *pfmg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_PFMGSetLogging_dbl( void *pfmg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_PFMGSetLogging_long_dbl( void *pfmg_vdata, HYPRE_Int logging );

HYPRE_Int
hypre_PFMGSetMatmultType_flt( void *pfmg_vdata, HYPRE_Int matmult_type );
HYPRE_Int
hypre_PFMGSetMatmultType_dbl( void *pfmg_vdata, HYPRE_Int matmult_type );
HYPRE_Int
hypre_PFMGSetMatmultType_long_dbl( void *pfmg_vdata, HYPRE_Int matmult_type );

HYPRE_Int
hypre_PFMGSetMaxIter_flt( void *pfmg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_PFMGSetMaxIter_dbl( void *pfmg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_PFMGSetMaxIter_long_dbl( void *pfmg_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_PFMGSetMaxLevels_flt( void *pfmg_vdata, HYPRE_Int max_levels );
HYPRE_Int
hypre_PFMGSetMaxLevels_dbl( void *pfmg_vdata, HYPRE_Int max_levels );
HYPRE_Int
hypre_PFMGSetMaxLevels_long_dbl( void *pfmg_vdata, HYPRE_Int max_levels );

HYPRE_Int
hypre_PFMGSetNumPostRelax_flt( void *pfmg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_PFMGSetNumPostRelax_dbl( void *pfmg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_PFMGSetNumPostRelax_long_dbl( void *pfmg_vdata, HYPRE_Int num_post_relax );

HYPRE_Int
hypre_PFMGSetNumPreRelax_flt( void *pfmg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_PFMGSetNumPreRelax_dbl( void *pfmg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_PFMGSetNumPreRelax_long_dbl( void *pfmg_vdata, HYPRE_Int num_pre_relax );

HYPRE_Int
hypre_PFMGSetPrintFreq_flt( void *pfmg_vdata, HYPRE_Int print_freq );
HYPRE_Int
hypre_PFMGSetPrintFreq_dbl( void *pfmg_vdata, HYPRE_Int print_freq );
HYPRE_Int
hypre_PFMGSetPrintFreq_long_dbl( void *pfmg_vdata, HYPRE_Int print_freq );

HYPRE_Int
hypre_PFMGSetPrintLevel_flt( void *pfmg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_PFMGSetPrintLevel_dbl( void *pfmg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_PFMGSetPrintLevel_long_dbl( void *pfmg_vdata, HYPRE_Int print_level );

HYPRE_Int
hypre_PFMGSetRAPType_flt( void *pfmg_vdata, HYPRE_Int rap_type );
HYPRE_Int
hypre_PFMGSetRAPType_dbl( void *pfmg_vdata, HYPRE_Int rap_type );
HYPRE_Int
hypre_PFMGSetRAPType_long_dbl( void *pfmg_vdata, HYPRE_Int rap_type );

HYPRE_Int
hypre_PFMGSetRelChange_flt( void *pfmg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_PFMGSetRelChange_dbl( void *pfmg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_PFMGSetRelChange_long_dbl( void *pfmg_vdata, HYPRE_Int rel_change );

HYPRE_Int
hypre_PFMGSetRelaxType_flt( void *pfmg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_PFMGSetRelaxType_dbl( void *pfmg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_PFMGSetRelaxType_long_dbl( void *pfmg_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_PFMGSetSkipRelax_flt( void *pfmg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_PFMGSetSkipRelax_dbl( void *pfmg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_PFMGSetSkipRelax_long_dbl( void *pfmg_vdata, HYPRE_Int skip_relax );

HYPRE_Int
hypre_PFMGSetTol_flt( void *pfmg_vdata, hypre_float tol );
HYPRE_Int
hypre_PFMGSetTol_dbl( void *pfmg_vdata, hypre_double tol );
HYPRE_Int
hypre_PFMGSetTol_long_dbl( void *pfmg_vdata, hypre_long_double tol );

HYPRE_Int
hypre_PFMGSetZeroGuess_flt( void *pfmg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_PFMGSetZeroGuess_dbl( void *pfmg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_PFMGSetZeroGuess_long_dbl( void *pfmg_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_PFMGSetup_flt( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGSetup_dbl( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGSetup_long_dbl( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_PFMGSetupInterpOp_flt( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir );
HYPRE_Int
hypre_PFMGSetupInterpOp_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir );
HYPRE_Int
hypre_PFMGSetupInterpOp_long_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir );

HYPRE_Int
hypre_PFMGSetupInterpOp_core_CC_flt( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_float *Pconst0_ptr, hypre_float *Pconst1_ptr, hypre_float *Pconst2_ptr );
HYPRE_Int
hypre_PFMGSetupInterpOp_core_CC_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_double *Pconst0_ptr, hypre_double *Pconst1_ptr, hypre_double *Pconst2_ptr );
HYPRE_Int
hypre_PFMGSetupInterpOp_core_CC_long_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_long_double *Pconst0_ptr, hypre_long_double *Pconst1_ptr, hypre_long_double *Pconst2_ptr );

HYPRE_Int
hypre_PFMGSetupInterpOp_core_VC_flt( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_float Pconst0, hypre_float Pconst1, hypre_float Pconst2 );
HYPRE_Int
hypre_PFMGSetupInterpOp_core_VC_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_double Pconst0, hypre_double Pconst1, hypre_double Pconst2 );
HYPRE_Int
hypre_PFMGSetupInterpOp_core_VC_long_dbl( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, hypre_long_double Pconst0, hypre_long_double Pconst1, hypre_long_double Pconst2 );

HYPRE_Int
hypre_PFMGSetupRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int rap_type, hypre_StructMatrix *Ac );
HYPRE_Int
hypre_PFMGSetupRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int rap_type, hypre_StructMatrix *Ac );
HYPRE_Int
hypre_PFMGSetupRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int rap_type, hypre_StructMatrix *Ac );

HYPRE_Int
hypre_PFMGSolve_flt( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGSolve_dbl( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_PFMGSolve_long_dbl( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_RedBlackConstantCoefGS_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackConstantCoefGS_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackConstantCoefGS_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_RedBlackGS_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackGS_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackGS_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

void *
hypre_RedBlackGSCreate_flt( MPI_Comm comm );
void *
hypre_RedBlackGSCreate_dbl( MPI_Comm comm );
void *
hypre_RedBlackGSCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_RedBlackGSDestroy_flt( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSDestroy_dbl( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSDestroy_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_RedBlackGSSetMaxIter_flt( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_RedBlackGSSetMaxIter_dbl( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_RedBlackGSSetMaxIter_long_dbl( void *relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_RedBlackGSSetStartBlack_flt( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSSetStartBlack_dbl( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSSetStartBlack_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_RedBlackGSSetStartRed_flt( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSSetStartRed_dbl( void *relax_vdata );
HYPRE_Int
hypre_RedBlackGSSetStartRed_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_RedBlackGSSetTol_flt( void *relax_vdata, hypre_float tol );
HYPRE_Int
hypre_RedBlackGSSetTol_dbl( void *relax_vdata, hypre_double tol );
HYPRE_Int
hypre_RedBlackGSSetTol_long_dbl( void *relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_RedBlackGSSetZeroGuess_flt( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_RedBlackGSSetZeroGuess_dbl( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_RedBlackGSSetZeroGuess_long_dbl( void *relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_RedBlackGSSetup_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackGSSetup_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_RedBlackGSSetup_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMG2BuildRAPNoSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2BuildRAPNoSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2BuildRAPNoSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMG2BuildRAPSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2BuildRAPSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2BuildRAPSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

hypre_StructMatrix *
hypre_SMG2CreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMG2CreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMG2CreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );

HYPRE_Int
hypre_SMG2RAPPeriodicNoSym_flt( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2RAPPeriodicNoSym_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2RAPPeriodicNoSym_long_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMG2RAPPeriodicSym_flt( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2RAPPeriodicSym_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG2RAPPeriodicSym_long_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMG3BuildRAPNoSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3BuildRAPNoSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3BuildRAPNoSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMG3BuildRAPSym_flt( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3BuildRAPSym_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3BuildRAPSym_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

hypre_StructMatrix *
hypre_SMG3CreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMG3CreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMG3CreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );

HYPRE_Int
hypre_SMG3RAPPeriodicNoSym_flt( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3RAPPeriodicNoSym_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3RAPPeriodicNoSym_long_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMG3RAPPeriodicSym_flt( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3RAPPeriodicSym_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMG3RAPPeriodicSym_long_dbl( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMGAxpy_flt( hypre_float alpha, hypre_StructVector *x, hypre_StructVector *y, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGAxpy_dbl( hypre_double alpha, hypre_StructVector *x, hypre_StructVector *y, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGAxpy_long_dbl( hypre_long_double alpha, hypre_StructVector *x, hypre_StructVector *y, hypre_Index base_index, hypre_Index base_stride );

void *
hypre_SMGCreate_flt( MPI_Comm comm );
void *
hypre_SMGCreate_dbl( MPI_Comm comm );
void *
hypre_SMGCreate_long_dbl( MPI_Comm comm );

hypre_StructMatrix *
hypre_SMGCreateInterpOp_flt( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_SMGCreateInterpOp_dbl( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_SMGCreateInterpOp_long_dbl( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );

hypre_StructMatrix *
hypre_SMGCreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMGCreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );
hypre_StructMatrix *
hypre_SMGCreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid );

hypre_StructMatrix *
hypre_SMGCreateRestrictOp_flt( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_SMGCreateRestrictOp_dbl( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );
hypre_StructMatrix *
hypre_SMGCreateRestrictOp_long_dbl( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir );

HYPRE_Int
hypre_SMGDestroy_flt( void *smg_vdata );
HYPRE_Int
hypre_SMGDestroy_dbl( void *smg_vdata );
HYPRE_Int
hypre_SMGDestroy_long_dbl( void *smg_vdata );

HYPRE_Int
hypre_SMGGetFinalRelativeResidualNorm_flt( void *smg_vdata, hypre_float *relative_residual_norm );
HYPRE_Int
hypre_SMGGetFinalRelativeResidualNorm_dbl( void *smg_vdata, hypre_double *relative_residual_norm );
HYPRE_Int
hypre_SMGGetFinalRelativeResidualNorm_long_dbl( void *smg_vdata, hypre_long_double *relative_residual_norm );

HYPRE_Int
hypre_SMGGetLogging_flt( void *smg_vdata, HYPRE_Int *logging );
HYPRE_Int
hypre_SMGGetLogging_dbl( void *smg_vdata, HYPRE_Int *logging );
HYPRE_Int
hypre_SMGGetLogging_long_dbl( void *smg_vdata, HYPRE_Int *logging );

HYPRE_Int
hypre_SMGGetMaxIter_flt( void *smg_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_SMGGetMaxIter_dbl( void *smg_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_SMGGetMaxIter_long_dbl( void *smg_vdata, HYPRE_Int *max_iter );

HYPRE_Int
hypre_SMGGetMemoryUse_flt( void *smg_vdata, HYPRE_Int *memory_use );
HYPRE_Int
hypre_SMGGetMemoryUse_dbl( void *smg_vdata, HYPRE_Int *memory_use );
HYPRE_Int
hypre_SMGGetMemoryUse_long_dbl( void *smg_vdata, HYPRE_Int *memory_use );

HYPRE_Int
hypre_SMGGetNumIterations_flt( void *smg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SMGGetNumIterations_dbl( void *smg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SMGGetNumIterations_long_dbl( void *smg_vdata, HYPRE_Int *num_iterations );

HYPRE_Int
hypre_SMGGetNumPostRelax_flt( void *smg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int
hypre_SMGGetNumPostRelax_dbl( void *smg_vdata, HYPRE_Int *num_post_relax );
HYPRE_Int
hypre_SMGGetNumPostRelax_long_dbl( void *smg_vdata, HYPRE_Int *num_post_relax );

HYPRE_Int
hypre_SMGGetNumPreRelax_flt( void *smg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int
hypre_SMGGetNumPreRelax_dbl( void *smg_vdata, HYPRE_Int *num_pre_relax );
HYPRE_Int
hypre_SMGGetNumPreRelax_long_dbl( void *smg_vdata, HYPRE_Int *num_pre_relax );

HYPRE_Int
hypre_SMGGetPrintLevel_flt( void *smg_vdata, HYPRE_Int *print_level );
HYPRE_Int
hypre_SMGGetPrintLevel_dbl( void *smg_vdata, HYPRE_Int *print_level );
HYPRE_Int
hypre_SMGGetPrintLevel_long_dbl( void *smg_vdata, HYPRE_Int *print_level );

HYPRE_Int
hypre_SMGGetRelChange_flt( void *smg_vdata, HYPRE_Int *rel_change );
HYPRE_Int
hypre_SMGGetRelChange_dbl( void *smg_vdata, HYPRE_Int *rel_change );
HYPRE_Int
hypre_SMGGetRelChange_long_dbl( void *smg_vdata, HYPRE_Int *rel_change );

HYPRE_Int
hypre_SMGGetTol_flt( void *smg_vdata, hypre_float *tol );
HYPRE_Int
hypre_SMGGetTol_dbl( void *smg_vdata, hypre_double *tol );
HYPRE_Int
hypre_SMGGetTol_long_dbl( void *smg_vdata, hypre_long_double *tol );

HYPRE_Int
hypre_SMGGetZeroGuess_flt( void *smg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_SMGGetZeroGuess_dbl( void *smg_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_SMGGetZeroGuess_long_dbl( void *smg_vdata, HYPRE_Int *zero_guess );

HYPRE_Int
hypre_SMGPrintLogging_flt( void *smg_vdata );
HYPRE_Int
hypre_SMGPrintLogging_dbl( void *smg_vdata );
HYPRE_Int
hypre_SMGPrintLogging_long_dbl( void *smg_vdata );

HYPRE_Int
hypre_SMGRelax_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelax_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelax_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

void *
hypre_SMGRelaxCreate_flt( MPI_Comm comm );
void *
hypre_SMGRelaxCreate_dbl( MPI_Comm comm );
void *
hypre_SMGRelaxCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_SMGRelaxDestroy_flt( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroy_dbl( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroy_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SMGRelaxDestroyARem_flt( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyARem_dbl( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyARem_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SMGRelaxDestroyASol_flt( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyASol_dbl( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyASol_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SMGRelaxDestroyTempVec_flt( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyTempVec_dbl( void *relax_vdata );
HYPRE_Int
hypre_SMGRelaxDestroyTempVec_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SMGRelaxSetBase_flt( void *relax_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGRelaxSetBase_dbl( void *relax_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGRelaxSetBase_long_dbl( void *relax_vdata, hypre_Index base_index, hypre_Index base_stride );

HYPRE_Int
hypre_SMGRelaxSetMaxIter_flt( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SMGRelaxSetMaxIter_dbl( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SMGRelaxSetMaxIter_long_dbl( void *relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SMGRelaxSetMaxLevel_flt( void *relax_vdata, HYPRE_Int num_max_level );
HYPRE_Int
hypre_SMGRelaxSetMaxLevel_dbl( void *relax_vdata, HYPRE_Int num_max_level );
HYPRE_Int
hypre_SMGRelaxSetMaxLevel_long_dbl( void *relax_vdata, HYPRE_Int num_max_level );

HYPRE_Int
hypre_SMGRelaxSetMemoryUse_flt( void *relax_vdata, HYPRE_Int memory_use );
HYPRE_Int
hypre_SMGRelaxSetMemoryUse_dbl( void *relax_vdata, HYPRE_Int memory_use );
HYPRE_Int
hypre_SMGRelaxSetMemoryUse_long_dbl( void *relax_vdata, HYPRE_Int memory_use );

HYPRE_Int
hypre_SMGRelaxSetNewMatrixStencil_flt( void *relax_vdata, hypre_StructStencil *diff_stencil );
HYPRE_Int
hypre_SMGRelaxSetNewMatrixStencil_dbl( void *relax_vdata, hypre_StructStencil *diff_stencil );
HYPRE_Int
hypre_SMGRelaxSetNewMatrixStencil_long_dbl( void *relax_vdata, hypre_StructStencil *diff_stencil );

HYPRE_Int
hypre_SMGRelaxSetNumPostRelax_flt( void *relax_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SMGRelaxSetNumPostRelax_dbl( void *relax_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SMGRelaxSetNumPostRelax_long_dbl( void *relax_vdata, HYPRE_Int num_post_relax );

HYPRE_Int
hypre_SMGRelaxSetNumPreRelax_flt( void *relax_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SMGRelaxSetNumPreRelax_dbl( void *relax_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SMGRelaxSetNumPreRelax_long_dbl( void *relax_vdata, HYPRE_Int num_pre_relax );

HYPRE_Int
hypre_SMGRelaxSetNumPreSpaces_flt( void *relax_vdata, HYPRE_Int num_pre_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumPreSpaces_dbl( void *relax_vdata, HYPRE_Int num_pre_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumPreSpaces_long_dbl( void *relax_vdata, HYPRE_Int num_pre_spaces );

HYPRE_Int
hypre_SMGRelaxSetNumRegSpaces_flt( void *relax_vdata, HYPRE_Int num_reg_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumRegSpaces_dbl( void *relax_vdata, HYPRE_Int num_reg_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumRegSpaces_long_dbl( void *relax_vdata, HYPRE_Int num_reg_spaces );

HYPRE_Int
hypre_SMGRelaxSetNumSpaces_flt( void *relax_vdata, HYPRE_Int num_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumSpaces_dbl( void *relax_vdata, HYPRE_Int num_spaces );
HYPRE_Int
hypre_SMGRelaxSetNumSpaces_long_dbl( void *relax_vdata, HYPRE_Int num_spaces );

HYPRE_Int
hypre_SMGRelaxSetPreSpaceRank_flt( void *relax_vdata, HYPRE_Int i, HYPRE_Int pre_space_rank );
HYPRE_Int
hypre_SMGRelaxSetPreSpaceRank_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int pre_space_rank );
HYPRE_Int
hypre_SMGRelaxSetPreSpaceRank_long_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int pre_space_rank );

HYPRE_Int
hypre_SMGRelaxSetRegSpaceRank_flt( void *relax_vdata, HYPRE_Int i, HYPRE_Int reg_space_rank );
HYPRE_Int
hypre_SMGRelaxSetRegSpaceRank_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int reg_space_rank );
HYPRE_Int
hypre_SMGRelaxSetRegSpaceRank_long_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int reg_space_rank );

HYPRE_Int
hypre_SMGRelaxSetSpace_flt( void *relax_vdata, HYPRE_Int i, HYPRE_Int space_index, HYPRE_Int space_stride );
HYPRE_Int
hypre_SMGRelaxSetSpace_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int space_index, HYPRE_Int space_stride );
HYPRE_Int
hypre_SMGRelaxSetSpace_long_dbl( void *relax_vdata, HYPRE_Int i, HYPRE_Int space_index, HYPRE_Int space_stride );

HYPRE_Int
hypre_SMGRelaxSetTempVec_flt( void *relax_vdata, hypre_StructVector *temp_vec );
HYPRE_Int
hypre_SMGRelaxSetTempVec_dbl( void *relax_vdata, hypre_StructVector *temp_vec );
HYPRE_Int
hypre_SMGRelaxSetTempVec_long_dbl( void *relax_vdata, hypre_StructVector *temp_vec );

HYPRE_Int
hypre_SMGRelaxSetTol_flt( void *relax_vdata, hypre_float tol );
HYPRE_Int
hypre_SMGRelaxSetTol_dbl( void *relax_vdata, hypre_double tol );
HYPRE_Int
hypre_SMGRelaxSetTol_long_dbl( void *relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SMGRelaxSetZeroGuess_flt( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SMGRelaxSetZeroGuess_dbl( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SMGRelaxSetZeroGuess_long_dbl( void *relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SMGRelaxSetup_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetup_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetup_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGRelaxSetupARem_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupARem_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupARem_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGRelaxSetupASol_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupASol_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupASol_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGRelaxSetupBaseBoxArray_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupBaseBoxArray_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupBaseBoxArray_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGRelaxSetupTempVec_flt( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupTempVec_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGRelaxSetupTempVec_long_dbl( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGResidual_flt( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int
hypre_SMGResidual_dbl( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int
hypre_SMGResidual_long_dbl( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );

void *
hypre_SMGResidualCreate_flt( void );
void *
hypre_SMGResidualCreate_dbl( void );
void *
hypre_SMGResidualCreate_long_dbl( void );

HYPRE_Int
hypre_SMGResidualDestroy_flt( void *residual_vdata );
HYPRE_Int
hypre_SMGResidualDestroy_dbl( void *residual_vdata );
HYPRE_Int
hypre_SMGResidualDestroy_long_dbl( void *residual_vdata );

HYPRE_Int
hypre_SMGResidualSetBase_flt( void *residual_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGResidualSetBase_dbl( void *residual_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGResidualSetBase_long_dbl( void *residual_vdata, hypre_Index base_index, hypre_Index base_stride );

HYPRE_Int
hypre_SMGResidualSetup_flt( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int
hypre_SMGResidualSetup_dbl( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );
HYPRE_Int
hypre_SMGResidualSetup_long_dbl( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r );

HYPRE_Int
hypre_SMGSetBase_flt( void *smg_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGSetBase_dbl( void *smg_vdata, hypre_Index base_index, hypre_Index base_stride );
HYPRE_Int
hypre_SMGSetBase_long_dbl( void *smg_vdata, hypre_Index base_index, hypre_Index base_stride );

HYPRE_Int
hypre_SMGSetLogging_flt( void *smg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SMGSetLogging_dbl( void *smg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SMGSetLogging_long_dbl( void *smg_vdata, HYPRE_Int logging );

HYPRE_Int
hypre_SMGSetMaxIter_flt( void *smg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SMGSetMaxIter_dbl( void *smg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SMGSetMaxIter_long_dbl( void *smg_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SMGSetMaxLevel_flt( void *smg_vdata, HYPRE_Int max_level );
HYPRE_Int
hypre_SMGSetMaxLevel_dbl( void *smg_vdata, HYPRE_Int max_level );
HYPRE_Int
hypre_SMGSetMaxLevel_long_dbl( void *smg_vdata, HYPRE_Int max_level );

HYPRE_Int
hypre_SMGSetMemoryUse_flt( void *smg_vdata, HYPRE_Int memory_use );
HYPRE_Int
hypre_SMGSetMemoryUse_dbl( void *smg_vdata, HYPRE_Int memory_use );
HYPRE_Int
hypre_SMGSetMemoryUse_long_dbl( void *smg_vdata, HYPRE_Int memory_use );

HYPRE_Int
hypre_SMGSetNumPostRelax_flt( void *smg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SMGSetNumPostRelax_dbl( void *smg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SMGSetNumPostRelax_long_dbl( void *smg_vdata, HYPRE_Int num_post_relax );

HYPRE_Int
hypre_SMGSetNumPreRelax_flt( void *smg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SMGSetNumPreRelax_dbl( void *smg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SMGSetNumPreRelax_long_dbl( void *smg_vdata, HYPRE_Int num_pre_relax );

HYPRE_Int
hypre_SMGSetPrintLevel_flt( void *smg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SMGSetPrintLevel_dbl( void *smg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SMGSetPrintLevel_long_dbl( void *smg_vdata, HYPRE_Int print_level );

HYPRE_Int
hypre_SMGSetRelChange_flt( void *smg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SMGSetRelChange_dbl( void *smg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SMGSetRelChange_long_dbl( void *smg_vdata, HYPRE_Int rel_change );

HYPRE_Int
hypre_SMGSetStructVectorConstantValues_flt( hypre_StructVector *vector, hypre_float values, hypre_BoxArray *box_array, hypre_Index stride );
HYPRE_Int
hypre_SMGSetStructVectorConstantValues_dbl( hypre_StructVector *vector, hypre_double values, hypre_BoxArray *box_array, hypre_Index stride );
HYPRE_Int
hypre_SMGSetStructVectorConstantValues_long_dbl( hypre_StructVector *vector, hypre_long_double values, hypre_BoxArray *box_array, hypre_Index stride );

HYPRE_Int
hypre_SMGSetTol_flt( void *smg_vdata, hypre_float tol );
HYPRE_Int
hypre_SMGSetTol_dbl( void *smg_vdata, hypre_double tol );
HYPRE_Int
hypre_SMGSetTol_long_dbl( void *smg_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SMGSetZeroGuess_flt( void *smg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SMGSetZeroGuess_dbl( void *smg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SMGSetZeroGuess_long_dbl( void *smg_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SMGSetup_flt( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGSetup_dbl( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGSetup_long_dbl( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SMGSetupInterpOp_flt( void *relax_data, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x, hypre_StructMatrix *PT, HYPRE_Int cdir, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SMGSetupInterpOp_dbl( void *relax_data, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x, hypre_StructMatrix *PT, HYPRE_Int cdir, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SMGSetupInterpOp_long_dbl( void *relax_data, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x, hypre_StructMatrix *PT, HYPRE_Int cdir, hypre_Index cindex, hypre_Index findex, hypre_Index stride );

HYPRE_Int
hypre_SMGSetupRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMGSetupRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMGSetupRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMGSetupRestrictOp_flt( hypre_StructMatrix *A, hypre_StructMatrix *R, hypre_StructVector *temp_vec, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMGSetupRestrictOp_dbl( hypre_StructMatrix *A, hypre_StructMatrix *R, hypre_StructVector *temp_vec, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride );
HYPRE_Int
hypre_SMGSetupRestrictOp_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *R, hypre_StructVector *temp_vec, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride );

HYPRE_Int
hypre_SMGSolve_flt( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGSolve_dbl( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_SMGSolve_long_dbl( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_SemiBuildRAP_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int P_stored_as_transpose, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_SemiBuildRAP_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int P_stored_as_transpose, hypre_StructMatrix *RAP );
HYPRE_Int
hypre_SemiBuildRAP_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int P_stored_as_transpose, hypre_StructMatrix *RAP );

hypre_StructMatrix *
hypre_SemiCreateRAPOp_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int P_stored_as_transpose );
hypre_StructMatrix *
hypre_SemiCreateRAPOp_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int P_stored_as_transpose );
hypre_StructMatrix *
hypre_SemiCreateRAPOp_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int P_stored_as_transpose );

HYPRE_Int
hypre_SemiInterp_flt( void *interp_vdata, hypre_StructMatrix *P, hypre_StructVector *xc, hypre_StructVector *e );
HYPRE_Int
hypre_SemiInterp_dbl( void *interp_vdata, hypre_StructMatrix *P, hypre_StructVector *xc, hypre_StructVector *e );
HYPRE_Int
hypre_SemiInterp_long_dbl( void *interp_vdata, hypre_StructMatrix *P, hypre_StructVector *xc, hypre_StructVector *e );

void *
hypre_SemiInterpCreate_flt( void );
void *
hypre_SemiInterpCreate_dbl( void );
void *
hypre_SemiInterpCreate_long_dbl( void );

HYPRE_Int
hypre_SemiInterpDestroy_flt( void *interp_vdata );
HYPRE_Int
hypre_SemiInterpDestroy_dbl( void *interp_vdata );
HYPRE_Int
hypre_SemiInterpDestroy_long_dbl( void *interp_vdata );

HYPRE_Int
hypre_SemiInterpSetup_flt( void *interp_vdata, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, hypre_StructVector *xc, hypre_StructVector *e, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SemiInterpSetup_dbl( void *interp_vdata, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, hypre_StructVector *xc, hypre_StructVector *e, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SemiInterpSetup_long_dbl( void *interp_vdata, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, hypre_StructVector *xc, hypre_StructVector *e, hypre_Index cindex, hypre_Index findex, hypre_Index stride );

HYPRE_Int
hypre_SemiRestrict_flt( void *restrict_vdata, hypre_StructMatrix *R, hypre_StructVector *r, hypre_StructVector *rc );
HYPRE_Int
hypre_SemiRestrict_dbl( void *restrict_vdata, hypre_StructMatrix *R, hypre_StructVector *r, hypre_StructVector *rc );
HYPRE_Int
hypre_SemiRestrict_long_dbl( void *restrict_vdata, hypre_StructMatrix *R, hypre_StructVector *r, hypre_StructVector *rc );

void *
hypre_SemiRestrictCreate_flt( void );
void *
hypre_SemiRestrictCreate_dbl( void );
void *
hypre_SemiRestrictCreate_long_dbl( void );

HYPRE_Int
hypre_SemiRestrictDestroy_flt( void *restrict_vdata );
HYPRE_Int
hypre_SemiRestrictDestroy_dbl( void *restrict_vdata );
HYPRE_Int
hypre_SemiRestrictDestroy_long_dbl( void *restrict_vdata );

HYPRE_Int
hypre_SemiRestrictSetup_flt( void *restrict_vdata, hypre_StructMatrix *R, HYPRE_Int R_stored_as_transpose, hypre_StructVector *r, hypre_StructVector *rc, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SemiRestrictSetup_dbl( void *restrict_vdata, hypre_StructMatrix *R, HYPRE_Int R_stored_as_transpose, hypre_StructVector *r, hypre_StructVector *rc, hypre_Index cindex, hypre_Index findex, hypre_Index stride );
HYPRE_Int
hypre_SemiRestrictSetup_long_dbl( void *restrict_vdata, hypre_StructMatrix *R, HYPRE_Int R_stored_as_transpose, hypre_StructVector *r, hypre_StructVector *rc, hypre_Index cindex, hypre_Index findex, hypre_Index stride );

HYPRE_Int
hypre_StructDiagScale_flt( hypre_StructMatrix *A, hypre_StructVector *y, hypre_StructVector *x );
HYPRE_Int
hypre_StructDiagScale_dbl( hypre_StructMatrix *A, hypre_StructVector *y, hypre_StructVector *x );
HYPRE_Int
hypre_StructDiagScale_long_dbl( hypre_StructMatrix *A, hypre_StructVector *y, hypre_StructVector *x );

HYPRE_Int
hypre_StructInterpAssemble_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, HYPRE_Int cdir, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_StructInterpAssemble_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, HYPRE_Int cdir, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_StructInterpAssemble_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, HYPRE_Int cdir, hypre_Index index, hypre_Index stride );

void *
hypre_StructJacobiCreate_flt( MPI_Comm comm );
void *
hypre_StructJacobiCreate_dbl( MPI_Comm comm );
void *
hypre_StructJacobiCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_StructJacobiDestroy_flt( void *jacobi_vdata );
HYPRE_Int
hypre_StructJacobiDestroy_dbl( void *jacobi_vdata );
HYPRE_Int
hypre_StructJacobiDestroy_long_dbl( void *jacobi_vdata );

HYPRE_Int
hypre_StructJacobiGetFinalRelativeResidualNorm_flt( void *jacobi_vdata, hypre_float *norm );
HYPRE_Int
hypre_StructJacobiGetFinalRelativeResidualNorm_dbl( void *jacobi_vdata, hypre_double *norm );
HYPRE_Int
hypre_StructJacobiGetFinalRelativeResidualNorm_long_dbl( void *jacobi_vdata, hypre_long_double *norm );

HYPRE_Int
hypre_StructJacobiGetMaxIter_flt( void *jacobi_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_StructJacobiGetMaxIter_dbl( void *jacobi_vdata, HYPRE_Int *max_iter );
HYPRE_Int
hypre_StructJacobiGetMaxIter_long_dbl( void *jacobi_vdata, HYPRE_Int *max_iter );

HYPRE_Int
hypre_StructJacobiGetNumIterations_flt( void *jacobi_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_StructJacobiGetNumIterations_dbl( void *jacobi_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_StructJacobiGetNumIterations_long_dbl( void *jacobi_vdata, HYPRE_Int *num_iterations );

HYPRE_Int
hypre_StructJacobiGetTol_flt( void *jacobi_vdata, hypre_float *tol );
HYPRE_Int
hypre_StructJacobiGetTol_dbl( void *jacobi_vdata, hypre_double *tol );
HYPRE_Int
hypre_StructJacobiGetTol_long_dbl( void *jacobi_vdata, hypre_long_double *tol );

HYPRE_Int
hypre_StructJacobiGetZeroGuess_flt( void *jacobi_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_StructJacobiGetZeroGuess_dbl( void *jacobi_vdata, HYPRE_Int *zero_guess );
HYPRE_Int
hypre_StructJacobiGetZeroGuess_long_dbl( void *jacobi_vdata, HYPRE_Int *zero_guess );

HYPRE_Int
hypre_StructJacobiSetMaxIter_flt( void *jacobi_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_StructJacobiSetMaxIter_dbl( void *jacobi_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_StructJacobiSetMaxIter_long_dbl( void *jacobi_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_StructJacobiSetTempVec_flt( void *jacobi_vdata, hypre_StructVector *t );
HYPRE_Int
hypre_StructJacobiSetTempVec_dbl( void *jacobi_vdata, hypre_StructVector *t );
HYPRE_Int
hypre_StructJacobiSetTempVec_long_dbl( void *jacobi_vdata, hypre_StructVector *t );

HYPRE_Int
hypre_StructJacobiSetTol_flt( void *jacobi_vdata, hypre_float tol );
HYPRE_Int
hypre_StructJacobiSetTol_dbl( void *jacobi_vdata, hypre_double tol );
HYPRE_Int
hypre_StructJacobiSetTol_long_dbl( void *jacobi_vdata, hypre_long_double tol );

HYPRE_Int
hypre_StructJacobiSetWeight_flt( void *jacobi_vdata, hypre_float weight );
HYPRE_Int
hypre_StructJacobiSetWeight_dbl( void *jacobi_vdata, hypre_double weight );
HYPRE_Int
hypre_StructJacobiSetWeight_long_dbl( void *jacobi_vdata, hypre_long_double weight );

HYPRE_Int
hypre_StructJacobiSetZeroGuess_flt( void *jacobi_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_StructJacobiSetZeroGuess_dbl( void *jacobi_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_StructJacobiSetZeroGuess_long_dbl( void *jacobi_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_StructJacobiSetup_flt( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_StructJacobiSetup_dbl( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_StructJacobiSetup_long_dbl( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_StructJacobiSolve_flt( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_StructJacobiSolve_dbl( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );
HYPRE_Int
hypre_StructJacobiSolve_long_dbl( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x );

HYPRE_Int
hypre_StructKrylovAxpy_flt( hypre_float alpha, void *x, void *y );
HYPRE_Int
hypre_StructKrylovAxpy_dbl( hypre_double alpha, void *x, void *y );
HYPRE_Int
hypre_StructKrylovAxpy_long_dbl( hypre_long_double alpha, void *x, void *y );

void *
hypre_StructKrylovCAlloc_flt( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_StructKrylovCAlloc_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_StructKrylovCAlloc_long_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_StructKrylovClearVector_flt( void *x );
HYPRE_Int
hypre_StructKrylovClearVector_dbl( void *x );
HYPRE_Int
hypre_StructKrylovClearVector_long_dbl( void *x );

HYPRE_Int
hypre_StructKrylovCommInfo_flt( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );
HYPRE_Int
hypre_StructKrylovCommInfo_dbl( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );
HYPRE_Int
hypre_StructKrylovCommInfo_long_dbl( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );

HYPRE_Int
hypre_StructKrylovCopyVector_flt( void *x, void *y );
HYPRE_Int
hypre_StructKrylovCopyVector_dbl( void *x, void *y );
HYPRE_Int
hypre_StructKrylovCopyVector_long_dbl( void *x, void *y );

void *
hypre_StructKrylovCreateVector_flt( void *vvector );
void *
hypre_StructKrylovCreateVector_dbl( void *vvector );
void *
hypre_StructKrylovCreateVector_long_dbl( void *vvector );

void *
hypre_StructKrylovCreateVectorArray_flt( HYPRE_Int n, void *vvector );
void *
hypre_StructKrylovCreateVectorArray_dbl( HYPRE_Int n, void *vvector );
void *
hypre_StructKrylovCreateVectorArray_long_dbl( HYPRE_Int n, void *vvector );

HYPRE_Int
hypre_StructKrylovDestroyVector_flt( void *vvector );
HYPRE_Int
hypre_StructKrylovDestroyVector_dbl( void *vvector );
HYPRE_Int
hypre_StructKrylovDestroyVector_long_dbl( void *vvector );

HYPRE_Int
hypre_StructKrylovFree_flt( void *ptr );
HYPRE_Int
hypre_StructKrylovFree_dbl( void *ptr );
HYPRE_Int
hypre_StructKrylovFree_long_dbl( void *ptr );

HYPRE_Int
hypre_StructKrylovIdentity_flt( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_StructKrylovIdentity_dbl( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_StructKrylovIdentity_long_dbl( void *vdata, void *A, void *b, void *x );

HYPRE_Int
hypre_StructKrylovIdentitySetup_flt( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_StructKrylovIdentitySetup_dbl( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_StructKrylovIdentitySetup_long_dbl( void *vdata, void *A, void *b, void *x );

HYPRE_Real
hypre_StructKrylovInnerProd_flt( void *x, void *y );
HYPRE_Real
hypre_StructKrylovInnerProd_dbl( void *x, void *y );
HYPRE_Real
hypre_StructKrylovInnerProd_long_dbl( void *x, void *y );

HYPRE_Int
hypre_StructKrylovInnerProdTagged_flt( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_float **iprod_ptr );
HYPRE_Int
hypre_StructKrylovInnerProdTagged_dbl( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_double **iprod_ptr );
HYPRE_Int
hypre_StructKrylovInnerProdTagged_long_dbl( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_long_double **iprod_ptr );

HYPRE_Int
hypre_StructKrylovMatvec_flt( void *matvec_data, hypre_float alpha, void *A, void *x, hypre_float beta, void *y );
HYPRE_Int
hypre_StructKrylovMatvec_dbl( void *matvec_data, hypre_double alpha, void *A, void *x, hypre_double beta, void *y );
HYPRE_Int
hypre_StructKrylovMatvec_long_dbl( void *matvec_data, hypre_long_double alpha, void *A, void *x, hypre_long_double beta, void *y );

void *
hypre_StructKrylovMatvecCreate_flt( void *A, void *x );
void *
hypre_StructKrylovMatvecCreate_dbl( void *A, void *x );
void *
hypre_StructKrylovMatvecCreate_long_dbl( void *A, void *x );

HYPRE_Int
hypre_StructKrylovMatvecDestroy_flt( void *matvec_data );
HYPRE_Int
hypre_StructKrylovMatvecDestroy_dbl( void *matvec_data );
HYPRE_Int
hypre_StructKrylovMatvecDestroy_long_dbl( void *matvec_data );

HYPRE_Int
hypre_StructKrylovScaleVector_flt( hypre_float alpha, void *x );
HYPRE_Int
hypre_StructKrylovScaleVector_dbl( hypre_double alpha, void *x );
HYPRE_Int
hypre_StructKrylovScaleVector_long_dbl( hypre_long_double alpha, void *x );

HYPRE_Int
hypre_StructKrylovSetRandomValues_flt( void *x, HYPRE_Int seed );
HYPRE_Int
hypre_StructKrylovSetRandomValues_dbl( void *x, HYPRE_Int seed );
HYPRE_Int
hypre_StructKrylovSetRandomValues_long_dbl( void *x, HYPRE_Int seed );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

