/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.symboltable.ClassScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouplingBetweenObjects
extends AbstractRule {
    private int couplingCount;
    private Set<String> typesFoundSoFar;
    private static final PropertyDescriptor thresholdDescriptor = new IntegerProperty("threshold", "Coupling threshold value", 2, 1.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = CouplingBetweenObjects.asFixedMap(thresholdDescriptor);

    @Override
    public Object visit(ASTCompilationUnit cu, Object data) {
        this.typesFoundSoFar = new HashSet<String>();
        this.couplingCount = 0;
        Object returnObj = cu.childrenAccept(this, data);
        if (this.couplingCount > this.getIntProperty(thresholdDescriptor)) {
            this.addViolation(data, cu, "A value of " + this.couplingCount + " may denote a high amount of coupling within the class");
        }
        return returnObj;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTResultType node, Object data) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            SimpleNode classOrIntType;
            SimpleNode reftypeNode;
            SimpleNode tNode = (SimpleNode)node.jjtGetChild(x);
            if (!(tNode instanceof ASTType) || !((reftypeNode = (SimpleNode)tNode.jjtGetChild(0)) instanceof ASTReferenceType) || !((classOrIntType = (SimpleNode)reftypeNode.jjtGetChild(0)) instanceof ASTClassOrInterfaceType)) continue;
            SimpleNode nameNode = classOrIntType;
            this.checkVariableType(nameNode, nameNode.getImage());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFormalParameter node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            SimpleNode firstStmt = (SimpleNode)node.jjtGetChild(x);
            if (!(firstStmt instanceof ASTType)) continue;
            ASTType tp = (ASTType)firstStmt;
            SimpleNode nd = (SimpleNode)tp.jjtGetChild(0);
            this.checkVariableType(nd, nd.getImage());
        }
        return super.visit(node, data);
    }

    private void handleASTTypeChildren(SimpleNode node) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            SimpleNode sNode = (SimpleNode)node.jjtGetChild(x);
            if (!(sNode instanceof ASTType)) continue;
            SimpleNode nameNode = (SimpleNode)sNode.jjtGetChild(0);
            this.checkVariableType(nameNode, nameNode.getImage());
        }
    }

    private void checkVariableType(SimpleNode nameNode, String variableType) {
        if (nameNode.getParentsOfType(ASTClassOrInterfaceDeclaration.class).isEmpty()) {
            return;
        }
        ClassScope clzScope = nameNode.getScope().getEnclosingClassScope();
        if (!(clzScope.getClassName().equals(variableType) || this.filterTypes(variableType) || this.typesFoundSoFar.contains(variableType))) {
            ++this.couplingCount;
            this.typesFoundSoFar.add(variableType);
        }
    }

    private boolean filterTypes(String variableType) {
        return variableType != null && (variableType.startsWith("java.lang.") || variableType.equals("String") || this.filterPrimitivesAndWrappers(variableType));
    }

    private boolean filterPrimitivesAndWrappers(String variableType) {
        return variableType.equals("int") || variableType.equals("Integer") || variableType.equals("char") || variableType.equals("Character") || variableType.equalsIgnoreCase("double") || variableType.equalsIgnoreCase("long") || variableType.equalsIgnoreCase("short") || variableType.equalsIgnoreCase("float") || variableType.equalsIgnoreCase("byte") || variableType.equalsIgnoreCase("boolean");
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

