# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-firefox-view =
    .label = { -firefoxview-brand-name }
    .tooltiptext = { -firefoxview-brand-name }
toolbar-button-firefox-view-2 =
    .label = { -firefoxview-brand-name }
    .tooltiptext = Bekijk uw recente navigatie van vensters en apparaten
menu-tools-firefox-view =
    .label = { -firefoxview-brand-name }
    .accesskey = F
firefoxview-page-title = { -firefoxview-brand-name }
firefoxview-page-heading =
    .heading = { -firefoxview-brand-name }
firefoxview-page-label =
    .label = { -firefoxview-brand-name }
firefoxview-close-button =
    .title = Sluiten
    .aria-label = Sluiten
# Used instead of the localized relative time when a timestamp is within a minute or so of now
firefoxview-just-now-timestamp = Zojuist
# This is a headline for an area in the product where users can resume and re-open tabs they have previously viewed on other devices.
firefoxview-tabpickup-header = Tabbladen ophalen
firefoxview-tabpickup-description = Open pagina’s van andere apparaten.
# Variables:
#  $percentValue (Number): the percentage value for setup completion
firefoxview-tabpickup-progress-label = { $percentValue }% voltooid
firefoxview-tabpickup-step-signin-header = Schakel naadloos tussen apparaten
firefoxview-tabpickup-step-signin-description = Meld u eerst aan of maak een account aan om hier de tabbladen van uw telefoon op te halen.
firefoxview-tabpickup-step-signin-primarybutton = Doorgaan
firefoxview-syncedtabs-signin-header-2 = Uw { -brand-product-name } op al uw apparaten
firefoxview-syncedtabs-signin-description-2 = Meld u aan of registreer u voor een account om op uw telefoon en andere apparaten geopende tabbladen te zien. Met een account kunt u ook uw wachtwoorden, geschiedenis en meer synchroniseren.
firefoxview-syncedtabs-signin-primarybutton-2 = Aanmelden
firefoxview-tabpickup-adddevice-header = { -brand-product-name } op uw telefoon of tablet synchroniseren
firefoxview-tabpickup-adddevice-description = Download { -brand-product-name } voor mobiel en meld u daar aan.
firefoxview-tabpickup-adddevice-learn-how = Meer info
firefoxview-tabpickup-adddevice-primarybutton = { -brand-product-name } voor mobiel downloaden
firefoxview-syncedtabs-adddevice-header-2 = Pak overal tabbladen
firefoxview-syncedtabs-adddevice-description-2 = Meld u aan bij { -brand-product-name } op uw telefoon of een andere computer om hier tabbladen te bekijken. Lees hoe u <a data-l10n-name="url">extra apparaten kunt verbinden</a>.
firefoxview-syncedtabs-adddevice-primarybutton = { -brand-product-name } voor mobiel proberen
firefoxview-tabpickup-synctabs-header = Tabbladsynchronisatie inschakelen
firefoxview-tabpickup-synctabs-description = { -brand-short-name } toestaan om tabbladen tussen apparaten te delen.
firefoxview-tabpickup-synctabs-learn-how = Meer info
firefoxview-tabpickup-synctabs-primarybutton = Open tabbladen synchroniseren
firefoxview-syncedtabs-synctabs-header = Werk uw synchronisatie-instellingen bij
firefoxview-syncedtabs-synctabs-description = Om tabbladen van andere apparaten te zien, moet u uw open tabbladen synchroniseren.
firefoxview-syncedtabs-loading-header = Synchroniseren
firefoxview-syncedtabs-loading-description = Als dit is afgerond, ziet u alle tabbladen die u op andere apparaten hebt geopend. Kom snel terug.
firefoxview-tabpickup-fxa-admin-disabled-header = Uw organisatie heeft synchronisatie uitgeschakeld
firefoxview-tabpickup-fxa-admin-disabled-description = { -brand-short-name } kan geen tabbladen synchroniseren tussen apparaten, omdat uw beheerder synchronisatie heeft uitgeschakeld.
firefoxview-tabpickup-fxa-disabled-by-policy-description = { -brand-short-name } kan geen tabbladen synchroniseren tussen apparaten, omdat uw organisatie synchronisatie heeft uitgeschakeld.
firefoxview-tabpickup-network-offline-header = Controleer uw internetverbinding
firefoxview-tabpickup-network-offline-description = Als u een firewall of proxy gebruikt, controleer dan of { -brand-short-name } toestemming heeft voor toegang tot internet.
firefoxview-tabpickup-network-offline-primarybutton = Opnieuw proberen
firefoxview-tabpickup-sync-error-header = We hebben problemen met synchroniseren
firefoxview-tabpickup-generic-sync-error-description = { -brand-short-name } kan de synchronisatieservice momenteel niet bereiken. Probeer het over enkele ogenblikken opnieuw.
firefoxview-tabpickup-sync-error-primarybutton = Opnieuw proberen
firefoxview-tabpickup-sync-disconnected-header = Schakel synchronisatie in om door te gaan
firefoxview-tabpickup-sync-disconnected-description = Om uw tabbladen te halen, moet u synchronisatie in { -brand-short-name } toestaan.
firefoxview-tabpickup-sync-disconnected-primarybutton = Synchronisatie inschakelen in instellingen
firefoxview-tabpickup-password-locked-header = Voer uw hoofdwachtwoord in om tabbladen te bekijken
firefoxview-tabpickup-password-locked-description = Om uw tabbladen op te halen, moet u uw hoofdwachtwoord voor { -brand-short-name } ingeven.
firefoxview-tabpickup-password-locked-link = Meer info
firefoxview-tabpickup-password-locked-primarybutton = Hoofdwachtwoord invoeren
firefoxview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">Meer info</a>
firefoxview-tabpickup-signed-out-header = Aanmelden om opnieuw te verbinden
firefoxview-tabpickup-signed-out-description = Meld u aan bij uw { -fxaccount-brand-name } om opnieuw te verbinden en uw tabbladen op te halen.
firefoxview-tabpickup-signed-out-description2 = Meld u aan bij uw account om opnieuw te verbinden en uw tabbladen op te halen.
firefoxview-tabpickup-signed-out-primarybutton = Aanmelden
firefoxview-tabpickup-syncing = Een ogenblik, uw tabbladen worden gesynchroniseerd.
firefoxview-mobile-promo-header = Haal tabbladen op van uw telefoon of tablet
firefoxview-mobile-promo-description = Meld u aan bij { -brand-product-name } in iOS of Android om uw laatste mobiele tabbladen te bekijken.
firefoxview-mobile-promo-primarybutton = { -brand-product-name } voor mobiel downloaden
firefoxview-mobile-confirmation-header = 🎉 U kunt van start!
firefoxview-mobile-confirmation-description = U kunt nu uw { -brand-product-name }-tabbladen van uw tablet of telefoon ophalen.
firefoxview-closed-tabs-title = Onlangs gesloten
firefoxview-closed-tabs-description2 = Open pagina’s die u in dit venster hebt gesloten opnieuw.
firefoxview-closed-tabs-placeholder-header = Geen onlangs gesloten tabbladen
firefoxview-closed-tabs-placeholder-body = Wanneer u een tabblad in dit venster sluit, kunt u het hier ophalen.
# Variables:
#   $tabTitle (string) - Title of tab being dismissed
firefoxview-closed-tabs-dismiss-tab =
    .title = { $tabTitle } sluiten
# refers to the last tab that was used
firefoxview-pickup-tabs-badge = Laatst actief
# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
firefoxview-tabs-list-tab-button =
    .title = { $targetURI } openen in een nieuw tabblad
firefoxview-try-colorways-button = Kleurstellingen proberen
firefoxview-change-colorway-button = Kleurstelling wijzigen
# Variables:
#  $intensity (String): Colorway intensity
#  $collection (String): Colorway Collection name
firefoxview-colorway-description = { $intensity } · { $collection }
firefoxview-synced-tabs-placeholder-header = Nog niets te zien
firefoxview-synced-tabs-placeholder-body = De volgende keer dat u op een ander apparaat een pagina opent in { -brand-product-name }, kunt u deze hier als bij toverslag pakken.
firefoxview-collapse-button-show =
    .title = Lijst tonen
firefoxview-collapse-button-hide =
    .title = Lijst verbergen
firefoxview-overview-nav = Onlangs bekeken
    .title = Onlangs bekeken
firefoxview-overview-header = Onlangs bekeken
    .title = Onlangs bekeken

## History in this context refers to browser history

firefoxview-history-nav = Geschiedenis
    .title = Geschiedenis
firefoxview-history-header = Geschiedenis
firefoxview-history-context-delete = Verwijderen uit geschiedenis
    .accesskey = V

## Open Tabs in this context refers to all open tabs in the browser

firefoxview-opentabs-nav = Open tabbladen
    .title = Open tabbladen
firefoxview-opentabs-header = Open tabbladen

## Recently closed tabs in this context refers to recently closed tabs from all windows

firefoxview-recently-closed-nav = Onlangs gesloten tabbladen
    .title = Onlangs gesloten tabbladen
firefoxview-recently-closed-header = Onlangs gesloten tabbladen

## Tabs from other devices refers in this context refers to synced tabs from other devices

firefoxview-synced-tabs-nav = Tabbladen van andere apparaten
    .title = Tabbladen van andere apparaten
firefoxview-synced-tabs-header = Tabbladen van andere apparaten

## Chats in this context refers to chats saved from the AI Window Assistant

firefoxview-chats-nav = Chats
    .title = Chats
firefoxview-chats-header = Chats
firefoxview-chat-context-delete = Verwijderen uit chats
    .accesskey = w

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of Firefox View
firefoxview-view-all-link = Alles bekijken
# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
firefoxview-opentabs-window-header =
    .title = Venster { $winID }
# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
firefoxview-opentabs-current-window-header =
    .title = Venster { $winID } (huidige)
firefoxview-show-more = Meer tonen
firefoxview-show-less = Minder tonen
firefoxview-show-all = Alles tonen
firefoxview-search-text-box-clear-button =
    .title = Wissen
# Placeholder for the input field to search in recent browsing ("search" is a verb).
firefoxview-search-text-box-recentbrowsing =
    .placeholder = Zoeken
# Placeholder for the input field to search in history ("search" is a verb).
firefoxview-search-text-box-history =
    .placeholder = Geschiedenis doorzoeken
# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
firefoxview-search-text-box-recentlyclosed =
    .placeholder = Onlangs gesloten tabbladen doorzoeken
# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
firefoxview-search-text-box-tabs =
    .placeholder = Tabbladen doorzoeken
# Placeholder for the input field to search in open tabs ("search" is a verb).
firefoxview-search-text-box-opentabs =
    .placeholder = Open tabbladen doorzoeken
# Placeholder for the input field to search in open tabs ("search" is a verb).
firefoxview-search-text-box-chats =
    .placeholder = Chats doorzoeken
# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
firefoxview-search-results-header = Zoekresultaten voor ‘{ $query }’
# Variables:
#   $count (Number) - The number of visits matching the search query.
firefoxview-search-results-count =
    { $count ->
        [one] { $count } website
       *[other] { $count } websites
    }
# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
firefoxview-search-results-empty = Geen resultaten voor ‘{ $query }’
firefoxview-sort-history-by-date-label = Sorteren op datum
firefoxview-sort-history-by-site-label = Sorteren op website
firefoxview-sort-open-tabs-by-recency-label = Sorteren op recente activiteit
firefoxview-sort-open-tabs-by-order-label = Sorteren op tabbladvolgorde

## Variables:
##   $date (string) - Date to be formatted based on locale

firefoxview-history-date-today = Vandaag – { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-yesterday = Gisteren – { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }
# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
firefoxview-history-site-localhost = (lokale bestanden)
firefoxview-chat-date-today = Vandaag – { DATETIME($date, dateStyle: "full") }
firefoxview-chat-date-yesterday = Gisteren – { DATETIME($date, dateStyle: "full") }
firefoxview-chat-date-this-month = { DATETIME($date, dateStyle: "full") }
firefoxview-chat-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }

##

firefoxview-show-all-history = Alle geschiedenis tonen

## Message displayed in Firefox View when the user has no history data

firefoxview-history-empty-header = Terug naar waar u was
firefoxview-history-empty-description = Terwijl u surft, worden de pagina’s die u bezoekt hier weergegeven.
firefoxview-history-empty-description-two = Het beschermen van uw privacy staat centraal in wat we doen. Daarom kunt u de activiteit die { -brand-short-name } onthoudt, beheren in uw <a data-l10n-name="history-settings-url">geschiedenisinstellingen</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
firefoxview-choose-browser-button = Kies browser
    .title = Kies browser

## Message displayed in Firefox View when the user has chosen to never remember History

firefoxview-dont-remember-history-empty-header-2 = U hebt controle over wat { -brand-short-name } onthoudt
firefoxview-dont-remember-history-empty-description-one = Op dit moment onthoudt { -brand-short-name } uw surfactiviteit niet. <a data-l10n-name="history-settings-url-two">Werk uw geschiedenisinstellingen bij</a> om dat te wijzigen.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in Firefox View
firefoxview-import-history-close-button =
    .aria-label = Sluiten
    .title = Sluiten

## Text displayed in a dismissable banner to import bookmarks/history from another browser

firefoxview-import-history-header = Geschiedenis importeren vanuit een andere browser
firefoxview-import-history-description = Maak van { -brand-short-name } uw favoriete browser. Importeer navigatiegeschiedenis, bladwijzers en meer.

## Message displayed in Firefox View when the user has no recently closed tabs data

firefoxview-recentlyclosed-empty-header = Te vroeg een tabblad gesloten?
firefoxview-recentlyclosed-empty-description = Hier vindt u de tabbladen die u onlangs hebt gesloten, zodat u ze snel weer kunt openen.
firefoxview-recentlyclosed-empty-description-two = Bekijk uw <a data-l10n-name="history-url">navigatiegeschiedenis</a> om tabbladen van langer geleden te vinden.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

firefoxview-syncedtabs-device-notabs = Er zijn geen tabbladen geopend op dit apparaat
firefoxview-syncedtabs-connect-another-device = Een ander apparaat verbinden
firefoxview-pinned-tabs =
    .title = Vastgemaakte tabbladen
firefoxview-tabs =
    .title = Tabbladen

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

firefoxview-opentabs-pinned-tab =
    .title = Wisselen naar { $tabTitle }
# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-pinned-tab =
    .title = Wisselen naar (Bladwijzer) { $tabTitle }

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-tab =
    .title = (Bladwijzer) { $url }
