//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/HardParticle/HardParticles.h
//! @brief     Includes all particle-shape form-factor definitions.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif

#ifndef USER_API
#ifndef BORNAGAIN_SAMPLE_HARDPARTICLE_HARDPARTICLES_H
#define BORNAGAIN_SAMPLE_HARDPARTICLE_HARDPARTICLES_H

#include "Sample/HardParticle/FormFactorAnisoPyramid.h"
#include "Sample/HardParticle/FormFactorBar.h"
#include "Sample/HardParticle/FormFactorBox.h"
#include "Sample/HardParticle/FormFactorCantellatedCube.h"
#include "Sample/HardParticle/FormFactorCone.h"
#include "Sample/HardParticle/FormFactorCone6.h"
#include "Sample/HardParticle/FormFactorCosineRipple.h"
#include "Sample/HardParticle/FormFactorCuboctahedron.h"
#include "Sample/HardParticle/FormFactorCylinder.h"
#include "Sample/HardParticle/FormFactorDodecahedron.h"
#include "Sample/HardParticle/FormFactorDot.h"
#include "Sample/HardParticle/FormFactorEllipsoidalCylinder.h"
#include "Sample/HardParticle/FormFactorFullSpheroid.h"
#include "Sample/HardParticle/FormFactorHemiEllipsoid.h"
#include "Sample/HardParticle/FormFactorHollowSphere.h"
#include "Sample/HardParticle/FormFactorIcosahedron.h"
#include "Sample/HardParticle/FormFactorLongBoxGauss.h"
#include "Sample/HardParticle/FormFactorLongBoxLorentz.h"
#include "Sample/HardParticle/FormFactorPrism3.h"
#include "Sample/HardParticle/FormFactorPrism6.h"
#include "Sample/HardParticle/FormFactorPyramid.h"
#include "Sample/HardParticle/FormFactorSawtoothRipple.h"
#include "Sample/HardParticle/FormFactorTetrahedron.h"
#include "Sample/HardParticle/FormFactorTruncatedCube.h"
#include "Sample/HardParticle/FormFactorTruncatedSphere.h"
#include "Sample/HardParticle/FormFactorTruncatedSpheroid.h"

#endif // BORNAGAIN_SAMPLE_HARDPARTICLE_HARDPARTICLES_H
#endif // USER_API
