//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _r2root_3.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root3(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[3] = {4.157761428884650e-01,2.294289112607765e+00,6.289969078481845e+00};
  constexpr double aw[3] = {3.555478612975036e-01,1.392593980080030e-01,5.194648064954447e-03};
  constexpr double x[1581] = {  1.333193785481400e-01,  1.024188639094186e-02,  5.431298990068923e-04,  2.249201605887059e-05,  6.850432718250695e-07,
  9.355887612572497e-09, -5.327864432448729e-10, -4.830469613796645e-11, -2.016116740493461e-12, -4.443689564743550e-14,  4.896458076066169e-16,  1.038395244921571e-16,
  9.509945329775856e-01,  3.838562921326436e-02,  4.870372628813179e-05, -3.764652912285678e-05, -6.746330023569673e-08,  6.766313339813510e-08,  2.141016721466713e-10,
 -1.332860264344839e-10, -5.414554859775406e-13,  2.598111841081563e-13,  1.162321614891007e-15, -5.203344808143994e-16,  1.769835207445001e+00,  1.477117416176882e-02,
 -6.278645631082409e-04,  1.889919706852138e-05, -2.813490046482401e-07, -9.449657383711922e-09,  9.783759983661697e-10, -3.828804618972080e-11,  4.257305610732022e-13,
  3.301482003197009e-14, -2.231842273969794e-15,  7.154491465018248e-17,  1.849590334667911e-01,  1.585971039301192e-02,  8.811163058252435e-04,  3.364871001520298e-05,
  5.922950678783054e-07, -2.796836804470653e-08, -2.921959914102134e-09, -1.198207792669321e-10, -1.247383477302706e-12,  1.695082847029293e-13,  1.285527481503469e-14,
  4.285046083527875e-16,  1.102559731335305e+00,  3.704846556729020e-02, -3.672890156832329e-04, -2.881934934848957e-05,  1.059220256258327e-06,  3.398289297954315e-08,
 -2.528543667034459e-09, -3.165534951905001e-11,  5.074446776261777e-12, -2.271959899182463e-14, -9.440492928465530e-15,  2.013934905129403e-16,  1.820191842784675e+00,
  1.057115378124861e-02, -4.310964871737910e-04,  1.383379281831088e-05, -3.115479372357047e-07,  3.325717770324872e-09,  1.844556390509596e-10, -1.757513174851037e-11,
  6.316736551325577e-13, -8.558249547565777e-15, -2.526889269175963e-16,  1.989931919566855e-17,  2.651863864485945e-01,  2.461199936266977e-02,  1.307887544980986e-03,
  3.373176424601201e-05, -9.240538010337174e-07, -1.329309126568008e-07, -5.046875878314367e-09,  6.220496396735879e-11,  1.645594408473518e-11,  7.471332621573043e-13,
 -1.521505869162905e-15, -2.029544352614927e-15,  1.243134212294897e+00,  3.304490988265996e-02, -5.997807099236630e-04, -9.733647910904449e-06,  1.144277450151238e-06,
 -2.174684098351556e-08, -1.639609235148169e-09,  7.039248085818290e-11,  7.100047363276916e-13, -1.249740277961729e-13,  3.837055260328225e-15,  1.640393091342800e-16,
  1.856518450655926e+00,  7.707602945387589e-03, -2.923925041883434e-04,  9.491399036126998e-06, -2.301696719298990e-07,  3.811318212419469e-09, -7.709388648653454e-11,
 -2.947994234246381e-12,  2.919311175448654e-13, -7.381751663303067e-15,  2.020554875930085e-16,  3.332990073670124e-18,  3.864590049338013e-01,  3.620632953394322e-02,
  1.519704969898362e-03, -6.970908830966717e-06, -4.259797916125154e-06, -1.550475752942908e-07,  6.628972741182256e-09,  7.588687049479389e-10,  1.072486519101846e-11,
 -1.950536483541787e-12, -1.155834896581691e-13,  1.320883388976073e-15,  1.365360032878788e+00,  2.804711267165690e-02, -6.261623840261009e-04,  3.632282652819154e-06,
  4.755622088003715e-07, -3.780907107116287e-08,  2.178256344119131e-10,  5.515041117926990e-11, -7.403333242445299e-13,  1.811349139845210e-14,  2.218072081782005e-16,
 -2.459005218807389e-16,  1.883310269800041e+00,  5.766512583271932e-03, -1.984388680714209e-04,  6.306309717545589e-06, -1.745105116067631e-07,  1.837146261624413e-09,
 -5.773645728207359e-11,  3.631607398002577e-12,  1.511249663480768e-13, -2.726202565983623e-15, -1.446008563228996e-16, -1.892956930117162e-17,  5.532369152763200e-01,
  4.672622479923151e-02,  9.718849894315872e-04, -8.444284752206723e-05, -4.209713218452029e-06,  2.110139773397434e-07,  1.831566211096961e-08, -4.218131922852809e-10,
 -7.335187933662842e-11,  1.493844931282473e-13,  2.667565921905312e-13,  4.577388296389592e-15,  1.467918076219386e+00,  2.328832019845791e-02, -5.596258541181355e-04,
  5.957051242517479e-06, -1.159294556739342e-07, -1.655755644919225e-08,  1.428034952753487e-09,  2.503260461216286e-11, -2.016661107998112e-12, -1.108553596265697e-13,
 -2.022263180750887e-15,  3.727129778546932e-16,  1.903616880942189e+00,  4.436746440205621e-03, -1.384333013010984e-04,  3.775340563701322e-06, -1.412172858626884e-07,
  2.049972339214478e-09,  8.043460300438698e-11,  4.399918392851311e-12, -2.008639792856198e-13, -1.729741843190329e-14, -1.057076232578474e-16,  4.422905314474391e-17,
  7.482315229037195e-01,  4.974199918398278e-02, -2.498218913087082e-04, -1.021759579880587e-04,  2.355874499588444e-06,  3.170607267396897e-07, -1.251681616172528e-08,
 -1.015441330081315e-09,  5.742423241971578e-11,  3.167790212919848e-12, -2.443902664718454e-13, -9.419335368121727e-15,  1.552508243434707e+00,  1.905314103261051e-02,
 -5.039302497646925e-04,  3.377503996275789e-06, -9.967974159703656e-08,  1.561274330296033e-08,  7.563058937848035e-10, -7.693614580134828e-11, -2.347518022393275e-12,
  2.018289771536737e-13,  1.115669559621773e-14, -4.903073419241241e-16,  1.919386761203379e+00,  3.476013561558061e-03, -1.049252952609085e-04,  1.970817062804938e-06,
 -7.686533920946632e-08,  4.243862201597273e-09,  4.152171243228620e-11, -8.086088064715167e-12, -3.277618252089968e-13,  2.230031244846408e-14,  1.375258353492787e-15,
 -5.029459104282729e-17,  9.368059374460680e-01,  4.382533076089951e-02, -1.109304277921672e-03, -3.537219614749821e-05,  4.645784172682843e-06, -8.347478294473788e-08,
 -1.214821375795784e-08,  7.573816307344862e-10,  1.298443348539193e-11, -3.089456162711149e-12,  6.809187321122485e-14,  8.195579420815068e-15,  1.620910942450816e+00,
  1.518294709823546e-02, -4.616133872118816e-04,  4.485813367999257e-06,  2.104220734337418e-07,  7.633292025800099e-09, -1.122070586719477e-09, -1.650179824427498e-11,
  4.619729771022017e-12, -2.297968053264176e-14, -1.555725806233806e-14,  2.918318704631456e-16,  1.931740703071243e+00,  2.716677675446707e-03, -8.591403596604470e-05,
  1.387775579580469e-06, -2.487814198697717e-09,  2.291122534452085e-09, -1.758597232411839e-10, -2.320951456486937e-12,  5.539766640163142e-13,  1.958713797199395e-15,
 -1.849249683216681e-15,  1.413074891704823e-17,  1.093200476724465e+00,  3.432234798033252e-02, -1.174783505126823e-03,  1.677089964071642e-05,  1.686193760687396e-06,
 -1.481070134540907e-07,  3.892532316437324e-09,  2.084106035479226e-10, -2.301444161697376e-11,  6.567619024894952e-13,  3.163338620028270e-14, -3.640853606500193e-15,
  1.674682302581551e+00,  1.176499122540169e-02, -3.870806603663608e-04,  7.710952530810210e-06,  1.274461249040889e-07, -1.203708240958687e-08, -2.156172827338757e-10,
  4.795724339317420e-11, -1.059072929381918e-12, -1.157893783975055e-13,  7.918209256551821e-15,  5.903087316087380e-17,  1.941340047754976e+00,  2.097320692006239e-03,
 -6.871081006599997e-05,  1.495727382103000e-06,  4.943318577981328e-09, -1.050828914021808e-09, -5.885646645020633e-11,  6.888581036780102e-12, -9.070727966452451e-14,
 -1.723067176122151e-14,  8.607206208454671e-16,  2.237404919338074e-17,  1.213366208118268e+00,  2.600044810823440e-02, -8.904606869425300e-04,  2.593179503711024e-05,
 -1.942958854371764e-07, -4.322325742065967e-08,  3.386860313290623e-09, -1.199458649978938e-10, -3.356591670304409e-13,  3.039372433259915e-13, -1.821134015134917e-14,
  4.220895608542270e-16,  1.716159828328158e+00,  9.054892270139697e-03, -2.901544562484912e-04,  7.901597923071675e-06, -8.498349208520879e-08, -6.779936176476794e-09,
  4.117806262087044e-10, -1.623421377074104e-12, -1.002598263101684e-12,  5.596459954490801e-14, -2.785797221902487e-16, -1.324607209561301e-16,  1.948743144338283e+00,
  1.618961361253920e-03, -5.107583174821536e-05,  1.384691692623239e-06, -1.781185023677137e-08, -8.077040361145509e-10,  4.756412077767781e-11,  4.726272414745669e-13,
 -1.603432637389587e-13,  6.962360933125190e-15,  6.336615216260346e-17, -2.084498303005961e-17,  1.304959719615892e+00,  2.002619689986084e-02, -6.151275784662780e-04,
  1.924806241073063e-05, -4.964337419133860e-07,  2.621234428534114e-09,  7.521207538333748e-10, -5.648631054916921e-11,  2.304600877363176e-12, -4.285413052649905e-14,
 -1.538212507267089e-15,  1.755076833812711e-16,  1.748295301782178e+00,  7.082735466898690e-03, -2.063807653409452e-04,  5.934922417602705e-06, -1.371506773093734e-07,
  5.400947787456904e-10,  1.662477783486514e-10, -9.580389485650758e-12,  1.969475363666815e-13,  8.596629691631989e-15, -9.046758839154010e-16,  3.461328661456145e-17,
  1.954499050874019e+00,  1.271140396043341e-03, -3.650814770010531e-05,  1.029435263266201e-06, -2.353316136879103e-08,  1.306496549919342e-10,  2.320078194892192e-11,
 -1.261627096935050e-12,  1.694974144857382e-14,  1.789531425164220e-15, -1.377815613717183e-16,  4.064993867974481e-18,  1.376505355483829e+00,  1.590227879700704e-02,
 -4.280538555074381e-04,  1.229727687475159e-05, -3.552483804921079e-07,  8.443530185288414e-09, -5.389414825517528e-11, -9.665789632300645e-12,  7.207199795033950e-13,
 -3.105941835200223e-14,  8.524045957680779e-16, -6.864268636774411e-18,  1.773724913940189e+00,  5.681095982052154e-03, -1.474837531079926e-04,  3.967073919938371e-06,
 -1.039744514656547e-07,  2.126440159437381e-09, -1.664324162847195e-12, -2.733300390166873e-12,  1.573701764711127e-13, -4.703864011806166e-15,  1.684188889720350e-17,
  6.683157333447550e-18,  1.959069126478279e+00,  1.022428776006025e-03, -2.625900123198791e-05,  6.936122910791296e-07, -1.775459121356166e-08,  3.549576186388115e-10,
 -4.364017975145214e-13, -4.138180714858047e-13,  2.256150561175326e-14, -5.801030280460061e-16, -4.794699304099301e-18,  1.249023955360009e-18,  1.434079755821566e+00,
  1.298356148588571e-02, -3.094083842608932e-04,  7.837767497440374e-06, -2.113629610643357e-07,  5.688417314621144e-09, -1.281550705116485e-10,  1.139300019612271e-12,
  9.522987612221212e-14, -7.378708016897560e-15,  3.239626984682154e-16, -1.003733881741612e-17,  1.794355257113326e+00,  4.666488335083916e-03, -1.085145773953896e-04,
  2.623879116270651e-06, -6.571969814132639e-08,  1.594438619805784e-09, -3.022682735453437e-11,  3.701794328517594e-14,  3.339506422793707e-14, -1.942147341881703e-15,
  6.693214840425409e-17, -1.258927477639997e-18,  1.962785283258280e+00,  8.413422935316682e-04, -1.941543250420548e-05,  4.630465635177029e-07, -1.135764750943133e-08,
  2.682433214778819e-10, -4.910481276633087e-12,  2.347030615203498e-15,  5.357522854000892e-15, -2.955318239739145e-16,  9.383307672401913e-18, -1.315853137365522e-19,
  1.481588091948298e+00,  1.083464755100591e-02, -2.323938142122204e-04,  5.213619093038808e-06, -1.247643273940746e-07,  3.165415727030733e-09, -7.990909850044898e-11,
  1.732477873984064e-12, -1.981408211901913e-14, -7.126533102066619e-16,  6.261450111744918e-17, -2.780334838201545e-18,  1.811462038184997e+00,  3.908617814956345e-03,
 -8.240775543319666e-05,  1.789915652755721e-06, -4.059298343464962e-08,  9.533355928352244e-10, -2.169062726015506e-11,  3.950938386242301e-13, -1.492662087302919e-15,
 -3.184511124920831e-16,  1.905384426872094e-17, -6.968205113942801e-19,  1.965871322260032e+00,  7.055230767138061e-04, -1.479223729441276e-05,  3.181077620983305e-07,
 -7.099164447827888e-09,  1.629915205736410e-10, -3.603098137149605e-12,  6.288025481706849e-14, -1.471116559075744e-16, -5.371630122644905e-17,  3.029622919287832e-18,
 -1.047814145508475e-19,  1.521562290230259e+00,  9.196025303319800e-03, -1.800145544871347e-04,  3.634686252268631e-06, -7.712846597406788e-08,  1.746899893555934e-09,
 -4.176279001775587e-11,  9.935568017861885e-13, -2.085216681162910e-14,  2.802634121767994e-16,  3.589662004061917e-18, -4.465320226347784e-19,  1.825900132142751e+00,
  3.325513676327572e-03, -6.427828146898504e-05,  1.268247080566216e-06, -2.589370504864207e-08,  5.535413186114362e-10, -1.225420296747838e-11,  2.639411069791568e-13,
 -4.712767483880719e-15,  3.225197832982824e-17,  2.407922119400333e-18, -1.544422659245123e-19,  1.968478480572327e+00,  6.007434743199625e-04, -1.156253272493879e-05,
  2.264741705522738e-07, -4.569370464340310e-09,  9.597327651143102e-11, -2.075528919279620e-12,  4.341325523353262e-14, -7.410000900225880e-16,  3.881084709250748e-18,
  4.290065815080095e-19, -2.543997881998903e-20,  1.555715883692319e+00,  7.911738216486171e-03, -1.428032564433214e-04,  2.633901521603156e-06, -5.030897860672289e-08,
  1.012643097558735e-09, -2.172696421151365e-11,  4.900447309999819e-13, -1.102077167672758e-14,  2.240888160890645e-16, -3.316341146832490e-18, -2.639289464438881e-21,
  1.838261170260779e+00,  2.865869053416191e-03, -5.122536995138337e-05,  9.287592232455316e-07, -1.724720641588042e-08,  3.325667557132189e-10, -6.725472605674652e-12,
  1.408841178891347e-13, -2.889839374147378e-15,  5.094786108047625e-17, -4.846362274557264e-19, -1.397623901034626e-20,  1.970712083803676e+00,  5.180012638658516e-04,
 -9.227908407911574e-06,  1.663810327054811e-07, -3.062578767038779e-09,  5.827320855345170e-11, -1.156874377557274e-12,  2.367614150900768e-14, -4.719701937648921e-16,
  7.968489807934534e-18, -6.404568097095123e-20, -2.703066677408050e-21,  1.585260664921406e+00,  6.883431096608958e-03, -1.154383187879728e-04,  1.966683695310856e-06,
 -3.433675336903794e-08,  6.225630313550530e-10, -1.190637580602455e-11,  2.421211662979449e-13, -5.157711815315505e-15,  1.098705936228349e-16, -2.161402988583984e-18,
  3.373797190520289e-20,  1.848969605311787e+00,  2.496409785797738e-03, -4.154164889273317e-05,  6.984180425939178e-07, -1.193781854238140e-08,  2.095867391054292e-10,
 -3.829977000731739e-12,  7.345697186188198e-14, -1.459959408765400e-15,  2.861602022590328e-17, -4.980464199305447e-19,  5.734040456483629e-21,  1.972648016915295e+00,
  4.514110444862102e-04, -7.491220948483478e-06,  1.253928043903486e-07, -2.128838768696801e-09,  3.700058095314200e-11, -6.665637167061612e-13,  1.254732942012854e-14,
 -2.438139373448700e-16,  4.651660882405034e-18, -7.783561794130467e-20,  7.996913030346633e-22,  1.611084791908740e+00,  6.045841418793363e-03, -9.476826202299575e-05,
  1.503390757321821e-06, -2.427672313299532e-08,  4.026384812678903e-10, -6.946254521006419e-12,  1.263506205844809e-13, -2.436313169535881e-15,  4.906789936324118e-17,
 -9.914463018909411e-19,  1.882793934025523e-20,  1.858339456679143e+00,  2.194642822951035e-03, -3.418280734709937e-05,  5.365678053364294e-07, -8.522382569457062e-09,
  1.378965436196546e-10, -2.296863699036676e-12,  3.987951429217160e-14, -7.267409067020641e-16,  1.372971047257628e-17, -2.575820008598004e-19,  4.410464540521598e-21,
  1.974342581626477e+00,  3.969722160140542e-04, -6.168978875509104e-06,  9.648765188665437e-08, -1.524317330345823e-09,  2.447237517917188e-11, -4.031537937570702e-13,
  6.896869769682010e-15, -1.233842020954856e-16,  2.281588673373128e-18, -4.175133660166422e-20,  6.905255411362486e-22,  1.633857540176184e+00,  5.353813365406979e-03,
 -7.881879210549027e-05,  1.171390294400671e-06, -1.764397510257867e-08,  2.709667801582533e-10, -4.280685228216298e-12,  7.038678165156404e-14, -1.218613973102364e-15,
  2.229205193700652e-17, -4.249194572727250e-19,  8.149760069595898e-21,  1.866608863535433e+00,  1.944809385709502e-03, -2.847989762421367e-05,  4.196156146436146e-07,
 -6.237126711645054e-09,  9.393758288305430e-11, -1.443719506234133e-12,  2.287694326598599e-14, -3.781220119024784e-16,  6.556271020565217e-18, -1.178910708677665e-19,
  2.117971924991543e-21,  1.975838559654639e+00,  3.518712569116989e-04, -5.142850678744659e-06,  7.554694303457035e-08, -1.118005978886442e-09,  1.673359068622165e-11,
 -2.549571005891607e-13,  3.993049502193513e-15, -6.501721503315116e-17,  1.107346513417309e-18, -1.951671081740444e-20,  3.427810784784633e-22,  1.654094444382027e+00,
  4.775069239598418e-03, -6.629351502935282e-05,  9.274586366300820e-07, -1.311237082522109e-08,  1.881133130657383e-10, -2.755022285080202e-12,  4.154287784866222e-14,
 -6.518736894266648e-16,  1.074895031917081e-17, -1.866634726799327e-19,  3.369994825493818e-21,  1.873962092499671e+00,  1.735546799851726e-03, -2.398683250892099e-05,
  3.331646855704805e-07, -4.659229154660494e-09,  6.579723788042509e-11, -9.426466493246425e-13,  1.379906330672108e-14, -2.084696710049327e-16,  3.285121684379686e-18,
 -5.425669263561505e-20,  9.292251328502261e-22,  1.977169102349430e+00,  3.140740552227355e-04, -4.333554087490029e-06,  6.003796599261563e-08, -8.365438638443758e-10,
  1.175328176695868e-11, -1.672107119504976e-13,  2.424968199479437e-15, -3.619459214123140e-17,  5.619386757282699e-19, -9.123684655745276e-21,  1.533888347602133e-22,
  1.672199826589480e+00,  4.285936966492056e-03, -5.630929382193636e-05,  7.445234887682123e-07, -9.927922598524609e-09,  1.339063737006473e-10, -1.834505369327189e-12,
  2.567864160351664e-14, -3.701949407627482e-16,  5.549199997903723e-18, -8.720627478690808e-20,  1.438336325097660e-21,  1.880544144283663e+00,  1.558469361625493e-03,
 -2.039636876569320e-05,  2.680344374319569e-07, -3.541704298459307e-09,  4.715243536507231e-11, -6.344699802017514e-13,  8.669634865593931e-15, -1.211594814933710e-16,
  1.748220196792569e-18, -2.629777458177155e-20,  4.139949194017163e-22,  1.978360325255856e+00,  2.820764591515391e-04, -3.686297951674915e-06,  4.833669451648086e-08,
 -6.367142793118194e-10,  8.440599167030882e-12, -1.129207924965926e-13,  1.531279295163685e-15, -2.119027088867259e-17,  3.020213991233695e-19, -4.477504365891732e-21,
  6.935870244265403e-23,  1.688495647359956e+00,  3.868688467602498e-03, -4.824684856886732e-05,  6.049320788815271e-07, -7.638050943399106e-09,  9.733088580967847e-11,
 -1.255491189657464e-12,  1.646132885902516e-14, -2.206259338553953e-16,  3.044998470942553e-18, -4.364294611292766e-20,  6.539607747957209e-22,  1.886470778619440e+00,
  1.407267397535446e-03, -1.749131048942521e-05,  2.181595420694659e-07, -2.733306980456202e-09,  3.445172278299666e-11, -4.378041593182359e-13,  5.627152099495558e-15,
 -7.350532450200330e-17,  9.825830125094638e-19, -1.356113563098849e-20,  1.948954380334501e-22,  1.979433095207671e+00,  2.547449908250621e-04, -3.162251598865954e-06,
  3.936583001985081e-08, -4.918877866995203e-10,  6.177328823607112e-12, -7.811963733080070e-14,  9.977381306335068e-16, -1.292760794799022e-17,  1.710602232138248e-19,
 -2.332033588054061e-21,  3.304619428369105e-23,  1.703241676016343e+00,  3.509810899313565e-03, -4.166158507127747e-05,  4.968025927990302e-07, -5.959149857753200e-09,
  7.202281362716474e-11, -8.790487205111602e-13,  1.086702419160164e-14, -1.366165196183946e-16,  1.755892247976044e-18, -2.322752986995636e-20,  3.185226107645061e-22,
  1.891835582448826e+00,  1.277114017572790e-03, -1.511476889541222e-05,  1.794171827762305e-07, -2.137830526386625e-09,  2.559866668783413e-11, -3.085166227223290e-13,
  3.750863278095682e-15, -4.615205662337278e-17,  5.774510609355147e-19, -7.395626894810153e-21,  9.773753545551814e-23,  1.980404293662944e+00,  2.312115160839681e-04,
 -2.733311730623548e-06,  3.239085454999164e-08, -3.850466355355008e-10,  4.596061342432000e-12, -5.516245293279278e-14,  6.670634200993540e-16, -8.152042142072569e-18,
  1.011332301119151e-19, -1.281890118347425e-21,  1.673616809884495e-23,  1.716649938474600e+00,  3.198846361754439e-03, -3.622794759621025e-05,  4.119288220846734e-07,
 -4.707345452132576e-09,  5.413557067358264e-11, -6.276099434640672e-13,  7.351394597548782e-15, -8.725546899435472e-17,  1.053462387979871e-18, -1.300135620334378e-20,
  1.649840123917763e-22,  1.896715065205576e+00,  1.164262863384156e-03, -1.315131164785119e-05,  1.489383085743825e-07, -1.692182022001039e-09,  1.930502830701622e-11,
 -2.214067540053822e-13,  2.556921690809086e-15, -2.980197757566692e-17,  3.517128032064497e-19, -4.222294125281317e-21,  5.187626777791757e-23,  1.981287729244483e+00,
  2.108015987633796e-04, -2.378769396262290e-06,  2.689940633218097e-08, -3.049907504493059e-10,  3.469860728284426e-12, -3.965251947651093e-14,  4.558249408549191e-16,
 -5.282076721010630e-18,  6.188944265439150e-20, -7.364769432153589e-22,  8.954618383865253e-24,  1.728895277917654e+00,  2.927592261297986e-03, -3.170344996957974e-05,
  3.445193076997732e-07, -3.760081416467167e-09,  4.125925950424279e-11, -4.558014826122239e-13,  5.078212704479791e-15, -5.718533856028134e-17,  6.527120573502959e-19,
 -7.578518160056911e-21,  8.990172997975379e-23,  1.901172401649278e+00,  1.065768716851791e-03, -1.151463317365645e-05,  1.246860286424389e-07, -1.353931187008334e-09,
  1.475326310705663e-11, -1.614697716893580e-13,  1.777217089200765e-15, -1.970434678799616e-17,  2.205753369715532e-19, -2.501024113298759e-21,  2.884731218708398e-23,
  1.982094809122767e+00,  1.929846160996252e-04, -2.083121933000068e-06,  2.252704548843414e-08, -2.441669885003876e-10,  2.654130349529950e-12, -2.895734015958241e-14,
  3.174470756262929e-16, -3.502020403451476e-18,  3.896085854374041e-20, -4.384531261594293e-22,  5.012047175493356e-24,  1.740123209454426e+00,  2.689537924504175e-03,
 -2.790475658050009e-05,  2.904100046911276e-07, -3.033754787884380e-09,  3.183931718151247e-11, -3.360745270495138e-13,  3.572643857297864e-15, -3.831504675271642e-17,
  4.154369190919324e-19, -4.566275615365908e-21,  5.104298627484282e-23,  1.905260226553423e+00,  9.792894476416077e-04, -1.013927978319786e-05,  1.051888200280068e-07,
 -1.093927371325772e-09,  1.141058611049948e-11, -1.194660535963272e-13,  1.256644940959573e-15, -1.329720854093368e-17,  1.417823858340051e-19, -1.526834912571558e-21,
  1.665595907355062e-23,  1.982835040958671e+00,  1.773383284825033e-04, -1.834600264845948e-06,  1.901008391370266e-08, -1.973745281683344e-10,  2.054337914025331e-12,
 -2.144872714120808e-14,  2.248257474216450e-16, -2.368636909061530e-18,  2.512073650386331e-20, -2.687697077590276e-22,  2.909314198201567e-24,  1.750455851659594e+00,
  2.479460078634821e-03, -2.469139531934653e-05,  2.465576620046855e-07, -2.470185228837602e-09,  2.484804880564620e-11, -2.511853944444354e-13,  2.554550046379798e-15,
 -2.617234462541972e-17,  2.705862540948455e-19, -2.828766818680187e-21,  2.997520331864861e-23,  1.909022751810012e+00,  9.029431125454359e-04, -8.974973878922124e-06,
  8.936704685247552e-08, -8.917673442941732e-10,  8.921878474413063e-12, -8.954625729857189e-14,  9.023055537214498e-16, -9.136934692769278e-18,  9.309882566194228e-20,
 -9.561326436433428e-22,  9.918582141167041e-24,  1.983516413543168e+00,  1.635232754353451e-04, -1.624156449793676e-06,  1.615481265528523e-08, -1.609665302983537e-10,
  1.607312093817187e-12, -1.609226703173080e-14,  1.616498479985854e-16, -1.630626292145148e-18,  1.653713734969153e-20, -1.688782648780743e-22,  1.740096479552378e-24,
  1.759996466734475e+00,  2.293127548666876e-03, -2.195443986499985e-05,  2.107055651254305e-07, -2.028168593163475e-09,  1.959156817927253e-11, -1.900607782486942e-13,
  1.853386132304494e-15, -1.818724586683663e-17,  1.798356462968734e-19, -1.794713995286022e-21,  1.811040505416858e-23,  1.912497391108116e+00,  8.352032220274210e-04,
 -7.982646663863427e-06,  7.641753434314048e-08, -7.329329545758667e-10,  7.045756373593081e-12, -6.791927828671653e-14,  6.569405171402958e-16, -6.380642616230838e-18,
  6.229323819093180e-20, -6.120877250345258e-22,  6.062671104624707e-24,  1.984145689154473e+00,  1.512639859614299e-04, -1.444754668622722e-06,  1.381697322865658e-08,
 -1.323441080633094e-10,  1.270022613801423e-12, -1.221559007923297e-14,  1.178272227463769e-16, -1.140524977424643e-18,  1.108874525900121e-20, -1.084155675732826e-22,
  1.067505289914028e-24,  1.768832978032070e+00,  2.127082487049354e-03, -1.960850413023068e-05,  1.811582123696410e-07, -1.678064522571557e-09,  1.559260476062927e-11,
 -1.454310465383006e-13,  1.362539958839941e-15, -1.283474483808838e-17,  1.216865583137719e-19, -1.162732873289158e-21,  1.121322828036142e-23,  1.915716021366775e+00,
  7.748208961900299e-04, -7.131618363383060e-06,  6.573522530020209e-08, -6.069395374178140e-10,  5.615268522660931e-12, -5.207724118416736e-14,  4.843903506003542e-16,
 -4.521537227806432e-18,  4.239005264539165e-20, -3.995442427228708e-22,  3.790563639608138e-24,  1.984728630714659e+00,  1.403349979571199e-04, -1.290866511925353e-06,
  1.188779395256928e-08, -1.096280162556857e-10,  1.012655313282923e-12, -9.372846624901946e-15,  8.696422795943947e-17, -8.093009042078266e-19,  7.559413085660463e-21,
 -7.093690707042482e-23,  6.694818555355857e-25,  1.777040725331773e+00,  1.978476144497361e-03, -1.758598941808220e-05,  1.566265399551395e-07, -1.398249413287746e-09,
  1.251741179209281e-11, -1.124301542746647e-13,  1.013823501373872e-15, -9.185005885146932e-18,  8.368022046523211e-20, -7.674564505418217e-22,  7.093793666367759e-24,
  1.918705972593854e+00,  7.207662683121003e-04, -6.397563823221839e-06,  5.685906122159420e-08, -5.061129995587143e-10,  4.513127347125951e-12, -4.033078639741355e-14,
  3.613313972186967e-16, -3.247196926876915e-18,  2.929031002312030e-20, -2.653989938044926e-22,  2.417870535083686e-24,  1.985270180151583e+00,  1.305503248874113e-04,
 -1.158106370421612e-06,  1.028432663894342e-08, -9.144128245140493e-11,  8.142337536851399e-13, -7.263098721508399e-15,  6.492585651921289e-17, -5.818795383287898e-19,
  5.231380377256857e-21, -4.721521404660871e-23,  4.281488284769842e-25,  1.784684644709048e+00,  1.844944098796079e-03, -1.583289128853794e-05,  1.361198140495202e-07,
 -1.172745625773402e-09,  1.012910566864173e-11, -8.774406205309664e-14,  7.627373347789788e-16, -6.657593391311816e-18,  5.839409807884514e-20, -5.151243655210103e-22,
  4.574662588753325e-24,  1.921490812220939e+00,  6.721838644614752e-04, -5.761024713444518e-06,  4.943400268114196e-08, -4.247671419854191e-10,  3.655759847444789e-12,
 -3.152322048416984e-14,  2.724342287777287e-16, -2.360788495040285e-18,  2.052322183561650e-20, -1.791055124024852e-22,  1.570224277450669e-24,  1.985774599802358e+00,
  1.217554285984953e-04, -1.042964496578401e-06,  8.942654786448031e-09, -7.676267964107794e-11,  6.597922357995780e-13, -5.679944968007868e-15,  4.898828544888411e-17,
 -4.234619068511634e-19,  3.670398431670992e-21, -3.191849533935328e-23,  2.786678045600577e-25,  1.791821009019445e+00,  1.724510419998165e-03, -1.430570367189268e-05,
  1.188689743834784e-07, -9.896088615989624e-10,  8.257263457283871e-12, -6.908022049192388e-14,  5.797143037676532e-16, -4.882586728218268e-18,  4.129858247110300e-20,
 -3.510666723868953e-22,  3.001604185661538e-24,  1.924090972161710e+00,  6.283582641917598e-04, -5.206307944495930e-06,  4.318399197856572e-08, -3.586410284124990e-10,
  2.982840238382040e-12, -2.485075262575638e-14,  2.074519865890098e-16, -1.735883408419559e-18,  1.456594402883054e-20, -1.226319935912673e-22,  1.036496572679747e-24,
  1.986245585514004e+00,  1.138210375791348e-04, -9.426091743864360e-07,  7.813052322982742e-09, -6.482634211969738e-11,  5.385162225458861e-13, -4.479747090838240e-15,
  3.732731269737486e-17, -3.116411198814748e-19,  2.607987037919896e-21, -2.188699817063989e-23,  1.842990808574204e-25,  1.798498829315210e+00,  1.615513319743784e-03,
 -1.296910607953089e-05,  1.042715320721715e-07, -8.398138029644933e-10,  6.777749613486592e-12, -5.483003782978290e-14,  4.447873566040725e-16, -3.619816895185444e-18,
  2.957017269254801e-20, -2.426191014884398e-22,  2.000706386118396e-24,  1.926524254280438e+00,  5.886874146395630e-04, -4.720660737211766e-06,  3.789245248338522e-08,
 -3.045084038207105e-10,  2.450301841910589e-12, -1.974720912413134e-14,  1.594292808731040e-16, -1.289850481554983e-18,  1.046115180883887e-20, -8.509061261219703e-23,
  6.944647109001766e-25,  1.986686357849628e+00,  1.066383402083135e-04, -8.547384526358338e-07,  6.856487991012607e-09, -5.505197524421503e-11,  4.424984560513103e-13,
 -3.561201988029493e-15,  2.870266816033427e-17, -2.317415860560779e-19,  1.874917824106425e-21, -1.520648928095492e-23,  1.236875483631808e-25, -2.003792803294707e+00,
  2.251597461952183e-03, -4.218475333954539e-04,  7.918252028303741e-05, -1.489121918150737e-05,  2.805930841415248e-06, -5.297716275843820e-07,  1.002271455259231e-07,
 -1.900145869717339e-08,  3.609905221943140e-09, -6.864546434479165e-10,  1.263639368726124e-10, -2.003625014519597e+00,  2.144124824982359e-03, -3.924167806488045e-04,
  7.197049290442256e-05, -1.322856586020955e-05,  2.437057276672274e-06, -4.500470938310714e-07,  8.331729777146369e-08, -1.546477604048303e-08,  2.878153585885752e-09,
 -5.365459307354032e-10,  9.700796998741182e-11, -2.003551361562663e+00,  2.097182033956008e-03, -3.798459682882025e-04,  6.895859697688889e-05, -1.254965742937563e-05,
  2.289773481309311e-06, -4.189154928619700e-07,  7.685831074097549e-08, -1.414306291303615e-08,  2.610518682710427e-09, -4.828637441672347e-10,  8.669688873835813e-11,
 -2.001746316384679e+00,  1.029314698707232e-03, -1.840949499306363e-04,  3.293902907272970e-05, -5.895986556900007e-06,  1.055797220614241e-06, -1.891404682200003e-07,
  3.389767384123395e-08, -6.077682380839265e-09,  1.090127150514558e-09, -1.954244236902150e-10,  3.398696049701103e-11, -2.001708597297555e+00,  1.005354988676948e-03,
 -1.777777653824271e-04,  3.145049491576558e-05, -5.566388904042609e-06,  9.856430522054813e-07, -1.746103280754581e-07,  3.094770570359480e-08, -5.487809688173446e-09,
  9.735840866158565e-10, -1.726482373860549e-10,  2.972272118010185e-11, -2.001691442985975e+00,  9.944839445871492e-04, -1.749425447506616e-04,  3.078972330171279e-05,
 -5.421680974493489e-06,  9.551798919182589e-07, -1.683699956363921e-07,  2.969462699394717e-08, -5.239980953916748e-09,  9.251529515489531e-10, -1.632855673873061e-10,
  2.798746445732535e-11, -2.000839888117472e+00,  4.934668826781909e-04, -8.639624597620039e-05,  1.512769804401841e-05, -2.649061872440831e-06,  4.639303686389642e-07,
 -8.125593899651922e-08,  1.423308985869846e-08, -2.493359209458323e-09,  4.368182724897606e-10, -7.646697110065517e-11,  1.300014109988641e-11, -2.000830919153926e+00,
  4.877910321636485e-04, -8.492563995926014e-05,  1.478728149618710e-05, -2.575032946223834e-06,  4.484588734691691e-07, -7.811029575123225e-08,  1.360630529110798e-08,
 -2.370383000011286e-09,  4.129833793631004e-10, -7.189807021848274e-11,  1.216021830249255e-11, -2.000826770836672e+00,  4.851688541880816e-04, -8.424987572137684e-05,
  1.463170131415993e-05, -2.541383246969646e-06,  4.414645699940864e-07, -7.669595959098529e-08,  1.332602523444329e-08, -2.315690697380691e-09,  4.024406990854538e-10,
 -6.988807878097775e-11,  1.179258220602863e-11, -2.000412083974343e+00,  2.417480278344930e-04, -4.189386010510020e-05,  7.260186739674307e-06, -1.258215985639939e-06,
  2.180582985223197e-07, -3.779201702022839e-08,  6.549943678093977e-09, -1.135232451852034e-09,  1.967573824656636e-10, -3.407362581068046e-11,  5.733761763267332e-12,
 -2.000409895737892e+00,  2.403657202599960e-04, -4.153870127550145e-05,  7.178670583744835e-06, -1.240640388717917e-06,  2.144167150450413e-07, -3.705802289273297e-08,
  6.404965281251344e-09, -1.107036598666889e-09,  1.913406813816024e-10, -3.304445856013114e-11,  5.546136174130053e-12, -2.000408875273739e+00,  2.397214590310999e-04,
 -4.137361106795055e-05,  7.140880985069716e-06, -1.232514628275311e-06,  2.127376505913872e-07, -3.672050895474995e-08,  6.338480255307178e-09, -1.094141433130525e-09,
  1.888701075292414e-10, -3.257631896752462e-11,  5.461006320857660e-12, -2.000204130263619e+00,  1.196638737232161e-04, -2.063325001472049e-05,  3.557743887228378e-06,
 -6.134570778113789e-07,  1.057781930851990e-07, -1.823940096820086e-08,  3.145049279872281e-09, -5.423085958805914e-10,  9.350982505742995e-11, -1.611049269036395e-11,
  2.697803614210100e-12, -2.000203589746773e+00,  1.193227284964398e-04, -2.054595963460039e-05,  3.537792201183082e-06, -6.091732873691092e-07,  1.048943338401413e-07,
 -1.806200095622385e-08,  3.110157220640746e-09, -5.355514215579882e-10,  9.221721888639730e-11, -1.586594054567897e-11,  2.653397451126941e-12, -2.000203336654237e+00,
  1.191630350659755e-04, -2.050515244343856e-05,  3.528477546879483e-06, -6.071760491545213e-07,  1.044828070368297e-07, -1.797951473735043e-08,  3.093955292237285e-09,
 -5.324180105868918e-10,  9.161862734153842e-11, -1.575284372716539e-11,  2.632887090810056e-12, -2.000101593639531e+00,  5.953376719083131e-05, -1.023968633446563e-05,
  1.761207604353510e-06, -3.029249610685802e-07,  5.210269409008775e-08, -8.961607317749059e-09,  1.541388951417854e-09, -2.651177903834008e-10,  4.559902149066158e-11,
 -7.836365314714437e-12,  1.309126471919129e-12, -2.000101459315558e+00,  5.944902581307149e-05, -1.021804743637516e-05,  1.756271847261960e-06, -3.018674030978858e-07,
  5.188494396248992e-08, -8.917993272999245e-09,  1.532828531747404e-09, -2.634634388821918e-10,  4.528321441102365e-11, -7.776741108799855e-12,  1.298320962164528e-12,
 -2.000101396292138e+00,  5.940927161781627e-05, -1.020790285018326e-05,  1.753959453164313e-06, -3.013722722624844e-07,  5.178306574331726e-08, -8.897601447883856e-09,
  1.528828795136001e-09, -2.626909884817112e-10,  4.513585729010332e-11, -7.748938885806454e-12,  1.293285631317668e-12, -2.000050679738091e+00,  2.969287718213075e-05,
 -5.100789683614771e-06,  8.762392522559440e-07, -1.505248291946400e-07,  2.585792872920938e-08, -4.442009437397227e-09,  7.630717271460790e-10, -1.310844240688252e-10,
  2.251782594836660e-11, -3.864965285581876e-12,  6.449134136514455e-13, -2.000050646256982e+00,  2.967175940020887e-05, -5.095402693895321e-06,  8.750117570946575e-07,
 -1.502620907002311e-07,  2.580388683650847e-08, -4.431196331513434e-09,  7.609515576434744e-10, -1.306751122297321e-10,  2.243977124796675e-11, -3.850243786527569e-12,
  6.422480620085708e-13, -2.000050630532143e+00,  2.966184185412423e-05, -5.092873640119669e-06,  8.744356724987925e-07, -1.501388244585131e-07,  2.577854111373899e-08,
 -4.426126680090944e-09,  7.599578660014725e-10, -1.304833386816192e-10,  2.240321288111138e-11, -3.843351018206423e-12,  6.410005085867200e-13, -2.000025310696728e+00,
  1.482800339633702e-05, -2.545653875923963e-06,  4.370348487656191e-07, -7.502963286573203e-08,  1.288100094395483e-08, -2.211395596248384e-09,  3.796499067972248e-10,
 -6.517782802680280e-11,  1.118938029505965e-11, -1.919361151745038e-12,  3.200799548345997e-13, -2.000025302338889e+00,  1.482273236189988e-05, -2.544309956293591e-06,
  4.367287757718555e-07, -7.496415321793350e-08,  1.286753954456324e-08, -2.208703522841060e-09,  3.791223325045367e-10, -6.507602895858362e-11,  1.116997747147734e-11,
 -1.915703560844668e-12,  3.194180605933596e-13, -2.000025298411543e+00,  1.482025559188824e-05, -2.543678575816360e-06,  4.365850051436351e-07, -7.493340085370346e-08,
  1.286121849415204e-08, -2.207439622802183e-09,  3.788746837279183e-10, -6.502825149803181e-11,  1.116087266153022e-11, -1.913987518252269e-12,  3.191075667079657e-13,
 -2.000012648067496e+00,  7.409401163938231e-06, -1.271644482106038e-06,  2.182470200165311e-07, -3.745682339297747e-08,  6.428558104307347e-09, -1.103306592309536e-09,
  1.893559050118500e-10, -3.249834123224205e-11,  5.577416671797283e-12, -9.564227546180890e-13,  1.594501886724275e-13, -2.000012645979588e+00,  7.408084454577556e-06,
 -1.271308854800025e-06,  2.181706015746781e-07, -3.744047901618877e-08,  6.425198865051720e-09, -1.102634968294205e-09,  1.892243184731226e-10, -3.247295722948586e-11,
  5.572579743110272e-12, -9.555111872676157e-13,  1.592852668966026e-13, -2.000012644998234e+00,  7.407465588588794e-06, -1.271151119825844e-06,  2.181346901568915e-07,
 -3.743279892716850e-08,  6.423620518859382e-09, -1.102319430818793e-09,  1.891625026628962e-10, -3.246103351509936e-11,  5.570307867786444e-12, -9.550830657361640e-13,
  1.592078167804761e-13, -2.000006322215055e+00,  3.703551479190718e-06, -6.355269743581007e-07,  1.090560073505712e-07, -1.871393864291874e-08,  3.211299495931914e-09,
 -5.510568725919260e-10,  9.456099393340264e-11, -1.622659245253913e-11,  2.784403594065579e-12, -4.773997221184741e-13,  7.957819313026625e-14, -2.000006321693271e+00,
  3.703222432873703e-06, -6.354431115523597e-07,  1.090369151976777e-07, -1.870985573521006e-08,  3.210460448470985e-09, -5.508891405039096e-10,  9.452813558622419e-11,
 -1.622025465080415e-11,  2.783196079120904e-12, -4.771721829838382e-13,  7.953703143121399e-14, -2.000006321447993e+00,  3.703067757156511e-06, -6.354036915628846e-07,
  1.090279412434144e-07, -1.870793671180880e-08,  3.210066101092823e-09, -5.508103107292565e-10,  9.451269365783967e-11, -1.621727629795008e-11,  2.782628649907168e-12,
 -4.770652634565769e-13,  7.951769051234511e-14, -2.000003160653044e+00,  1.851488592606185e-06, -3.176897138558250e-07,  5.451114029560490e-08, -9.353354203093841e-09,
  1.604905611801605e-09, -2.753795022398081e-10,  4.725129516605016e-11, -8.107659791286187e-12,  1.391127309702826e-12, -2.384972961086037e-13,  3.975243926746770e-14,
 -2.000003160522622e+00,  1.851406347396528e-06, -3.176687536535876e-07,  5.450636881343866e-08, -9.352333874140417e-09,  1.604695945138737e-09, -2.753375909338172e-10,
  4.724308535946962e-11, -8.106076364376273e-12,  1.390825645313161e-12, -2.384404553446595e-13,  3.974215742160383e-14, -2.000003160461310e+00,  1.851367683562590e-06,
 -3.176589003745992e-07,  5.450412581210086e-08, -9.351854243059419e-09,  1.604597388166644e-09, -2.753178903083421e-10,  4.723922637890964e-11, -8.105332097781334e-12,
  1.390683855382204e-12, -2.384137393020955e-13,  3.973732488946551e-14,     0.996738629293983,     0.982002923044307,     0.950656336770537,     0.998372654803918,
     0.991020100615821,     0.975380526351482,     0.999187140677077,     0.995514563023563,     0.987702783542281,      0.99959377108193,     0.997758392297484,
     0.993854455116632,     0.999796935413296,     0.998879471728373,     0.996927985305376,     0.999898480136048,     0.999439804497952,      0.99846418109357,
     0.999949243170569,     0.999719919374987,     0.999232137533457,     0.999974622360322,     0.999859963964956,     0.999616080498011,     0.999987311373846,
     0.999929983051339,     0.999808043179907,     0.999993655735335,     0.999964991792822,     0.999904022322439,     0.999996827879769,     0.999982495963191,
     0.999952011344311  };
  constexpr double w[1581] = {  4.707327092437820e-01, -1.859525121674241e-01,  3.994101738983569e-02, -5.916683143742439e-03,  6.706185144024396e-04,
 -6.164122604377144e-05,  4.769024938595575e-06, -3.187006758945725e-07,  1.874951650635223e-08, -9.853204811662779e-10,  4.678958671360583e-11, -2.023674307440859e-12,
  4.500058099754604e-01, -1.150481594983527e-01,  1.830665060702680e-02, -2.176056329714640e-03,  2.094644520374816e-04, -1.705114537604383e-05,  1.206049449789403e-06,
 -7.550917908787676e-08,  4.242512294243124e-09, -2.162248122757214e-10,  1.008351155709234e-11, -4.326898942677031e-13,  2.755494941033658e-01, -3.062262489344410e-02,
  2.705062089133016e-03, -2.069732688272750e-04,  1.415002117483308e-05, -8.815551709827475e-07,  5.064674841872953e-08, -2.710251802500150e-09,  1.360142337467681e-10,
 -6.423975593796480e-12,  2.862435200774395e-13, -1.203208042012878e-14,  8.737919876181163e-02, -3.256444437321619e-02,  6.715011874088390e-03, -9.651983250501356e-04,
  1.069260956869007e-04, -9.654140734258773e-06,  7.363077101219913e-07, -4.863579389736632e-08,  2.833996660674504e-09, -1.477533587158023e-10,  6.970084020515773e-12,
 -2.997921954486951e-13,  1.731602829617229e-01, -3.447212261831189e-02,  4.686329424029160e-03, -4.936147902944525e-04,  4.319307626219137e-05, -3.256181045728252e-06,
  2.164607300274942e-07, -1.288743612203638e-08,  6.947719477662394e-10, -3.421518848212423e-11,  1.550298712121638e-12, -6.493254144195441e-14,  1.846951762002722e-01,
 -1.607867385266371e-02,  1.157973078243238e-03, -7.465552158356977e-05,  4.384823718739294e-06, -2.393161889705838e-07,  1.220600362200298e-08, -5.845992663129797e-10,
  2.657349077842204e-11, -1.149858574330158e-12,  4.742737704077474e-14, -1.865475137051955e-15,  1.866351111114213e-02, -6.248436247251991e-03,  1.207654703514235e-03,
 -1.656616501087223e-04,  1.773749111205698e-05, -1.560550916821285e-06,  1.166374913870439e-07, -7.581004846537456e-09,  4.359681943500725e-10, -2.248416886349109e-11,
  1.051135797156754e-12, -4.487275631705969e-14,  8.453775493330434e-02, -1.250781270515602e-02,  1.423295288752934e-03, -1.299968940499287e-04,  1.015057329457177e-05,
 -6.964150261510065e-07,  4.276895903884090e-08, -2.386942638260566e-09,  1.219979643900161e-10, -5.746162166410573e-12,  2.509538423347623e-13, -1.018645481496391e-14,
  1.345417242792844e-01, -9.488022818764541e-03,  5.647558263913713e-04, -3.109582003519226e-05,  1.573801391954239e-06, -7.497437781403008e-08,  3.425120204544373e-09,
 -1.465812833668996e-10,  5.985258501318217e-12, -2.364122141385668e-13,  8.889720617292010e-15, -3.254985532632454e-16,  4.999976665709566e-03, -1.367625976376572e-03,
  2.399856190245647e-04, -3.060241867848129e-05,  3.112323815177720e-06, -2.636764002218726e-07,  1.913736774039386e-08, -1.216039486865762e-09,  6.868339547517428e-11,
 -3.489591539178668e-12,  1.611851931840427e-13, -6.811584683139412e-15,  5.025091873724137e-02, -5.383952566711731e-03,  5.115902090638837e-04, -3.993752576178391e-05,
  2.738537717069912e-06, -1.696223392478772e-07,  9.471341419818242e-09, -4.869650679438161e-10,  2.337261731186736e-11, -1.038486410670477e-12,  4.316117891575870e-14,
 -1.695201323763369e-15,  1.037461842037142e-01, -6.125080404714336e-03,  3.046202002767072e-04, -1.453175387592151e-05,  6.495057824358829e-07, -2.633988767810210e-08,
  1.087396367565333e-09, -4.319119365514964e-11,  1.504389502871775e-12, -5.611669719835140e-14,  2.004574667824757e-15, -5.630901508686167e-17,  1.861144524735806e-03,
 -3.521758392284249e-04,  5.493422842322718e-05, -6.289175631490069e-06,  5.897323449523132e-07, -4.743802531262692e-08,  3.300678946631902e-09, -2.024539600699403e-10,
  1.117834843972756e-11, -5.570819488010720e-13,  2.518446518780862e-14, -1.054267894753508e-15,  3.465588113726689e-02, -2.659019341064787e-03,  2.135150348192769e-04,
 -1.437403179642266e-05,  8.390113187560466e-07, -4.688558803678263e-08,  2.418832744647166e-09, -1.102083388629600e-10,  4.858759503542217e-12, -2.120328555734526e-13,
  7.989961662863409e-15, -2.805800764310774e-16,  8.322150590768841e-02, -4.241514089807804e-03,  1.788699812061777e-04, -7.268628908891269e-06,  3.076265895980267e-07,
 -1.072132918608549e-08,  3.374758298217904e-10, -1.540426943960587e-11,  5.200687350835386e-13, -7.026469329212498e-15,  6.149780766830183e-16, -3.178055898426320e-17,
  1.011106831990940e-03, -1.055886792522845e-04,  1.478816129444264e-05, -1.523007509251745e-06,  1.238155441312171e-07, -9.144053190859917e-09,  6.175902026357180e-10,
 -3.593630194961376e-11,  1.849518828074254e-12, -9.204761731275433e-14,  4.266639040844141e-15, -1.613618705938827e-16,  2.659252750720701e-02, -1.467598466096423e-03,
  9.857793336743163e-05, -6.102923804650413e-06,  2.992619812864172e-07, -1.359881071117095e-08,  6.987100147686578e-10, -3.215540571372045e-11,  1.033368918447067e-12,
 -3.600909906829820e-14,  2.200762499467751e-15, -7.756828197664993e-17,  6.866446569183308e-02, -3.089808918618182e-03,  1.152044557062399e-04, -3.736690476526011e-06,
  1.483571646967547e-07, -6.057852139197488e-09,  1.169141482898930e-10, -1.192267322637691e-12,  3.261842674815945e-13, -1.298498977201569e-14, -6.187334532271270e-16,
  1.099610940852339e-17,  7.438104789008454e-04, -3.669364567067773e-05,  4.260286155320940e-06, -4.513814168238345e-07,  3.260113354107796e-08, -1.870497584680752e-09,
  1.133577834167444e-10, -7.355383512280309e-12,  3.829986962272236e-13, -1.373164492690287e-14,  4.944543298932780e-16, -3.449557897223834e-17,  2.192910604562141e-02,
 -9.065522253939173e-04,  4.734960346334158e-05, -2.829009952888916e-06,  1.379539966740374e-07, -4.653154740415009e-09,  1.490717247291034e-10, -9.409955131047935e-12,
  5.310838923943209e-13, -9.848361523204145e-15, -3.627833928470547e-16, -7.329333016291875e-18,  5.791059658503660e-02, -2.315392045381937e-03,  8.110756442393326e-05,
 -2.176665186998576e-06,  5.638560010516090e-08, -3.014196790102561e-09,  1.405831896804609e-10, -1.905819735886916e-13, -2.123348220732558e-13, -4.649955610819436e-15,
  9.614038521572191e-16,  1.417335556648672e-18,  6.405517938805685e-04, -1.755677639686614e-05,  1.075516444487203e-06, -1.312485084339439e-07,  1.127044518550850e-08,
 -6.044798857514365e-10,  2.139574606217111e-11, -8.404660516498504e-13,  6.968510696265705e-14, -5.100273724040074e-15,  1.879597992391363e-16,  7.234038736051898e-19,
  1.889033080945804e-02, -6.321560302825820e-04,  2.403110093687669e-05, -1.231970064941114e-06,  6.754343340403013e-08, -2.727586862139399e-09,  5.492702185715577e-11,
  7.856903366559531e-14,  5.917337077387912e-14, -1.008922624779854e-14,  4.238818949953886e-16,  7.287488505076335e-18,  4.979835748620513e-02, -1.759129791660173e-03,
  5.896731600039589e-05, -1.588705595432015e-06,  2.564048897933057e-08, -3.987506385025384e-10,  5.819477300851149e-11, -4.120919798231479e-12,  4.848816059855778e-14,
  8.800618015160629e-15, -3.857773396136605e-16, -1.578837575249815e-17,  5.808692839877031e-04, -1.295189594106384e-05,  2.592248629119632e-07, -2.488559581747909e-08,
  3.173504993049594e-09, -2.418249889194854e-10,  1.109350101661708e-11, -2.493449683288995e-13, -1.673015177507046e-15,  1.694951117202339e-17,  3.803006489118970e-17,
 -3.430293439032194e-18,  1.667364116519135e-02, -4.843425712247868e-04,  1.416771584592321e-05, -5.146035542146898e-07,  2.646228264838343e-08, -1.388179286122286e-09,
  5.182284450385951e-11, -7.540022987331246e-13, -3.754281697397758e-14,  1.889396407726682e-15,  6.134762357682933e-17, -9.450741271113807e-18,  4.359403057040557e-02,
 -1.356960454302275e-03,  4.225323488475054e-05, -1.199850090157905e-06,  2.400816950786957e-08, -3.515581374995363e-11, -1.082372272806021e-11, -6.399362071247351e-13,
  9.142177090734415e-14, -3.570443333151442e-15, -4.648119822542147e-17,  1.121861376531860e-17,  5.321557431103154e-04, -1.149501595007594e-05,  1.458976026035363e-07,
 -7.531515273463129e-10,  4.252771679651400e-10, -5.977150941935368e-11,  4.334447486009834e-12, -1.953577252875566e-13,  4.637209985040199e-15,  5.400325775285806e-17,
 -9.095761981117616e-18,  2.381397009649881e-19,  1.493172532289073e-02, -3.902176619828191e-04,  9.811916630746967e-06, -2.545112145741969e-07,  9.003923092918447e-09,
 -4.684496882844709e-10,  2.421704389228234e-11, -9.193493177455611e-13,  1.706910116098277e-14,  4.993106432441996e-16, -5.010382065085170e-17,  1.387888347134642e-18,
  3.876007079314122e-02, -1.070153644977113e-03,  3.008527182814504e-05, -8.371053086556023e-07,  2.047124597366328e-08, -2.937224021721228e-10, -5.834368732147282e-12,
  4.827092944451597e-13, -3.995328927963640e-15, -1.053076267907634e-15,  7.336885080193207e-17, -2.027691318086782e-18,  4.885328035728336e-04, -1.031043330605599e-05,
  1.521996791188708e-07,  5.848136682607111e-10, -8.593372442189189e-11, -4.745365842010616e-12,  8.705100674873917e-13, -6.254425979224291e-14,  2.885005074544950e-15,
 -8.398430615053772e-17,  6.319538235043307e-19,  8.616157215417743e-20,  1.351123251365888e-02, -3.220352279365824e-04,  7.394270622409452e-06, -1.613615355526746e-07,
  3.711051522470661e-09, -1.285406923044104e-10,  6.787755657797061e-12, -3.492640644031410e-13,  1.377607794309974e-14, -3.410435642696456e-16, -7.151976527956331e-20,
  4.864094187529237e-19,  3.490443596575589e-02, -8.645595204200701e-04,  2.179803283228201e-05, -5.601183598766318e-07,  1.412755321950153e-08, -3.051769625808451e-10,
  3.210834265858566e-12,  1.411371666547100e-13, -9.882973059658910e-15,  2.542106883837037e-16,  3.772207972898850e-18, -6.829813144776366e-19,  4.497346596339659e-04,
 -9.090286859691174e-06,  1.502650926668196e-07, -8.550533870822301e-10, -7.068571233102353e-11,  3.059882943311341e-12,  1.712412651037646e-14, -9.808744073222675e-15,
  7.243515352292818e-16, -3.404176662140382e-17,  1.119902517716022e-18, -2.169526786236698e-20,  1.233035997491021e-02, -2.697682428691935e-04,  5.750794165183326e-06,
 -1.162682860693825e-07,  2.188763885724351e-09, -4.383147811998317e-11,  1.486702172567050e-12, -8.054202066852745e-14,  4.139947888271548e-15, -1.672358332785495e-16,
  4.854593928592229e-18, -7.142144560090060e-20,  3.175725056017521e-02, -7.136504685120883e-04,  1.624736741647369e-05, -3.779082554072593e-07,  8.966298543219366e-09,
 -2.079531978356104e-10,  4.091775088735531e-12, -3.593348448295396e-14, -2.003089651582262e-15,  1.361426431722496e-16, -4.483513242383751e-18,  5.880446797885506e-20,
  4.156915542304236e-04, -7.943953414906240e-06,  1.351425531401242e-07, -1.532203498358695e-09, -1.791612290285910e-11,  1.925090804503481e-12, -6.630488113923737e-14,
  5.806014565426075e-16,  8.441740007326920e-17, -6.837359235538705e-18,  3.262062172453453e-19, -1.135166945235733e-20,  1.133522824672743e-02, -2.288043757353950e-04,
  4.541469001547328e-06, -8.687927103219475e-08,  1.544380013835417e-09, -2.463205407136819e-11,  4.093258198186209e-13, -1.365924214115162e-14,  7.859997124205720e-16,
 -4.078196392017068e-17,  1.663404140479182e-18, -5.198555901176550e-20,  2.913695302083901e-02, -5.996557756931396e-04,  1.245212341604871e-05, -2.628096974989342e-07,
  5.685519168667493e-09, -1.256263977142507e-10,  2.713674672188578e-12, -5.005382554450724e-14,  4.371061540353780e-16,  2.044817944976368e-17, -1.422669273311297e-18,
  5.145624310565188e-20,  3.859578952130751e-04, -6.938825666553457e-06,  1.160500873206993e-07, -1.588482886365267e-09,  6.863474539207159e-12,  6.765052827515919e-13,
 -3.588828550154546e-14,  1.094554165067880e-15, -1.619320139460834e-17, -5.113186932457679e-19,  5.329836556353787e-20, -2.608494173595122e-21,  1.048661887373715e-02,
 -1.962572168942417e-04,  3.632387574442829e-06, -6.566909414701375e-08,  1.129293268972509e-09, -1.754743169327983e-11,  2.282405236537347e-13, -2.763890246255024e-15,
  9.330285830510848e-17, -6.293669786949359e-18,  3.386830766911484e-19, -1.389046451914112e-20,  2.691954807716622e-02, -5.112773841916608e-04,  9.771545150220178e-06,
 -1.888454478922482e-07,  3.720679535613730e-09, -7.535551304668929e-11,  1.561525974562687e-12, -3.174143225049905e-14,  5.606374889706953e-16, -5.397776446045608e-18,
 -1.578092873679675e-19,  1.199101713873754e-20,  3.599423350328906e-04, -6.084033999478361e-06,  9.796777066511331e-08, -1.407967341447655e-09,  1.392726758201875e-11,
  1.177485439780791e-13, -1.331539298418350e-14,  5.309181643384382e-16, -1.481871643986268e-17,  2.599591877577669e-19,  1.223246367268369e-21, -3.417468328804008e-22,
  9.755118137332973e-03, -1.700679165201189e-04,  2.942091728248933e-06, -5.013256555051630e-08,  8.279715578645515e-10, -1.280053288930267e-11,  1.718449273617739e-13,
 -1.679276011220497e-15,  7.950884525099881e-18, -3.434624300341984e-19,  4.029616096038052e-20, -2.388825902957012e-21,  2.501772373859689e-02, -4.412602517261543e-04,
  7.818702829823002e-06, -1.396034978137734e-07,  2.525967489553733e-09, -4.672019477652026e-11,  8.904716966778430e-13, -1.740088881676415e-14,  3.353752862567313e-16,
 -5.744823262764312e-18,  6.210590641569974e-20,  8.840502869117417e-22,  3.370721461690019e-04, -5.363998319207799e-06,  8.244237973771625e-08, -1.179454492472463e-09,
  1.404995886503101e-11, -6.854229168818347e-14, -3.728026962887761e-15,  1.975951720658658e-16, -6.598576823466379e-18,  1.709164663284214e-19, -3.197802038809034e-21,
  1.896262563934269e-23,  9.118403892077596e-03, -1.487304160483464e-04,  2.412221136407686e-06, -3.872455849375634e-08,  6.095229904850229e-10, -9.215886049592011e-12,
  1.278803405176493e-13, -1.453182981146311e-15,  8.561181302093051e-18,  1.161138304717602e-19, -2.002497784251489e-21, -1.852917816928309e-22,  2.336805705183984e-02,
 -3.847887462326216e-04,  6.358474663856497e-06, -1.056481833493280e-07,  1.771333659530489e-09, -3.015593582039657e-11,  5.260014865009195e-13, -9.473492845594354e-15,
  1.753090401407777e-16, -3.220085828012556e-18,  5.380737512512001e-20, -6.404911205312469e-22,  3.168508200453269e-04, -4.757379452943071e-06,  6.958098548473524e-08,
 -9.689668443966428e-10,  1.213031381492997e-11, -1.106223118075804e-13, -3.885114772124456e-16,  6.270524501292623e-17, -2.426350426152029e-18,  7.106794610217763e-20,
 -1.720589300311010e-21,  3.277367495451767e-23,  8.559351571675275e-03, -1.311386265275277e-04,  2.000461957049286e-06, -3.029321173677117e-08,  4.527743254844316e-10,
 -6.600988366069023e-12,  9.149556791248415e-14, -1.135342272587011e-15,  1.053693812745365e-17, -7.038111983450221e-21, -2.550025557285124e-21,  5.566299056051651e-23,
  2.192323327680238e-02, -3.385520454895766e-04,  5.242841717947274e-06, -8.152590811731435e-08,  1.275840747767977e-09, -2.017470058980047e-11,  3.244988539779730e-13,
 -5.357534331903566e-15,  9.147495813763639e-17, -1.608055714510473e-18,  2.824022765094952e-20, -4.609915112994941e-22,  2.988653916871519e-04, -4.244111554671503e-06,
  5.904455042271190e-08, -7.926227801916914e-10,  9.930006597587213e-12, -1.056982829867607e-13,  5.849055803523737e-16,  1.521267594849914e-17, -8.082674418967935e-19,
  2.570418678791018e-20, -6.767680853359175e-22,  1.537742937953155e-23,  8.064663724038338e-03, -1.164751596755658e-04,  1.676411675341803e-06, -2.399580238734913e-08,
  3.403322751398608e-10, -4.749288775613928e-12,  6.427537451731474e-14, -8.172361854896404e-16,  9.011970748650540e-18, -6.387497869389548e-20, -4.884749323336138e-22,
  3.139975463381281e-23,  2.064716726659405e-02, -3.002036742575837e-04,  4.374940524378640e-06, -6.396293017313212e-08,  9.395835515299399e-10, -1.390267577916050e-11,
  2.081138984785870e-13, -3.173494625647872e-15,  4.974278718705144e-17, -8.072236990106448e-19,  1.351151148207971e-20, -2.272526052679760e-22,  2.827770271504959e-04,
 -3.807255250487677e-06,  5.041935723695958e-08, -6.497900929478046e-10,  7.978857224283863e-12, -8.877490204618089e-14,  7.571996448489888e-16,  3.534937970268043e-20,
 -2.394187804944555e-19,  8.743303680389651e-21, -2.406699655041550e-22,  5.779493449129868e-24,  7.623883802749649e-03, -1.041298051285620e-04,  1.418251005923278e-06,
 -1.923377897782826e-08,  2.590781924645076e-10, -3.450886505222412e-12,  4.507056150337272e-14, -5.672434511700145e-16,  6.614722272834758e-18, -6.419005880673985e-20,
  2.991876831367925e-22,  7.569075287678041e-24,  1.951182542685202e-02, -2.680383108524675e-04,  3.689213248290139e-06, -5.090992730748869e-08,  7.051077069675686e-10,
 -9.817921551643409e-12,  1.378160649657698e-13, -1.959218833788905e-15,  2.840583115388071e-17, -4.237521786618505e-19,  6.549275108908498e-21, -1.045333236417650e-22,
  2.683082258142333e-04, -3.433048641148552e-06,  4.333242379225508e-08, -5.353570538379344e-10,  6.381719944592337e-12, -7.122094318534152e-14,  6.874370547303100e-16,
 -4.039495055672709e-18, -4.982585190325623e-20,  2.817041525933580e-21, -8.260007690438439e-23,  2.023240565393313e-24,  7.228687851852837e-03, -9.364143786814679e-05,
  1.210216180557044e-06, -1.558689399125714e-08,  1.997057848190501e-10, -2.537908569109291e-12,  3.182291920799029e-14, -3.897964120880018e-16,  4.568411543938920e-18,
 -4.880808260403707e-20,  4.105404913092837e-22, -7.429690071256164e-25,  1.849508289330633e-02, -2.407903334161148e-04,  3.140039891482699e-06, -4.103632746635315e-08,
  5.378585913296012e-10, -7.078405187225284e-12,  9.370499265495635e-14, -1.251503149799426e-15,  1.694303231093876e-17, -2.341363245022556e-19,  3.331040720545714e-21,
 -4.910270972503085e-23,  2.552309778399634e-04, -3.110453193956435e-06,  3.747657151856356e-08, -4.437891588992531e-10,  5.112519963729203e-12, -5.618528446804976e-14,
  5.635573893675599e-16, -4.506727930166332e-18,  8.861593627676268e-21,  7.992816562367846e-22, -2.778257188518305e-23,  6.967772728332251e-25,  6.872372874885104e-03,
 -8.465716466421069e-05,  1.040795141257676e-06, -1.275960307681486e-08,  1.557799453830453e-10, -1.890123527078362e-12,  2.271309034982665e-14, -2.686652561756023e-16,
  3.091796077594329e-18, -3.377539777246340e-20,  3.299137828713311e-22, -2.349334614561848e-24,  1.757923672244241e-02, -2.175034807683523e-04,  2.694932347531849e-06,
 -3.345184706275537e-08,  4.162279004343610e-10, -5.195687459507985e-12,  6.514786868096524e-14, -8.221446010248546e-16,  1.047422991092590e-17, -1.353610916758420e-19,
  1.786642317055274e-21, -2.427883488538383e-23,  2.433569186032196e-04, -2.830632732862336e-06,  3.260708647661472e-08, -3.702856581530798e-10,  4.114101456210895e-12,
 -4.412193028668226e-14,  4.444277825817957e-16, -3.928269945012475e-18,  2.339865283541254e-20,  1.309112236587408e-22, -8.902634980094259e-24,  2.401600960714974e-25,
  6.549483468174101e-03, -7.690358482779460e-05,  9.014767036657547e-07, -1.054229593263087e-08,  1.228726110818918e-10, -1.425138408003168e-12,  1.640978277690299e-14,
 -1.868372476181079e-16,  2.088658912643333e-18, -2.261579293339172e-20,  2.304033891139123e-22, -2.050654066243202e-24,  1.674994944686305e-02, -1.974438784472981e-04,
  2.330294230025249e-06, -2.754575643355175e-08,  3.262632945788431e-10, -3.874560811861344e-12,  4.617520795113491e-14, -5.529786603137380e-16,  6.668166975300486e-18,
 -8.122109495130652e-20,  1.004058075936776e-21, -1.267903021724674e-23,  2.325294552640505e-04, -2.586494196540026e-06,  2.853127066961267e-08, -3.109758495687543e-10,
  3.329864441488839e-12, -3.468861596931398e-14,  3.452379987112982e-16, -3.155961211008014e-18,  2.368777042371525e-20, -7.269512208660734e-23, -2.410594147756476e-24,
  8.186509589840554e-26,  6.255536033713744e-03, -7.016641555018472e-05,  7.858890939722648e-07, -8.784609798004432e-09,  9.792050249374541e-11, -1.087221222807033e-12,
  1.200337268215238e-14, -1.314142061919845e-16,  1.420226376704019e-18, -1.502899193760503e-20,  1.533010102346459e-22, -1.456517926339784e-24,  1.599548314663018e-02,
 -1.800404999224068e-04,  2.028690852854912e-06, -2.289012360932805e-08,  2.587140516234578e-10, -2.930493841736366e-12,  3.328913760211357e-14, -3.795963597777046e-16,
  4.351202267267321e-18, -5.024312705769739e-20,  5.862730846792241e-22, -6.944508487073159e-24,  2.226175573058062e-04, -2.372315093703050e-06,  2.509771279830861e-08,
 -2.628265467184310e-10,  2.712222001596820e-12, -2.738058642239029e-14,  2.669912385573018e-16, -2.452719404238552e-18,  2.000662942993332e-20, -1.177273493159339e-22,
 -2.396894636327387e-25,  2.619288611966736e-26,  5.986812510302286e-03, -6.427588643266329e-05,  6.892040717687262e-07, -7.377349435121371e-09,  7.878340443598924e-11,
 -8.386204518661460e-13,  8.886458050883208e-15, -9.355602760504176e-17,  9.755478078166218e-19, -1.002340575974585e-20,  1.005460344162709e-22, -9.670122002514809e-25,
  1.530613435935069e-02, -1.648435179972089e-04,  1.777043169540796e-06, -1.917951937220340e-08,  2.073074115940496e-10, -2.244888034398583e-12,  2.436698690168545e-14,
 -2.653057336919397e-16,  2.900460591278348e-18, -3.188556741035706e-20,  3.532280834698739e-22, -3.955129837202461e-24,  2.135108748548398e-04, -2.183450808530549e-06,
  2.218716335682082e-08, -2.234858307025045e-10,  2.223482581245899e-12, -2.172850184018325e-14,  2.066384338245230e-16, -1.880383981231907e-18,  1.580423387719819e-20,
 -1.115505231319135e-22,  4.082869122319019e-25,  6.610834047804635e-27,  5.740204213129884e-03, -5.909614114052357e-05,  6.077208426746163e-07, -6.240237496283095e-09,
  6.394847123491304e-11, -6.535603039044337e-13,  6.654773637658987e-15, -6.741220897526617e-17,  6.778634300957391e-19, -6.742627354694520e-21,  6.595825939358396e-23,
 -6.278957164234877e-25,  1.467381068750798e-02, -1.514946195649794e-04,  1.565405273909039e-06, -1.619235802802043e-08,  1.677060471370237e-10, -1.739705937890185e-12,
  1.808290920621243e-14, -1.884361625055106e-16,  1.970106273510308e-18, -2.068706158599092e-20,  2.184927136027357e-22, -2.325859676406113e-24,  2.051158936863492e-04,
 -2.016107395829711e-06,  1.970527320693962e-08, -1.911341325979712e-10,  1.834521107882040e-12, -1.734742726629987e-14,  1.604892244479697e-16, -1.435342164366424e-18,
  1.212866116497012e-20, -9.189639640016096e-23,  5.271993434271318e-25,  9.652575894370094e-30,  5.513092237815929e-03, -5.451745186371749e-05,  5.385721526265230e-07,
 -5.313554149139196e-09,  5.233329832539388e-11, -5.142524205259091e-13,  5.037763057480039e-15, -4.914469641167167e-17,  4.766329921914075e-19, -4.584457547716809e-21,
  4.356050316229563e-23, -4.061862947959286e-25,  1.409170916987904e-02, -1.397054940834621e-04,  1.386120323212516e-06, -1.376550811278286e-08,  1.368585553377079e-10,
 -1.362539185984775e-12,  1.358830804067241e-14, -1.358026650059256e-16,  1.360904656104527e-18, -1.368554947887746e-20,  1.382541102361352e-22, -1.405016007007213e-24,
  1.973528936058093e-04, -1.867165731989312e-06,  1.757697072736958e-08, -1.643610184266057e-10,  1.523048836268555e-12, -1.393701587586491e-14,  1.252647120396643e-16,
 -1.096136257175409e-18,  9.192779944953999e-21, -7.155755309284801e-23,  4.762208588644186e-25, -1.890533859000670e-27,  5.303254871185663e-03, -5.045043177175073e-05,
  4.795141646461120e-07, -4.552371211300538e-09,  4.315415422727869e-11, -4.082765061687460e-13,  3.852641434772945e-15, -3.622887894695211e-17,  3.390812665508693e-19,
 -3.152954698561975e-21,  2.904724273639304e-23, -2.639634159068530e-25,  1.355406890085055e-02, -1.292420123777095e-04,  1.233227436941822e-06, -1.177726812753749e-08,
  1.125845958319012e-10, -1.077548319017047e-12,  1.032841691278928e-14, -9.917906824748745e-17,  9.545350354234356e-19, -9.213171842744092e-21,  8.925247741565460e-23,
 -8.686739319135895e-25,  1.901535289694904e-04, -1.734045198273769e-06,  1.574215474517866e-08, -1.420686807999475e-10,  1.272048171640205e-12, -1.126797655069962e-14,
  9.832921114113289e-17, -8.396805662987114e-19,  6.938135975922914e-21, -5.431162550891598e-23,  3.844041284731786e-25, -2.136274380051490e-27,  5.108795182659047e-03,
 -4.682168391065240e-05,  4.287744279164413e-07, -3.922529248549807e-09,  3.583701013013953e-11, -3.268572877910521e-13,  2.974553755073078e-15, -2.699101177517605e-17,
  2.439663130619079e-19, -2.193602036484887e-21,  1.958089926618614e-23, -1.729828657289526e-25,  1.305597859582540e-02, -1.199124335616531e-04,  1.102038347491963e-06,
 -1.013573985290738e-08,  9.330413335597893e-11, -8.598224410357990e-13,  7.933685229674801e-15, -7.331986597168826e-17,  6.789004327819098e-19, -6.301332386151566e-21,
  5.866355291784511e-23, -5.481894629181319e-25,  1.834588923211214e-04, -1.614597592098089e-06,  1.415240487445892e-08, -1.233981295329059e-10,  1.068505621150032e-12,
 -9.166824871932159e-15,  7.765261420750054e-17, -6.461566280000061e-19,  5.237570020089271e-21, -4.075241675638341e-23,  2.956086620975595e-25, -1.860395374941699e-27,
  4.928083862292178e-03, -4.357049506148807e-05,  3.849406027907627e-07, -3.397797401564320e-09,  2.995680982310636e-11, -2.637227054153928e-13,  2.317227921653176e-15,
 -2.031014641608434e-17,  1.774379322009192e-19, -1.543500518253861e-21,  1.334868469860904e-23, -1.145124543656186e-25,  1.259322534525895e-02, -1.115585065811879e-04,
  9.888308887053110e-07, -8.770756156969912e-09,  7.785733278011440e-11, -6.917890753750744e-13,  6.153749042246651e-15, -5.481490816482409e-17,  4.890782825494530e-19,
 -4.372626004899443e-21,  3.919233890562317e-23, -3.523653075545108e-25,  1.772179549017681e-04, -1.507024134705922e-06,  1.276846573601163e-08, -1.076732998309256e-10,
  9.024326798790512e-13, -7.502609544800207e-15,  6.170148352466350e-17, -4.998991300328047e-19,  3.964610372447515e-21, -3.045312274570038e-23,  2.221692899158928e-25,
 -1.476095038586948e-27,  4.759713697615287e-03, -4.064629840435726e-05,  3.468781168153670e-07, -2.957844844440049e-09,  2.519553776340973e-11, -2.143397173091531e-13,
  1.820364004842402e-15, -1.542722921796329e-17,  1.303833046421451e-19, -1.097980726935670e-21,  9.202378243395517e-24, -7.662858434522526e-26,  1.216217460921652e-02,
 -1.040486804251060e-04,  8.906241783013508e-07, -7.628192378419623e-09,  6.538269061700979e-11, -5.608837383448517e-13,  4.816367859037634e-15, -4.140831249609905e-17,
  3.565184940794825e-19, -3.074937365005899e-21,  2.657779614226207e-23, -2.303100738564505e-25,  1.713863027737188e-04, -1.409810169375322e-06,  1.155831617044627e-08,
 -9.435884925865140e-11,  7.661250793450584e-13, -6.176358712886912e-15,  4.932716574751586e-17, -3.889779322159691e-19,  3.013600312220733e-21, -2.275702947331661e-23,
  1.652132734466759e-25, -1.122627364452003e-27,  4.602463021785494e-03, -3.800670790659701e-05,  3.136685934646839e-07, -2.586775669373360e-09,  2.131293219057918e-11,
 -1.753972014505148e-13,  1.441341804744235e-15, -1.182245513528770e-17,  9.674393274253553e-20, -7.892615114906690e-22,  6.413579143421687e-24, -5.184210710776320e-26,
  1.175967416381135e-02, -9.727286974728903e-05,  8.050117451302712e-07, -6.665902438057492e-09,  5.523328387619165e-11, -4.580103422629117e-13,  3.801369650805947e-15,
 -3.158395694634545e-17,  2.627500034355012e-19, -2.189164530364628e-21,  1.827304719342824e-23, -1.528561606911181e-25,  1.659251062019217e-04, -1.321673466540839e-06,
  1.049568028172877e-08, -8.302825904127159e-11,  6.536074874490935e-13, -5.113019821965989e-15,  3.967127619097389e-17, -3.044664929853726e-19,  2.302219581114740e-21,
 -1.704701238199328e-23,  1.223727497781288e-25, -8.362924859720123e-28,  4.455266140103440e-03, -3.561598220048408e-05,  2.845633599222105e-07, -2.272059372522642e-09,
  1.812579951706306e-11, -1.444521051281216e-13,  1.149711646978248e-15, -9.135884724594789e-18,  7.244786825493575e-20, -5.730251606013408e-22,  4.517260235376148e-24,
 -3.545441181053010e-26,  1.138297659471435e-02, -9.113838104703130e-05,  7.300362989320771e-07, -5.850779036104544e-09,  4.691839196499449e-11, -3.765076598894573e-13,
  3.023817646041361e-15, -2.430799605436225e-17,  1.956270253514451e-19, -1.576471967054183e-21,  1.272432447528266e-23, -1.028932297218217e-25,  2.002190280823104e+00,
 -1.224290380463374e-03,  1.394713646754371e-04, -9.712681580251481e-06, -1.190647898521393e-06,  7.774649161313002e-07, -2.482362463137174e-07,  6.558096900867332e-08,
 -1.585181444356675e-08,  3.639591202520504e-09, -8.069485282353762e-10,  1.676626655443282e-10,  2.003062811233868e+00, -1.784715392962478e-03,  2.948365995675466e-04,
 -4.825756847888951e-05,  7.805608547586916e-06, -1.243119165045489e-06,  1.938650212977502e-07, -2.934758645190443e-08,  4.247693926876480e-09, -5.705553314743042e-10,
  6.621532268324624e-11, -5.293230652401330e-12,  2.003451274516810e+00, -2.033276533009201e-03,  3.625912952197849e-04, -6.478841822630373e-05,  1.160106792809856e-05,
 -2.082017323566222e-06,  3.745633825683466e-07, -6.756056768703449e-08,  1.221978491317403e-08, -2.216665329520387e-09,  4.029391803119957e-10, -7.117214812362227e-11,
  2.001388272917889e+00, -8.017991315977297e-04,  1.240096181405438e-04, -1.875698448185952e-05,  2.750302168189308e-06, -3.850631885520464e-07,  4.996997536246387e-08,
 -5.590921044840813e-09,  4.069181787651547e-10,  3.239706351662189e-11, -2.437578594495237e-11,  7.240304427858383e-12,  2.001580435012935e+00, -9.240230998944973e-04,
  1.564290311560581e-04, -2.644228663253375e-05,  4.462305016053567e-06, -7.516566043865987e-07,  1.263539949386819e-07, -2.119153385016670e-08,  3.545000064729147e-09,
 -5.912855691659683e-10,  9.822905265296455e-11, -1.583990684401597e-11,  2.001668418995171e+00, -9.798817659190191e-04,  1.711203559603890e-04, -2.989558541095113e-05,
  5.225112764054312e-06, -9.136365918827076e-07,  1.598257212826487e-07, -2.797187265652441e-08,  4.897835804042483e-09, -8.580049579559262e-10,  1.502483422103495e-10,
 -2.556122115348074e-11,  2.000754973885569e+00, -4.397214329384560e-04,  7.245999013000369e-05, -1.189916265195630e-05,  1.946401354111083e-06, -3.169602485239007e-07,
  5.134968033342288e-08, -8.269196631135049e-09,  1.322257366380703e-09, -2.096478788162852e-10,  3.288402514641451e-11, -4.981705872891035e-12,  2.000800231943494e+00,
 -4.683805115106164e-04,  7.990767811119261e-05, -1.362833826311712e-05,  2.323569269131110e-06, -3.960225286574489e-07,  6.747276253166166e-08, -1.149142052709521e-08,
  1.956352359205212e-09, -3.329125950176120e-10,  5.658251178743367e-11, -9.350346467287427e-12,  2.000821233635279e+00, -4.816674730762088e-04,  8.334597999693145e-05,
 -1.442323380363446e-05,  2.496214613402226e-06, -4.320590865297259e-07,  7.479059184806133e-08, -1.294774276281856e-08,  2.241737612757893e-09, -3.881584981153152e-10,
  6.716000126036456e-11, -1.129271595884297e-11,  2.000391391834845e+00, -2.286757583696593e-04,  3.853389880569561e-05, -6.488709735872959e-06,  1.091814074397687e-06,
 -1.835670912546182e-07,  3.083726838277985e-08, -5.175700367199620e-09,  8.678593055694914e-10, -1.453719179531281e-10,  2.430655874802726e-11, -3.952479483912698e-12,
  2.000402382808148e+00, -2.356209450886119e-04,  4.032099068986344e-05, -6.899498453599866e-06,  1.180516826066137e-06, -2.019735312694209e-07,  3.455282941775353e-08,
 -5.910699579276371e-09,  1.011018718033429e-09, -1.729154549421628e-10,  2.954759670441887e-11, -4.909295321030104e-12,  2.000407516692454e+00, -2.388635784205946e-04,
  4.115359769751678e-05, -7.090476591302662e-06,  1.221667075009486e-06, -2.104942368005259e-07,  3.626916228731136e-08, -6.249494396462392e-09,  1.076866963206503e-09,
 -1.855575898981336e-10,  3.194808915233167e-11, -5.346669675592961e-12,  2.000199022082133e+00, -1.164397351564773e-04,  1.980811982305548e-05, -3.369110589903196e-06,
  5.729482091737675e-07, -9.741853594902854e-08,  1.656120486450654e-08, -2.814908188187761e-09,  4.783612955619873e-10, -8.127472326532158e-11,  1.379524790208376e-11,
 -2.277321387572139e-12,  2.000201730778634e+00, -1.181495879672284e-04,  2.024595222813606e-05, -3.469259490458913e-06,  5.944671516931925e-07, -1.018618022865973e-07,
  1.745368700628339e-08, -2.990578804350675e-09,  5.124071453773664e-10, -8.779238165900307e-11,  1.502926613479479e-11, -2.501553377493384e-12,  2.000203000129629e+00,
 -1.189506800893563e-04,  2.045086603258942e-05, -3.516080951243617e-06,  6.045168675192099e-07, -1.039346569087170e-07,  1.786959727145221e-08, -3.072356149227898e-09,
  5.282390121534660e-10, -9.081995078786667e-11,  1.560187884007634e-11, -2.605498298178744e-12,  2.000100324568706e+00, -5.873312873619655e-05,  1.003522241864871e-05,
 -1.714565690749414e-06,  2.929303012709246e-07, -5.004460759672352e-08,  8.549345584372911e-09, -1.460463852501335e-09,  2.494770412051690e-10, -4.261299783508309e-11,
  7.272551803205242e-12, -1.206939137771036e-12,  2.000100996945775e+00, -5.915734660399155e-05,  1.014358754012525e-05, -1.739292646286393e-06,  2.982304020983394e-07,
 -5.113630357693449e-08,  8.768088061895377e-09, -1.503414067360679e-09,  2.577805492258876e-10, -4.419869105843233e-11,  7.572042048070429e-12, -1.261233896975861e-12,
  2.000101312545410e+00, -5.935644319358324e-05,  1.019441918530866e-05, -1.750885300818346e-06,  3.007138964008052e-07, -5.164756990510283e-08,  8.870475082341459e-09,
 -1.523507002074924e-09,  2.616629995845415e-10, -4.493971090785638e-11,  7.711923712091523e-12, -1.286580399340779e-12,  2.000050363459103e+00, -2.949338627952856e-05,
  5.049898660025243e-06, -8.646425292520908e-07,  1.480424978634869e-07, -2.534732122845911e-08,  4.339838418241928e-09, -7.430376884920212e-10,  1.272165448496316e-10,
 -2.178019633572964e-11,  3.725838122907693e-12, -6.197230901265738e-13,  2.000050530958873e+00, -2.959903876135004e-05,  5.076854818267622e-06, -8.707859869716104e-07,
  1.493577176585193e-07, -2.561789573439699e-08,  4.393987182613058e-09, -7.536568565314918e-10,  1.292670272875616e-10, -2.217129167377051e-11,  3.799614461599973e-12,
 -6.330827680256957e-13,  2.000050609643167e+00, -2.964866703822371e-05,  5.089513613589308e-06, -8.736702245053885e-07,  1.499750226953575e-07, -2.574485707122237e-08,
  4.419388496884264e-09, -7.586369913613270e-10,  1.302283951679062e-10, -2.235460716102131e-11,  3.834185870832605e-12, -6.393415050233416e-13,  2.000025231750069e+00,
 -1.477821389995531e-05,  2.532959092819375e-06, -4.341435883540595e-07,  7.441107720326791e-08, -1.275383437942181e-08,  2.185963631192788e-09, -3.746658045139894e-10,
  6.421608857500637e-11, -1.100606914791318e-11,  1.884804684244120e-12, -3.138263209533463e-13,  2.000025273551017e+00, -1.480457700000963e-05,  2.539681334771645e-06,
 -4.356746986204580e-07,  7.473866564166246e-08, -1.282118681310596e-08,  2.199434353294198e-09, -3.773059540475098e-10,  6.472557150673957e-11, -1.110318535408862e-11,
  1.903113601863641e-12, -3.171398774560081e-13,  2.000025293195241e+00, -1.481696590872055e-05,  2.542839924058247e-06, -4.363940272798954e-07,  7.489254880745373e-08,
 -1.285282105132453e-08,  2.205760459019085e-09, -3.785456510203910e-10,  6.496476980257828e-11, -1.114877451279537e-11,  1.911707183564370e-12, -3.186949520145612e-13,
  2.000012628346187e+00, -7.396964171138578e-06,  1.268474273817986e-06, -2.175251919086119e-07,  3.730243697221195e-08, -6.396826881905605e-09,  1.096962387093800e-09,
 -1.881129150741618e-10,  3.225855656858602e-11, -5.531725096762982e-12,  9.478116208835324e-13, -1.578922355525609e-13,  2.000012638787194e+00, -7.403548707762591e-06,
  1.270152740361732e-06, -2.179073771280237e-07,  3.738418258651300e-08, -6.413628745730250e-09,  1.100321798487315e-09, -1.887711317808921e-10,  3.238553735631621e-11,
 -5.555922461408405e-12,  9.523720691919769e-13, -1.587173532531947e-13,  2.000012643694900e+00, -7.406643669436111e-06,  1.270941625851820e-06, -2.180869935757006e-07,
  3.742259817578888e-08, -6.421524093475689e-09,  1.101900309899780e-09, -1.890803920647665e-10,  3.244519470761984e-11, -5.567289955046623e-12,  9.545143431456838e-13,
 -1.591049284754053e-13,  2.000006317286644e+00, -3.700443527258611e-06,  6.347348576543147e-07, -1.088756735081290e-07,  1.867537354345474e-08, -3.203374227418174e-09,
  5.494725406453116e-10, -9.425062495236253e-11,  1.616672733809431e-11, -2.772997675814763e-12,  4.752504252590727e-13, -7.918938440868004e-14,  2.000006319895744e+00,
 -3.702088882498681e-06,  6.351542129059387e-07, -1.089711458893789e-07,  1.869579104551299e-08, -3.207570172415059e-09,  5.503113623088357e-10, -9.441495214341369e-11,
  1.619842393261501e-11, -2.779036838208437e-12,  4.763884468265452e-13, -7.939525639201329e-14,  2.000006321122252e+00, -3.702862340013286e-06,  6.353513391655232e-07,
 -1.090160230754811e-07,  1.870538805404973e-08, -3.209542360999249e-09,  5.507056140832648e-10, -9.449218441427357e-11,  1.621332053839991e-11, -2.781874997558263e-12,
  4.769232524510961e-13, -7.949200150426970e-14,  2.000003159421181e+00, -1.850711766569608e-06,  3.174917390654719e-07, -5.446607222121662e-08,  9.343716862942275e-09,
 -1.602925235857578e-09,  2.749836339297130e-10, -4.717375017444067e-11,  8.092703630181849e-12, -1.388277948902965e-12,  2.379604070103912e-13, -3.965532188484217e-14,
  2.000003160073312e+00, -1.851123008070235e-06,  3.175965452277260e-07, -5.448993108355324e-08,  9.348818877975180e-09, -1.603973657586563e-09,  2.751932106006646e-10,
 -4.721480363633733e-11,  8.100621712282036e-12, -1.389786469155261e-12,  2.382446515325690e-13, -3.970673904302001e-14,  2.000003160379887e+00, -1.851316337103659e-06,
  3.176458149107452e-07, -5.450114701677463e-08,  9.351217269728345e-09, -1.604466498883438e-09,  2.752917265842391e-10, -4.723410136618414e-11,  8.104343650077362e-12,
 -1.390495545386169e-12,  2.383782577252727e-13, -3.973090676456420e-14,   0.00278882280903266,   0.00109214318004105,  4.07252053890668e-05,   0.00139159837233385,
  0.000545034673716018,  2.03292242741673e-05,  0.000695108892830187,  0.000272254656468572,  1.01554327218794e-05,  0.000347383414976755,  0.000136061276333655,
   5.0753273702357e-06,  0.000173649137797596,  6.80140803035322e-05,  2.53705525277476e-06,  8.68139497216884e-05,  3.40028952447732e-05,  1.26837415503394e-06,
  4.34043229553444e-05,  1.70004107258845e-05,  6.34148541398809e-07,  2.17014988613461e-05,   8.4999460557402e-06,  3.17064615766484e-07,  1.08505838215324e-05,
  4.24990819072497e-06,   1.5852989154527e-07,  5.42525051409455e-06,  2.12493788478562e-06,  7.92643413630588e-08,  2.71261490858081e-06,  1.06246488958743e-06,
  3.96320195385319e-08  };
  int offset = -3;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 3;
    if (std::isnan(t)) {
      fill_n(rr+offset, 3, 0.5);
      fill_n(ww+offset, 3, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 3; ++r) {
        ww[offset+r] = aw[3-r-1] / t;
        rr[offset+r] = 1.0 - ax[3-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=3; ++j) {
        const int boxof = it*36+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 1548 + (it - 32) * 3 + 3 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
