/* This file is part of the 'atomes' software

'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>

Copyright (C) 2022-2025 by CNRS and University of Strasbourg */

/*!
* @file charmm36_prot_metals.c
* @short CHARMM-charmm36m_prot force field, from 'charmm36m_prot'
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'charmm36_prot_metals.c'
*
* Contains:
*

  CHARMM-charmm36m_prot force field, data from taken from:

       - the file: 'charmm36m_prot'
       - distributed in: 'toppar_c36_jul16_mass_orig.tgz'

  This file contains several tables:

    Atoms      : charmm36m_prot_atoms[53][5]
    Bonds      : charmm36m_prot_bonds[132][5]
    Angles     : charmm36m_prot_angles[364][8]
    Dihedrals  : charmm36m_prot_dihedrals[706][8]
    Impropers  : charmm36m_prot_impropers[35][8]
    Non bonded : charmm36m_prot_vdw[53][6]

*/

#include "global.h"

int charmm36m_prot_objects[14] = {53, 0, 0, 132, 0, 0, 364, 0, 706, 0 , 0, 35, 53, 0};
int charmm36m_prot_dim[14] = {5, 0, 0, 5, 0, 0, 8, 0, 8, 0, 0, 8, 6, 0};

/*
 Atoms
  0= Element, 1= Mass, 2= Key, 3= Description, 4= charmm36m_prot info
*/
char * charmm36m_prot_atoms[53][5]= {{"H", "1.00800", "H", "polar H", "31"},
                              {"H", "1.00800", "HC", "N-ter H", "32"},
                              {"H", "1.00800", "HA", "nonpolar H", "33"},
                              {"H", "1.00800", "HP", "aromatic H", "34"},
                              {"H", "1.00800", "HB1", "backbone H", "35"},
                              {"H", "1.00800", "HB2", "aliphatic backbone H, to CT2", "36"},
                              {"H", "1.00800", "HR1", "his he1, (+) his HG,HD2", "37"},
                              {"H", "1.00800", "HR2", "(+) his HE1", "38"},
                              {"H", "1.00800", "HR3", "neutral his HG, HD2", "39"},
                              {"H", "1.00800", "HS", "thiol hydrogen", "40"},
                              {"H", "1.00800", "HE1", "for alkene; RHC=CR", "41"},
                              {"H", "1.00800", "HE2", "for alkene; H2C=CR", "42"},
                              {"H", "1.00800", "HA1", "alkane, CH, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "43"},
                              {"H", "1.00800", "HA2", "alkane, CH2, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "44"},
                              {"H", "1.00800", "HA3", "alkane, CH3, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "45"},
                              {"C", "12.01100", "C", "carbonyl C, peptide backbone", "46"},
                              {"C", "12.01100", "CA", "aromatic C", "47"},
                              {"C", "12.01100", "CT", "aliphatic sp3 C, new LJ params, no hydrogens, see retinol stream file for parameters", "48"},
                              {"C", "12.01100", "CT1", "aliphatic sp3 C for CH", "49"},
                              {"C", "12.01100", "CT2", "aliphatic sp3 C for CH2", "50"},
                              {"C", "12.01100", "CT2A", "from CT2 (GLU, HSP chi1/chi2 fitting) 05282010, zhu", "51"},
                              {"C", "12.01100", "CT3", "aliphatic sp3 C for CH3", "52"},
                              {"C", "12.01100", "CPH1", "his CG and CD2 carbons", "53"},
                              {"C", "12.01100", "CPH2", "his CE1 carbon", "54"},
                              {"C", "12.01100", "CPT", "trp C between rings", "55"},
                              {"C", "12.01100", "CY", "TRP C in pyrrole ring", "56"},
                              {"C", "12.01100", "CP1", "tetrahedral C (proline CA)", "57"},
                              {"C", "12.01100", "CP2", "tetrahedral C (proline CB/CG)", "58"},
                              {"C", "12.01100", "CP3", "tetrahedral C (proline CD)", "59"},
                              {"C", "12.01100", "CC", "carbonyl C, asn,asp,gln,glu,cter,ct2", "60"},
                              {"C", "12.01100", "CD", "carbonyl C, pres aspp,glup,ct1", "61"},
                              {"C", "12.01100", "CS", "thiolate carbon", "62"},
                              {"C", "12.01100", "CE1", "for alkene; RHC=CR", "63"},
                              {"C", "12.01100", "CE2", "for alkene; H2C=CR", "64"},
                              {"C", "12.01100", "CAI", "aromatic C next to CPT in trp", "65"},
                              {"N", "14.00700", "N", "proline N", "66"},
                              {"N", "14.00700", "NR1", "neutral his protonated ring nitrogen", "67"},
                              {"N", "14.00700", "NR2", "neutral his unprotonated ring nitrogen", "68"},
                              {"N", "14.00700", "NR3", "charged his ring nitrogen", "69"},
                              {"N", "14.00700", "NH1", "peptide nitrogen", "70"},
                              {"N", "14.00700", "NH2", "amide nitrogen", "71"},
                              {"N", "14.00700", "NH3", "ammonium nitrogen", "72"},
                              {"N", "14.00700", "NC2", "guanidinium nitrogen", "73"},
                              {"N", "14.00700", "NY", "TRP N in pyrrole ring", "74"},
                              {"N", "14.00700", "NP", "Proline ring NH2+ (N-terminal)", "75"},
                              {"O", "15.99900", "O", "carbonyl oxygen", "76"},
                              {"O", "15.99900", "OB", "carbonyl oxygen in acetic acid", "77"},
                              {"O", "15.99900", "OC", "carboxylate oxygen", "78"},
                              {"O", "15.99900", "OH1", "hydroxyl oxygen", "79"},
                              {"O", "15.99940", "OS", "ester oxygen", "80"},
                              {"S", "32.06000", "S", "sulphur", "81"},
                              {"S", "32.06000", "SM", "sulfur C-S-S-C type", "82"},
                              {"S", "32.06000", "SS", "thiolate sulfur", "83"}};

/*
 Quadratic bonds
  0= Key_a, 1= Key_b, 2= R0 (A), 3= Kb (kcal mol^-1 A^2), 4= charmm36m_prot info

  V(R) = Kb x (R - R0)^2
*/
char * charmm36m_prot_bonds[132][5]= {{"NH2", "CT1", "240.000", "1.4550", " "},
                               {"CA", "CAI", "305.000", "1.3750", "from CA CA"},
                               {"CAI", "CAI", "305.000", "1.3750", "atm, methylindole, fit CCDSS"},
                               {"CPT", "CA", "300.000", "1.3600", "atm, methylindole, fit CCDSS"},
                               {"CPT", "CAI", "300.000", "1.3600", "atm, methylindole, fit CCDSS"},
                               {"CPT", "CPT", "360.000", "1.3850", "atm, methylindole, fit CCDSS"},
                               {"CY", "CA", "350.000", "1.3650", "trj, adm jr., 5/08/91, indole CCDB structure search"},
                               {"CY", "CAI", "350.000", "1.3650", "from CY CA"},
                               {"CY", "CPT", "350.000", "1.4300", "atm, methylindole, fit CDS data"},
                               {"CY", "CT3", "375.000", "1.4920", "atm, methylindole, fit CDS data"},
                               {"CY", "CT2", "375.000", "1.4920", "atm, methylindole, fit CDS data"},
                               {"HP", "CAI", "340.000", "1.0800", "from HP CA"},
                               {"HP", "CY", "350.000", "1.0800", "trp, adm jr., 12/30/91"},
                               {"NY", "CA", "270.000", "1.3700", "trp, adm jr., 12/30/91"},
                               {"NY", "CPT", "270.000", "1.3700", "atm, methylindole, from CCDS 1/17/04"},
                               {"NY", "H", "537.500", "0.9760", "atm, methylindole, 1/17/04"},
                               {"CA", "CA", "305.000", "1.3750", "benzene, JES 8/25/89"},
                               {"CE1", "CE1", "440.000", "1.3400", "for butene; from propene, yin/adm jr., 12/95"},
                               {"CE1", "CE2", "500.000", "1.3420", "for propene, yin/adm jr., 12/95"},
                               {"CE1", "CT2", "365.000", "1.5020", "for butene; from propene, yin/adm jr., 12/95"},
                               {"CE1", "CT3", "383.000", "1.5040", "for butene, yin/adm jr., 12/95"},
                               {"CE2", "CE2", "510.000", "1.3300", "for ethene, yin/adm jr., 12/95"},
                               {"CP1", "C", "250.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CP1", "CC", "250.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CP1", "CD", "200.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CP2", "CP1", "222.500", "1.5270", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CP2", "CP2", "222.500", "1.5370", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CP3", "CP2", "222.500", "1.5370", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"CPH1", "CPH1", "410.000", "1.3600", "histidine, adm jr., 6/27/90"},
                               {"CT1", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                               {"CT1", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                               {"CT1", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"CT1", "CT1", "222.500", "1.5000", "alkane update, adm jr., 3/2/92"},
                               {"CT2", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                               {"CT2", "CA", "230.000", "1.4900", "phe,tyr, JES 8/25/89"},
                               {"CT2", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                               {"CT2", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"CT2", "CPH1", "229.630", "1.5000", "his, adm jr., 7/22/89, FC from CT2CT, BL from crystals"},
                               {"CT2", "CT1", "222.500", "1.5380", "alkane update, adm jr., 3/2/92"},
                               {"CT2", "CT2", "222.500", "1.5300", "alkane update, adm jr., 3/2/92"},
                               {"CT3", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                               {"CT3", "CA", "230.000", "1.4900", "toluene, adm jr. 3/7/92"},
                               {"CT3", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                               {"CT3", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"CT3", "CPH1", "229.630", "1.5000", "his, adm jr., 7/22/89, FC from CT2CT, BL from crystals"},
                               {"CT3", "CS", "190.000", "1.5310", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"CT3", "CT1", "222.500", "1.5380", "alkane update, adm jr., 3/2/92"},
                               {"CT3", "CT2", "222.500", "1.5280", "alkane update, adm jr., 3/2/92"},
                               {"CT3", "CT3", "222.500", "1.5300", "alkane update, adm jr., 3/2/92"},
                               {"H", "CD", "330.000", "1.1100", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"HA1", "CC", "317.130", "1.1000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                               {"HA2", "CP2", "309.000", "1.1110", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"HA2", "CP3", "309.000", "1.1110", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"HA2", "CS", "300.000", "1.1110", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"HA3", "CS", "300.000", "1.1110", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"HA1", "CT1", "309.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                               {"HA2", "CT2", "309.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                               {"HA3", "CT3", "322.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                               {"HE1", "CE1", "360.500", "1.1000", "for propene, yin/adm jr., 12/95"},
                               {"HE2", "CE2", "365.000", "1.1000", "for ethene, yin/adm jr., 12/95"},
                               {"HB1", "CP1", "330.000", "1.0800", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"HB1", "CT1", "330.000", "1.0800", "Alanine Dipeptide ab initio calc's (LK)"},
                               {"HB2", "CT2", "330.000", "1.0800", "Alanine Dipeptide ab initio calc's (LK)"},
                               {"HP", "CA", "340.000", "1.0800", "phe,tyr JES 8/25/89"},
                               {"HR1", "CPH1", "375.000", "1.0830", "his, adm jr., 6/27/90"},
                               {"HR1", "CPH2", "340.000", "1.0900", "his, adm jr., 6/28/29"},
                               {"HR2", "CPH2", "333.000", "1.0700", "his, adm jr., 6/27/90"},
                               {"HR3", "CPH1", "365.000", "1.0830", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                               {"N", "C", "260.000", "1.3000", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"N", "CP1", "320.000", "1.4340", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"N", "CP3", "320.000", "1.4550", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"NC2", "C", "450.000", "1.3650", "mp2/6-311g** mgua vib. data, adm jr., 1/04"},
                               {"NC2", "CT2", "390.000", "1.4900", "mp2/6-311g** mgua vib. data, adm jr., 1/04"},
                               {"NC2", "CT3", "390.000", "1.4900", "mp2/6-311g** mgua vib. data, adm jr., 1/04"},
                               {"NC2", "HC", "455.000", "1.0000", "405.0->455.0 GUANIDINIUM (KK)"},
                               {"NH1", "C", "370.000", "1.3450", "Alanine Dipeptide ab initio calc's (LK)"},
                               {"NH1", "CT1", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                               {"NH1", "CT2", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                               {"NH1", "CT3", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                               {"NH1", "H", "440.000", "0.9970", "Alanine Dipeptide ab initio calc's (LK)"},
                               {"NH1", "HC", "405.000", "0.9800", "(DS)"},
                               {"NH2", "CC", "430.000", "1.3600", "adm jr. 4/10/91, acetamide"},
                               {"NH2", "CT2", "240.000", "1.4550", "from NH2 CT3, neutral glycine, adm jr."},
                               {"NH2", "CT3", "240.000", "1.4550", "methylamine geom/freq, adm jr., 6/2/92"},
                               {"NH2", "H", "480.000", "1.0000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                               {"NH2", "HC", "460.000", "1.0000", "methylamine geom/freq, adm jr., 6/2/92"},
                               {"NH3", "CT1", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                               {"NH3", "CT2", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                               {"NH3", "CT3", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                               {"NH3", "HC", "403.000", "1.0400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                               {"NP", "CP1", "320.000", "1.4850", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"NP", "CP3", "320.000", "1.5020", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"NP", "HC", "460.000", "1.0060", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                               {"NR1", "CPH1", "400.000", "1.3800", "his, ADM JR., 7/20/89"},
                               {"NR1", "CPH2", "400.000", "1.3600", "his, ADM JR., 7/20/89"},
                               {"NR1", "H", "466.000", "1.0000", "his, ADM JR., 7/20/89"},
                               {"NR2", "CPH1", "400.000", "1.3800", "his, ADM JR., 7/20/89"},
                               {"NR2", "CPH2", "400.000", "1.3200", "his, ADM JR., 7/20/89"},
                               {"NR3", "CPH1", "380.000", "1.3700", "his, adm jr., 6/28/90"},
                               {"NR3", "CPH2", "380.000", "1.3200", "his, adm jr., 6/27/90"},
                               {"NR3", "H", "453.000", "1.0000", "his, adm jr., 6/27/90"},
                               {"O", "C", "620.000", "1.2300", "Peptide geometry, condensed phase (LK)"},
                               {"O", "CC", "650.000", "1.2300", "adm jr. 4/10/91, acetamide"},
                               {"OB", "CC", "750.000", "1.2200", "adm jr., 10/17/90, acetic acid vibrations and geom."},
                               {"OB", "CD", "750.000", "1.2200", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"OC", "CA", "525.000", "1.2600", "adm jr. 8/27/91, phenoxide"},
                               {"OC", "CC", "525.000", "1.2600", "adm jr. 7/23/91, acetic acid"},
                               {"OC", "CT2", "450.000", "1.3300", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"OC", "CT3", "450.000", "1.3300", "methoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"OH1", "CA", "334.300", "1.4110", "MeOH, EMB 10/10/89,"},
                               {"OH1", "CD", "230.000", "1.4000", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"OH1", "CT1", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                               {"OH1", "CT2", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                               {"OH1", "CT3", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                               {"OH1", "H", "545.000", "0.9600", "EMB 11/21/89 methanol vib fit"},
                               {"OS", "CD", "150.000", "1.3340", "adm jr. 5/02/91, acetic acid pure solvent"},
                               {"OS", "CT3", "340.000", "1.4300", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                               {"S", "CT2", "198.000", "1.8180", "fitted to C-S s 9/26/92 (FL)"},
                               {"S", "CT3", "240.000", "1.8160", "fitted to C-S s 9/26/92 (FL)"},
                               {"S", "HS", "275.000", "1.3250", "methanethiol pure solvent, adm jr., 6/22/92"},
                               {"SM", "CT2", "214.000", "1.8160", "improved CSSC surface in DMDS 5/15/92 (FL)"},
                               {"SM", "CT3", "214.000", "1.8160", "improved CSSC surface in DMDS 5/15/92 (FL)"},
                               {"SM", "SM", "173.000", "2.0290", "improved CSSC surface in DMDS 5/15/92 (FL)"},
                               {"SS", "CS", "205.000", "1.8360", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                               {"HR1", "CD", "330.000", "1.1100", "acetaldehyde, benzaldehyde, 3ALP"},
                               {"O", "CD", "720.000", "1.2050", "acetaldehyde, benzaldehyde, 3ALP. from stream/toppar_all27_na_bkb_modifications.str"},
                               {"CT2A", "CT1", "222.500", "1.5380", "from CT2 CT1, Zhu"},
                               {"CT2", "CT2A", "222.500", "1.5300", "from CT2 CT2, Zhu"},
                               {"CT2A", "HA2", "309.000", "1.1110", "from HA2 CT2, Zhu"},
                               {"CT2A", "CPH1", "229.630", "1.5000", "from CT2 CPH1, Zhu"},
                               {"CT2A", "CC", "200.000", "1.5220", "from CT2 CC, jshim"},
                               {"CT1", "CS", "190.000", "1.5380", "from CT3 CS but lengthened; compare CT3 CT2 with CT2 CT1; kevo"}};

/*
 Quadratic angles:
  0= Key_a, 1= Key_b, 2= Key_c, 3= Ktheta (kcal mol^-1 rad^2), 4= Theta0 (deg)

  V(Theta) = Ktheta * (Theta - Theta0)^2

 Urey-Bradley angles:
  5= Kub (kcal mol^-1 A^2), 6= S0 (A), 7= charmm36m_prot info

  V(S) = Kub x (S - S0)^2
*/
char * charmm36m_prot_angles[364][8]= {{"H", "NH2", "CT1", "50.000", "111.00", " ", " ", "From LSN HC-NH2-CT2"},
                                {"H", "NH2", "CT2", "50.000", "111.00", " ", " ", "From LSN HC-NH2-CT2, Neutral Gly Nterminus"},
                                {"NH2", "CT1", "CT1", "67.700", "110.00", " ", " ", "From LSN NH2-CT2-CT2"},
                                {"NH2", "CT1", "CT2", "67.700", "110.00", " ", " ", "From LSN NH2-CT2-CT2"},
                                {"NH2", "CT1", "CT3", "67.700", "110.00", " ", " ", "From LSN NH2-CT2-CT2"},
                                {"CT1", "CD", "OH1", "55.000", "110.50", " ", " ", "From ASPP CT2-CD-OH1"},
                                {"CT3", "CT1", "CD", "52.000", "108.00", " ", " ", "Ala cter"},
                                {"NH2", "CT1", "HB1", "38.000", "109.50", "50.00", "2.1400", "From LSN NH2-CT2-HA"},
                                {"NH2", "CT1", "C", "50.000", "107.00", " ", " ", "From ALA Dipep. NH1-CT2-C"},
                                {"NH2", "CT2", "C", "50.000", "107.00", " ", " ", "From ALA Dipep. NH1-CT2-C, Neutral Gly Nterminus"},
                                {"CAI", "CAI", "CA", "40.000", "120.00", "35.00", "2.41620", "from CA CA CA"},
                                {"CAI", "CA", "CA", "40.000", "120.00", "35.00", "2.41620", "from CA CA CA"},
                                {"CPT", "CA", "CA", "50.000", "113.20", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CPT", "CPT", "CA", "50.000", "110.00", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CPT", "CAI", "CA", "50.000", "113.20", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CPT", "CPT", "CAI", "50.000", "110.00", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CPT", "CY", "CA", "85.000", "106.40", "25.00", "2.26100", "atm, methylindole, 1/17/04"},
                                {"CPT", "NY", "CA", "85.000", "112.00", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CT2", "CY", "CA", "30.000", "127.00", " ", " ", "atm, methylindole, CT3 CY CA"},
                                {"CT2", "CY", "CPT", "30.000", "126.70", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CT3", "CY", "CA", "30.000", "127.00", " ", " ", "atm, methylindole, CT3 CY CA"},
                                {"CT3", "CY", "CPT", "30.000", "126.70", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CY", "CPT", "CA", "130.000", "133.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CY", "CPT", "CAI", "130.000", "133.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CY", "CPT", "CPT", "85.000", "108.00", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CY", "CT2", "CT1", "58.350", "114.00", " ", " ", "from TRP crystal, JWK"},
                                {"CY", "CT2", "CT3", "58.350", "114.00", " ", " ", "from TRP crystal, JWK"},
                                {"H", "NY", "CA", "28.000", "126.00", " ", " ", "trp, adm jr., 12/30/91"},
                                {"H", "NY", "CAI", "28.000", "126.00", " ", " ", "trp, adm jr., 12/30/91"},
                                {"H", "NY", "CPT", "28.000", "126.00", " ", " ", "trp, adm jr., 12/30/91"},
                                {"HA2", "CT2", "CY", "55.000", "109.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"HA3", "CT3", "CY", "55.000", "109.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"HP", "CA", "CAI", "30.000", "120.00", "22.00", "2.15250", "from HP CA CA"},
                                {"HP", "CAI", "CA", "30.000", "120.00", "22.00", "2.15250", "from HP CA CA"},
                                {"HP", "CA", "CPT", "30.000", "122.00", "22.00", "2.14600", "trp, adm jr., 12/30/91"},
                                {"HP", "CAI", "CPT", "30.000", "122.00", "22.00", "2.14600", "from HP CA CPT"},
                                {"HP", "CA", "CY", "32.000", "125.00", "25.00", "2.17300", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                {"HP", "CY", "CA", "32.000", "126.40", "25.00", "2.18600", "trp, adm jr., 12/30/91"},
                                {"HP", "CY", "CPT", "32.000", "126.40", "25.00", "2.25500", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                {"NY", "CA", "CY", "85.000", "110.50", "25.00", "2.24000", "trp, adm jr., 12/30/91"},
                                {"NY", "CA", "HP", "32.000", "125.00", "25.00", "2.17700", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                {"NY", "CPT", "CA", "130.000", "129.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"NY", "CPT", "CAI", "130.000", "129.50", " ", " ", "atm, methylindole, 1/17/04"},
                                {"NY", "CPT", "CPT", "95.000", "107.40", " ", " ", "atm, methylindole, 1/17/04"},
                                {"CA", "CA", "CA", "40.000", "120.00", "35.00", "2.41620", "JES 8/25/89"},
                                {"CE1", "CE1", "CT2", "48.00", "123.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                {"CE1", "CE1", "CT3", "48.00", "123.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                {"CE1", "CT2", "CT3", "32.00", "112.20", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                {"CE2", "CE1", "CT2", "48.00", "126.00", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                {"CE2", "CE1", "CT3", "47.00", "125.20", " ", " ", "for propene, yin/adm jr., 12/95"},
                                {"CP1", "N", "C", "60.000", "117.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP2", "CP1", "C", "52.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP2", "CP1", "CC", "52.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP2", "CP1", "CD", "50.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP2", "CP2", "CP1", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP3", "CP2", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP3", "N", "C", "60.000", "117.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP3", "N", "CP1", "100.000", "114.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CP3", "NP", "CP1", "100.000", "111.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"CPH2", "NR1", "CPH1", "130.000", "107.5000", " ", " ", "his, adm jr., 6/27/90"},
                                {"CPH2", "NR2", "CPH1", "130.000", "104.0000", " ", " ", "his, adm jr., 6/27/90"},
                                {"CPH2", "NR3", "CPH1", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                {"CT1", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"CT1", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT1", "CT1", "CD", "52.000", "108.0000", " ", " ", "adm jr. 6/27/2012, for Thr with CT1 patch"},
                                {"CT1", "CT1", "CT1", "53.350", "111.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT1", "CT2", "CA", "51.800", "107.5000", " ", " ", "PARALLH19 (JES)"},
                                {"CT1", "CT2", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT1", "CT2", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"CT1", "CT2", "CPH1", "58.350", "113.0000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2CT, U-B omitted"},
                                {"CT1", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"CT1", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                {"CT2", "CA", "CA", "45.800", "122.3000", " ", " ", "PARALLH19 (JES)"},
                                {"CT2", "CPH1", "CPH1", "45.800", "130.0000", " ", " ", "his, ADM JR., 7/22/89, FC=>CT2CA CA,BA=> CRYSTALS"},
                                {"CT2", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"CT2", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT2A", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT2", "CT1", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"CT2", "CT1", "CT1", "53.350", "111.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT2", "CT2", "C", "52.000", "108.0000", " ", " ", "from CT2 CT1 C, for lactams, adm jr."},
                                {"CT2", "CT2", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT3", "CT2", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"CT2", "CT2", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"CT2A", "CT2", "CD", "52.000", "108.0000", " ", " ", " "},
                                {"CT2", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"CT2", "CT2", "CT2", "58.350", "113.60", "11.16", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT2", "CT3", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"CT2", "NC2", "C", "62.300", "120.0000", " ", " ", "107.5->120.0 to make planar Arg (KK)"},
                                {"CT2", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                {"CT2", "OS", "CD", "40.000", "109.60", "30.00", "2.26510", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"CT3", "CA", "CA", "45.800", "122.3000", " ", " ", "toluene, adm jr., 3/7/92"},
                                {"CT3", "CPH1", "CPH1", "45.800", "130.0000", " ", " ", "his, ADM JR., 7/22/89, FC=>CT2CA CA,BA=> CRYSTALS"},
                                {"CT3", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"CT3", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/09/92, for ALA cter"},
                                {"CT3", "CT1", "CT1", "53.350", "108.50", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT3", "CT1", "CT2", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT3", "CT1", "CT3", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT3", "CT2", "CA", "51.800", "107.5000", " ", " ", "ethylbenzene, adm jr., 3/7/92"},
                                {"CT3", "CT2", "CPH1", "58.350", "113.0000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2CT, U-B omitted"},
                                {"CT3", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"CT3", "CT2", "CT2", "58.000", "115.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT3", "CT2", "CT3", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                {"CT3", "NC2", "C", "62.300", "120.0000", " ", " ", "methylguanidinium, adm jr., 3/26/92"},
                                {"CT3", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                {"CT3", "OS", "CD", "40.000", "109.60", "30.00", "2.26510", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"CT3", "S", "CT2", "34.000", "95.0000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                {"H", "NH1", "C", "34.000", "123.0000", " ", " ", "NMA Vib Modes (LK)"},
                                {"H", "NH1", "CT1", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                {"H", "NH1", "CT2", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                {"H", "NH1", "CT3", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                {"H", "NH2", "CC", "50.000", "120.0000", " ", " ", "his, adm jr. 8/13/90 acetamide geometry and vibrations"},
                                {"H", "NH2", "H", "23.000", "120.0000", " ", " ", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                {"H", "NR1", "CPH1", "30.000", "125.50", "20.00", "2.15000", "his, adm jr., 6/27/90"},
                                {"H", "NR1", "CPH2", "30.000", "127.00", "20.00", "2.14000", "his, adm jr., 6/27/90"},
                                {"H", "NR3", "CPH1", "25.000", "126.00", "15.00", "2.13000", "his, adm jr., 6/27/90"},
                                {"H", "NR3", "CPH2", "25.000", "126.00", "15.00", "2.09000", "his, adm jr., 6/27/90"},
                                {"H", "OH1", "CA", "65.000", "108.0000", " ", " ", "JES 8/25/89 phenol"},
                                {"H", "OH1", "CD", "55.000", "115.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"H", "OH1", "CT1", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                {"H", "OH1", "CT2", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                {"H", "OH1", "CT3", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                {"HA2", "CP2", "CP1", "33.430", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CP2", "CP2", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CP2", "CP3", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CP2", "HA2", "35.500", "109.00", "5.40", "1.80200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CP3", "CP2", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CP3", "HA2", "35.500", "109.00", "5.40", "1.80200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HA2", "CS", "CT3", "34.600", "110.10", "22.53", "2.17900", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"HA2", "CS", "HA2", "35.500", "108.40", "14.00", "1.77500", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"HA3", "CS", "HA3", "35.500", "108.40", "14.00", "1.77500", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"HA1", "CT1", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                {"HA1", "CT1", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"HA1", "CT1", "CT1", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA1", "CT1", "CT2", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA1", "CT1", "CT3", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA1", "CT1", "HA1", "35.500", "109.00", "5.40", "1.80200", "based on HA CT2 HA"},
                                {"HA2", "CT2", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                {"HA2", "CT2", "CA", "49.300", "107.5000", " ", " ", "PARALLH19 (JES)"},
                                {"HA2", "CT2", "CC", "33.000", "109.50", "30.00", "2.16300", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"HA2", "CT2", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"HA2", "CT2", "CE1", "45.00", "111.50", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                {"HA2", "CT2", "CPH1", "33.430", "109.5000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2HA, U-B OMITTED"},
                                {"HA2", "CT2", "CT1", "26.500", "110.10", "22.53", "2.17900", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"HA2", "CT2", "CT2", "26.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA2", "CT2", "CT3", "34.600", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA2", "CT2", "HA2", "35.500", "109.00", "5.40", "1.80200", "alkane update, adm jr., 3/2/92"},
                                {"HA3", "CT3", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                {"HA3", "CT3", "CA", "49.300", "107.5000", " ", " ", "toluene, adm jr. 3/7/92"},
                                {"HA3", "CT3", "CC", "33.000", "109.50", "30.00", "2.16300", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"HA3", "CT3", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"HA3", "CT3", "CE1", "42.00", "111.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                {"HA3", "CT3", "CPH1", "33.430", "109.5000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2HA, U-B OMITTED"},
                                {"HA3", "CT3", "CS", "34.600", "110.10", "22.53", "2.17900", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"HA3", "CT3", "CT1", "33.430", "110.10", "22.53", "2.17900", "alkane frequencies (MJF), alkane geometries (SF)"},
                                {"HA3", "CT3", "CT2", "34.600", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA3", "CT3", "CT3", "37.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                {"HA3", "CT3", "HA3", "35.500", "108.40", "5.40", "1.80200", "alkane update, adm jr., 3/2/92"},
                                {"HE1", "CE1", "CE1", "52.00", "119.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                {"HE1", "CE1", "CE2", "42.00", "118.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                {"HE1", "CE1", "CT2", "40.00", "116.00", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                {"HE1", "CE1", "CT3", "22.00", "117.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                {"HE2", "CE2", "CE1", "45.00", "120.50", " ", " ", "for propene, yin/adm jr., 12/95"},
                                {"HE2", "CE2", "CE2", "55.50", "120.50", " ", " ", "for ethene, yin/adm jr., 12/95"},
                                {"HE2", "CE2", "HE2", "19.00", "119.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                {"HB1", "CP1", "C", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HB1", "CP1", "CC", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HB1", "CP1", "CD", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HB1", "CP1", "CP2", "35.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HB1", "CT1", "C", "50.000", "109.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HB1", "CT1", "CC", "50.000", "109.5000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"HB1", "CT1", "CD", "50.000", "109.5000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"HB1", "CT1", "CT1", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HB1", "CT1", "CT2", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HB1", "CT1", "CT3", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HB2", "CT2", "C", "50.000", "109.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HB2", "CT2", "CC", "50.000", "109.5000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"HB2", "CT2", "CD", "50.000", "109.5000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"HB2", "CT2", "HB2", "36.000", "115.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"HC", "NC2", "C", "49.000", "120.0000", " ", " ", "35.3->49.0 GUANIDINIUM (KK)"},
                                {"HC", "NC2", "CT2", "40.400", "120.0000", " ", " ", "107.5->120.0 to make planar Arg (KK)"},
                                {"HC", "NC2", "CT3", "40.400", "120.0000", " ", " ", "methylguanidinium, adm jr., 3/26/92"},
                                {"HC", "NC2", "HC", "25.000", "120.0000", " ", " ", "40.0->25.0 GUANIDINIUM (KK)"},
                                {"HC", "NH2", "CT2", "50.000", "111.0000", " ", " ", "from HC NH2 CT3, neutral glycine, adm jr."},
                                {"HC", "NH2", "CT3", "50.000", "111.0000", " ", " ", "methylamine geom/freq, adm jr., 6/2/92"},
                                {"HC", "NH2", "HC", "39.000", "106.5000", " ", " ", "40.0->25.0 GUANIDINIUM (KK)"},
                                {"HC", "NH3", "CT1", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"HC", "NH3", "CT2", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"HC", "NH3", "CT3", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"HC", "NH3", "HC", "44.000", "109.5000", " ", " ", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"HC", "NP", "CP1", "33.000", "109.50", "4.00", "2.05600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HC", "NP", "CP3", "33.000", "109.50", "4.00", "2.05600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HC", "NP", "HC", "51.000", "107.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"HP", "CA", "CA", "30.000", "120.00", "22.00", "2.15250", "JES 8/25/89 benzene"},
                                {"HR1", "CPH1", "CPH1", "22.000", "130.00", "15.00", "2.21500", "adm jr., 6/27/90, his"},
                                {"HR3", "CPH1", "CPH1", "25.000", "130.00", "20.00", "2.20000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                {"HS", "S", "CT2", "38.800", "95.0000", " ", " ", "methanethiol pure solvent, adm jr., 6/22/92"},
                                {"HS", "S", "CT3", "43.000", "95.0000", " ", " ", "methanethiol pure solvent, adm jr., 6/22/92"},
                                {"N", "C", "CP1", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "C", "CT1", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "C", "CT2", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "C", "CT3", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP1", "C", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP1", "CC", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP1", "CD", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP1", "CP2", "70.000", "110.8000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP1", "HB1", "48.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP3", "CP2", "70.000", "110.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"N", "CP3", "HA2", "48.000", "108.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NC2", "C", "NC2", "40.000", "120.00", "70.00", "2.31", "mp2/6-311g** mgua vib data, adm jr., 1/04"},
                                {"NC2", "CT2", "CT2", "67.700", "107.5000", " ", " ", "arg, (DS)"},
                                {"NC2", "CT2", "HA2", "56.500", "107.5000", " ", " ", "mp2/6-311g** mgua vib data, adm jr., 1/04"},
                                {"NC2", "CT3", "HA3", "56.5000", "107.5000", " ", " ", "mp2/6-311g** mgua vib data, adm jr., 1/04"},
                                {"NH1", "C", "CP1", "80.000", "116.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NH1", "C", "CT1", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                {"NH1", "C", "CT2", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                {"NH1", "C", "CT3", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                {"NH1", "CT1", "C", "50.000", "107.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT1", "CC", "50.000", "107.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"NH1", "CT1", "CD", "50.000", "107.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"NH1", "CT1", "CT1", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT1", "CT2", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT1", "CT3", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT1", "HB1", "48.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT2", "C", "50.000", "107.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT2", "CC", "50.000", "107.0000", " ", " ", "adm jr. 5/20/92, for asn,asp,gln,glu and cters"},
                                {"NH1", "CT2", "CD", "50.000", "107.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"NH1", "CT2", "CT2", "70.000", "113.5000", " ", " ", "from NH1 CT1 CT2, for lactams, adm jr."},
                                {"NH1", "CT2", "HA2", "51.500", "109.5000", " ", " ", "from NH1 CT3 HA, for lactams, adm jr."},
                                {"NH1", "CT2", "HB2", "48.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"NH1", "CT3", "HA3", "51.500", "109.5000", " ", " ", "NMA crystal (JCS)"},
                                {"NH2", "CC", "CP1", "80.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NH2", "CC", "CT1", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                {"NH2", "CC", "CT2", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                {"NH2", "CC", "CT3", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                {"NH2", "CC", "HA1", "44.000", "111.00", "50.00", "1.98000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                {"NH2", "CT2", "HB2", "38.000", "109.50", "50.00", "2.14000", "NH2 CT3 HA, neutral glycine, adm jr."},
                                {"NH2", "CT2", "CD", "52.000", "108.0000", " ", " ", "CT2 CT2 CD, neutral glycine, adm jr."},
                                {"NH2", "CT2", "CT2", "67.700", "110.0000", " ", " ", "NH3 CT2 CT2, neutral lysine"},
                                {"NH2", "CT2", "HA2", "38.000", "109.50", "50.00", "2.14000", "NH2 CT3 HA, neutral lysine"},
                                {"NH2", "CT3", "HA3", "38.000", "109.50", "50.00", "2.14000", "methylamine geom/freq, adm jr., 6/2/92"},
                                {"NH3", "CT1", "C", "43.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                {"NH3", "CT1", "CC", "43.700", "110.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"NH3", "CT1", "CT1", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                {"NH3", "CT1", "CT2", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                {"NH3", "CT1", "CT3", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                {"NH3", "CT1", "HB1", "51.500", "107.5000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                {"NH3", "CT2", "C", "43.700", "110.0000", " ", " ", "alanine (JCS)"},
                                {"NH3", "CT2", "CC", "43.700", "110.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                {"NH3", "CT2", "CD", "43.700", "110.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"NH3", "CT2", "CT2", "67.700", "110.0000", " ", " ", "methylammonium"},
                                {"NH3", "CT2", "CT3", "67.700", "110.0000", " ", " ", "ethylammonium"},
                                {"NH3", "CT2", "HA2", "45.000", "107.50", "35.00", "2.10100", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"NH3", "CT2", "HB2", "51.500", "107.5000", " ", " ", "for use on NTER -- from NH3 CT2HA (JCS) -- (LK)"},
                                {"NH3", "CT3", "HA3", "45.000", "107.50", "35.00", "2.10100", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                {"NP", "CP1", "C", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP1", "CC", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP1", "CD", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP1", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP1", "HB1", "51.500", "107.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP3", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NP", "CP3", "HA2", "51.500", "109.1500", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"NR1", "CPH1", "CPH1", "130.000", "106.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                {"NR1", "CPH1", "CT2", "45.800", "124.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                {"NR1", "CPH1", "CT3", "45.800", "124.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                {"NR1", "CPH1", "HR3", "25.000", "124.00", "20.00", "2.14000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                {"NR1", "CPH2", "HR1", "25.000", "122.50", "20.00", "2.14000", "his, adm jr., 6/27/90"},
                                {"NR2", "CPH1", "CPH1", "130.000", "110.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                {"NR2", "CPH1", "CT2", "45.800", "120.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                {"NR2", "CPH1", "HR3", "25.000", "120.00", "20.00", "2.14000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                {"NR2", "CPH2", "HR1", "25.000", "125.00", "20.00", "2.12000", "his, adm jr., 6/27/90"},
                                {"NR2", "CPH2", "NR1", "130.000", "112.5000", " ", " ", "his, adm jr., 6/27/90"},
                                {"NR3", "CPH1", "CPH1", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                {"NR3", "CPH1", "CT2", "45.800", "122.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                {"NR3", "CPH1", "HR1", "22.000", "122.00", "15.00", "2.18000", "his, adm jr., 6/27/90"},
                                {"NR3", "CPH2", "HR2", "32.000", "126.00", "25.00", "2.14000", "his, adm jr., 6/27/90"},
                                {"NR3", "CPH2", "NR3", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                {"O", "C", "CP1", "80.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"O", "C", "CT1", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"O", "C", "CT2", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"O", "C", "CT3", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                {"O", "C", "H", "50.000", "121.7000", " ", " ", "acetaldehyde (JCS)"},
                                {"O", "C", "N", "80.000", "122.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"O", "C", "NH1", "80.000", "122.5000", " ", " ", "NMA Vib Modes (LK)"},
                                {"O", "CC", "CP1", "80.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"O", "CC", "CT1", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                {"O", "CC", "CT2", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                {"O", "CC", "CT3", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                {"O", "CC", "HA1", "44.000", "122.0000", " ", " ", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                {"O", "CC", "NH2", "75.000", "122.50", "50.00", "2.37000", "adm jr. 4/10/91, acetamide update"},
                                {"OB", "CD", "CP1", "70.000", "125.00", "20.00", "2.44200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"OB", "CD", "CT1", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"OB", "CD", "CT2", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"OB", "CD", "CT3", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                {"OC", "CA", "CA", "40.000", "120.0000", " ", " ", "adm jr. 8/27/91, phenoxide"},
                                {"OC", "CC", "CP1", "40.000", "118.00", "50.00", "2.38800", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"OC", "CC", "CT1", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                {"OC", "CC", "CT2", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                {"OC", "CC", "CT3", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                {"OC", "CC", "OC", "100.000", "124.00", "70.00", "2.22500", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                {"OC", "CT2", "CT3", "65.000", "122.0000", " ", " ", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"OC", "CT2", "HA2", "65.000", "118.3000", " ", " ", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"OC", "CT3", "HA3", "65.000", "118.3000", " ", " ", "methoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"OH1", "CA", "CA", "45.200", "120.0000", " ", " ", "PARALLH19 WITH [122.3] (JES)"},
                                {"OH1", "CD", "CT2", "55.000", "110.5000", " ", " ", "adm jr, 10/17/90, acetic acid vibrations"},
                                {"OH1", "CD", "CT3", "55.000", "110.5000", " ", " ", "adm jr, 10/17/90, acetic acid vibrations"},
                                {"OH1", "CD", "OB", "50.000", "123.00", "210.00", "2.26200", "adm jr, 10/17/90, acetic acid vibrations"},
                                {"OH1", "CT1", "CT1", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT1", "CT3", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT1", "HA1", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT2", "CT1", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT2", "CT2", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT2", "CT3", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT2", "HA2", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OH1", "CT3", "HA3", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                {"OS", "CD", "CP1", "55.000", "109.00", "20.00", "2.32600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                {"OS", "CD", "CT1", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                {"OS", "CD", "CT2", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                {"OS", "CD", "CT3", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                {"OS", "CD", "OB", "90.000", "125.90", "160.00", "2.25760", "adm jr. 3/19/92, from lipid methyl acetate"},
                                {"OS", "CT2", "HA2", "60.000", "109.5000", " ", " ", "adm jr. 4/05/91, for PRES CT1 from methyl acetate"},
                                {"OS", "CT3", "HA3", "60.000", "109.5000", " ", " ", "adm jr. 4/05/91, for PRES CT1 from methyl acetate"},
                                {"S", "CT2", "CT1", "58.000", "112.5000", " ", " ", "as in expt.MeEtS and DALC crystal, 5/15/92"},
                                {"S", "CT2", "CT2", "58.000", "114.5000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                {"S", "CT2", "CT3", "58.000", "114.5000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                {"S", "CT2", "HA2", "46.100", "111.3000", " ", " ", "vib. freq. and HF/6-31G* geo. (DTN) 8/24/90"},
                                {"S", "CT3", "HA3", "46.100", "111.3000", " ", " ", "vib. freq. and HF/6-31G* geo. (DTN) 8/24/90"},
                                {"SM", "CT2", "CT1", "58.000", "112.5000", " ", " ", "as in expt.MeEtS and DALC crystal, 5/15/92"},
                                {"SM", "CT2", "CT3", "58.000", "112.5000", " ", " ", "diethyldisulfide, as in expt.MeEtS and DALC crystal, 5/15/92"},
                                {"SM", "CT2", "HA2", "38.000", "111.0000", " ", " ", "new S-S atom type 8/24/90"},
                                {"SM", "CT3", "HA3", "38.000", "111.0000", " ", " ", "new S-S atom type 8/24/90"},
                                {"SM", "SM", "CT2", "72.500", "103.3000", " ", " ", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                {"SM", "SM", "CT3", "72.500", "103.3000", " ", " ", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                {"SS", "CS", "CT3", "55.000", "118.0000", " ", " ", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"SS", "CS", "HA2", "40.000", "112.3000", " ", " ", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"SS", "CS", "HA3", "40.000", "112.3000", " ", " ", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                {"O", "CD", "HR1", "75.000", "121.0000", " ", " ", "GLU/HSP, Zhu"},
                                {"NH1", "CT1", "CT2A", "70.000", "113.5000", " ", " ", "from NH1 CT1 CT2"},
                                {"HB1", "CT1", "CT2A", "35.000", "111.0000", " ", " ", "from HB1 CT1 CT2"},
                                {"CT2A", "CT1", "C", "52.000", "108.0000", " ", " ", "from CT2 CT1 C"},
                                {"CT1", "CT2A", "HA2", "26.500", "110.1000", "22.53", "2.17900", "from HA2 CT2 CT1"},
                                {"CT1", "CT2A", "CT2", "58.350", "113.5000", "11.16", "2.56100", "from CT2 CT2 CT1"},
                                {"HA2", "CT2A", "HA2", "35.500", "109.0000", "5.40", "1.80200", "from HA2 CT2 HA2"},
                                {"HA2", "CT2A", "CT2", "26.500", "110.1000", "22.53", "2.17900", "from HA2 CT2 CT2"},
                                {"CT2A", "CT2", "HA2", "26.500", "110.1000", "22.53", "2.17900", "from HA2 CT2 CT2"},
                                {"CT2A", "CT2", "CC", "52.000", "108.0000", " ", " ", "from CT2 CT2 CC"},
                                {"CT1", "CT2A", "CPH1", "58.350", "113.0000", " ", " ", "from CT1 CT2 CPH1"},
                                {"HA2", "CT2A", "CPH1", "33.430", "109.5000", " ", " ", "from HA2 CT2 CPH1"},
                                {"CT2A", "CPH1", "CPH1", "45.800", "130.0000", " ", " ", "from CT2 CPH1 CPH1"},
                                {"CT2A", "CPH1", "NR3", "45.800", "122.0000", " ", " ", "from NR3 CPH1 CT2"},
                                {"CT1", "CT2A", "CC", "52.000", "108.0000", " ", " ", "from CT1 CT2 CC"},
                                {"HA2", "CT2A", "CC", "33.000", "109.5000", "30.00", "2.16300", "from HA2 CT2 CC"},
                                {"OC", "CC", "CT2A", "40.000", "118.0000", "50.00", "2.38800", "from OC CC CT2"},
                                {"NH3", "CT1", "CT2A", "67.700", "110.0000", " ", " ", "from NH3 CT1 CT2"},
                                {"CT2A", "CT1", "CD", "52.000", "108.0000", " ", " ", "from CT2 CT1 CD"},
                                {"NH2", "CT1", "CS", "67.700", "110.0000", " ", " ", "from NH2 CT1 CT2 , kevo"},
                                {"CS", "CT1", "C", "52.000", "108.0000", " ", " ", "from CT2 CT1 C , kevo"},
                                {"CS", "CT1", "CC", "52.000", "108.0000", " ", " ", "from CT2 CT1 CC , kevo"},
                                {"CS", "CT1", "CD", "52.000", "108.0000", " ", " ", "from CT2 CT1 CD , kevo"},
                                {"HB1", "CT1", "CS", "35.000", "111.0000", " ", " ", "from HB1 CT1 CT2 , kevo"},
                                {"NH1", "CT1", "CS", "70.000", "113.5000", " ", " ", "from NH1 CT1 CT2 , kevo"},
                                {"NH3", "CT1", "CS", "67.700", "110.0000", " ", " ", "from NH3 CT1 CT2 , kevo"},
                                {"SS", "CS", "CT1", "55.000", "118.0000", " ", " ", "from SS CS CT3 , kevo"},
                                {"HA2", "CS", "CT1", "34.600", "110.10", "22.53", "2.17900", "from HA2 CS CT3 to be consistent with SS CS CT1, kevo"},
                                {"OC", "CT2", "CT1", "65.000", "122.0000", " ", " ", "from OC CT2 CT3 , kevo"}};

/*
 Dihedrals
  0-3= Keys, 4= Kchi (kcal mol^-1), 5= n (multi), 6= delta (deg), 7= charmm36m_prot info

  V(chi) = Kchi x (1 + cos (n x (chi) - delta))
*/
char * charmm36m_prot_dihedrals[706][8]= {{"NH2", "CT1", "C", "O", "0.0000", "1", "0.00", " "},
                                   {"NH2", "CT2", "C", "O", "0.0000", "1", "0.00", "Neutral Gly Nterminus"},
                                   {"NH2", "CT1", "C", "NH1", "0.0000", "1", "0.00", " "},
                                   {"NH2", "CT2", "C", "NH1", "0.0000", "1", "0.00", "Neutral Gly Nterminus"},
                                   {"H", "NH2", "CT1", "CT1", "0.0000", "1", "0.00", " "},
                                   {"H", "NH2", "CT1", "C", "0.0000", "1", "0.00", " "},
                                   {"H", "NH2", "CT2", "C", "0.0000", "1", "0.00", "Neutral Gly Nterminus"},
                                   {"H", "NH2", "CT1", "HB1", "0.1100", "3", "0.00", "From LSN HC-NH2-CT2-HA"},
                                   {"H", "NH2", "CT2", "HB2", "0.1100", "3", "0.00", "From LSN HC-NH2-CT2-HA, Neutral Gly Nterminus"},
                                   {"H", "NH2", "CT1", "CT2", "0.1100", "3", "0.00", "From LSN HC-NH2-CT2-CT2"},
                                   {"H", "NH2", "CT1", "CT3", "0.1100", "3", "0.00", "From LSN HC-NH2-CT2-CT2"},
                                   {"CAI", "CA", "CA", "CAI", "3.1000", "2", "180.00", "from CA CA CA CA"},
                                   {"CA", "CPT", "CPT", "CA", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CAI", "CPT", "CPT", "CAI", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CA", "CY", "CPT", "CA", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CA", "CY", "CPT", "CAI", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CA", "NY", "CPT", "CA", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CPT", "CA", "CA", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"CPT", "CPT", "CA", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"CA", "NY", "CPT", "CAI", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CPT", "CAI", "CA", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"CPT", "CPT", "CAI", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"CPT", "CPT", "CY", "CA", "5.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CPT", "CPT", "NY", "CA", "6.5000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CT3", "CY", "CPT", "CA", "2.5000", "2", "180.00", "atm, methylindole, r6r5"},
                                   {"CT3", "CY", "CPT", "CAI", "2.5000", "2", "180.00", "atm, methylindole, r6r5"},
                                   {"CT3", "CY", "CPT", "CPT", "3.0000", "2", "180.00", "atm, methylindole, meth"},
                                   {"CT2", "CY", "CPT", "CA", "2.5000", "2", "180.00", "atm, methylindole, r6r5"},
                                   {"CT2", "CY", "CPT", "CAI", "2.5000", "2", "180.00", "atm, methylindole, r6r5"},
                                   {"CT2", "CY", "CPT", "CPT", "3.0000", "2", "180.00", "atm, methylindole, meth"},
                                   {"CY", "CA", "NY", "CPT", "6.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CY", "CPT", "CA", "CA", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CY", "CPT", "CPT", "CA", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CY", "CPT", "CAI", "CA", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"CY", "CPT", "CPT", "CAI", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"H", "NY", "CA", "CY", "0.0500", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"H", "NY", "CPT", "CA", "0.2000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"H", "NY", "CPT", "CAI", "0.2000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"H", "NY", "CPT", "CPT", "0.8500", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"HP", "CAI", "CA", "CA", "4.2000", "2", "180.00", "from HP CA CA CA"},
                                   {"HP", "CA", "CA", "CPT", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"HP", "CA", "CPT", "CPT", "3.0000", "2", "180.00", "JWK indole 05/14/91"},
                                   {"HP", "CA", "CPT", "CY", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"HP", "CA", "CA", "CAI", "4.2000", "2", "180.00", "from HP CA CA CA"},
                                   {"HP", "CA", "CAI", "CPT", "3.0000", "2", "180.00", "from HP CA CA CPT"},
                                   {"HP", "CAI", "CA", "HP", "2.4000", "2", "180.00", "from HP CA CA HP"},
                                   {"HP", "CAI", "CPT", "CPT", "3.0000", "2", "180.00", "from HP CA CPT CPT"},
                                   {"HP", "CAI", "CPT", "CY", "4.0000", "2", "180.00", "from HP CA CPT CY, r6r5"},
                                   {"HP", "CA", "CY", "CPT", "2.8000", "2", "180.00", "adm jr., 12/30/91, for jwk"},
                                   {"HP", "CA", "CY", "CT3", "1.2000", "2", "180.00", "atm, methylindole"},
                                   {"HP", "CA", "CY", "CT2", "1.2000", "2", "180.00", "atm, methylindole"},
                                   {"HP", "CA", "NY", "CPT", "2.6000", "2", "180.00", "adm jr., 12/30/91, for jwk"},
                                   {"HP", "CA", "NY", "H", "0.4000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"HP", "CY", "CA", "HP", "1.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"HP", "CY", "CPT", "CA", "2.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"HP", "CY", "CPT", "CAI", "2.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"HP", "CY", "CPT", "CPT", "2.6000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                   {"NY", "CA", "CY", "CPT", "5.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"NY", "CA", "CY", "CT3", "2.5000", "2", "180.00", "atm, methylindole, from NY CA CY CT3"},
                                   {"NY", "CA", "CY", "CT2", "2.5000", "2", "180.00", "atm, methylindole, from NY CA CY CT3"},
                                   {"NY", "CA", "CY", "HP", "3.5000", "2", "180.00", "JWK indole 05/14/91"},
                                   {"NY", "CPT", "CA", "CA", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04, r6r5"},
                                   {"NY", "CPT", "CA", "HP", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole, r6r5"},
                                   {"NY", "CPT", "CPT", "CA", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04, bfly"},
                                   {"NY", "CPT", "CAI", "CA", "3.0000", "2", "180.00", "atm, methylindole, 1/17/04"},
                                   {"NY", "CPT", "CAI", "HP", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole, r6r5"},
                                   {"NY", "CPT", "CPT", "CAI", "4.0000", "2", "180.00", "atm, methylindole, 1/17/04, bfly"},
                                   {"NY", "CPT", "CPT", "CY", "6.5000", "2", "180.00", "JWK 05/14/91 fit to indole, r5 t1"},
                                   {"CT3", "CT2", "CY", "CA", "0.3800", "2", "0.00", "trp, from ethylbenzene, adm jr., 3/7/92"},
                                   {"CT3", "CT2", "CY", "CPT", "0.2500", "2", "180.00", "atm 1/14/04 3-ethylindole"},
                                   {"CT3", "CT2", "CY", "CPT", "0.3000", "3", "0.00", "atm 1/14/04 3-ethylindole"},
                                   {"HA3", "CT3", "CY", "CA", "0.0100", "3", "0.00", "atm, methylindole, 1/17/04"},
                                   {"HA3", "CT3", "CY", "CPT", "0.2000", "3", "0.00", "atm, methylindole, 1/17/04"},
                                   {"HA2", "CT2", "CY", "CA", "0.0100", "3", "0.00", "atm, methylindole, 1/17/04"},
                                   {"HA2", "CT2", "CY", "CPT", "0.2000", "3", "0.00", "atm, methylindole, 1/17/04"},
                                   {"X", "CS", "SS", "X", "0.0000", "3", "0.20", "methanethiol, HS S CT3 HA"},
                                   {"C", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"C", "CT2", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"C", "N", "CP1", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CA", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89"},
                                   {"CC", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CC", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                   {"CC", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"CC", "CT2", "NH1", "C", "2.0000", "1", "180.00", "Based on Gly3 data from graf et al, RB 7/1/11"},
                                   {"CD", "CP1", "N", "C", "0.0000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CD", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"CD", "CT2", "NH1", "C", "2.0000", "1", "180.00", "Based on Gly3 data from graf et al, RB 7/1/11"},
                                   {"CE1", "CE1", "CT3", "HA3", "0.0300", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                   {"CE2", "CE1", "CT2", "CT3", "0.5000", "1", "180.00", "1-butene, adm jr., 2/00 update"},
                                   {"CE2", "CE1", "CT2", "CT3", "1.3000", "3", "180.00", "1-butene, adm jr., 2/00 update"},
                                   {"CE2", "CE1", "CT2", "HA2", "0.1200", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                   {"CE2", "CE1", "CT3", "HA3", "0.0500", "3", "180.00", "for propene, yin/adm jr., 12/95"},
                                   {"CP1", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP1", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP2", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP2", "CP3", "N", "C", "0.0000", "3", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP2", "CP3", "N", "CP1", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP2", "CP3", "NP", "CP1", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "N", "C", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "N", "C", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "N", "CP1", "C", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "N", "CP1", "CC", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "N", "CP1", "CP2", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "NP", "CP1", "C", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "NP", "CP1", "CC", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "NP", "CP1", "CD", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CP3", "NP", "CP1", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CPH2", "NR1", "CPH1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"CPH2", "NR2", "CPH1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"CPH2", "NR3", "CPH1", "CPH1", "12.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"CT1", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT1", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT1", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT1", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT1", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT1", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT1", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"CT1", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT1", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT2", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT2", "C", "NH1", "CT2", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT2", "C", "NH1", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT2", "C", "NH1", "CT3", "1.6000", "1", "0.00", "from CT2 C NH1 CT2, adm jr. 10/21/96"},
                                   {"CT2", "C", "NH1", "CT3", "2.5000", "2", "180.00", "from CT2 C NH1 CT2, adm jr. 10/21/96"},
                                   {"CT2", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89 toluene and ethylbenzene"},
                                   {"CT2", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR1 CPH2"},
                                   {"CT2", "CPH1", "NR2", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR2 CPH2"},
                                   {"CT2", "CPH1", "NR3", "CPH2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"CT2", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"CT2", "CT2", "CPH1", "CPH1", "0.4000", "1", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. ADM JR., 9/4/89"},
                                   {"CT2", "CT2", "CT2", "CT2", "0.10", "2", "180.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "CT2", "CT2", "0.15", "4", "0.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "CT2", "CT2", "0.10", "6", "180.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "CT2", "CT3", "0.10", "2", "180.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "CT2", "CT3", "0.15", "4", "0.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "CT2", "CT3", "0.10", "6", "180.00", "alkane, 4/98, adm jr."},
                                   {"CT2", "CT2", "NH1", "C", "1.8000", "1", "0.00", "from CT2 CT1 NH1 C, for lactams, adm jr."},
                                   {"CT2", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT2", "NH1", "C", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT2", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT2", "SM", "SM", "CT2", "1.0000", "1", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                   {"CT2", "SM", "SM", "CT2", "4.1000", "2", "0.00", "mp 6-311G** dimethyldisulfide, 3/26/92 (FL)"},
                                   {"CT2", "SM", "SM", "CT2", "0.9000", "3", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                   {"CT3", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT3", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT3", "C", "NH1", "CT2", "1.6000", "1", "0.00", "for acetylated GLY N-terminus, adm jr."},
                                   {"CT3", "C", "NH1", "CT2", "2.5000", "2", "180.00", "for acetylated GLY N-terminus, adm jr."},
                                   {"CT3", "C", "NH1", "CT3", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT3", "C", "NH1", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT3", "CA", "CA", "CA", "3.1000", "2", "180.00", "toluene, adm jr., 3/7/92"},
                                   {"CT3", "CE1", "CE2", "HE2", "5.2000", "2", "180.00", "for propene, yin/adm jr., 12/95"},
                                   {"CT3", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR1 CPH2"},
                                   {"CT3", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"CT3", "CT2", "CA", "CA", "0.2300", "2", "180.00", "ethylbenzene ethyl rotation, adm jr. 3/7/92"},
                                   {"CT3", "CT2", "CPH1", "CPH1", "0.2000", "1", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                   {"CT3", "CT2", "CPH1", "CPH1", "0.2700", "2", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                   {"CT3", "CT2", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                   {"CT3", "CT2", "S", "CT3", "0.2400", "1", "180.00", "expt. MeEtS, 3/26/92 (FL)"},
                                   {"CT3", "CT2", "S", "CT3", "0.3700", "3", "0.00", "DTN 8/24/90"},
                                   {"CT3", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"CT3", "NH1", "C", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                   {"CT3", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"CT3", "S", "CT2", "CT2", "0.2400", "1", "180.00", "expt. MeEtS, 3/26/92 (FL)"},
                                   {"CT3", "S", "CT2", "CT2", "0.3700", "3", "0.00", "expt. MeEtS, 3/26/92 (FL)"},
                                   {"CT3", "SM", "SM", "CT3", "1.0000", "1", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                   {"CT3", "SM", "SM", "CT3", "4.1000", "2", "0.00", "mp 6-311G** dimethyldisulfide, 3/26/92 (FL)"},
                                   {"CT3", "SM", "SM", "CT3", "0.9000", "3", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                   {"H", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"H", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"H", "NH1", "C", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"H", "NH1", "C", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"H", "NH1", "CT1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH1", "CT1", "CC", "0.0000", "1", "0.00", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                   {"H", "NH1", "CT1", "CD", "0.0000", "1", "0.00", "adm jr. 5/02/91, acetic acid pure solvent"},
                                   {"H", "NH1", "CT1", "CT1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH1", "CT1", "CT2", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH1", "CT1", "CT3", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH1", "CT2", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH1", "CT2", "CC", "0.0000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                   {"H", "NH1", "CT2", "CD", "0.0000", "1", "0.00", "adm jr. 5/02/91, acetic acid pure solvent"},
                                   {"H", "NH1", "CT2", "CT2", "0.0000", "1", "0.00", "from H NH1 CT2 CT3, for lactams, adm jr."},
                                   {"H", "NH1", "CT2", "CT3", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"H", "NH2", "CC", "CT1", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                   {"H", "NH2", "CC", "CT2", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                   {"H", "NH2", "CC", "CT3", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                   {"H", "NH2", "CC", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"H", "NR1", "CPH1", "CPH1", "1.0000", "2", "180.00", "his, adm jr., 7/20/89"},
                                   {"H", "NR1", "CPH1", "CT2", "1.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HA CPH1 NR1 H"},
                                   {"H", "NR1", "CPH1", "CT3", "1.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HA CPH1 NR1 H"},
                                   {"H", "NR3", "CPH1", "CPH1", "1.4000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"H", "NR3", "CPH1", "CT2", "3.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HC NR3 CPH1 HA"},
                                   {"H", "NR3", "CPH1", "CT3", "3.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HC NR3 CPH1 HA"},
                                   {"H", "OH1", "CA", "CA", "0.9900", "2", "180.00", "phenol OH rot bar, 3.37 kcal/mole, adm jr. 3/7/92"},
                                   {"H", "OH1", "CT1", "CT3", "1.3300", "1", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT1", "CT3", "0.1800", "2", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT1", "CT3", "0.3200", "3", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT2", "1.3000", "1", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT2", "0.3000", "2", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT2", "0.4200", "3", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT3", "1.3000", "1", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT3", "0.3000", "2", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"H", "OH1", "CT2", "CT3", "0.4200", "3", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                   {"HA1", "CC", "NH2", "H", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                   {"HA2", "CP3", "N", "C", "0.0000", "3", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HA2", "CP3", "N", "CP1", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HA2", "CP3", "NP", "CP1", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HA1", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                   {"HA2", "CT2", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. adm jr., 9/4/89"},
                                   {"HA2", "CT2", "NH1", "C", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"HA2", "CT2", "NH1", "H", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"HA2", "CT2", "S", "CT3", "0.2800", "3", "0.00", "DTN 8/24/90"},
                                   {"HA3", "CT3", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. adm jr., 9/4/89"},
                                   {"HA3", "CT3", "CS", "HA2", "0.1600", "3", "0.00", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                   {"HA3", "CT3", "CS", "HA3", "0.1600", "3", "0.00", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                   {"HA3", "CT3", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                   {"HA3", "CT3", "NH1", "C", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"HA3", "CT3", "NH1", "H", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"HA3", "CT3", "S", "CT2", "0.2800", "3", "0.00", "DTN 8/24/90"},
                                   {"HE1", "CE1", "CE1", "HE1", "1.0000", "2", "180.00", "2-butene, adm jr., 8/98 update"},
                                   {"CT3", "CE1", "CE1", "HE1", "1.0000", "2", "180.00", "2-butene, adm jr., 8/98 update"},
                                   {"HE1", "CE1", "CE2", "HE2", "5.2000", "2", "180.00", "for propene, yin/adm jr., 12/95"},
                                   {"HE1", "CE1", "CT2", "HA2", "0.0000", "3", "0.00", "butene, adm jr., 2/00 update"},
                                   {"HE1", "CE1", "CT2", "CT3", "0.1200", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                   {"HE1", "CE1", "CT3", "HA3", "0.0000", "3", "0.00", "butene, adm jr., 2/00 update"},
                                   {"HE2", "CE2", "CE1", "CT2", "5.2000", "2", "180.00", "for butene, yin/adm jr., 12/95"},
                                   {"HB1", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HB1", "CP1", "N", "CP3", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HB1", "CP1", "NP", "CP3", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HB1", "CT1", "NH1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"HB1", "CT1", "NH1", "H", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"HB2", "CT2", "NH1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"HB2", "CT2", "NH1", "H", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"HC", "NH2", "CT2", "HB2", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral glycine, adm jr."},
                                   {"HC", "NH2", "CT2", "CD", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral glycine, adm jr."},
                                   {"HC", "NH2", "CT2", "CT2", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral lysine"},
                                   {"HC", "NH2", "CT2", "HA2", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral lysine"},
                                   {"HC", "NP", "CP1", "C", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP1", "CC", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP1", "CD", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP1", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP1", "HB1", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP3", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HC", "NP", "CP3", "HA2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"HP", "CA", "CA", "CA", "4.2000", "2", "180.00", "JES 8/25/89 benzene"},
                                   {"HP", "CA", "CA", "CT2", "4.2000", "2", "180.00", "JES 8/25/89 toluene and ethylbenzene"},
                                   {"HP", "CA", "CA", "CT3", "4.2000", "2", "180.00", "toluene, adm jr., 3/7/92"},
                                   {"HP", "CA", "CA", "HP", "2.4000", "2", "180.00", "JES 8/25/89 benzene"},
                                   {"HR1", "CPH1", "CPH1", "CT2", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH1", "CPH1", "CT3", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH1", "CPH1", "HR1", "1.0000", "2", "180.00", "his, adm jr., 6/27/90, his"},
                                   {"HR1", "CPH1", "NR3", "CPH2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH1", "NR3", "H", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH2", "NR1", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH2", "NR1", "H", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR1", "CPH2", "NR2", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR2", "CPH2", "NR3", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"HR2", "CPH2", "NR3", "H", "0.0000", "2", "180.00", "his, adm jr., 6/27/90, YES, 0.0"},
                                   {"HR3", "CPH1", "CPH1", "CT2", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HR3", "CPH1", "CPH1", "CT3", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HR3", "CPH1", "CPH1", "HR3", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HR3", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HR3", "CPH1", "NR1", "H", "1.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HR3", "CPH1", "NR2", "CPH2", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"HS", "S", "CT2", "CT3", "0.2400", "1", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                   {"HS", "S", "CT2", "CT3", "0.1500", "2", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                   {"HS", "S", "CT2", "CT3", "0.2700", "3", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                   {"HS", "S", "CT2", "HA2", "0.2000", "3", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                   {"HS", "S", "CT3", "HA3", "0.2000", "3", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                   {"N", "C", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CP1", "HB1", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CP1", "HB1", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT1", "CT1", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT1", "CT2", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT1", "CT3", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT1", "HB1", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT2", "HB2", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "C", "CT3", "HA3", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"N", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                   {"NH1", "C", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CP1", "HB1", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CP1", "HB1", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "C", "CT1", "CT1", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                   {"NH1", "C", "CT1", "CT2", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                   {"NH1", "C", "CT1", "CT3", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                   {"NH1", "C", "CT1", "HB1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"NH1", "C", "CT1", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                   {"NH1", "C", "CT2", "CT2", "0.0000", "1", "0.00", "from NH1 C CT1 CT2, for lactams, adm jr."},
                                   {"NH1", "C", "CT2", "HA2", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"NH1", "C", "CT2", "HB2", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"NH1", "C", "CT2", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                   {"NH1", "C", "CT3", "HA3", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                   {"NH1", "CT1", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH1", "CT2", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "HB1", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "HB1", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH2", "CC", "CT2", "HA2", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                   {"NH3", "CT1", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH3", "CT1", "C", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                   {"NH3", "CT1", "CC", "NH2", "0.4000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                   {"NH3", "CT2", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NH3", "CT2", "C", "NH1", "1.0000", "1", "0.00", "RB 1/07/11, based on graf et al Gly 3 N-ter J-couplings for PRES GLYP"},
                                   {"NH3", "CT2", "CC", "NH2", "0.4000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                   {"NP", "CP1", "C", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NP", "CP1", "C", "NH1", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NP", "CP1", "CC", "NH2", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"NR1", "CPH1", "CPH1", "CT2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR1 CPH1 CPH1 HA"},
                                   {"NR1", "CPH1", "CPH1", "CT3", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR1 CPH1 CPH1 HA"},
                                   {"NR1", "CPH1", "CPH1", "HR3", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"NR1", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR1", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR1", "CPH1", "CT2", "HA2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR1", "CPH1", "CT3", "HA3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR1", "CPH2", "NR2", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"NR2", "CPH1", "CPH1", "CT2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR2 CPH1 CPH1 HA"},
                                   {"NR2", "CPH1", "CPH1", "CT3", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR2 CPH1 CPH1 HA"},
                                   {"NR2", "CPH1", "CPH1", "HR3", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                   {"NR2", "CPH1", "CPH1", "NR1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"NR2", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "HIS CB-CG TORSION,"},
                                   {"NR2", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "HIS CB-CG TORSION,"},
                                   {"NR2", "CPH1", "CT2", "HA2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR2", "CPH1", "CT3", "HA3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR2", "CPH2", "NR1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"NR2", "CPH2", "NR1", "H", "1.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"NR3", "CPH1", "CPH1", "CT2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"NR3", "CPH1", "CPH1", "CT3", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"NR3", "CPH1", "CPH1", "HR1", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"NR3", "CPH1", "CPH1", "NR3", "12.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"NR3", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR3", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR3", "CPH1", "CT2", "HA2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR3", "CPH1", "CT3", "HA3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                   {"NR3", "CPH2", "NR3", "CPH1", "12.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                   {"NR3", "CPH2", "NR3", "H", "1.4000", "2", "180.00", "his, adm jr., 6/27/90"},
                                   {"O", "C", "CP1", "CP2", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "CP1", "HB1", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "CP1", "HB1", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "CT1", "CT1", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"O", "C", "CT1", "CT2", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"O", "C", "CT1", "CT3", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                   {"O", "C", "CT1", "HB1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"O", "C", "CT1", "NH1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"O", "C", "CT1", "NH3", "0.0000", "1", "0.00", "Backbone parameter set made complete RLD 8/8/90"},
                                   {"O", "C", "CT2", "CT2", "1.4000", "1", "0.00", "from O C CT1 CT2, for lactams, adm jr."},
                                   {"O", "C", "CT2", "HA2", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                   {"O", "C", "CT2", "HB2", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"O", "C", "CT2", "NH1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                   {"O", "C", "CT2", "NH3", "0.0000", "1", "0.00", "Backbone parameter set made complete RLD 8/8/90"},
                                   {"O", "C", "CT3", "HA3", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                   {"O", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"O", "C", "NH1", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"O", "C", "NH1", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"O", "C", "NH1", "H", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                   {"O", "CC", "CP1", "CP2", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "CC", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "CC", "CP1", "HB1", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "CC", "CP1", "HB1", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "CC", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"O", "CC", "CT2", "HA2", "0.0000", "3", "180.00", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                   {"O", "CC", "NH2", "H", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                   {"OB", "CD", "OS", "CT2", "0.9650", "1", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"OB", "CD", "OS", "CT2", "3.8500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"OB", "CD", "OS", "CT3", "0.9650", "1", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"OB", "CD", "OS", "CT3", "3.8500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"OC", "CA", "CA", "CA", "3.1000", "2", "180.00", "adm jr. 8/27/91, phenoxide"},
                                   {"OC", "CA", "CA", "HP", "4.2000", "2", "180.00", "adm jr. 8/27/91, phenoxide"},
                                   {"OC", "CC", "CP1", "CP2", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"OC", "CC", "CP1", "HB1", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"OC", "CC", "CP1", "N", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"OC", "CC", "CP1", "NP", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"OC", "CC", "CT1", "NH3", "3.2000", "2", "180.00", "adm jr. 4/17/94, zwitterionic glycine"},
                                   {"OC", "CC", "CT2", "NH3", "3.2000", "2", "180.00", "adm jr. 4/17/94, zwitterionic glycine"},
                                   {"OH1", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89 phenol"},
                                   {"OH1", "CA", "CA", "HP", "4.2000", "2", "180.00", "JES 8/25/89 phenol"},
                                   {"S", "CT2", "CT2", "HA2", "0.0100", "3", "0.00", "DTN 8/24/90"},
                                   {"SM", "CT2", "CT2", "HA2", "0.0100", "3", "0.00", "DTN 8/24/90"},
                                   {"SM", "SM", "CT2", "CT1", "0.3100", "3", "0.00", "S-S for cys-cys, dummy parameter for now ... DTN 9/04/90"},
                                   {"SM", "SM", "CT2", "CT2", "0.3100", "3", "0.00", "S-S for cys-cys, dummy parameter for now ... DTN 9/04/90"},
                                   {"SM", "SM", "CT2", "CT3", "0.3100", "3", "0.00", "S-S for cys-cys, dummy parameter for now ... DTN 9/04/90"},
                                   {"SM", "SM", "CT2", "HA2", "0.1580", "3", "0.00", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                   {"SM", "SM", "CT3", "HA3", "0.1580", "3", "0.00", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                   {"SS", "CS", "CT3", "HA3", "0.1500", "3", "0.00", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                   {"X", "C", "NC2", "X", "2.2500", "2", "180.00", "9.0->2.25 GUANIDINIUM (KK)"},
                                   {"X", "CD", "OH1", "X", "2.0500", "2", "180.00", "adm jr, 10/17/90, acetic acid C-Oh rotation barrier"},
                                   {"X", "CD", "OS", "X", "2.0500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CE1", "CE1", "X", "0.1500", "1", "0.00", "2-butene, adm jr., 2/00 update"},
                                   {"X", "CE1", "CE1", "X", "8.5000", "2", "180.00", "2-butene, adm jr., 2/00 update"},
                                   {"X", "CE2", "CE2", "X", "4.9000", "2", "180.00", "for ethene, yin/adm jr., 12/95"},
                                   {"X", "CP1", "C", "X", "0.0000", "6", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"X", "CP1", "CC", "X", "0.0000", "6", "180.00", "changed to 0.0 RLD 5/19/92"},
                                   {"X", "CP1", "CD", "X", "0.0000", "6", "180.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                   {"X", "CP1", "CP2", "X", "0.1400", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"X", "CP2", "CP2", "X", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"X", "CP3", "CP2", "X", "0.1400", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                   {"X", "CT1", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                   {"X", "CT1", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CT1", "CT1", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                   {"X", "CT1", "CT2", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                   {"X", "CT1", "CT3", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                   {"X", "CT1", "NH3", "X", "0.1000", "3", "0.00", "0.715->0.10 METHYLAMMONIUM (KK)"},
                                   {"X", "CT1", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                   {"X", "CT1", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CT2", "CA", "X", "0.0000", "6", "0.00", "toluene, adm jr., 3/7/92"},
                                   {"X", "CT2", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                   {"X", "CT2", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CT2", "CT2", "X", "0.1900", "3", "0.00", "alkane, 4/98, yin and mackerell"},
                                   {"X", "CT2", "CT3", "X", "0.1600", "3", "0.00", "alkane, 4/98, yin and mackerell"},
                                   {"X", "CT2", "NC2", "X", "0.0000", "6", "180.00", "methylguanidinium, adm jr., 3/26/92"},
                                   {"X", "CT2", "NH3", "X", "0.1000", "3", "0.00", "0.715->0.10 METHYLAMMONIUM (KK)"},
                                   {"X", "CT2", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                   {"X", "CT2", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CT3", "CA", "X", "0.0000", "6", "0.00", "toluene, adm jr., 3/7/92"},
                                   {"X", "CT3", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                   {"X", "CT3", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"X", "CT3", "CT3", "X", "0.1525", "3", "0.00", "alkane, 4/98, yin and mackerell"},
                                   {"X", "CT3", "NC2", "X", "0.0000", "6", "180.00", "methylguanidinium, adm jr., 3/26/92"},
                                   {"X", "CT3", "NH2", "X", "0.1100", "3", "0.00", "methylamine geom/freq, adm jr., 6/2/92"},
                                   {"X", "CT3", "NH3", "X", "0.0900", "3", "0.00", "fine-tuned to ab initio; METHYLAMMONIUM, KK 03/10/92"},
                                   {"X", "CT3", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                   {"X", "CT3", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                   {"NH1", "CT1", "CT1", "HA1", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"HB1", "CT1", "CT1", "HA1", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"HB1", "CT1", "CT1", "CT3", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"HA1", "CT1", "CT1", "C", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"NH1", "CT1", "CT2", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2", "OH1", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2", "CT2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2", "CT1", "C", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2", "OH1", "H", "0.1400", "3", "0.00", "From X CT2 OH1 X"},
                                   {"CT1", "CT2", "CT2", "HA2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HA2", "CT2", "CT2", "HA2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HA2", "CT2", "CT2", "CC", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HB1", "CT1", "CT2", "S", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT2", "CT2", "CT2", "HA2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"CT2", "CT2", "CT2", "NC2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"CT2", "CT2", "NC2", "HC", "0.0000", "6", "180.00", "From X CT2 NC2 X"},
                                   {"CT2", "CT2", "NC2", "C", "0.0000", "6", "180.00", "From X CT2 NC2 X"},
                                   {"HA2", "CT2", "CT2", "NC2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"CT2", "NC2", "C", "NC2", "2.2500", "2", "180.00", "From X C NC2 X"},
                                   {"HA2", "CT2", "NC2", "HC", "0.0000", "6", "180.00", "From X CT2 NC2 X"},
                                   {"HA2", "CT2", "NC2", "C", "0.0000", "6", "180.00", "From X CT2 NC2 X"},
                                   {"NC2", "C", "NC2", "HC", "2.2500", "2", "180.00", "From X C NC2 X"},
                                   {"HB1", "CT1", "CT2", "CC", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2", "CY", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2", "CC", "OC", "0.0500", "6", "180.00", "From X CT2 CC X"},
                                   {"HB1", "CT1", "CT2", "CPH1", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT1", "CT1", "CT3", "HA3", "0.2000", "3", "0.00", "From X CT1 CT3 X"},
                                   {"CT1", "CT1", "CT2", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT1", "CT2", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"CT1", "CT2", "CT3", "HA3", "0.1600", "3", "0.00", "From X CT2 CT3 X"},
                                   {"HA1", "CT1", "CT3", "HA3", "0.2000", "3", "0.00", "From X CT1 CT3 X"},
                                   {"HA1", "CT1", "CT2", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA1", "CT1", "CT2", "CT3", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT3", "CT1", "CT2", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT3", "CT1", "CT2", "CT3", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA3", "CT3", "CT1", "CT2", "0.2000", "3", "0.00", "From X CT1 CT3 X"},
                                   {"HA2", "CT2", "CT3", "HA3", "0.1600", "3", "0.00", "From X CT2 CT3 X"},
                                   {"CT1", "CT2", "CT1", "HA1", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2", "CT1", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT3", "CT1", "CT3", "HA3", "0.2000", "3", "0.00", "From X CT1 CT3 X"},
                                   {"CT2", "CT2", "CT2", "NH3", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"CT2", "CT2", "NH3", "HC", "0.1000", "3", "0.00", "From X CT2 NH3 X"},
                                   {"HA2", "CT2", "CT2", "NH3", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HA2", "CT2", "NH3", "HC", "0.1000", "3", "0.00", "From X CT2 NH3 X"},
                                   {"HB1", "CT1", "CT2", "CA", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2", "CA", "CA", "0.0000", "6", "0.00", "From X CT2 CA X"},
                                   {"HB1", "CT1", "CT1", "OH1", "0.2000", "3", "0.00", "From X CT1 CT1 X"},
                                   {"HA1", "CT1", "OH1", "H", "0.1400", "3", "0.00", "From X CT1 OH1 X"},
                                   {"OH1", "CT1", "CT3", "HA3", "0.2000", "3", "0.00", "From X CT1 CT3 X"},
                                   {"CT2", "CT2", "CC", "O", "0.0500", "6", "180.00", "From X CT2 CC X"},
                                   {"CT2", "CT2", "CC", "NH2", "0.0500", "6", "180.00", "From X CT2 CC X"},
                                   {"CT2", "CT2", "CC", "OC", "0.0500", "6", "180.00", "From X CT2 CC X"},
                                   {"NH1", "CT1", "CT2A", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"NH3", "CT1", "CT2A", "CT2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"CT1", "CT2A", "CT2", "HA2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HB1", "CT1", "CT2A", "HA2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HB1", "CT1", "CT2A", "CT2", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2A", "CT1", "C", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"HA2", "CT2A", "CT1", "CC", "0.2000", "3", "0.00", "RB: added for C-ter Glu"},
                                   {"HA2", "CT2A", "CT2", "HA2", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HA2", "CT2A", "CT2", "CC", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HB1", "CT1", "CT2A", "CPH1", "0.2000", "3", "0.00", "From X CT1 CT2 X"},
                                   {"C", "NH1", "CT1", "CT2A", "1.8000", "1", "0.00", "from CT2 CT1 NH1 C"},
                                   {"H", "NH1", "CT1", "CT2A", "0.0000", "1", "0.00", "from H NH1 CT1 CT2"},
                                   {"CT2A", "CT1", "C", "O", "1.4000", "1", "0.00", "from O C CT1 CT2"},
                                   {"CT2A", "CT1", "C", "NH1", "0.0000", "1", "0.00", "NH1 C CT1 CT2"},
                                   {"CT2A", "CT1", "C", "N", "0.0000", "1", "0.00", "RB: added for GLU-PRO in UBQ"},
                                   {"CT1", "CT2A", "CT2", "CD", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"HA2", "CT2A", "CT2", "CD", "0.1900", "3", "0.00", "From X CT2 CT2 X"},
                                   {"CT2A", "CPH1", "CPH1", "HR1", "1.0000", "2", "180.00", "from HR1 CPH1 CPH1 CT2"},
                                   {"CT2A", "CPH1", "CPH1", "NR3", "2.5000", "2", "180.00", "from NR3 CPH1 CPH1 CT2"},
                                   {"CT2A", "CPH1", "NR3", "H", "3.0000", "2", "180.00", "from H NR3 CPH1 CT2"},
                                   {"CT2A", "CPH1", "NR3", "CPH2", "2.5000", "2", "180.00", "from CT2 CPH1 NR3 CPH2"},
                                   {"HA2", "CT2A", "CPH1", "CPH1", "0.0000", "3", "0.00", "from HA2 CT2 CPH1 CPH1"},
                                   {"HA2", "CT2A", "CPH1", "NR3", "0.1900", "3", "0.00", "from NR3 CPH1 CT2 HA2"},
                                   {"C", "CT1", "CT2", "CT2", "0.3500", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CT2", "0.4200", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CT2", "1.9100", "3", "180.00", " "},
                                   {"CT2", "CT2", "CT1", "NH1", "0.8800", "1", "180.00", " "},
                                   {"CT2", "CT2", "CT1", "NH1", "0.0000", "2", "180.00", " "},
                                   {"CT2", "CT2", "CT1", "NH1", "1.9000", "3", "0.00", " "},
                                   {"CC", "CT2", "CT2", "CT1", "1.8400", "1", "180.00", " "},
                                   {"CC", "CT2", "CT2", "CT1", "0.8400", "2", "180.00", " "},
                                   {"CC", "CT2", "CT2", "CT1", "0.3900", "3", "180.00", " "},
                                   {"CT1", "CT2", "CT2", "CT2", "0.6300", "1", "180.00", " "},
                                   {"CT1", "CT2", "CT2", "CT2", "0.0100", "2", "0.00", " "},
                                   {"CT1", "CT2", "CT2", "CT2", "0.1500", "3", "0.00", " "},
                                   {"CT1", "CT2", "CT2", "S", "0.1400", "1", "180.00", " "},
                                   {"CT1", "CT2", "CT2", "S", "0.5400", "2", "0.00", " "},
                                   {"CT1", "CT2", "CT2", "S", "0.6900", "3", "0.00", "Fitted Asn"},
                                   {"C", "CT1", "CT2", "CC", "1.4100", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CC", "1.2900", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CC", "0.5900", "3", "180.00", " "},
                                   {"CC", "CT2", "CT1", "NH1", "0.2800", "1", "180.00", " "},
                                   {"CC", "CT2", "CT1", "NH1", "0.5000", "2", "180.00", " "},
                                   {"CC", "CT2", "CT1", "NH1", "0.3800", "3", "0.00", " "},
                                   {"CT1", "CT2", "CC", "NH2", "0.6200", "1", "180.00", " "},
                                   {"CT1", "CT2", "CC", "NH2", "0.6600", "2", "180.00", " "},
                                   {"CT1", "CT2", "CC", "NH2", "0.7200", "3", "180.00", " "},
                                   {"CT1", "CT2", "CC", "O", "0.4200", "1", "180.00", " "},
                                   {"CT1", "CT2", "CC", "O", "0.1500", "2", "180.00", " "},
                                   {"CT1", "CT2", "CC", "O", "0.9500", "3", "180.00", "Fitted Asp"},
                                   {"C", "CT1", "CT2A", "CC", "1.6100", "1", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CC", "1.2900", "2", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CC", "0.5900", "3", "180.00", " "},
                                   {"CC", "CT2A", "CT1", "NH1", "0.6800", "1", "180.00", " "},
                                   {"CC", "CT2A", "CT1", "NH1", "0.1000", "2", "180.00", " "},
                                   {"CC", "CT2A", "CT1", "NH1", "0.3800", "3", "0.00", " "},
                                   {"CT1", "CT2A", "CC", "OC", "0.8400", "1", "0.00", " "},
                                   {"CT1", "CT2A", "CC", "OC", "0.9800", "2", "180.00", " "},
                                   {"CT1", "CT2A", "CC", "OC", "1.4600", "3", "0.00", "Fitted Cys"},
                                   {"CT1", "CT2", "S", "HS", "0.2000", "1", "0.00", " "},
                                   {"CT1", "CT2", "S", "HS", "0.6500", "2", "0.00", " "},
                                   {"CT1", "CT2", "S", "HS", "0.2200", "3", "0.00", " "},
                                   {"C", "CT1", "CT2", "S", "0.2400", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "S", "0.7500", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "S", "1.3500", "3", "180.00", " "},
                                   {"NH1", "CT1", "CT2", "S", "0.3400", "1", "0.00", " "},
                                   {"NH1", "CT1", "CT2", "S", "0.5000", "2", "180.00", " "},
                                   {"NH1", "CT1", "CT2", "S", "1.4300", "3", "0.00", "Fitted Glu"},
                                   {"CC", "CT2", "CT2A", "CT1", "0.0000", "1", "180.00", " "},
                                   {"CC", "CT2", "CT2A", "CT1", "0.3800", "2", "180.00", " "},
                                   {"CC", "CT2", "CT2A", "CT1", "0.5900", "3", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CT2", "0.1100", "1", "0.00", " "},
                                   {"C", "CT1", "CT2A", "CT2", "0.9800", "2", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CT2", "1.6000", "3", "180.00", " "},
                                   {"CC", "CT1", "CT2A", "CT2", "1.6000", "3", "180.00", " "},
                                   {"CT2", "CT2A", "CT1", "NH1", "0.3000", "1", "0.00", " "},
                                   {"CT2", "CT2A", "CT1", "NH1", "0.3500", "2", "0.00", " "},
                                   {"CT2", "CT2A", "CT1", "NH1", "1.7600", "3", "0.00", "Group-fitted for Hsd/Hse"},
                                   {"CPH1", "CPH1", "CT2", "CT1", "1.7400", "1", "0.00", " "},
                                   {"CPH1", "CPH1", "CT2", "CT1", "0.1500", "2", "0.00", " "},
                                   {"CPH1", "CPH1", "CT2", "CT1", "0.7700", "3", "180.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR1", "1.4900", "1", "0.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR1", "0.0900", "2", "180.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR1", "0.7900", "3", "180.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR2", "1.0900", "1", "0.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR2", "0.0900", "2", "0.00", " "},
                                   {"CT1", "CT2", "CPH1", "NR2", "0.6700", "3", "180.00", " "},
                                   {"C", "CT1", "CT2", "CPH1", "0.1800", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CPH1", "0.6400", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CPH1", "0.8700", "3", "180.00", " "},
                                   {"CPH1", "CT2", "CT1", "NH1", "0.0000", "1", "0.00", " "},
                                   {"CPH1", "CT2", "CT1", "NH1", "0.0000", "2", "180.00", " "},
                                   {"CPH1", "CT2", "CT1", "NH1", "0.9000", "3", "0.00", "Fitted Hsp"},
                                   {"CPH1", "CPH1", "CT2A", "CT1", "2.0400", "1", "0.00", " "},
                                   {"CPH1", "CPH1", "CT2A", "CT1", "0.4400", "2", "0.00", " "},
                                   {"CPH1", "CPH1", "CT2A", "CT1", "0.1300", "3", "180.00", " "},
                                   {"CT1", "CT2A", "CPH1", "NR3", "0.5300", "1", "180.00", " "},
                                   {"CT1", "CT2A", "CPH1", "NR3", "0.4200", "2", "180.00", " "},
                                   {"CT1", "CT2A", "CPH1", "NR3", "0.3000", "3", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CPH1", "1.7500", "1", "180.00", " "},
                                   {"C", "CT1", "CT2A", "CPH1", "0.1300", "2", "0.00", " "},
                                   {"C", "CT1", "CT2A", "CPH1", "1.8600", "3", "180.00", " "},
                                   {"CPH1", "CT2A", "CT1", "NH1", "1.0900", "1", "180.00", " "},
                                   {"CPH1", "CT2A", "CT1", "NH1", "0.2200", "2", "180.00", " "},
                                   {"CPH1", "CT2A", "CT1", "NH1", "2.3200", "3", "0.00", "Group-fitted for Ile/Thr"},
                                   {"CT1", "CT1", "CT2", "CT3", "0.3800", "1", "180.00", " "},
                                   {"CT1", "CT1", "CT2", "CT3", "0.1300", "2", "180.00", " "},
                                   {"CT1", "CT1", "CT2", "CT3", "0.2900", "3", "180.00", " "},
                                   {"C", "CT1", "CT1", "CT2", "0.1000", "1", "180.00", " "},
                                   {"C", "CT1", "CT1", "CT2", "0.5200", "2", "180.00", " "},
                                   {"C", "CT1", "CT1", "CT2", "0.2900", "3", "180.00", " "},
                                   {"CT2", "CT1", "CT1", "NH1", "0.1200", "1", "180.00", " "},
                                   {"CT2", "CT1", "CT1", "NH1", "0.3600", "2", "180.00", " "},
                                   {"CT2", "CT1", "CT1", "NH1", "0.4100", "3", "0.00", "Fitted Leu"},
                                   {"CT1", "CT2", "CT1", "CT3", "0.0500", "1", "0.00", " "},
                                   {"CT1", "CT2", "CT1", "CT3", "0.1000", "2", "180.00", " "},
                                   {"CT1", "CT2", "CT1", "CT3", "0.0100", "3", "180.00", " "},
                                   {"C", "CT1", "CT2", "CT1", "0.3200", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CT1", "0.6100", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CT1", "0.7200", "3", "180.00", " "},
                                   {"CT1", "CT2", "CT1", "NH1", "0.4800", "1", "180.00", " "},
                                   {"CT1", "CT2", "CT1", "NH1", "0.4200", "2", "180.00", " "},
                                   {"CT1", "CT2", "CT1", "NH1", "0.6500", "3", "0.00", "Group-fitted for Phe/Tyr"},
                                   {"CA", "CA", "CT2", "CT1", "1.0700", "1", "0.00", " "},
                                   {"CA", "CA", "CT2", "CT1", "0.2400", "2", "180.00", " "},
                                   {"CA", "CA", "CT2", "CT1", "0.1700", "3", "180.00", " "},
                                   {"C", "CT1", "CT2", "CA", "1.2800", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CA", "0.9400", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CA", "1.5700", "3", "180.00", " "},
                                   {"CA", "CT2", "CT1", "NH1", "0.5200", "1", "180.00", " "},
                                   {"CA", "CT2", "CT1", "NH1", "0.6200", "2", "180.00", " "},
                                   {"CA", "CT2", "CT1", "NH1", "1.5800", "3", "0.00", "Fitted Ser"},
                                   {"CT1", "CT2", "OH1", "H", "0.0200", "1", "0.00", " "},
                                   {"CT1", "CT2", "OH1", "H", "0.5600", "2", "0.00", " "},
                                   {"CT1", "CT2", "OH1", "H", "0.4900", "3", "0.00", " "},
                                   {"C", "CT1", "CT2", "OH1", "0.6500", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "OH1", "0.2500", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "OH1", "1.1700", "3", "180.00", " "},
                                   {"NH1", "CT1", "CT2", "OH1", "0.1800", "1", "180.00", " "},
                                   {"NH1", "CT1", "CT2", "OH1", "0.1900", "2", "180.00", " "},
                                   {"NH1", "CT1", "CT2", "OH1", "1.4600", "3", "0.00", "Group-fitted for Ile/Thr"},
                                   {"CT1", "CT1", "OH1", "H", "0.1800", "1", "0.00", " "},
                                   {"CT1", "CT1", "OH1", "H", "0.0600", "2", "0.00", " "},
                                   {"CT1", "CT1", "OH1", "H", "0.2500", "3", "0.00", " "},
                                   {"C", "CT1", "CT1", "OH1", "0.7900", "1", "180.00", " "},
                                   {"C", "CT1", "CT1", "OH1", "0.3900", "2", "180.00", " "},
                                   {"C", "CT1", "CT1", "OH1", "0.9900", "3", "180.00", " "},
                                   {"NH1", "CT1", "CT1", "OH1", "0.0900", "1", "0.00", " "},
                                   {"NH1", "CT1", "CT1", "OH1", "0.1900", "2", "180.00", " "},
                                   {"NH1", "CT1", "CT1", "OH1", "0.1700", "3", "0.00", "Fitted Trp"},
                                   {"CA", "CY", "CT2", "CT1", "0.0300", "1", "0.00", " "},
                                   {"CA", "CY", "CT2", "CT1", "0.5500", "2", "0.00", " "},
                                   {"CA", "CY", "CT2", "CT1", "0.3900", "3", "180.00", " "},
                                   {"CPT", "CY", "CT2", "CT1", "0.3600", "1", "180.00", " "},
                                   {"CPT", "CY", "CT2", "CT1", "0.0500", "2", "0.00", " "},
                                   {"CPT", "CY", "CT2", "CT1", "0.1900", "3", "180.00", " "},
                                   {"C", "CT1", "CT2", "CY", "1.0900", "1", "180.00", " "},
                                   {"C", "CT1", "CT2", "CY", "0.5000", "2", "180.00", " "},
                                   {"C", "CT1", "CT2", "CY", "1.1700", "3", "180.00", " "},
                                   {"CY", "CT2", "CT1", "NH1", "0.2900", "1", "180.00", " "},
                                   {"CY", "CT2", "CT1", "NH1", "0.6600", "2", "180.00", " "},
                                   {"CY", "CT2", "CT1", "NH1", "1.1700", "3", "0.00", "Fitted Val"},
                                   {"C", "CT1", "CT1", "CT3", "0.1400", "1", "180.00", " "},
                                   {"C", "CT1", "CT1", "CT3", "0.2600", "2", "180.00", " "},
                                   {"C", "CT1", "CT1", "CT3", "0.3300", "3", "180.00", " "},
                                   {"CT3", "CT1", "CT1", "NH1", "0.1800", "1", "0.00", " "},
                                   {"CT3", "CT1", "CT1", "NH1", "0.0600", "2", "0.00", " "},
                                   {"CT3", "CT1", "CT1", "NH1", "0.5900", "3", "0.00", "CT2->CT2A, jshim"},
                                   {"H", "NH1", "CT2A", "CC", "0.0000", "1", "0.00", " "},
                                   {"X", "CT2A", "CC", "X", "0.0500", "6", "180.00", " "},
                                   {"HB1", "CT1", "CT2A", "CC", "0.2000", "3", "0.00", " "},
                                   {"HA2", "CT2A", "CC", "OC", "0.0500", "6", "180.00", " "},
                                   {"NH3", "CT1", "CT2A", "HA2", "0.2000", "3", "0.00", " "},
                                   {"NH3", "CT1", "CT2A", "CC", "0.2000", "3", "0.00", " "},
                                   {"CC", "CT2A", "CT1", "CC", "0.2000", "3", "0.00", "specific terms"},
                                   {"CPH1", "CT2A", "CT1", "CC", "0.2000", "3", "0.00", " "},
                                   {"CPH1", "CT2A", "CT1", "NH3", "0.2000", "3", "0.00", " "},
                                   {"CPH1", "CT2A", "CT1", "CD", "0.2000", "3", "0.00", " "},
                                   {"HA2", "CT2A", "CT1", "CD", "0.2000", "3", "0.00", " "},
                                   {"CT2", "CT2A", "CT1", "CD", "0.2000", "3", "0.00", "RESI CYSM and PRES CYSD"},
                                   {"H", "NH2", "CT1", "CS", "0.1100", "3", "0.00", "from H NH2 CT1 CT2 or H NH2 CT1 CT2 , kevo"},
                                   {"CS", "CT1", "NH1", "C", "1.8000", "1", "0.00", "from CT2 CT1 NH1 C or CT2A CT1 NH1 C , kevo"},
                                   {"H", "NH1", "CT1", "CS", "0.0000", "1", "0.00", "from H NH1 CT1 CT2 or H NH1 CT1 CT2 , kevo"},
                                   {"N", "C", "CT1", "CS", "0.0000", "1", "0.00", "from N C CT1 CT2 or N C CT1 CT2 , kevo"},
                                   {"NH1", "C", "CT1", "CS", "0.0000", "1", "0.00", "from NH1 C CT1 CT2 or NH1 C CT1 CT2 , kevo"},
                                   {"O", "C", "CT1", "CS", "1.4000", "1", "0.00", "from O C CT1 CT2 or O C CT1 CT2 , kevo"},
                                   {"HA2", "CS", "CT1", "C", "0.2000", "3", "0.00", "from HA2 CT2 CT1 C or HA2 CT2A CT1 C , kevo"},
                                   {"NH1", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from NH1 CT1 CT2 HA2 or NH1 CT1 CT2A HA2 , kevo"},
                                   {"HB1", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from HB1 CT1 CT2 HA2 or HB1 CT1 CT2A HA2 , kevo"},
                                   {"HB1", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from HB1 CT1 CT2 S or HB1 CT1 CT2A S , kevo"},
                                   {"C", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH1", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH3", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH3", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH2", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH2", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CC", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CC", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CD", "CT1", "CS", "HA2", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CD", "CT1", "CS", "SS", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH1", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH2", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"NH3", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"C", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CC", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"CD", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"},
                                   {"HB1", "CT1", "CT2", "OC", "0.2000", "3", "0.00", "from X CT1 CT2 X , kevo"}};

/*
 Impropers
  0-3= Keys, 4= Kpsi (kcal mol^-1 rad^-2), 5= psi0 (deg), 6= charmm36m_prot info

  V(psi) = Kpsi x (psi - psi0)^2
*/
char * charmm36m_prot_impropers[35][8]= {{"HE2", "HE2", "CE2", "CE2", "3.0", "0", "0.00", "for ethene, yin/adm jr., 12/95"},
                                  {"HR1", "NR1", "NR2", "CPH2", "0.5000", "0", "0.0000", "his, adm jr., 7/05/90"},
                                  {"HR1", "NR2", "NR1", "CPH2", "0.5000", "0", "0.0000", "his, adm jr., 7/05/90"},
                                  {"HR3", "CPH1", "NR1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                  {"HR3", "CPH1", "NR2", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                  {"HR3", "CPH1", "NR3", "CPH1", "1.0000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                  {"HR3", "NR1", "CPH1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                  {"HR3", "NR2", "CPH1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                  {"N", "C", "CP1", "CP3", "0.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                  {"NC2", "X", "X", "C", "45.0000", "0", "0.0000", "mp2/6-311g** guan vibrational data, adm jr., 1/04"},
                                  {"C", "HC", "HC", "NC2", "0.0", "0", "0.0", "mp2/6-311g** guan vibrational data, adm jr., 1/04"},
                                  {"NC2", "X", "X", "HC", "-2.0", "0", "0.0", "mp2/6-311g** guan vibrational data, adm jr., 1/04"},
                                  {"NH1", "X", "X", "H", "20.0000", "0", "0.0000", "NMA Vibrational Modes (LK)"},
                                  {"NH2", "X", "X", "H", "4.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"NR1", "CPH1", "CPH2", "H", "0.4500", "0", "0.0000", "his, adm jr., 7/05/90"},
                                  {"NR1", "CPH2", "CPH1", "H", "0.4500", "0", "0.0000", "his, adm jr., 7/05/90"},
                                  {"NR3", "CPH1", "CPH2", "H", "1.2000", "0", "0.0000", "his, adm jr., 6/27/90"},
                                  {"NR3", "CPH2", "CPH1", "H", "1.2000", "0", "0.0000", "his, adm jr., 6/27/90"},
                                  {"O", "CP1", "NH2", "CC", "45.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                  {"O", "CT1", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "CT2", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "CT3", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "HA1", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                  {"O", "N", "CT2", "CC", "120.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                  {"O", "NH2", "CP1", "CC", "45.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                  {"O", "NH2", "CT1", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "NH2", "CT2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "NH2", "CT3", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                  {"O", "NH2", "HA1", "CC", "45.0000", "0", "0.0000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                  {"O", "X", "X", "C", "120.0000", "0", "0.0000", "NMA Vibrational Modes (LK)"},
                                  {"OB", "X", "X", "CD", "100.0000", "0", "0.0000", "adm jr., 10/17/90, acetic acid vibrations"},
                                  {"OC", "X", "X", "CC", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                  {"CC", "X", "X", "CT1", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                  {"CC", "X", "X", "CT2", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                  {"CC", "X", "X", "CT3", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"}};

/*
 Non-bonded
  0= Key, 1= epsilon (kcal mol^-1), 2= Rmin/2 (A), 3= epsilon[1-4], 4= Rmin[1-4]/2, 5= charmm36m_prot info

  V(rij) =  Eps(ij) x [(Rmin(ij)/rij)^12 - 2 x (Rmin(ij)/rij)^6]
  With:
    Esp(ij) = sqrt(epsilon([i) x epsilon[j])
    Rmin(ij)= (Rmin[i] + Rmin[j])/2
*/
char * charmm36m_prot_vdw[53][6]= {{"C", "-0.110000", "2.000000", " ", " ", " "},
                            {"CA", "-0.070000", "1.992400", " ", " ", " "},
                            {"CC", "-0.070000", "2.000000", " ", " ", " "},
                            {"CD", "-0.070000", "2.000000", " ", " ", " "},
                            {"CE1", "-0.068000", "2.090000", " ", " ", " "},
                            {"CE2", "-0.064000", "2.080000", " ", " ", " "},
                            {"CP1", "-0.020000", "2.275000", "-0.010000", "1.900000", " "},
                            {"CP2", "-0.055000", "2.175000", "-0.010000", "1.900000", " "},
                            {"CP3", "-0.055000", "2.175000", "-0.010000", "1.900000", " "},
                            {"CPH1", "-0.050000", "1.800000", " ", " ", " "},
                            {"CPH2", "-0.050000", "1.800000", " ", " ", " "},
                            {"CS", "-0.110000", "2.200000", " ", " ", " "},
                            {"CPT", "-0.099000", "1.860000", " ", " ", " "},
                            {"CY", "-0.073000", "1.990000", " ", " ", " "},
                            {"CAI", "-0.073000", "1.990000", " ", " ", " "},
                            {"CT", "-0.0200", "2.275", "-0.01", "1.9", " "},
                            {"CT1", "-0.0320", "2.000", "-0.01", "1.9", " "},
                            {"CT2", "-0.0560", "2.010", "-0.01", "1.9", " "},
                            {"CT2A", "-0.0560", "2.010", "-0.01", "1.9", " "},
                            {"CT3", "-0.0780", "2.040", "-0.01", "1.9", " "},
                            {"H", "-0.046000", "0.224500", " ", " ", " "},
                            {"HA", "-0.022000", "1.320000", " ", " ", " "},
                            {"HB1", "-0.022000", "1.320000", " ", " ", " "},
                            {"HB2", "-0.028000", "1.340000", " ", " ", " "},
                            {"HE1", "-0.031000", "1.250000", " ", " ", " "},
                            {"HE2", "-0.026000", "1.260000", " ", " ", " "},
                            {"HC", "-0.046000", "0.224500", " ", " ", " "},
                            {"HP", "-0.030000", "1.358200", "-0.030000", "1.358200", " "},
                            {"HR1", "-0.046000", "0.900000", " ", " ", " "},
                            {"HR2", "-0.046000", "0.700000", " ", " ", " "},
                            {"HR3", "-0.007800", "1.468000", " ", " ", " "},
                            {"HS", "-0.100000", "0.450000", " ", " ", " "},
                            {"HA1", "-0.045", "1.3400", " ", " ", " "},
                            {"HA2", "-0.034", "1.3400", " ", " ", " "},
                            {"HA3", "-0.024", "1.3400", " ", " ", " "},
                            {"N", "-0.200000", "1.850000", "-0.000100", "1.850000", " "},
                            {"NC2", "-0.200000", "1.850000", " ", " ", " "},
                            {"NH1", "-0.200000", "1.850000", "-0.200000", "1.550000", " "},
                            {"NH2", "-0.200000", "1.850000", " ", " ", " "},
                            {"NH3", "-0.200000", "1.850000", " ", " ", " "},
                            {"NP", "-0.200000", "1.850000", " ", " ", " "},
                            {"NR1", "-0.200000", "1.850000", " ", " ", " "},
                            {"NR2", "-0.200000", "1.850000", " ", " ", " "},
                            {"NR3", "-0.200000", "1.850000", " ", " ", " "},
                            {"NY", "-0.200000", "1.850000", " ", " ", " "},
                            {"O", "-0.120000", "1.700000", "-0.120000", "1.400000", " "},
                            {"OB", "-0.120000", "1.700000", "-0.120000", "1.400000", " "},
                            {"OC", "-0.120000", "1.700000", " ", " ", " "},
                            {"OH1", "-0.152100", "1.770000", " ", " ", " "},
                            {"OS", "-0.152100", "1.770000", " ", " ", " "},
                            {"S", "-0.450000", "2.000000", " ", " ", " "},
                            {"SM", "-0.380000", "1.975000", " ", " ", " "},
                            {"SS", "-0.470000", "2.200000", " ", " ", " "}};
