/*
 * ratCompat.c --
 *
 *	This file contains compatibility functions.
 *
 * TkRat software and its included text is Copyright 1996-2000 by
 * Martin Forssn
 *
 * The full text of the legal notice is contained in the file called
 * COPYRIGHT, included with this distribution.
 */

#include "rat.h"

#ifndef HAVE_SNPRINTF

size_t
snprintf (char *buf, size_t buflen, const char *fmt, ...)
{
    va_list argList;
    int bytes_written;

    va_start(argList, fmt);
    bytes_written = vsprintf (buf, fmt, argList);
    va_end(argList);

    if (bytes_written >= buflen) {
	fprintf(stderr, "Buffer overflow in snprintf (%d > %d)\n",
		bytes_written+1, buflen);
        abort();
    }

    return bytes_written;
}

#endif /* HAVE_SNPRINTF */
