/***************************************************************************
                          access.cpp  -  allow or not connexion from user
                             -------------------
    begin                : Tue Feb 20 2001
    copyright            : (C) 2000 by Franck Ladurelle
    email                : ladurelf@partimage.org
 ***************************************************************************/
// $Revision: 1.18 $
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

// shadow.h and crypt.h may not exist on bsd
#ifdef HAVE_SHADOW_H
  #include <shadow.h>
#endif
#ifdef HAVE_CRYPT_H
  #include <crypt.h>
#endif

#include <time.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <pwd.h>

#include "common.h"
#include "pathnames.h"
#include "privs.h"

extern CPrivs * g_privs;

char * GetSalt(char * szLogin)
{
#ifdef OS_LINUX
  struct spwd * s_pass;
#endif
#ifdef OS_FBSD
  struct passwd * s_pass;
#endif
  char * salt = (char *) malloc(12); 
  long int r;
  BEGIN;

  if (!salt)
    return NULL;

  srandom((unsigned int) time(NULL));
  *(salt+11) = '\0';
  for (unsigned int i = 0; i < 11; i++)
    {
      r = random() % 52;
      *(salt+i) = (r>25 ? 'a'+r-26 : 'A'+r);
    }
 
  g_privs->Root(); 
#ifdef OS_LINUX
  s_pass = getspnam(szLogin);
#endif
#ifdef OS_FBSD
  s_pass = getpwnam(szLogin);
#endif
  g_privs->User(); 

#ifdef OS_LINUX
  if (s_pass && strlen(s_pass->sp_pwdp) > 10)
    memcpy(salt, s_pass->sp_pwdp, 11);
  else if (s_pass)
    memcpy(salt, s_pass->sp_pwdp, strlen(s_pass->sp_pwdp));
#endif
#ifdef OS_FBSD
  if (s_pass && strlen(s_pass->pw_passwd) > 10)
    memcpy(salt, s_pass->pw_passwd, 11);
  else if (s_pass)
    memcpy(salt, s_pass->pw_passwd, strlen(s_pass->pw_passwd));
#endif

  showDebug(9, "end of access::getsalt\n");
  return strdup(salt);
}

#ifdef MUST_LOGIN  
unsigned int CheckAccess(bool bMustLogin, char * szLogin, char * szPasswd)
{
  if (!bMustLogin)
    RETURN_int(0)


  FILE * f;
#ifdef OS_LINUX
  struct spwd * s_pass;
#endif
#ifdef OS_FBSD
  struct passwd * s_pass;
#endif
  int found;
  char * str = (char *) malloc (1024);
  char * ptr, * ptr2;
  BEGIN;



  f = fopen(PARTIMAGED_USERS, "r");
  if (!f) 
    {
    showDebug(1, "can't open: %d %s\n", errno, strerror(errno));
    RETURN_int(1);
    }

  found = 0;
  while (!feof(f))
    {
      fgets(str, 1023, f);
      while (str[strlen(str)-1] == '\n')
        str[strlen(str)-1] = '\0';
      ptr = strchr(str, '#');
      if (ptr)
        *ptr = '\0'; // remove comments from partimagedusers

      ptr = str;
      while (*ptr && isblank(*ptr)) // remove starting spaces or tabs
        ++ptr;
 
      ptr2 = ptr+strlen(ptr);       // *ptr2 = '\0'
                                    // warning: maybe *ptr=*ptr2='\0'
      while (ptr2 > ptr)            
        {
          --ptr2;
          if ( isblank(*ptr2) )
            *(ptr2) = '\0';         // remove trailing spaces or tabs 
        }
       
      if (!strcmp(ptr, szLogin)) 
        {
          found = 1;
          break;
        }
    }
  free(str);
  fclose(f);

  if (!found)
    RETURN_int(2);

  g_privs->Root();
#ifdef OS_LINUX
  s_pass = getspnam(szLogin);
#endif
#ifdef OS_FBSD
  s_pass = getpwnam(szLogin);
#endif
  g_privs->User();

  if (!s_pass)
    RETURN_int(3);

#ifdef OS_LINUX
  if (!strcmp(s_pass->sp_pwdp, szPasswd))
    RETURN_int(0)
  else
    RETURN_int(10);
#endif
#ifdef OS_FBSD
  if (strncmp(s_pass->pw_passwd, "$1$", 3))
    {
      showDebug(1, "password for %s is not a MD5, I don't kwow what to do.\n",
         szLogin);
      RETURN_int(4);
    }
  if (!strcmp(s_pass->pw_passwd, szPasswd))
    RETURN_int(0)
  else
    RETURN_int(10);
#endif

}
#else
unsigned int CheckAccess(bool b, char * szLogin, char * szPasswd)
{
  RETURN_int(0);
}
#endif

static void help(char * szFile)
{
  fprintf(stderr,"error when verifying %s, check logfile for help\n",
     szFile);
  fprintf(stderr, "logfile is %s\n", PARTIMAGED_LOG);
  fprintf(stderr,"if you don't have logfile, use partimaged --debug=1\n");
}


unsigned int CheckAccessFile(char * szFile)
{
  int nRes;
  struct stat status;
  mode_t mode;

  showDebug(2, "verifing %s access rights\n", szFile); 
  nRes = stat(szFile, &status);
  if (nRes)
    {
      help(szFile);
      showDebug(0, "error on stat for %s: %s\n", szFile, strerror(errno));
      return 1;
    }
  mode = status.st_mode;
  if (!S_ISREG(mode))  
    {
      help(szFile);
      showDebug(0, "file %s is not a regular file\n", szFile);
      return 1;
    }
/*
  if (status.st_uid != 0 || status.st_gid != 0)
    {
      help(szFile);
      showDebug(0, "file %s must belong to root.root\n", szFile);
      return 1;
    }
*/

  if (mode != (S_IFREG | S_IRUSR | S_IWUSR))
    {
      help(szFile);
      showDebug(0, "file %s must be chmoded 0600\n", szFile);
      showDebug(0, "enter \"chmod 0600 %s\"\n", szFile);
      showDebug(0, "it's %o, see stat manpage for help\n");
      return 1;
    }
  
  return 0;
}
