#!/usr/bin/perl -w

# Perl version of check_dns plugin which calls DNS directly instead of
# relying on nslookup (which has bugs)
#
# Copyright 2000, virCIO, LLP
#
# $Log: check_netdns.pl,v $
# Revision 1.1.2.2  2001/04/13 20:19:47  karldebisschop
# cannot use max() with POSIX state defs
#
# Revision 1.1.2.1  2001/04/12 07:08:17  karldebisschop
# fix host regex, clean up GetOptions call
#
# Revision 1.1  2000/08/03 20:41:12  karldebisschop
# rename to avoid conflict when installing
#
# Revision 1.1  2000/08/03 19:27:08  karldebisschop
# use Net::DNS to check name server
#
# Revision 1.1  2000/07/20 19:09:13  cwg
# All the pieces needed to use my version of check_dns.
#

BEGIN {
	if ($0 =~ m/^(.*?)[\/\\]([^\/\\]+)$/) {
		$runtimedir = $1;
		$PROGNAME = $2;
	}
}

use Getopt::Long;
use Net::DNS;

delete @ENV{'PATH', 'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

Getopt::Long::Configure('bundling', 'no_ignore_case');
GetOptions
    ("V|version"    => \&version,
     "h|help"       => \&help,
     "t|timeout=i"  => \$opt_t,
     "s|server=s"   => \$opt_s,
     "H|hostname=s" => \$opt_H);
                           
# -H means host name
$opt_H = shift unless ($opt_H);
unless ($opt_H) { print_usage(); exit $ERRORS{'UNKNOWN'}; }
if ($opt_H && 
		$opt_H =~ m/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+|[a-zA-Z][-a-zA-Z0-9]*(\.[a-zA-Z][-a-zA-Z0-9]*)*)$/)
{
	$host = $1;
} else {
	print "$opt_H is not a valid host name";
	exit $ERRORS{'UNKNOWN'};
}

# -s means server name
$opt_s = shift unless ($opt_s);
if ($opt_s) {
	if ($opt_s =~ m/^([0-9]+.[0-9]+.[0-9]+.[0-9]+|[a-zA-Z][-a-zA-Z0]+(.[a-zA-Z][-a-zA-Z0]+)*)$/)
	{
		$server = $1;
	} else {
		print "$opt_s is not a valid host name";
		exit $ERRORS{'UNKNOWN'};
	}
}

# -t means timeout
my $timeout = 10 unless ($opt_t);

my $res = new Net::DNS::Resolver;
#$res->debug(1);
if ($server) {
	$res->nameservers($server);
}

$res->tcp_timeout($timeout);
$SIG{ALRM} = &catch_alarm;
alarm($timeout);

$query = $res->query($host);
if ($query) {
	my @answer = $query->answer;
	if (@answer) {
		print join(`/`, map {
			$_->type . ` ` . $_->rdatastr;
		} @answer);
		exit $ERRORS{'OK'};
	} else {
		print "empty answer";
		exit $ERRORS{'CRITICAL'};
	}
}
else {
	print "query failed: ", $res->errorstring, "";
	exit $ERRORS{'CRITICAL'};
}

sub catch_alarm {
	print "query timed out";
	exit $ERRORS{'CRITICAL'};
}

sub print_help() {
	print_revision($PROGNAME,'$Revision: 1.1.2.2 $ ');
	print "";
	print "Check if a nameserver can resolve a given hostname.";
	print "";
	print_usage();
	print "";
	print "-H, --hostname=HOST";
	print "   The name or address you want to query";
	print "-s, --server=HOST";
	print "   Optional DNS server you want to use for the lookup";
	print "-t, --timeout=INTEGER";
	print "   Seconds before connection times out (default: 10)";
	print "-h, --help";
	print "   Print detailed help";
	print "-V, --version";
	print "   Print version numbers and license information";
}

sub print_usage () {
	print "$PROGNAME -H host [-s server] [-t timeout]";
	print "$PROGNAME [-h | --help]";
	print "$PROGNAME [-V | --version]";
}

sub version () {
	print_revision($PROGNAME,'$Revision: 1.1.2.2 $ ');
	exit $ERRORS{'OK'};
}

sub help () {
	print_help();
	exit $ERRORS{'OK'};
}
