/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * PgDbResultSet.cc
 *   description goes here
 *
 * $Id: PgDbResultSet.cc,v 1.3 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include "PgDbResultSet.h" 

PgDbResultSet::PgDbResultSet(PgDatabase &pgdb)
{
    init(pgdb);
}

PgDbResultSet::~PgDbResultSet()
{
}

void PgDbResultSet::init(PgDatabase &pgdb)
{
    // create the metaData

    // initialize the DBResultSet
    int nbRows = pgdb.Tuples();
    int nbColumns = pgdb.Fields();
    
    if (nbRows == 0 || nbColumns == 0)
    {
        return;
    }

    for (int row = 0; row < nbRows; row++)
    {
        vector<string> rowVector;

        for (int column = 0; column < nbColumns; column++)
        {
            rowVector.push_back(string(pgdb.GetValue(row,column)));
        }
        rows.push_back(rowVector);
    }
}
