/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * PgDbMetaData.h
 *   description goes here
 *
 * $Id: PgDbMetaData.h,v 1.4 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef PGDBMETADATA_H
#define PGDBMETADATA_H

#include "DbMetaData.h"
#include <libpq++.h>
#include <map>

class PgDbMetaData : public DbMetaData
{
  public:
    PgDbMetaData(PgDatabase &pgdb);
    ~PgDbMetaData();

  protected:
    class TypeContainer
    {
      public:
        TypeContainer();
        TypeContainer(eDataType type);
        TypeContainer(const char *typeName);

        eDataType type;
    };

    static void initTypes(PgDatabase &pgdb);
    void init(PgDatabase &pgdb);

    static map<int, TypeContainer> oidToEnum;
};
#endif // PGDBMETADATA_H
