#!/usr/bin/tclsh


#******************************************************************************
# This script checks the synchronicity of the data in a table between n hosts *
#**************************************************************************************
# Usage: test_sync.tcl database table "host1 port1" "host2 port2" ... "hostN" "portN" *
#**************************************************************************************

load /usr/local/pgsql/lib/libpgtcl.so

proc syncError {message} {

    puts "\nSYNC ERROR: [clock format [clock seconds] -format "%H:%M:%S"] $message"
    exit -1

}




if {[llength $argv]<3} {

    puts "Usage: test_sync.tcl database table  \"host port\" \[\"host port\"\] \[\"host port\"\] ..."
    exit

}


set user daniel
set password daniel
set hosts ""
set conns ""
set results ""

# Get Parameters
for {set i 0} {$i<[llength $argv]} {incr i} {

    switch $i {

	0 { set dbname [lindex $argv $i] }
	1 { set table [lindex $argv $i] }
	default { lappend hosts [lindex $argv $i] }

    }


}

puts "\ntest_sync.tcl:"
puts "\tTesting table '$table' in database '$dbname'."
puts "\tLogging in with user '$user' and password '$password'."

# Create connections
foreach i $hosts {
    set host [lindex $i 0]
    set port [lindex $i 1]
    puts "\tHost: $host:$port"
    set conn [pg_connect -conninfo "user=$user password=$password dbname=$dbname host=$host port=$port"]
    lappend conns $conn
}

puts ""
set sql "SELECT * from $table"

 
set hora_inicio [clock seconds]

# Execute the querys
foreach conn $conns {
    set result [pg_exec $conn $sql]
    lappend results $result
}


# Compare the number of rows and fields with the first connection.
set nrows -1
set nfields -1
foreach result $results {

    # Check number of rows
    if {$nrows<0} {
	set nrows [pg_result $result -numTuples]
    } else {
	if {$nrows!=[pg_result $result -numTuples]} {
	    syncError "Different number of tuples. First host $nrows. This one [pg_result $result -numTuples]"
	}
    }

    # Check number of fields
    if {$nfields<0} {
	set nfields [pg_result $result -numAttrs]
    } else {
	if {$nfields!=[pg_result $result -numAttrs]} {
	    syncError "Different number of fields. First host $nfields. This one [pg_result $result -numAttrs] "
	}
    }

}
puts "Table '$table' has $nrows rows with $nfields fields each"


# Now we'll compare the data

for {set i 0} {$i<$nrows} {incr i} {

    for {set j 0} {$j<$nfields} {incr j} {

	puts -nonewline  "\rChecking table '$table' row $i field $j"
	set first 1
	foreach result $results {
	    if {$first} {
		set data [lindex [pg_result $result -getTuple $i] $j]
		set first 0
	    } else {
		if {$data!=[lindex [pg_result $result -getTuple $i] $j]} {
		    syncError "Field value does not match: Row $i, Field $j"
		}
	    }
	}


    }

}


puts ""

# Disconnect
foreach conn $conns {
    pg_disconnect $conn
}



set hora_fin [clock seconds]
set dif [expr $hora_fin - $hora_inicio]


puts "\nIt took $dif seconds to check."

puts "SYNC OK!"
