#include "DBBalancerTxtConfig.hh"
#include "DBHostConfig.hh"
  
DBBalancerTxtConfig::DBBalancerTxtConfig(string txtFile, string unixSocketBasePath="/tmp") {
    
  this->setDefaultValues();
  _unixSocketBasePath=unixSocketBasePath;

  // Open config file
  ifstream file(txtFile.c_str());

  if (file.is_open()) {
    // Parse it and set instance properties
    this->parseFile(file);
  } else {
    ACE_DEBUG((LM_CRITICAL,"(%t, %T) Error opening file (%s): %m\n",txtFile.c_str()));
    ACE_OS::exit(-1);
  }

  file.close();

}

DBBalancerTxtConfig::~DBBalancerTxtConfig() {

  ACE_DEBUG((LM_DEBUG,"Destroyed DBBalancerTxtConfig.\n"));

}

// DBBalancerConfig interface implementation. ***************************************************************

// Methods inlined except for this one:

vector <DBHostConfig *> DBBalancerTxtConfig::getHosts() {
  return _hosts;
}

void DBBalancerTxtConfig::setDefaultValues() {

  _readerPort = 6666;
  _writerPort = 6667;
  _host = "localhost";
  _writerTransactionPerRequest = false;

  _initThreads = 5;
  _minThreads = 5;
  _maxThreads = 10;
  
  _initDbConnections = 5;
  _minDbConnections = 5;
  _maxDbConnections = 10;

  _daemonUser = "postgres";
  _daemonPassword = "postgres";
  _daemonDbName = "postgres";
  _daemonAuthMethod ="password";
  _daemonLogFile = "stdout";

  _reaperDelay = 1;


}


void DBBalancerTxtConfig::parseFile(ifstream &file) {


  char buffer[1024];
  char *nameC, *valueC;

  memset(buffer,0,sizeof(buffer));
  file.getline(buffer,sizeof(buffer)-1);

  while (!file.eof()) {

    //ACE_DEBUG((LM_DEBUG,"Buffer: %s\n",buffer));
    nameC = buffer;
    valueC = index(buffer,'=');

    if (valueC!=NULL && (buffer[0]!='#') && (buffer[0]!='/' || buffer[1]!='/')) {

      *valueC = 0;
      valueC += sizeof(char);

      string name(nameC);
      string value(valueC);

      processNameValuePair(trim(name),trim(value));

    } 

    memset(buffer,0,sizeof(buffer));
    file.getline(buffer,sizeof(buffer)-1);
  }


}


void DBBalancerTxtConfig::processNameValuePair(string name, string value) {

  const char* valueC = value.c_str();
  

  ACE_DEBUG((LM_DEBUG,"(%t, %T): DBBalancerTxtConfig: Processing name:#%s#, value:#%s#\n",name.c_str(),value.c_str()));


  // "daemon" section
  if (name=="daemon.reader-port")
    _readerPort = atoi(valueC);
  else if (name=="daemon.writer-port")
    _writerPort = atoi(valueC);  
  else if (name=="daemon.host")
    _host = value;
  else if (name=="daemon.writer-transaction-per-request")
    _writerTransactionPerRequest = (strncmp(valueC,"true",4)==0);

  else if (name=="daemon.init-threads")
    _initThreads = atoi(valueC);
  else if (name=="daemon.min-threads")
    _minThreads = atoi(valueC);
  else if (name=="daemon.max-threads")
    _maxThreads = atoi(valueC);

  else if (name=="daemon.init-db-connections")
    _initDbConnections = atoi(valueC);
  else if (name=="daemon.min-db-connections")
    _minDbConnections = atoi(valueC);
  else if (name=="daemon.max-db-connections")
    _maxDbConnections = atoi(valueC);

  else if (name=="daemon.reaper-delay")
    _reaperDelay = atoi(valueC);
  else if (name=="daemon.user")
    _daemonUser = value;
  else if (name=="daemon.password")
    _daemonPassword = value;
  else if (name=="daemon.dbname")
    _daemonDbName = value;
  else if (name=="daemon.auth-method")
    _daemonAuthMethod = value;
  else if (name=="daemon.log-file")
    _daemonLogFile = value;

  // "machine"section
  
  else if (name=="machine.host") {
    _hosts.push_back(new DBHostConfig());
    _hosts.back()->setName(value);
  } else if (name=="machine.dbname")
    _hosts.back()->setDbName(value);
  else if (name=="machine.port")
    _hosts.back()->setPort(atoi(valueC));
  else if (name=="machine.dbuser")
    _hosts.back()->setDbUser(value);
  else if (name=="machine.dbpassword")
    _hosts.back()->setDbPassword(value);



}

// Returns a string "trimmed" from TAB's and SPACE's

string DBBalancerTxtConfig::trim(string st) {

  unsigned int init,end,i;

  // Front ...
  for (i=0;i<st.length()-1;i++) {
    if (st[i]!=' ' && st[i]!='\t')
      break;
  }
  init = i;

  // ... and Back.
  for (i=st.length()-1;i>0;i--) {
    if (st[i]!=' ' && st[i]!='\t')
      break;
  }
  end = i;

  return st.substr(init,end-init+1);



}
