# arch-tag: cd547407-1daf-41ce-a75b-5fb8f5590f33
# Copyright (C) 2004 Canonical Ltd.
#               2004 David Allouche <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Test suite
"""

import unittest
import framework

# Order of imports is significant to test ordering
import test_coding
import test_nameparser
import test_compat
import test_namespace
import test_factory
import test_escaping
import test_output
import test_my_id
import test_archive
import test_workingtree
import test_logmessage
import test_commit
import test_arch
import test_location
import test_ancestry
import test_patchlog
import test_revlib

test_modules = framework.collect_test_modules()

def test_suite():
    excluded = ('test_suite', 'test_twisted', 'test_twisted_arch')
    suite = unittest.TestSuite()
    for module_name in test_modules:
        base_name = module_name.split('.')[-1]
        assert module_name == __name__ + '.' + base_name
        module = globals()[base_name]
        if base_name in excluded:
            continue
        if not base_name.startswith('test_'):
            continue
        suite.addTest(module.test_suite())
    return suite
