/* $Cambridge: hermes/src/prayer/accountd/quota.c,v 1.2 2004/10/01 12:42:27 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2002 */
/* See the file NOTICE for conditions of use and distribution. */

#include "accountd.h"

/* quota_check() *********************************************************
 *
 * Check disk quota.
 *    config: accountd configuration
 *    stream: iostream connection to client
 *
 * Returns: T on sucess, NIL otherwise (should be irrelevant)
 *
 * Output:
 *   OK bused: (number) blimit: (number) iused: (number) ilimit: (number)
 *   NO [Error message]  - Couldn't derive disk quota
 *  BAD [Error message]  - Protocol error
 ************************************************************************/

BOOL quota_check(struct config * config, struct iostream * stream)
{
    struct process process;
    char buffer[MAXLENGTH];
    int bused = 0;
    int blimit = 0;
    int iused = 0;
    int ilimit = 0;

    process_clear(&process);
    if (!process_start
        (&process, config->quota_cmdline, NIL, config->child_timeout)) {
        ioputs(stream, "NO Couldn't invoke quota check program" CRLF);
        ioflush(stream);
        return (NIL);
    }

    if (!config->quota_hermes) {
        char *line, *key, *value;

        while (iostream_getline(process.stream, buffer, MAXLENGTH)) {
            line = buffer;

            while (*line) {
                if (!(key = string_get_token(&line)))
                    break;

                if (!(value = string_get_token(&line)))
                    break;

                if (!strcmp(key, "bused:"))
                    bused = atoi(value);
                else if (!strcmp(key, "blimit:"))
                    blimit = atoi(value);
                else if (!strcmp(key, "iused:"))
                    iused = atoi(value);
                else if (!strcmp(key, "ilimit:"))
                    ilimit = atoi(value);
            }
        }
    } else {
        while (iostream_getline(process.stream, buffer, MAXLENGTH)) {
            char *line, *type, *current, *quota, *limit;

            /* Process this line of input */
            line = buffer;

            if ((type = string_get_token(&line)) == NIL)
                continue;

            if ((strcmp(type, "KBytes:") != NIL)
                && (strcmp(type, "Files:") != NIL))
                continue;

            if ((current = string_get_token(&line)) == NIL)
                continue;

            if ((quota = string_get_token(&line)) == NIL)
                continue;

            if ((limit = string_get_token(&line)) == NIL)
                continue;

            if (!strcmp(type, "KBytes:")) {
                bused = atoi(current);
                blimit = atoi(limit);
            } else {
                iused = atoi(current);
                ilimit = atoi(limit);
            }
        }
    }

    if (!process_stop(&process)) {
        ioputs(stream, "NO fquota program terminated incorrectly" CRLF);
        ioflush(stream);
        return (NIL);
    }

    ioprintf(stream, "OK bused: %d blimit: %d iused: %d ilimit: %d" CRLF,
             bused, blimit, iused, ilimit);
    ioflush(stream);
    return (T);
}
