// test_get_backup_content.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

char *cuser_data= 0;

void print_usage()
{
  printf("usage : test_get_backup_content.exe <filename> "
         "<log_filename> <charset> <interval> <user_data>\n");
}

void print_backup_content(MYX_BACKUP_CONTENT * content)
{
  MYX_BACKUP_TABLE * table= content->tables;
  MYX_BACKUP_TABLE * tables_end= table + content->tables_num;

  for (; table!=tables_end; table++)
    printf("%s.%s.%s\n",table->catalog,table->schema,table->table);
}

FILE * progress_log_file= 0;

int progress_report_content(bigint bytes_read, 
                            bigint bytes_total, void *user_data)
{
  fprintf(progress_log_file,"read %ld bytes of %ld, user_data=\"%s\"\n",
          (long int)bytes_read,(long int)bytes_total,user_data);
  return 0;
}

int main(int argc, char* argv[])
{
  if (argc<6)
  {
    print_usage();
  }
  else
  {
    const char * filename= argv[1];
    const char * log_filename= argv[2];
    const char * charset= argv[3];
    int interval= atoi(argv[4]);
    cuser_data= argv[5];

    progress_log_file= fopen(log_filename,"w");
    if (!progress_log_file)
    {
      fprintf(stderr,"can't open log file \"%s\"\n",progress_log_file);
      return -1;
    }
    else
    {
      MYX_BACKUP_ERROR err;
      MYX_BACKUP_CONTENT * content=
        myx_get_backup_content(filename,charset,MYX_BT_SQL_SCRIPT,interval,
                               progress_report_content,cuser_data,&err);
      fclose(progress_log_file);
      if (!content)
      {
        fprintf(stderr,"myx_get_backup_content returned error=%d\n",(int)err);
        return -1;
      }
      else
      {      
        print_backup_content(content);
        myx_free_backup_content(content);
        return 0;
      }
    }
  }
}

